#include-once

Func _Tool_Brush_Start($oSelf, $iX, $iY)
	$oSelf.lastX = $iX
	$oSelf.lastY = $iY
	$oSelf.gpx = _Util_GetCurrentGraphics()

	If $v4Setting_GraphicLibrary = $V4_LIBRARY_DIRECT2D Then
		$oSelf.d2d_target = _Util_CreateDCRenderTarget()
		_D2D1_SetAntialiasMode($oSelf.d2d_target, 0)

		$oSelf.extra8 = _Util_CreateStrokeProperties($D2D1_CAP_STYLE_ROUND, $D2D1_CAP_STYLE_ROUND)
	EndIf

	$oSelf.extra1 = 0
EndFunc

#cs
	REMARK #7: Wait, where's my Direct2D? [scintilla4evr]

	You may ask, vPaint is using Direct2D, so why there aren't
	many lines of code actually using Direct2D? The answer is simple.
	There is no functionality for now, where using Direct2D would
	boost up the performance.

#ce
Func _Tool_Brush_Draw($oSelf, $iX, $iY)
	Switch $iBrushToolMode
		Case 0
			$iX += Random(-$iBrushWidth*3, $iBrushWidth*3)*($iBrushScatter/100)
			$iY += Random(-$iBrushWidth*3, $iBrushWidth*3)*($iBrushScatter/100)

			$hBrush = _GDIPlus_BrushCreateSolid(BitAND($iForeground, BitOR(0xFFFFFF, BitShift(Random(255 - $iBrushRandomizeAlpha*2.55, 255, 1), -24))))

			$iR = $iBrushWidth/2

			_GDIPlus_GraphicsFillEllipse($oSelf.gpx, $iX-$iR, $iY-$iR, $iR*2, $iR*2, $hBrush)

			_GDIPlus_BrushDispose($hBrush)

			$oSelf.lastX = $iX
			$oSelf.lastY = $iY
			$oSelf.extra1 += 0.4
		Case 1
			$hPen = _GDIPlus_PenCreate($iForeground, $iBrushWidth)
			_GDIPlus_PenSetLineCap($hPen, 2, 2, 2)

			_GDIPlus_GraphicsDrawLine($oSelf.gpx, $iX, $iY, $oSelf.lastX, $oSelf.lastY, $hPen)

			_GDIPlus_PenDispose($hPen)

			$oSelf.lastX = $iX
			$oSelf.lastY = $iY
		Case 2
			_GDIPlus_GraphicsSetSmoothingMode($oSelf.gpx, 0)

			$hBrush = _GDIPlus_BrushCreateSolid($iForeground)

			For $i = 0 To 4
				$iX += Cos(Random(0, $Pi*2))*($iBrushWidth/2)
				$iY += Sin(Random(0, $Pi*2))*($iBrushWidth/2)

				_GDIPlus_GraphicsFillRect($oSelf.gpx, $iX, $iY, 1, 1, $hBrush)
			Next

			_GDIPlus_BrushDispose($hBrush)
	EndSwitch
EndFunc

Func _Tool_Brush_End($oSelf, $iX, $iY)
	_GDIPlus_GraphicsDispose($oSelf.gpx)
EndFunc

Func _Tool_Brush_DrawHUD($oSelf, $hGpx, $iX, $iY)
	$tPen = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
	_GDIPlus_GraphicsDrawEllipse($hGpx, $iX-($iBrushWidth/2)*$oCurrentThread.zoom, $iY-($iBrushWidth/2)*$oCurrentThread.zoom, $iBrushWidth*$oCurrentThread.zoom, $iBrushWidth*$oCurrentThread.zoom, $tPen)
	_GDIPlus_PenDispose($tPen)

	$tPen = _GDIPlus_PenCreate(0xAA000000)
	_GDIPlus_GraphicsDrawEllipse($hGpx, $iX-($iBrushWidth/2)*$oCurrentThread.zoom, $iY-($iBrushWidth/2)*$oCurrentThread.zoom, $iBrushWidth*$oCurrentThread.zoom, $iBrushWidth*$oCurrentThread.zoom, $tPen)
	_GDIPlus_PenDispose($tPen)
EndFunc

Func _Tool_Brush_DrawD2DHUD($oSelf, $oRenderTarget, $iX, $iY)
	Local $hBrush1 = _D2D1_CreateSolidBrush($oRenderTarget, _D2D1_CreateColorF(0, 0, 0, 0.7))
	Local $hBrush2 = _D2D1_CreateSolidBrush($oRenderTarget, _D2D1_CreateColorF(1, 1, 1, 0.7))
	Local $tEllipse = _D2D1_CreateEllipse($iX, $iY, $iBrushWidth*$oCurrentThread.zoom/2, $iBrushWidth*$oCurrentThread.zoom/2)

	_D2D1_DrawEllipse($oRenderTarget, $tEllipse, $hBrush2, 3)
	_D2D1_DrawEllipse($oRenderTarget, $tEllipse, $hBrush1, 1)

	_AutoItObject_IUnknownRelease($hBrush1)
	_AutoItObject_IUnknownRelease($hBrush2)
EndFunc

Func _Tool_Brush_ShowUI($oSelf)
	$hBrushUI = GUICreate("", 700, 40, 0, 30*$iUIScaleFactor, $WS_CHILD+$WS_VISIBLE, -1, $hMainUI)

	Global $cidBrush_BrushMode0 = _Tiles_CreateButton('%', 0, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Brush_SetMode")
	GUICtrlSetTip(-1, "Brush")

	Global $cidBrush_BrushMode1 = _Tiles_CreateButton('O', 40, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Brush_SetMode")
	GUICtrlSetTip(-1, "Pencil")

	Global $cidBrush_BrushMode2 = _Tiles_CreateButton('N', 80, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Brush_SetMode")
	GUICtrlSetTip(-1, "Aerograph")

	_Tiles_CreateButton('A', 140, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Brush_ResetWidth")
	GUICtrlSetTip(-1, "Brush width (click to reset)")

	Global $cidBrush_WidthSlider = GUICtrlCreateSlider(180, 5, 120, 40)
	GUICtrlSetData(-1, $iBrushWidth)
	GUICtrlSetBkColor(-1, 0xF0F0F0)
	GUICtrlSetTip(-1, $iBrushWidth)
	GUICtrlSetOnEvent(-1, "_Tool_Brush_SetWidth")

	_Tiles_CreateButton('B', 320, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Brush_ResetScattering")
	GUICtrlSetTip(-1, "Brush scattering (click to disable)")

	Global $cidBrush_ScatterSlider = GUICtrlCreateSlider(360, 5, 120, 40)
	GUICtrlSetData(-1, $iBrushScatter)
	GUICtrlSetBkColor(-1, 0xF0F0F0)
	GUICtrlSetTip(-1, $iBrushScatter&"%")
	GUICtrlSetOnEvent(-1, "_Tool_Brush_SetScattering")

	_Tiles_CreateButton('C', 500, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Brush_ResetAlphaRand")
	GUICtrlSetTip(-1, "Randomize opacity (click to disable)")

	Global $cidBrush_RandAlphaSlider = GUICtrlCreateSlider(540, 5, 120, 40)
	GUICtrlSetData(-1, $iBrushRandomizeAlpha)
	GUICtrlSetBkColor(-1, 0xF0F0F0)
	GUICtrlSetTip(-1, $iBrushRandomizeAlpha&"%")
	GUICtrlSetOnEvent(-1, "_Tool_Brush_SetAlphaRand")

	_Tiles_CreateButton('Q', 660, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Brush_ShowMoreMenu")
	GUICtrlSetTip(-1, "More options")

	_Tiles_ButtonSetBkColor(Eval("cidBrush_BrushMode"&$iBrushToolMode), 0xFFF0F0F0, 0xFFE0E0E0)
	_Tiles_ButtonSetTextColor(Eval("cidBrush_BrushMode"&$iBrushToolMode), 0xFF111111)

	GUISwitch($hMainUI)

	Return $hBrushUI
EndFunc

Func _Tool_Brush_ShowMoreMenu()
	$cidCtx = GUICtrlCreateContextMenu(GUICtrlCreateDummy())

	GUICtrlCreateMenuItem("Enable size randomizing", $cidCtx)
	GUICtrlCreateMenuItem("Enable pressure simulation", $cidCtx)

	_ShowMenu($hMainUI, @GUI_CtrlId, $cidCtx)
EndFunc

Func _Tool_Brush_ResetWidth()
	$iBrushWidth = 16
	GUICtrlSetData($cidBrush_WidthSlider, $iBrushWidth)
	GUICtrlSetTip($cidBrush_WidthSlider, $iBrushWidth)
EndFunc

Func _Tool_Brush_ResetScattering()
	$iBrushScatter = 0
	GUICtrlSetData($cidBrush_ScatterSlider, $iBrushScatter)
	GUICtrlSetTip($cidBrush_ScatterSlider, $iBrushScatter&"%")
EndFunc

Func _Tool_Brush_ResetAlphaRand()
	$iBrushRandomizeAlpha = 0
	GUICtrlSetData($cidBrush_RandAlphaSlider, $iBrushRandomizeAlpha)
	GUICtrlSetTip($cidBrush_RandAlphaSlider, $iBrushRandomizeAlpha&"%")
EndFunc

Func _Tool_Brush_SetWidth()
	$iBrushWidth = GUICtrlRead(@GUI_CtrlId)
	GUICtrlSetData(@GUI_CtrlId, $iBrushWidth)
	GUICtrlSetTip(@GUI_CtrlId, $iBrushWidth)
EndFunc

Func _Tool_Brush_SetScattering()
	$iBrushScatter = GUICtrlRead(@GUI_CtrlId)
	GUICtrlSetData(@GUI_CtrlId, $iBrushScatter)
	GUICtrlSetTip(@GUI_CtrlId, $iBrushScatter&"%")
EndFunc

Func _Tool_Brush_SetAlphaRand()
	$iBrushRandomizeAlpha = GUICtrlRead(@GUI_CtrlId)
	GUICtrlSetData(@GUI_CtrlId, $iBrushRandomizeAlpha)
	GUICtrlSetTip(@GUI_CtrlId, $iBrushRandomizeAlpha&"%")
EndFunc

Func _Tool_Brush_SetMode()
	_Tiles_ButtonSetBkColor(Eval("cidBrush_BrushMode"&$iBrushToolMode), 0xFFF0F0F0, 0xFFE0E0E0)
	_Tiles_ButtonSetTextColor(Eval("cidBrush_BrushMode"&$iBrushToolMode), 0xFF111111)

	Switch @GUI_CtrlId
		Case $cidBrush_BrushMode0
			$iBrushToolMode = 0
		Case $cidBrush_BrushMode1
			$iBrushToolMode = 1
		Case $cidBrush_BrushMode2
			$iBrushToolMode = 2
	EndSwitch

	_Tiles_ButtonSetBkColor(Eval("cidBrush_BrushMode"&$iBrushToolMode), 0xFFE0E0E0, 0xFFD0D0D0)
	_Tiles_ButtonSetTextColor(Eval("cidBrush_BrushMode"&$iBrushToolMode), 0xFF000000)
EndFunc

Func _Tool_Brush_CanBypassLock($oSelf, $iLockMode)
	Switch $iLockMode
		Case $V4_LL_NONE, $V4_LL_POS
			Return 1
		Case Else
			Return 0
	EndSwitch
EndFunc
