#include-once

Func _Tool_Gradient_Start($oSelf, $iX, $iY)
	$oSelf.lastX = $iX
	$oSelf.lastY = $iY
	$oSelf.gpx = _Util_GetCurrentGraphics()
EndFunc

Func _Tool_Gradient_Draw($oSelf, $iX, $iY)
EndFunc

Func _Tool_Gradient_End($oSelf, $iX, $iY)
	Switch $iFillMode
		Case 0
			_Util_StartFloodFill($oCurrentThread.thread.currentLayer.bmp, Int($iX), Int($iY), $iForeground)
		Case 1
			$tBrush = _GDIPlus_LineBrushCreate($oSelf.lastX, $oSelf.lastY, $iX, $iY, 0, 0, 3)
			_GDIPlus_LineBrushSetPresetBlend($tBrush, $aGradientPoints)

			_GDIPlus_GraphicsFillRect($oSelf.gpx, 0, 0, $oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height, $tBrush)

			_GDIPlus_BrushDispose($tBrush)

			_GDIPlus_GraphicsDispose($oSelf.gpx)
	EndSwitch
EndFunc

Func _Tool_Gradient_DrawHUD($oSelf, $hGpx, $iX, $iY)
	$x = $oSelf.lastX
	$y = $oSelf.lastY
	_Util_ConvertBitmapToClient($x, $y)

	If _IsPressed(1) And $iFillMode = 1 Then
		$tBrush = _GDIPlus_LineBrushCreate($x, $y, $iX, $iY, 0, 0, 3)
		_GDIPlus_LineBrushSetPresetBlend($tBrush, $aGradientPoints)

		$x0 = 0
		$y0 = 0
		_Util_ConvertBitmapToClient($x0, $y0)

		$w = Int($oCurrentThread.thread.currentLayer.width*$oCurrentThread.zoom)
		$h = Int($oCurrentThread.thread.currentLayer.height*$oCurrentThread.zoom)

		_GDIPlus_GraphicsFillRect($hGpx, $x0, $y0, $w, $h, $tBrush)

		_GDIPlus_BrushDispose($tBrush)
	EndIf

	$tPen = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)

	If _IsPressed(1) Then
		_GDIPlus_GraphicsDrawLine($hGpx, $x-10, $y, $x-4, $y, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $x+10, $y, $x+4, $y, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $x, $y-10, $x, $y-4, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $x, $y+10, $x, $y+4, $tPen)

		_GDIPlus_GraphicsDrawLine($hGpx, $x, $y, $iX, $iY, $tPen)

		For $i = 1 To $aGradientPoints[0][0]
			$_x = $x + $aGradientPoints[$i][1]*($iX-$x)
			$_y = $y + $aGradientPoints[$i][1]*($iY-$y)

			_GDIPlus_GraphicsDrawEllipse($hGpx, $_x-8, $_y-8, 16, 16, $tPen)
		Next
	EndIf
	_GDIPlus_PenDispose($tPen)

	$tPen = _GDIPlus_PenCreate(0xAA000000)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)

	If _IsPressed(1) Then
		_GDIPlus_GraphicsDrawLine($hGpx, $x-10, $y, $x-4, $y, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $x+10, $y, $x+4, $y, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $x, $y-10, $x, $y-4, $tPen)
		_GDIPlus_GraphicsDrawLine($hGpx, $x, $y+10, $x, $y+4, $tPen)

		_GDIPlus_GraphicsDrawLine($hGpx, $x, $y, $iX, $iY, $tPen)

		For $i = 1 To $aGradientPoints[0][0]
			$tBrush = _GDIPlus_BrushCreateSolid($aGradientPoints[$i][0])
			$_x = $x + $aGradientPoints[$i][1]*($iX-$x)
			$_y = $y + $aGradientPoints[$i][1]*($iY-$y)

			_GDIPlus_GraphicsFillEllipse($hGpx, $_x-8, $_y-8, 16, 16, $hTransparency)
			_GDIPlus_GraphicsFillEllipse($hGpx, $_x-8, $_y-8, 16, 16, $tBrush)
			_GDIPlus_BrushDispose($tBrush)

			_GDIPlus_GraphicsDrawEllipse($hGpx, $_x-8, $_y-8, 16, 16, $tPen)
		Next
	EndIf
	_GDIPlus_PenDispose($tPen)
EndFunc

Func _Tool_Gradient_CanBypassLock($oSelf, $iLockMode)
	Switch $iLockMode
		Case $V4_LL_NONE, $V4_LL_POS
			Return 1
		Case Else
			Return 0
	EndSwitch
EndFunc

Func _Tool_Gradient_ShowUI($oSelf)
	$hGradientUI = GUICreate("", 700, 40, 0, 30*$iUIScaleFactor, $WS_CHILD+$WS_VISIBLE, -1, $hMainUI)

	Global $cidGradient_FillMode0 = _Tiles_CreateButton('J', 0, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetTip(-1, "Flood fill")
	GUICtrlSetOnEvent(-1, "_Tool_Gradient_SetMode")

	Global $cidGradient_FillMode1 = _Tiles_CreateButton('H', 40, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetTip(-1, "Gradient")
	GUICtrlSetOnEvent(-1, "_Tool_Gradient_SetMode")

	_Tiles_ButtonSetBkColor(Eval("cidGradient_FillMode"&$iFillMode), 0xFFE0E0E0, 0xFFD0D0D0)
	_Tiles_ButtonSetTextColor(Eval("cidGradient_FillMode"&$iFillMode), 0xFF000000)

	GUISwitch($hMainUI)

	Return $hGradientUI
EndFunc

Func _Tool_Gradient_SetMode()
	_Tiles_ButtonSetBkColor(Eval("cidGradient_FillMode"&$iFillMode), 0xFFF0F0F0, 0xFFE0E0E0)
	_Tiles_ButtonSetTextColor(Eval("cidGradient_FillMode"&$iFillMode), 0xFF111111)

	Switch @GUI_CtrlId
		Case $cidGradient_FillMode0
			$iFillMode = 0
		Case $cidGradient_FillMode1
			$iFillMode = 1
	EndSwitch

	_Tiles_ButtonSetBkColor(Eval("cidGradient_FillMode"&$iFillMode), 0xFFE0E0E0, 0xFFD0D0D0)
	_Tiles_ButtonSetTextColor(Eval("cidGradient_FillMode"&$iFillMode), 0xFF000000)
EndFunc
