#include-once

Func _Tool_Select_Start($oSelf, $iX, $iY)
	$oSelf.lastX = $iX
	$oSelf.lastY = $iY
	$oSelf.extra1 = _GDIPlus_RegionClone($oCurrentThread.thread.selection)
	$oSelf.extra2 = _GDIPlus_RegionClone($oCurrentThread.thread.selection)

	$oSelf.extra3 = 0
	$tHRGN = _GDIPlus_RegionGetHRgn($oCurrentThread.thread.selection)
	$tRect = _WinAPI_CreateRect($iX-1, $iY-1, $iX+1, $iY+1)
	If _WinAPI_RectInRegion($tHRGN, $tRect) And $iSelectCombineMode = 0 Then $oSelf.extra3 = 1
	_WinAPI_DeleteObject($tHRGN)
EndFunc

Func _Tool_Select_Draw($oSelf, $iX, $iY)
	If $oSelf.extra3 = 1 Then
		_GDIPlus_RegionTranslate($oCurrentThread.thread.selection, $iX-$oSelf.lastX, $iY-$oSelf.lastY)

		$oSelf.lastX = $iX
		$oSelf.lastY = $iY
	Else
		_GDIPlus_RegionDispose($oSelf.extra2)
		$oSelf.extra2 = _GDIPlus_RegionClone($oSelf.extra1)

		$tRgn = _GDIPlus_RegionCreateFromRect(_Min($oSelf.lastX, $iX), _Min($oSelf.lastY, $iY), Abs($iX-$oSelf.lastX), Abs($iY-$oSelf.lastY))
		_GDIPlus_RegionCombineRegion($oSelf.extra2, $tRgn, $iSelectCombineMode)
		_GDIPlus_RegionDispose($tRgn)

		_GDIPlus_RegionDispose($oCurrentThread.thread.selection)
		$oCurrentThread.thread.selection = _GDIPlus_RegionClone($oSelf.extra2)
	EndIf
EndFunc

Func _Tool_Select_End($oSelf, $iX, $iY)
	If (Abs($iX-$oSelf.lastX) = 0 Or Abs($iY-$oSelf.lastY) = 0) And $oSelf.extra3 = 0 Then
		_GDIPlus_RegionDispose($oCurrentThread.thread.selection)
		$oCurrentThread.thread.selection = _GDIPlus_RegionCreate()
	ElseIf $oSelf.extra3 = 0 Then
		$tRgn = _GDIPlus_RegionCreateFromRect(_Min($oSelf.lastX, $iX), _Min($oSelf.lastY, $iY), Abs($iX-$oSelf.lastX), Abs($iY-$oSelf.lastY))
		_GDIPlus_RegionCombineRegion($oSelf.extra1, $tRgn, $iSelectCombineMode)
		_GDIPlus_RegionDispose($tRgn)
		_GDIPlus_RegionDispose($oSelf.extra1)
		_GDIPlus_RegionDispose($oSelf.extra2)
	EndIf
EndFunc

Func _Tool_Select_DrawHUD($oSelf, $hGpx, $iX, $iY)
	; ...
EndFunc

Func _Tool_Select_ShowUI($oSelf)
	$pos = MouseGetPos()

	Global $hSelectOptionsUI, $cidSelectOptionsUI_Tick
	Global $cidSelectOptionsUI_Mode0, $cidSelectOptionsUI_Mode1, $cidSelectOptionsUI_Mode2, $cidSelectOptionsUI_Mode3, $cidSelectOptionsUI_Mode4

	$hSelectOptionsUI = GUICreate("Selection Mode", 260, 220, $pos[0], $pos[1], $WS_POPUP+$WS_BORDER, -1, $hMainUI)
	GUISetOnEvent(-3, "_CloseGUI")
	GUISetFont(9, 400, 0, "Segoe UI")

	$cidSelectOptionsUI_Tick = _CreateImgButton(_GetIconPath("toggle", "check_box"), 0, 0, 24, 24, 10, 10+$iSelectCombineMode*40, 40, 40, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)

	$cidSelectOptionsUI_Mode0 = _CreateImgButton2(_GetIconPath("tools", "select_mode_replace"), "Replace", 0, 0, 24, 24, 50, 10, 200, 40, 14, 0xFFF0F0F0, 0xFFE5E5E5, 0xFFC4C4C4, 0xFF222222)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetMode")

	$cidSelectOptionsUI_Mode1 = _CreateImgButton2(_GetIconPath("tools", "select_mode_intersect"), "Intersect", 0, 0, 24, 24, 50, 50, 200, 40, 14, 0xFFF0F0F0, 0xFFE5E5E5, 0xFFC4C4C4, 0xFF222222)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetMode")

	$cidSelectOptionsUI_Mode2 = _CreateImgButton2(_GetIconPath("tools", "select_mode_union"), "Union", 0, 0, 24, 24, 50, 90, 200, 40, 14, 0xFFF0F0F0, 0xFFE5E5E5, 0xFFC4C4C4, 0xFF222222)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetMode")

	$cidSelectOptionsUI_Mode3 = _CreateImgButton2(_GetIconPath("tools", "select_mode_xor"), "XOR", 0, 0, 24, 24, 50, 130, 200, 40, 14, 0xFFF0F0F0, 0xFFE5E5E5, 0xFFC4C4C4, 0xFF222222)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetMode")

	$cidSelectOptionsUI_Mode4 = _CreateImgButton2(_GetIconPath("tools", "select_mode_sub1"), "Subtract", 0, 0, 24, 24, 50, 170, 200, 40, 14, 0xFFF0F0F0, 0xFFE5E5E5, 0xFFC4C4C4, 0xFF222222)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetMode")

	GUISetState()
	GUISwitch($hMainUI)

	Return $hSelectOptionsUI
EndFunc

Func _Tool_Select_SetMode()
	_ImgButtonDelete($cidSelectOptionsUI_Tick)
	_ImgButtonDelete($cidSelectOptionsUI_Mode0)
	_ImgButtonDelete($cidSelectOptionsUI_Mode1)
	_ImgButtonDelete($cidSelectOptionsUI_Mode2)
	_ImgButtonDelete($cidSelectOptionsUI_Mode3)
	_ImgButtonDelete($cidSelectOptionsUI_Mode4)

	$isClosing = 1

	$pos = ControlGetPos($hSelectOptionsUI, "", @GUI_CtrlId)
	$iSelectCombineMode = Int(($pos[1]-10)/40)

	GUIDelete($hSelectOptionsUI)
	GUISwitch($hMainUI)
	$isShowingToolUI = 0
	Sleep(100)

	$isClosing = 0
EndFunc
