#include-once

Func _Ripple($iSize, $fBias, $iStep, ByRef $hBmp)
	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_ProgressOn("Applying effect...", "Row 0 of "&Int($oCurrentThread.thread.currentLayer.height/$iStep))

	For $y = 0 To $oCurrentThread.thread.currentLayer.height Step $iStep
		$x = Sin($y/10+$fBias)*$iSize
		_GDIPlus_GraphicsDrawImageRectRect($tGpx, $hBmp, 0, $y, $oCurrentThread.thread.currentLayer.width, $iStep, $x, $y, $oCurrentThread.thread.currentLayer.width, $iStep)

		_ProgressSet("Applying effect...", "Row "&Int($y/$iStep+1)&" of "&Int($oCurrentThread.thread.currentLayer.height/$iStep), 100*Int($y/$iStep+1)/Int($oCurrentThread.thread.currentLayer.height/$iStep))
	Next

	_ProgressOff()

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_BitmapDispose($hBmp)
	$hBmp = $tBmp
EndFunc

Func _Ripple_Event()
	If Not $isOpen Then Return 0
	_Ripple()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc
