#include-once

Func _Wind($iSize = 10, $iStep = 2)
	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_ProgressOn("Applying effect...", "Row 0 of "&Int($oCurrentThread.thread.currentLayer.height/$iStep))

	For $y = 0 To $oCurrentThread.thread.currentLayer.height Step $iStep
		$x = Random(0, $iSize)
		_GDIPlus_GraphicsDrawImageRectRect($tGpx, $oCurrentThread.thread.currentLayer.bmp, 0, $y, $oCurrentThread.thread.currentLayer.width, $iStep, $x, $y, $oCurrentThread.thread.currentLayer.width, $iStep)

		_ProgressOn("Applying effect...", "Row "&Int($y/$iStep+1)&" of "&Int($oCurrentThread.thread.currentLayer.height/$iStep))
	Next

	_ProgressOff()

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
	$oCurrentThread.thread.currentLayer.bmp = $tBmp
EndFunc

Func _Wind_Event()
	If Not $isOpen Then Return 0
	_Wind()

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc
