#include-once

#Region Miscellaneous

Func _HideGUI()
	GUISetState(@SW_HIDE, @GUI_WinHandle)
EndFunc

Func _DrawingAreaClick()
	If Not $isOpen Then Return
	Switch $oCurrentThread.type
		Case $V4_TT_AUDIO
			If $oCurrentThread.isPlaying Then
				_BASS_ChannelPause($oCurrentThread.stream)
			Else
				_BASS_ChannelPlay($oCurrentThread.stream, 0)
			EndIf

			$oCurrentThread.isPlaying = 1-$oCurrentThread.isPlaying
	EndSwitch
EndFunc

Func _CloseGUI()
	GUIDelete(@GUI_WinHandle)
EndFunc

Func _SwapForeBack()
	$t = $iForeground
	$iForeground = $iBackground
	$iBackground = $t

	GUICtrlSetBkColor($cidForeground, _SetAlpha($iForeground, 0))
	GUICtrlSetBkColor($cidBackground, _SetAlpha($iBackground, 0))
EndFunc

Func _SetForeColor()
	Switch @GUI_CtrlId
		Case $cidForeSetToBlack
			$iForeground = 0xFF000000
		Case $cidForeSetToWhite
			$iForeground = 0xFFFFFFFF
	EndSwitch

	GUICtrlSetBkColor($cidForeground, _SetAlpha($iForeground, 0))
EndFunc

Func _SetBackColor()
	Switch @GUI_CtrlId
		Case $cidBackSetToBlack
			$iBackground = 0xFF000000
		Case $cidBackSetToWhite
			$iBackground = 0xFFFFFFFF
	EndSwitch

	GUICtrlSetBkColor($cidBackground, _SetAlpha($iBackground, 0))
EndFunc

Func _MoveOverlayUI()
	$cW = _WinAPI_GetClientWidth($hMainUI)
	$cH = _WinAPI_GetClientHeight($hMainUI)

	$iX = 0
	$iY = 0

	_ClientToScreen($hMainUI, $iX, $iY)
	_ClientToScreen($hMainUI, $cW, $cH)

	$aPos = WinGetPos($hMainUI)

	WinMove($hOverlayUI, "", $iX, $iY, $cW-$iX, $cH-$iY)
EndFunc

Func _RefreshCompositing()
	$obj = _Node_GetObjFromCtrl($cidCompositing)

	If $isOpen Then
		$obj.list = $oCurrentThread.compList
	Else
		$obj.list = $oBlankNodeList
	EndIf

	$obj.render()
EndFunc

#EndRegion

#Region POV-Ray

Func _ImportPovFile()
	$file = FileOpenDialog("", "", "POV-Ray (*.pov)")
	If @error Then Return

	$oLayer = _CreatePovLayer($file, 0, 0, $oCurrentThread.thread.width, $oCurrentThread.thread.height)
	$oLayer.name = _WinAPI_PathStripPath($file)

	$oCurrentThread.thread.addLayer($oLayer)
	$oCurrentThread.thread.selectLayer($oCurrentThread.thread.layers.count()-1)

	$oCurrentThread.historyAdd()
	_RefreshLayerList()

	_Pov_RefreshViewportImage()
	_Pov_RenderCurrentLayer()
EndFunc

#EndRegion

#Region Selections

Func _InvertSel()
EndFunc

#EndRegion

#Region UI Animations

Func _FadeIn($hWnd)
	$aPos = WinGetPos($hWnd)

	For $i = 0 To 255 Step +20
		WinSetTrans($hWnd, "", $i)
		WinMove($hWnd, "", $aPos[0], $aPos[1]+(255-$i)/3, $aPos[2], $aPos[3]-(255-$i)/3)

		Sleep(1)
	Next

	WinSetTrans($hWnd, "", 255)
	WinMove($hWnd, "", $aPos[0], $aPos[1], $aPos[2], $aPos[3])
EndFunc

Func _FadeOut($hWnd)
	$aPos = WinGetPos($hWnd)

	For $i = 255 To 0 Step -20
		WinSetTrans($hWnd, "", $i)
		WinMove($hWnd, "", $aPos[0], $aPos[1], $aPos[2], $aPos[3]-(255-$i)/3)

		Sleep(1)
	Next

	WinSetTrans($hWnd, "", 0)
EndFunc

#EndRegion

#Region Drawing Area Notifications

Func _CreateNotification($sHeader, $sContent, $iType = $V4_NT_INFORMATION)
	AdlibUnRegister("_CloseNotification")
	$sNotificationHeader = $sHeader
	$sNotificationContent = $sContent
	$iNotificationType = $iType
	AdlibRegister("_CloseNotification", 3500)
EndFunc

Func _CloseNotification()
	AdlibUnRegister("_CloseNotification")
	$sNotificationHeader = ""
	$sNotificationContent = ""
EndFunc

#EndRegion

#Region Layer List

Func _RefreshLayerList()
	_GUICtrlListView_DeleteAllItems($cidLayerListView)

	If Not $isOpen Then Return

	Local $i = 0

	; Layers
	For $layer In $oCurrentThread.thread.layers
		Switch $layer.type
			Case $V4_LT_IMAGE
				$tBmp = _CreateLayerThumbnail($layer, $i)
				$tHBmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($tBmp)

				$idx = _GUIImageList_Add($hLayerImageList, $tHBmp)
				$item = _GUICtrlListView_AddItem($cidLayerListView, ($i = $oCurrentThread.thread.currentLayerId) ? ("["&$layer.name&"]") : $layer.name, $idx)
				_GUICtrlListView_SetItemGroupID($cidLayerListView, $item, 1)

				_GUICtrlListView_AddSubItem($cidLayerListView, $item, "", 1, $layer.isVisible ? $iLayerIcon_Visible : $iLayerIcon_Hidden)

				$lockIcon = $iLayerIcon_NoLock
				Switch $layer.lockMode
					Case $V4_LL_POS
						$lockIcon = $iLayerIcon_LockPos
					Case $V4_LL_COLOR
						$lockIcon = $iLayerIcon_LockColor
					Case $V4_LL_ALL
						$lockIcon = $iLayerIcon_LockAll
				EndSwitch

				_GUICtrlListView_AddSubItem($cidLayerListView, $item, "", 2, $lockIcon)

				_WinAPI_DeleteObject($tHBmp)
				_GDIPlus_BitmapDispose($tBmp)
			Case $V4_LT_PATH
				$path = $oCurrentThread.thread.paths.at($layer.pathIndex)
				$hPath = $path.createGdipPath()
				$tBmp = _CreatePathThumbnail($hPath)
				_GDIPlus_PathDispose($hPath)
				$tHBmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($tBmp)

				$idx = _GUIImageList_Add($hLayerImageList, $tHBmp)
				$item = _GUICtrlListView_AddItem($cidLayerListView, ($i = $oCurrentThread.thread.currentLayerId) ? ("["&$layer.name&"]") : $layer.name, $idx)
				_GUICtrlListView_SetItemGroupID($cidLayerListView, $item, 1)

				_GUICtrlListView_AddSubItem($cidLayerListView, $item, "", 1, $layer.isVisible ? $iLayerIcon_Visible : $iLayerIcon_Hidden)

				$lockIcon = $iLayerIcon_NoLock
				Switch $layer.lockMode
					Case $V4_LL_POS
						$lockIcon = $iLayerIcon_LockPos
					Case $V4_LL_COLOR
						$lockIcon = $iLayerIcon_LockColor
					Case $V4_LL_ALL
						$lockIcon = $iLayerIcon_LockAll
				EndSwitch

				_GUICtrlListView_AddSubItem($cidLayerListView, $item, "", 2, $lockIcon)

				_WinAPI_DeleteObject($tHBmp)
				_GDIPlus_BitmapDispose($tBmp)
			Case $V4_LT_POVRAY, $V4_LT_POVGENERATED
				$item = _GUICtrlListView_AddItem($cidLayerListView, ($i = $oCurrentThread.thread.currentLayerId) ? ("["&$layer.name&"]") : $layer.name, $iLayerIcon_3DObject)
				_GUICtrlListView_AddSubItem($cidLayerListView, $item, "", 1, $layer.isVisible ? $iLayerIcon_Visible : $iLayerIcon_Hidden)
			Case $V4_LT_EFFECT
				$item = _GUICtrlListView_AddItem($cidLayerListView, ($i = $oCurrentThread.thread.currentLayerId) ? ("["&$layer.name&"]") : $layer.name, $iLayerIcon_3DObject)
				_GUICtrlListView_SetItemGroupID($cidLayerListView, $item, 1)

				_GUICtrlListView_AddSubItem($cidLayerListView, $item, "", 1, $layer.isVisible ? $iLayerIcon_Visible : $iLayerIcon_Hidden)
		EndSwitch

		$i += 1
	Next

	$i = 0
	For $selection In $oCurrentThread.thread.selections
		$tBmp = _CreateSelectionThumbnail($selection.rgn)
		$tHBmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($tBmp)

		$idx = _GUIImageList_Add($hLayerImageList, $tHBmp)
		$item = _GUICtrlListView_AddItem($cidLayerListView, ($i = $oCurrentThread.thread.currentSelection) ? ("["&$selection.name&"]") : $selection.name, $idx)
		_GUICtrlListView_SetItemGroupID($cidLayerListView, $item, 2)

		$i += 1
	Next

	$i = 0
	For $path In $oCurrentThread.thread.paths
		$hPath = $path.createGdipPath()
		$tBmp = _CreatePathThumbnail($hPath)
		$tHBmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($tBmp)

		$idx = _GUIImageList_Add($hLayerImageList, $tHBmp)

		$item = _GUICtrlListView_AddItem($cidLayerListView, ($i = $oCurrentThread.thread.currentPath) ? ("["&$path.name&"]") : $path.name, $idx)
		_GUICtrlListView_SetItemGroupID($cidLayerListView, $item, 3)

		_GUICtrlListView_AddSubItem($cidLayerListView, $item, "", 1, $path.isVisible ? $iLayerIcon_Visible : $iLayerIcon_Hidden)

		$i += 1
		_GDIPlus_PathDispose($hPath)
	Next
EndFunc

Func _CreateSelectionThumbnail($hRegion)
	$fRatio = 32/$oCurrentThread.thread.width
	If $oCurrentThread.thread.height > $oCurrentThread.thread.width Then $fRatio = 32/$oCurrentThread.thread.height

	$fNewW = $oCurrentThread.thread.width*$fRatio
	$fNewH = $oCurrentThread.thread.height*$fRatio

	$iX = (32-$fNewW)/2
	$iY = (32-$fNewH)/2

	$tBmp = _GDIPlus_BitmapCreateFromScan0(32, 32)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_GDIPlus_GraphicsFillRect($tGpx, $iX, $iY, $fNewW, $fNewH)

	$tRegion = _GDIPlus_RegionClone($hRegion)
	$tMx = _GDIPlus_MatrixCreate()
	_GDIPlus_MatrixScale($tMx, $fNewW/$oCurrentThread.thread.width, $fNewW/$oCurrentThread.thread.width)
	_GDIPlus_RegionTransform($tRegion, $tMx)
	_GDIPlus_RegionTranslate($tRegion, $iX, $iY)
	_GDIPlus_RegionCombineRect($tRegion, $iX, $iY, $fNewW, $fNewH, 1)

	_GDIPlus_GraphicsSetClipRegion($tGpx, $tRegion)
	_GDIPlus_GraphicsClear($tGpx, 0xFFFFFFFF)

	_GDIPlus_MatrixDispose($tMx)
	_GDIPlus_RegionDispose($tRegion)

	_GDIPlus_GraphicsDispose($tGpx)

	Return $tBmp
EndFunc

Func _CreatePathThumbnail($hPath)
	$fRatio = 32/$oCurrentThread.thread.width
	If $oCurrentThread.thread.height > $oCurrentThread.thread.width Then $fRatio = 32/$oCurrentThread.thread.height

	$fNewW = $oCurrentThread.thread.width*$fRatio
	$fNewH = $oCurrentThread.thread.height*$fRatio

	$iX = (32-$fNewW)/2
	$iY = (32-$fNewH)/2

	$tBmp = _GDIPlus_BitmapCreateFromScan0(32, 32)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsSetSmoothingMode($tGpx, 4)

	$tMx = _GDIPlus_MatrixCreate()
	_GDIPlus_MatrixScale($tMx, $fNewW/$oCurrentThread.thread.width, $fNewW/$oCurrentThread.thread.width)
	_GDIPlus_MatrixTranslate($tMx, $iX, $iY, True)
	_GDIPlus_PathTransform($hPath, $tMx)

	$hPen = _GDIPlus_PenCreate()
	_GDIPlus_GraphicsDrawPath($tGpx, $hPath, $hPen)
	_GDIPlus_PenDispose($hPen)

	_GDIPlus_GraphicsFillPath($tGpx, $hPath)

	_GDIPlus_GraphicsDispose($tGpx)

	Return $tBmp
EndFunc

Func _CreateLayerThumbnail($oLayer, $iId)
	$fRatio = 32/$oCurrentThread.thread.width
	If $oCurrentThread.thread.height > $oCurrentThread.thread.width Then $fRatio = 32/$oCurrentThread.thread.height

	$fNewW = $oCurrentThread.thread.width*$fRatio
	$fNewH = $oCurrentThread.thread.height*$fRatio

	$iX = (32-$fNewW)/2
	$iY = (32-$fNewH)/2

	$tBmp = _GDIPlus_BitmapCreateFromScan0(32, 32)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_GDIPlus_GraphicsFillRect($tGpx, $iX, $iY, $fNewW, $fNewH, $hTransparency)
	_GDIPlus_GraphicsDrawImageRect($tGpx, $oLayer.bmp, $iX, $iY, $fNewW, $fNewH)

	If $iId = $oCurrentThread.thread.currentLayerId Then
		$sImage = _GetIconPath("toggle", "check_box", "black", "mdpi", 18)
		$hCheckbox = _GDIPlus_ImageLoadFromFile($sImage)

		_GDIPlus_GraphicsDrawImageRect($tGpx, $hCheckbox, 0, 0, 18, 18)

		_GDIPlus_ImageDispose($hCheckbox)
	EndIf

	_GDIPlus_GraphicsDispose($tGpx)

	Return $tBmp
EndFunc

Func _AddLayer()
	$hBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.width, $oCurrentThread.thread.height)

	$sName = "Layer "&($oCurrentThread.thread.layers.count()+1)
	If IsObj(_Util_LayerNameToObject($sName)) Then
		Do
			$sName &= "_"
		Until Not IsObj(_Util_LayerNameToObject($sName))
	EndIf

	$oLayer = _CreateImageLayer($hBmp)
	$oLayer.name = $sName


	$oCurrentThread.thread.addLayer($oLayer)
	$oCurrentThread.thread.selectLayer($oCurrentThread.thread.layers.count()-1)

	$oCurrentThread.historyAdd()
	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

Func _AddSelection()
	$sName = "Selection "&$oCurrentThread.thread.selections.count+1
	If IsObj(_Util_SelectionNameToObject($sName)) Then
		Do
			$sName &= "_"
		Until Not IsObj(_Util_SelectionNameToObject($sName))
	EndIf

	$oSelection = _CreateSelection($sName)
	$oCurrentThread.thread.selections.add($oSelection)
	$oCurrentThread.thread.currentSelection = $oCurrentThread.thread.selections.count - 1
	$oCurrentThread.thread.selection = $oSelection.rgn

	$oCurrentThread.historyAdd()
	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

Func _AddLayerFromFile()
	$sFile = FileOpenDialog("", "", "Images (*.BMP;*.PNG;*.JPEG;*.JPG;*.TIF;*.TIFF)")
	If @error Then Return

	$hBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.width, $oCurrentThread.thread.height)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	$hImg = _GDIPlus_ImageLoadFromFile($sFile)

	$iW = _GDIPlus_ImageGetWidth($hImg)
	$iH = _GDIPlus_ImageGetHeight($hImg)

	_GDIPlus_GraphicsDrawImageRect($hGpx, $hImg, 0, 0, $iW, $iH)

	_GDIPlus_ImageDispose($hImg)
	_GDIPlus_GraphicsDispose($hGpx)

	$oLayer = _CreateImageLayer($hBmp)
	$oLayer.name = _WinAPI_PathFindFileName($sFile)

	$oCurrentThread.thread.addLayer($oLayer)
	$oCurrentThread.thread.selectLayer($oCurrentThread.thread.layers.count()-1)

	$oCurrentThread.historyAdd()
	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

Func _RemoveLayer()
	If $oCurrentThread.thread.layers.count = 1 Then Return

	$oCurrentThread.thread.removeLayer($oCurrentThread.thread.currentLayerId)
	$oCurrentThread.thread.selectLayer(0)

	$oCurrentThread.historyAdd()
	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

Func _SetLayerLock()
	$lock = $V4_LL_NONE
	Switch GUICtrlRead(@GUI_CtrlId, 1)
		Case "Lock position"
			$lock = $V4_LL_POS
		Case "Lock pixels"
			$lock = $V4_LL_COLOR
		Case "Lock all"
			$lock = $V4_LL_ALL
	EndSwitch

	$oCurrentThread.thread.currentLayer.lockMode = $lock
	_RefreshLayerList()
EndFunc

Func _CreateLayerMenu($cidLayerMenu)
	GUICtrlCreateMenuItem("Layer options", $cidLayerMenu)
	GUICtrlSetOnEvent(-1, "_LayerOptions")
	GUICtrlCreateMenuItem("Channel routing", $cidLayerMenu)
	GUICtrlSetOnEvent(-1, "_ChannelRouting")
	GUICtrlCreateMenuItem("", $cidLayerMenu)
	GUICtrlCreateMenuItem("Delete Layer", $cidLayerMenu)
	GUICtrlSetOnEvent(-1, "_RemoveLayer")
	GUICtrlCreateMenuItem("Duplicate Layer", $cidLayerMenu)
	GUICtrlSetOnEvent(-1, "_DuplicateLayer")
	GUICtrlCreateMenuItem("", $cidLayerMenu)
EndFunc

Func _LayerOptions()
	If Not $isOpen Then Return 0
	Sleep(100)

	$oLayer = $oCurrentThread.thread.currentLayer

	$iOpt = Opt("GUIOnEventMode", 0)

	$hLayerOptsUI = GUICreate("Layer options: "&$oLayer.name, 410, 194, -1, -1, -1, -1, $hMainUI)

	$cidCancel = GUICtrlCreateButton("Cancel", 312, 152, 89, 33)

	$cidOK = GUICtrlCreateButton("OK", 216, 152, 89, 33)

	GUICtrlCreateLabel("Name:", 8, 12, 47, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidName = GUICtrlCreateInput($oLayer.name, 72, 8, 273, 29)
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	GUICtrlCreateLabel("Opacity:", 8, 52, 58, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidOpacity = GUICtrlCreateSlider(72, 50, 273, 33)
	GUICtrlSetData(-1, $oLayer.opacity)

	$cidOpacityReader = GUICtrlCreateInput($oLayer.opacity, 352, 48, 49, 29, BitOR($GUI_SS_DEFAULT_INPUT,$ES_RIGHT,$ES_READONLY))
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	GUICtrlCreateLabel("Blending mode:", 8, 100, 109, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidBlendMode = GUICtrlCreateCombo("", 128, 96, 273, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Normal|Darken|Multiply|Color Burn|Linear Burn|Lighten|Screen|Color Dodge|Linear Dodge|Overlay|Soft Light|Vivid Light|Linear Light|Pin Light|Hard Mix|Difference|Exclusion|Subtract|Divide")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	_GUICtrlComboBox_SetCurSel($cidBlendMode, $oLayer.blendMode)

	GUISetState()
	GUISwitch($hMainUI)

	While 1
		If GUICtrlRead($cidOpacity) <> GUICtrlRead($cidOpacityReader) Then GUICtrlSetData($cidOpacityReader, GUICtrlRead($cidOpacity))
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				$oLayer.name = GUICtrlRead($cidName)
				$oLayer.opacity = GUICtrlRead($cidOpacity)
				$oLayer.blendMode = _GUICtrlComboBox_GetCurSel($cidBlendMode)
				$oCurrentThread.historyAdd()

				ExitLoop
		EndSwitch
	WEnd

	GUIDelete($hLayerOptsUI)
	GUISwitch($hMainUI)

	_RefreshLayerList()
	_RenderDrawingArea()

	Opt("GUIOnEventMode", $iOpt)
EndFunc

Func _ChannelRouting()
	If Not $isOpen Then Return 0
	Sleep(100)

	$oLayer = $oCurrentThread.thread.currentLayer

	$iOpt = Opt("GUIOnEventMode", 0)

	$hLayerOptsUI = GUICreate("Channel routing: "&$oLayer.name, 405, 257, -1, -1, -1, -1, $hMainUI)

	$cidCancel = GUICtrlCreateButton("Cancel", 304, 216, 89, 33)

	$cidOK = GUICtrlCreateButton("OK", 208, 216, 89, 33)

	$cidEnableRouting = GUICtrlCreateCheckbox("Enable routing", 16, 8, 273, 25)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")
	If $oLayer.enableRouting Then GUICtrlSetState(-1, $GUI_CHECKED)

	GUICtrlCreateLabel("Route Red to:", 16, 44, 94, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidRouteRed = GUICtrlCreateCombo("", 144, 40, 249, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Red|Green|Blue|Alpha")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	_GUICtrlComboBox_SetCurSel($cidRouteRed, BitAND(BitShift($oLayer.routeFlags, 24), 0xFF))

	GUICtrlCreateLabel("Route Green to:", 16, 84, 107, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidRouteGreen = GUICtrlCreateCombo("", 144, 80, 249, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Red|Green|Blue|Alpha")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	_GUICtrlComboBox_SetCurSel($cidRouteGreen, BitAND(BitShift($oLayer.routeFlags, 16), 0xFF))

	GUICtrlCreateLabel("Route Blue to:", 16, 124, 97, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidRouteBlue = GUICtrlCreateCombo("", 144, 120, 249, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Red|Green|Blue|Alpha")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	_GUICtrlComboBox_SetCurSel($cidRouteBlue, BitAND(BitShift($oLayer.routeFlags, 8), 0xFF))

	GUICtrlCreateLabel("Route Alpha to:", 16, 164, 107, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidRouteAlpha = GUICtrlCreateCombo("", 144, 160, 249, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Red|Green|Blue|Alpha")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	_GUICtrlComboBox_SetCurSel($cidRouteAlpha, BitAND($oLayer.routeFlags, 0xFF))

	GUISetState()
	GUISwitch($hMainUI)

	While 1
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				$oLayer.enableRouting = 0
				If BitAND(GUICtrlRead($cidEnableRouting), $GUI_CHECKED) Then $oLayer.enableRouting = 1
				$oLayer.routeFlags = BitOR(_GUICtrlComboBox_GetCurSel($cidRouteAlpha), BitShift(_GUICtrlComboBox_GetCurSel($cidRouteBlue), -8), BitShift(_GUICtrlComboBox_GetCurSel($cidRouteGreen), -16), BitShift(_GUICtrlComboBox_GetCurSel($cidRouteRed), -24))
;~ 				$oLayer.name = GUICtrlRead($cidName)
;~ 				$oLayer.opacity = GUICtrlRead($cidOpacity)
;~ 				$oLayer.blendMode = _GUICtrlComboBox_GetCurSel($cidBlendMode)
				$oCurrentThread.historyAdd()

				ExitLoop
		EndSwitch
	WEnd

	GUIDelete($hLayerOptsUI)
	GUISwitch($hMainUI)

	_RefreshLayerList()
	_RenderDrawingArea()

	Opt("GUIOnEventMode", $iOpt)
EndFunc

Func _DuplicateLayer()
	$Dupli = $oCurrentThread.thread.currentLayer.clone()
	$Dupli.name &= " - copy"

	$oCurrentThread.thread.addLayer($Dupli)
	$oCurrentThread.thread.selectLayer($oCurrentThread.thread.layers.count-1)

	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

Func _DuplicateLayerRef()
	$oCurrentThread.thread.currentLayer.ref += 1
	$oCurrentThread.thread.addLayer($oCurrentThread.thread.currentLayer)
	$oCurrentThread.thread.selectLayer($oCurrentThread.thread.layers.count-1)

	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

Func _FillLayer()
	If Not $isOpen Then Return 0

	$iOpt = Opt("GUIOnEventMode", 0)

	$hFillUI = GUICreate("Fill", 314, 162, -1, -1, -1, -1, $hMainUI)

	GUICtrlCreateLabel("Color:", 8, 8, 77, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidColor = GUICtrlCreateCombo("", 8, 32, 297, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Foreground|Background|Black|White", "Foreground")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	$cidCancel = GUICtrlCreateButton("Cancel", 216, 120, 89, 33)
	$cidOK = GUICtrlCreateButton("OK", 120, 120, 89, 33)

	GUISetState()

	While 1
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				$iColor = $iForeground
				Switch GUICtrlRead($cidColor)
					Case "Background"
						$iColor = $iBackground
					Case "White"
						$iColor = 0xFFFFFFFF
					Case "Black"
						$iColor = 0xFF000000
				EndSwitch

				$tGpx = _Util_GetCurrentGraphics()
				_GDIPlus_GraphicsClear($tGpx, $iColor)
				_GDIPlus_GraphicsDispose($tGpx)

				$oCurrentThread.historyAdd()
				ExitLoop
		EndSwitch
	WEnd

	GUIDelete($hFillUI)
	GUISwitch($hMainUI)

	_RenderDrawingArea()
	_RefreshLayerList()

	Opt("GUIOnEventMode", $iOpt)
EndFunc

Func _MaskLayer()
	$oMask = _Util_LayerNameToObject(GUICtrlRead(@GUI_CtrlId, 1))

	_Interference_ApplyMask($oCurrentThread.thread.currentLayer.bmp, $oMask.bmp)

	$oCurrentThread.historyAdd()

	_RenderDrawingArea()
	_RefreshLayerList()
EndFunc

Func _MaskSelection()
	$oSelection = _Util_SelectionNameToObject(GUICtrlRead(@GUI_CtrlId, 1))

	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.width, $oCurrentThread.thread.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsSetClipRegion($tGpx, $oSelection.rgn)

	_GDIPlus_GraphicsDrawImageRect($tGpx, $oCurrentThread.thread.currentLayer.bmp, 0, 0, $oCurrentThread.thread.width, $oCurrentThread.thread.height)

	_GDIPlus_GraphicsDispose($tGpx)

	_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
	$oCurrentThread.thread.currentLayer.bmp = $tBmp
	$oCurrentThread.historyAdd()

	_RenderDrawingArea()
	_RefreshLayerList()
EndFunc

Func _MaskPath()
	$oPath = _Util_PathNameToObject(GUICtrlRead(@GUI_CtrlId, 1))
	$hGDIPPath = $oPath.createGdipPath()

	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.width, $oCurrentThread.thread.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)
	_GDIPlus_GraphicsSetSmoothingMode($tGpx, 5)

	$hTexBrush = _GDIPlus_TextureCreate($oCurrentThread.thread.currentLayer.bmp, 0)
	_GDIPlus_GraphicsFillPath($tGpx, $hGDIPPath, $hTexBrush)
	_GDIPlus_BrushDispose($hTexBrush)

	_GDIPlus_GraphicsDispose($tGpx)

	_GDIPlus_PathDispose($hGDIPPath)

	_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
	$oCurrentThread.thread.currentLayer.bmp = $tBmp
	$oCurrentThread.historyAdd()

	_RenderDrawingArea()
	_RefreshLayerList()
EndFunc

Func _ConvertPathToSelection()
	$hPath = $oCurrentThread.thread.paths.at($oCurrentThread.thread.currentPath)
	$hGDIPPath = $hPath.createGdipPath()
	$hRgn = _GDIPlus_RegionCreateFromPath($hGDIPPath)
	_GDIPlus_PathDispose($hGDIPPath)
	$oSel = _CreateSelection("Selection from "&$hPath.name)
	_GDIPlus_RegionDispose($oSel.rgn)
	$oSel.rgn = $hRgn

	$oCurrentThread.thread.selections.add($oSel)

	$oCurrentThread.thread.currentSelection = $oCurrentThread.thread.selections.count-1
	$oCurrentThread.thread.selection = $oSel.rgn

	$oCurrentThread.historyAdd()

	_RenderDrawingArea()
	_RefreshLayerList()
EndFunc

Func _ConvertPathToMask()
	$hPath = $oCurrentThread.thread.paths.at($oCurrentThread.thread.currentPath)
	$hGDIPPath = $hPath.createGdipPath()

	$hBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.width, $oCurrentThread.thread.height)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsClear($hGpx)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)

	$hBrush = _GDIPlus_BrushCreateSolid(0xFFFFFFFF)
	_GDIPlus_GraphicsFillPath($hGpx, $hGDIPPath, $hBrush)
	_GDIPlus_BrushDispose($hBrush)

	_GDIPlus_GraphicsDispose($hGpx)

	$oLayer = _CreateImageLayer($hBmp)
	$oLayer.name = "Mask from "&$hPath.name

	$oCurrentThread.thread.addLayer($oLayer)
	$oCurrentThread.thread.selectLayer($oCurrentThread.thread.layers.count-1)

	_GDIPlus_PathDispose($hGDIPPath)

	$oCurrentThread.historyAdd()

	_RenderDrawingArea()
	_RefreshLayerList()
EndFunc

Func _CreatePathLayerEv()
	$oLayer = _CreatePathLayer($oCurrentThread.thread.currentPath)
	$oCurrentThread.thread.addLayer($oLayer)
	$oCurrentThread.thread.selectLayer($oCurrentThread.thread.layers.count-1)
	$oCurrentThread.historyAdd()

	_RenderDrawingArea()
	_RefreshLayerList()
EndFunc

Func _RasterizeLayer()
	$oCurLayer = $oCurrentThread.thread.currentLayer
	$oCurLayer.render()
	$oNewLayer = _CreateImageLayer(_GDIPlus_ImageClone($oCurLayer.bmp))
	$oNewLayer.name = $oCurLayer.name
	$oCurrentThread.thread.addLayer($oNewLayer)

	$oCurrentThread.historyAdd()

	_RenderDrawingArea()
	_RefreshLayerList()
EndFunc

Func _PathLayerOptions()
	If Not $isOpen Then Return 0
	Sleep(100)

	$oLayer = $oCurrentThread.thread.currentLayer

	$iOpt = Opt("GUIOnEventMode", 0)

	$hPathRenderOptsUI = GUICreate("Path options - $LayerName", 410, 339, -1, -1, -1, -1, $hMainUI)

	$cidCancel = GUICtrlCreateButton("Cancel", 312, 296, 89, 33)
	$cidOK = GUICtrlCreateButton("OK", 216, 296, 89, 33)

	GUICtrlCreateLabel("Color:", 8, 12, 43, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")
	$cidOutlineColor = GUICtrlCreateLabel(BitAND($oLayer.outlineColor, 0xFFFFFF), 72, 8, 330, 29, $WS_BORDER)
	GUICtrlSetBkColor(-1, BitAND($oLayer.outlineColor, 0xFF))
	GUICtrlSetColor(-1, BitAND($oLayer.outlineColor, 0xFF))

	GUICtrlCreateLabel("Width:", 8, 52, 47, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")
	$cidWidth = GUICtrlCreateSlider(72, 50, 273, 33)
	GUICtrlSetData(-1, $oLayer.penWidth)

	$cidWidthReader = GUICtrlCreateInput($oLayer.penWidth, 352, 48, 49, 29, BitOR($GUI_SS_DEFAULT_INPUT,$ES_RIGHT,$ES_READONLY))
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	GUICtrlCreateLabel("", 8, 96, 392, 1, $WS_BORDER)

	GUICtrlCreateLabel("Dash style:", 8, 116, 74, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")
	$cidDashStyle = GUICtrlCreateCombo("", 96, 112, 305, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Normal|Dashed|Dotted|Dash-dot|Dash-dot-dot", "Normal")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")
	_GUICtrlComboBox_SetCurSel($cidDashStyle, $oLayer.dashStyle)

	GUICtrlCreateLabel("Dash caps:", 8, 156, 74, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")
	$cidDashCap = GUICtrlCreateCombo("", 96, 152, 305, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Flat|Round|Triangular", "Flat")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")
	_GUICtrlComboBox_SetCurSel($cidDashCap, $oLayer.dashCap)

	GUICtrlCreateLabel("", 8, 192, 392, 1, $WS_BORDER)

	GUICtrlCreateLabel("Start cap:", 8, 210, 66, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidStartCap = GUICtrlCreateCombo("", 88, 206, 313, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Flat|Square|Circular|Triangular", "Flat")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")
	_GUICtrlComboBox_SetCurSel($cidStartCap, $oLayer.startCap)

	GUICtrlCreateLabel("End cap:", 8, 252, 60, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidEndCap = GUICtrlCreateCombo("", 88, 248, 313, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Flat|Square|Circular|Triangular", "Flat")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")
	_GUICtrlComboBox_SetCurSel($cidEndCap, $oLayer.endCap)

	GUISetState()
	GUISwitch($hMainUI)

	While 1
		If GUICtrlRead($cidWidth) <> GUICtrlRead($cidWidthReader) Then GUICtrlSetData($cidWidthReader, GUICtrlRead($cidWidth))
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				$oLayer.outlineColor = BitOR(GUICtrlRead($cidOutlineColor), 0xFF000000)
				$oLayer.penWidth = GUICtrlRead($cidWidth)

				$oLayer.startCap = _GUICtrlComboBox_GetCurSel($cidStartCap)
				$oLayer.endCap = _GUICtrlComboBox_GetCurSel($cidEndCap)
				$oLayer.dashCap = _GUICtrlComboBox_GetCurSel($cidDashCap)
				$oLayer.dashStyle = _GUICtrlComboBox_GetCurSel($cidDashStyle)

				$oCurrentThread.historyAdd()

				ExitLoop
			Case $cidOutlineColor
				$iColor = _ColorPicker("Path outline", GUICtrlRead($cidOutlineColor))
				GUICtrlSetData($cidOutlineColor, $iColor)
				GUICtrlSetBkColor($cidOutlineColor, $iColor)
				GUICtrlSetColor($cidOutlineColor, $iColor)
		EndSwitch
	WEnd

	GUIDelete($hPathRenderOptsUI)
	GUISwitch($hMainUI)

	_RefreshLayerList()
	_RenderDrawingArea()

	Opt("GUIOnEventMode", $iOpt)
EndFunc

Func WM_NOTIFY($hWnd, $iMsg, $wParam, $lParam)
	#forceref $hWnd, $iMsg, $wParam
	Local $hWndFrom, $iIDFrom, $iCode, $tNMHDR, $hWndListView, $tInfo
	$hWndListView = $cidLayerListView
	If Not IsHWnd($cidLayerListView) Then $hWndListView = GUICtrlGetHandle($cidLayerListView)

	$tNMHDR = DllStructCreate($tagNMHDR, $lParam)
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	$iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
	$iCode = DllStructGetData($tNMHDR, "Code")
	Switch $hWndFrom
		Case $hWndListView
			Switch $iCode
				Case $NM_CLICK
					$aHitTest = _GUICtrlListView_HitTest($hWndListView)
					If $aHitTest[0] <> -1 And _GUICtrlListView_GetItemGroupID($hWndListView, $aHitTest[0]) = 1 Then
						$oLayer = $oCurrentThread.thread.layers.at($aHitTest[0])

						$aSubHitTest = _GUICtrlListView_SubItemHitTest($hWndListView)
						If $aSubHitTest[1] = 1 Then
							$oLayer.isVisible = 1 - $oLayer.isVisible
							_RefreshLayerList()
							_RenderDrawingArea()
						ElseIf $aSubHitTest[1] = 2 And $oLayer.type = $V4_LT_IMAGE Then
							$oLayer.lockMode = 3 - $oLayer.lockMode
							_RefreshLayerList()
						Else
							$oCurrentThread.thread.selectLayer($aHitTest[0])
							_RefreshLayerList()
						EndIf
					ElseIf $aHitTest[0] <> -1 And _GUICtrlListView_GetItemGroupID($hWndListView, $aHitTest[0]) = 2 Then
						$sName = _GUICtrlListView_GetItemText($hWndListView, $aHitTest[0])
						If StringLeft($sName, 1) = "[" And StringRight($sName, 1) = "]" Then $sName = StringTrimLeft(StringTrimRight($sName, 1), 1)
						$oSelection = _Util_SelectionNameToObject($sName)
						$iSelection = @extended

						$oCurrentThread.thread.currentSelection = $iSelection
						$oCurrentThread.thread.selection = $oSelection.rgn

						$oCurrentThread.historyAdd()
						_RenderDrawingArea()
						_RefreshLayerList()
					ElseIf $aHitTest[0] <> -1 And _GUICtrlListView_GetItemGroupID($hWndListView, $aHitTest[0]) = 3 Then
						$sName = _GUICtrlListView_GetItemText($hWndListView, $aHitTest[0])
						If StringLeft($sName, 1) = "[" And StringRight($sName, 1) = "]" Then $sName = StringTrimLeft(StringTrimRight($sName, 1), 1)
						_Util_PathNameToObject($sName)
						$iPath = @extended



						$aSubHitTest = _GUICtrlListView_SubItemHitTest($hWndListView)
						If $aSubHitTest[1] = 1 Then
							$oPath = $oCurrentThread.thread.paths.at($iPath)
							$oPath.isVisible = 1 - $oPath.isVisible
						Else
							$oCurrentThread.thread.currentPath = $iPath
						EndIf

						$oCurrentThread.historyAdd()
						_RenderDrawingArea()
						_RefreshLayerList()
					EndIf
					;_Util_SelectionNameToObject
				Case $NM_DBLCLK
					;
				Case $NM_RCLICK
					$aHitTest = _GUICtrlListView_HitTest($hWndListView)
					If $aHitTest[0] <> -1 And _GUICtrlListView_GetItemGroupID($hWndListView, $aHitTest[0]) = 1 Then
						$oCurrentThread.thread.selectLayer($aHitTest[0])
						$oLayer = $oCurrentThread.thread.layers.at($aHitTest[0])
						_RefreshLayerList()

						If $oLayer.type = $V4_LT_IMAGE Then
							$aSubHitTest = _GUICtrlListView_SubItemHitTest($hWndListView)
							If $aSubHitTest[1] = 2 Then
								Local $arr[4]

								$cidDummy = GUICtrlCreateDummy()

								$cidLockMenu = GUICtrlCreateContextMenu($cidDummy)

								$arr[0] = GUICtrlCreateMenuItem(_Loc("ObjList/LockMenu/NoLock"), $cidLockMenu, -1, 1)
								GUICtrlSetOnEvent(-1, "_SetLayerLock")
								$arr[1] = GUICtrlCreateMenuItem("Lock position", $cidLockMenu, -1, 1)
								GUICtrlSetOnEvent(-1, "_SetLayerLock")
								$arr[2] = GUICtrlCreateMenuItem("Lock pixels", $cidLockMenu, -1, 1)
								GUICtrlSetOnEvent(-1, "_SetLayerLock")
								$arr[3] = GUICtrlCreateMenuItem("Lock all", $cidLockMenu, -1, 1)
								GUICtrlSetOnEvent(-1, "_SetLayerLock")

								GUICtrlSetState($arr[$oLayer.lockMode], $GUI_CHECKED)

								_GUICtrlMenu_TrackPopupMenu(GUICtrlGetHandle($cidLockMenu), $hMainUI)
							Else
								$sName = StringTrimLeft(StringTrimRight(_GUICtrlListView_GetItemText($hWndListView, $aHitTest[0]), 1), 1)

								$cidDummy = GUICtrlCreateDummy()

								$cidLayerMenu = GUICtrlCreateContextMenu($cidDummy)

								_CreateLayerMenu($cidLayerMenu)
								GUICtrlCreateMenuItem("", $cidLayerMenu)
								GUICtrlCreateMenuItem("Fill", $cidLayerMenu)
								GUICtrlSetOnEvent(-1, "_FillLayer")
								$cidMask = GUICtrlCreateMenu("Mask...", $cidLayerMenu)
								$cidMaskLayer = GUICtrlCreateMenu("With layer...", $cidMask)

								For $layer In $oCurrentThread.thread.layers
									If $layer.name <> $sName Then
										GUICtrlCreateMenuItem($layer.name, $cidMaskLayer)
										GUICtrlSetOnEvent(-1, "_MaskLayer")
									EndIf
								Next

								$cidMaskSel = GUICtrlCreateMenu("With selection...", $cidMask)

								For $sel In $oCurrentThread.thread.selections
									GUICtrlCreateMenuItem($sel.name, $cidMaskSel)
									GUICtrlSetOnEvent(-1, "_MaskSelection")
								Next

								$cidMaskPath = GUICtrlCreateMenu("With path...", $cidMask)

								For $path In $oCurrentThread.thread.paths
									GUICtrlCreateMenuItem($path.name, $cidMaskPath)
									GUICtrlSetOnEvent(-1, "_MaskPath")
								Next

								GUICtrlCreateMenuItem("", $cidLayerMenu)
								GUICtrlCreateMenuItem("Merge Layers", $cidLayerMenu)
								GUICtrlCreateMenuItem("Merge Visible", $cidLayerMenu)
								GUICtrlCreateMenuItem("Flatten Image", $cidLayerMenu)

								_GUICtrlMenu_TrackPopupMenu(GUICtrlGetHandle($cidLayerMenu), $hMainUI)
							EndIf
						ElseIf $oLayer.type = $V4_LT_POVRAY Then
							$cidDummy = GUICtrlCreateDummy()

							$cidLayerMenu = GUICtrlCreateContextMenu($cidDummy)

							_CreateLayerMenu($cidLayerMenu)
							GUICtrlCreateMenuItem("", $cidLayerMenu)
							GUICtrlCreateMenuItem("Refresh viewport image", $cidLayerMenu)
							GUICtrlSetOnEvent(-1, "_Pov_RefreshViewportImage")
							GUICtrlCreateMenuItem("Re-render", $cidLayerMenu)
							GUICtrlSetOnEvent(-1, "_Pov_RenderCurrentLayer")

							_GUICtrlMenu_TrackPopupMenu(GUICtrlGetHandle($cidLayerMenu), $hMainUI)
						ElseIf $oLayer.type = $V4_LT_PATH Then
							$cidDummy = GUICtrlCreateDummy()

							$cidLayerMenu = GUICtrlCreateContextMenu($cidDummy)

							_CreateLayerMenu($cidLayerMenu)
							GUICtrlCreateMenuItem("Rasterize layer", $cidLayerMenu)
							GUICtrlSetOnEvent(-1, "_RasterizeLayer")
							GUICtrlCreateMenuItem("Path layer options", $cidLayerMenu)
							GUICtrlSetOnEvent(-1, "_PathLayerOptions")

							_GUICtrlMenu_TrackPopupMenu(GUICtrlGetHandle($cidLayerMenu), $hMainUI)
						Else
							$cidDummy = GUICtrlCreateDummy()

							$cidLayerMenu = GUICtrlCreateContextMenu($cidDummy)

							_CreateLayerMenu($cidLayerMenu)
						EndIf
					ElseIf $aHitTest[0] <> -1 And _GUICtrlListView_GetItemGroupID($hWndListView, $aHitTest[0]) = 2 Then
						$sText = StringTrimLeft(StringTrimRight(_GUICtrlListView_GetItemText($hWndListView, $aHitTest[0]), 1), 1)

						$cidDummy = GUICtrlCreateDummy()

						$cidLayerMenu = GUICtrlCreateContextMenu($cidDummy)

						GUICtrlCreateMenuItem("Duplicate selection", $cidLayerMenu)
						GUICtrlCreateMenuItem("Delete selection", $cidLayerMenu)
						GUICtrlCreateMenuItem("Rename selection", $cidLayerMenu)
						GUICtrlCreateMenuItem("", $cidLayerMenu)
						GUICtrlCreateMenuItem("Combine", $cidLayerMenu)

						_GUICtrlMenu_TrackPopupMenu(GUICtrlGetHandle($cidLayerMenu), $hMainUI)
					ElseIf $aHitTest[0] <> -1 And _GUICtrlListView_GetItemGroupID($hWndListView, $aHitTest[0]) = 3 Then
						$sName = _GUICtrlListView_GetItemText($hWndListView, $aHitTest[0])
						If StringLeft($sName, 1) = "[" And StringRight($sName, 1) = "]" Then $sName = StringTrimLeft(StringTrimRight($sName, 1), 1)
						_Util_PathNameToObject($sName)
						$iPath = @extended

						$oCurrentThread.thread.currentPath = $iPath
						_RefreshLayerList()

						$cidDummy = GUICtrlCreateDummy()

						$cidLayerMenu = GUICtrlCreateContextMenu($cidDummy)

						GUICtrlCreateMenuItem("Duplicate path", $cidLayerMenu)
						GUICtrlCreateMenuItem("Delete path", $cidLayerMenu)
						GUICtrlCreateMenuItem("Rename path", $cidLayerMenu)
						GUICtrlCreateMenuItem("", $cidLayerMenu)
						GUICtrlCreateMenuItem("Combine", $cidLayerMenu)
						GUICtrlCreateMenuItem("", $cidLayerMenu)
						GUICtrlCreateMenuItem("Create path layer", $cidLayerMenu)
						GUICtrlSetOnEvent(-1, "_CreatePathLayerEv")
						GUICtrlCreateMenuItem("", $cidLayerMenu)
						GUICtrlCreateMenuItem("Convert to selection", $cidLayerMenu)
						GUICtrlSetOnEvent(-1, "_ConvertPathToSelection")
						GUICtrlCreateMenuItem("Convert to mask", $cidLayerMenu)
						GUICtrlSetOnEvent(-1, "_ConvertPathToMask")

						_GUICtrlMenu_TrackPopupMenu(GUICtrlGetHandle($cidLayerMenu), $hMainUI)
					Else
						$cidDummy = GUICtrlCreateDummy()

						$cidLayerMenu = GUICtrlCreateContextMenu($cidDummy)

						GUICtrlCreateMenuItem("Add empty layer", $cidLayerMenu)
						GUICtrlSetOnEvent(-1, "_AddLayer")
						GUICtrlCreateMenuItem("Add from file", $cidLayerMenu)
						GUICtrlSetOnEvent(-1, "_AddLayerFromFile")

						_GUICtrlMenu_TrackPopupMenu(GUICtrlGetHandle($cidLayerMenu), $hMainUI)
					EndIf
					Return 0 ; allow the default processing
				Case $NM_RDBLCLK
					;
					Return 0
			EndSwitch
	EndSwitch

	Return $GUI_RUNDEFMSG
EndFunc

#EndRegion

#Region Panel Rack

Func _SwitchPanel()
	If $isClosing Then Return 0

	$iCurrentPanel = _Tiles_ButtonGetExtra(@GUI_CtrlId)
	GUICtrlSetState($aPanelTabs[$iCurrentPanel], $GUI_SHOW)

	_Tiles_ButtonSetBkColor($cidCurrentPanel, 0xFFF0F0F0, 0xFFE0E0E0)

	$cidCurrentPanel = @GUI_CtrlId
	_Tiles_ButtonSetBkColor($cidCurrentPanel, 0xFFE0E0E0, 0xFFD0D0D0)
EndFunc

#EndRegion

#Region Tool Rack

Func _SetTool()
	If $isClosing Then Return 0

	If $hToolUIWindow <> 0 Then GUIDelete($hToolUIWindow)

	$iCurrentTool = _Tiles_ButtonGetExtra(@GUI_CtrlId)
	$oCurrentTool = $aTools[$iCurrentTool]

	_Tiles_Button2SetColors($cidSelectedTool, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0)

	$cidSelectedTool = @GUI_CtrlId
	_Tiles_Button2SetColors($cidSelectedTool, 0xFFD0D0D0, 0xFFC0C0C0, 0xFFB0B0B0)

	$hToolUIWindow = $oCurrentTool.showUI()
EndFunc

Func _SetColor()
	$sName = "Foreground"
	Switch @GUI_CtrlId
		Case $cidForeground
			$color = $iForeground
		Case $cidBackground
			$sName = "Background"
			$color = $iBackground
	EndSwitch
	$color = _ColorPicker("", _SetAlpha($color, 0))
	Switch @GUI_CtrlId
		Case $cidForeground
			$iForeground = _SetAlpha($color, 255)
		Case $cidBackground
			$iBackground = _SetAlpha($color, 255)
	EndSwitch
	GUICtrlSetBkColor(@GUI_CtrlId, _SetAlpha($color, 0))
EndFunc

#EndRegion

#Region Files

Func _Save()
	If Not $isOpen Then Return

	Local $file

	If $oCurrentThread.isNew Then
		$file = FileSaveDialog("", "", "vPaint Image (*.v4i)|JPEG (*.jpeg;*.jpg)|PNG (*.png)|Windows Bitmap (*.bmp)")
		If @error Then Return

		_SaveFile($file)
	Else
		$file = $oCurrentThread.file

		_SaveFile($oCurrentThread.file)
	EndIf

	If FileExists($file) Then
		_CreateNotification("File saved", "The image has been successfully saved to "&$file, $V4_NT_SUCCESS)
	Else
		_CreateNotification("An error occured", "vPaint was unable to save the file. Check if you have enough disk space.", $V4_NT_ERROR)
	EndIf
EndFunc

Func _SaveAs()
	If Not $isOpen Then Return

	$file = FileSaveDialog("", "", "vPaint Image (*.v4i)|JPEG (*.jpeg;*.jpg)|PNG (*.png)|Windows Bitmap (*.bmp)")
	If @error Then Return

	_SaveFile($file, 0)
EndFunc

Func _SaveFile($file, $iChangeInfo = 1)
	Switch _WinAPI_PathFindExtension($file)
		Case ".v4i" ; party time!
			_V4ISave($oCurrentThread, $file)
		Case ".bmp", ".jpg", ".png"
			ConsoleWrite("d")
			$tBmp = $oCurrentThread.thread.renderRaw()
			_GDIPlus_ImageSaveToFile($tBmp, $file)
			_GDIPlus_BitmapDispose($tBmp)
	EndSwitch

	If $iChangeInfo Then
		$oCurrentThread.name = _WinAPI_PathFindFileName($file)
		$oCurrentThread.file = $file
		$oCurrentThread.isNew = 0
	EndIf

	_RefreshTabs()
	_RefreshCompositing()

	_RenderDrawingArea()
EndFunc

Func _New()
	$opt = Opt("GUIOnEventMode", 0)

	$hNewFileUI = GUICreate("New canvas", 448, 264, -1, -1, -1, -1, $hMainUI)

	GUICtrlCreateLabel("Name:", 8, 12, 47, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidName = GUICtrlCreateInput("Untitled", 64, 8, 377, 29)
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	GUICtrlCreateGroup("", 8, 56, 433, 161)

	GUICtrlCreateLabel("Width:", 24, 92, 47, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidWidth = GUICtrlCreateInput("640", 128, 88, 297, 29)
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	GUICtrlCreateLabel("Height:", 24, 132, 52, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidHeight = GUICtrlCreateInput("480", 128, 128, 297, 29)
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	GUICtrlCreateLabel("Background:", 24, 172, 86, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidBg = GUICtrlCreateCombo("", 128, 168, 297, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Transparent|White|Black|Background color", "Transparent")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	GUICtrlCreateGroup("", -99, -99, 1, 1)

	$cidPresets = GUICtrlCreateCombo("", 24, 48, 185, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "vPaint Default|Photoshop Default")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	$cidCreate = GUICtrlCreateButton("Create", 352, 224, 89, 33)

	GUISetState()

	While 1
		$msg = GUIGetMsg(1)
		If $msg[1] = $hNewFileUI Then
			Switch $msg[0]
				Case -3
					ExitLoop
				Case $cidCreate
					GUISwitch($hMainUI)
					_NewFile(GUICtrlRead($cidName), GUICtrlRead($cidWidth), GUICtrlRead($cidHeight), GUICtrlRead($cidBg))
					ExitLoop
			EndSwitch
		EndIf
	WEnd

	GUIDelete($hNewFileUI)
	GUISwitch($hMainUI)

	Opt("GUIOnEventMode", $opt)
EndFunc

Func _NewFile($sName, $iW, $iH, $iBg)
	$hBmp = _GDIPlus_BitmapCreateFromScan0($iW, $iH)

	$oThread = _CreateThread($iW, $iH)

	$oLayer = _CreateImageLayer($hBmp)
	$oLayer.name = "Layer 1"

	$oThread.addLayer($oLayer)
	$oThread.selectLayer(0)

	$oThreadMgm = _CreateThreadManager($oThread)
	$oThreadMgm.name = $sName
	$oThreadMgm.isNew = 1
	$oThreadMgm.file = ""
	$oThreadMgm.historyAdd()
	$oThreadMgm.type = $V4_TT_IMAGE

	_AddThread($oThreadMgm)
	_SelectThread($aThreads[0])

	$isOpen = 1

	_RefreshCompositing()
	_RefreshTabs()
	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

Func _Open()
	$file = FileOpenDialog("", "", "vPaint Image (*.v4i)|JPEG (*.jpeg;*.jpg)|PNG (*.png)|Windows Bitmap (*.bmp)")
	If @error Then Return 0

	_OpenFile($file)
EndFunc

Func _OpenFile($file)
	Switch _WinAPI_PathFindExtension($file)
		Case ".v4i" ; party time!
			_V4IOpen($file)
		Case ".bmp", ".jpg", ".png"
			$hBmp = _GDIPlus_ImageLoadFromFile($file)

			$oThread = _CreateThread(_GDIPlus_ImageGetWidth($hBmp), _GDIPlus_ImageGetHeight($hBmp))

			$oLayer = _CreateImageLayer($hBmp)
			$oLayer.name = _WinAPI_PathFindFileName($file)

			$oThread.addLayer($oLayer)
			$oThread.selectLayer(0)

			$oThreadMgm = _CreateThreadManager($oThread)
			$oThreadMgm.name = _WinAPI_PathFindFileName($file)
			$oThreadMgm.file = $file
			$oThreadMgm.historyAdd()
			$oThreadMgm.type = $V4_TT_IMAGE

			_AddThread($oThreadMgm)
			_SelectThread($aThreads[0])

			$isOpen = 1
		Case ".mp3", ".wav" ; not yet
			$oThreadMgm = _CreateAudioThread($file)
			$oThreadMgm.name = _WinAPI_PathFindFileName($file)

			_AddThread($oThreadMgm)
			_SelectThread($aThreads[0])

			_BASS_ChannelPlay($oThreadMgm.stream, 1)

			$isOpen = 1
	EndSwitch

	_RefreshCompositing()
	_RefreshTabs()
	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

#EndRegion

#Region History

Func _Undo()
	If Not $isOpen Then Return 0

	$oCurrentThread.undo()

	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

Func _Redo()
	If Not $isOpen Then Return 0

	$oCurrentThread.redo()

	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

#EndRegion

#Region WMs

Func WM_MOUSEWHEEL($hWnd, $Msg, $wParam, $lParam)
	#forceref $hWnd, $Msg, $lParam

	If BitShift($wParam, 16) < 0 Then
		; down
		If $isOpen Then
			If _IsPressed(11) Then
				$oCurrentThread.zoom /= 2
				_UpdateTabText()
				If $oCurrentThread.zoom >= 4 Then _Util_CreatePixelGrid()
			ElseIf _IsPressed(12) Then
				$oCurrentThread.viewDx -= 10
			Else
				$oCurrentThread.viewDy -= 10
			EndIf
		EndIf
	Else
		; up
		If $isOpen Then
			If _IsPressed(11) Then
				$oCurrentThread.zoom *= 2
				_UpdateTabText()
				If $oCurrentThread.zoom >= 4 Then _Util_CreatePixelGrid()
			ElseIf _IsPressed(12) Then
				$oCurrentThread.viewDx += 10
			Else
				$oCurrentThread.viewDy += 10
			EndIf
		EndIf
	EndIf

	Return $GUI_RUNDEFMSG
EndFunc

#EndRegion

#Region Tabs

Func _SwitchTab()
	For $i = 1 To $aTabs[0]
		If $aTabs[$i] = @GUI_CtrlId Then
			_SelectThread($i)
			ExitLoop
		EndIf
	Next

	_RefreshCompositing()
	_RefreshLayerList()
	_RenderDrawingArea_Gen()
	_SetActiveTab($iCurrentThread)
EndFunc

Func _DeleteTab()
	If $aThreads[0] = 0 Then Return
	$obj = $aThreads[$iCurrentThread]
	$obj.dispose

	$oCurrentThread = 0

	_ArrayDelete($aThreads, $iCurrentThread)
	$aThreads[0] -= 1

	_RefreshTabs()

	If $aThreads[0] = 0 Then
		$isOpen = 0
	Else
		_SelectThread(1)
		_SetActiveTab(1)
	EndIf

	_RefreshCompositing()
	_RefreshLayerList()
	_RenderDrawingArea()
EndFunc

Func _RefreshTabs()
	; delete
	For $i = $aTabs[0] To 1 Step -1
		_Tiles_ButtonDelete($aTabs[$i])
		_ArrayDelete($aTabs, $i)
		$aTabs[0] -= 1
	Next

	$iNextTabBtnX = 40
	; create
	For $i = 1 To $aThreads[0]
		$oThread = $aThreads[$i]

		Switch $isTabletMode
			Case 0
				$cidFileMenuBtn = _Tiles_CreateButton(StringStripCR(_TabText($oThread))&"", $iNextTabBtnX, 70*$iUIScaleFactor, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 12*$iUIScaleFactor, 30*$iUIScaleFactor)
				$iNextTabBtnX += @extended
		EndSwitch

		GUICtrlSetOnEvent(-1, "_SwitchTab")

		_ArrayAdd($aTabs, $cidFileMenuBtn)
		$aTabs[0] += 1
	Next

	_SetActiveTab($iCurrentThread)
EndFunc

Func _UpdateTabText()
	For $i = 1 To $aTabs[0]
		$iIndex = _Tiles_GetButtonIndexFromCtrl($aTabs[$i])
		$oObj = $__Tiles_aButtonObjectList[$iIndex]
		$oThread = $aThreads[$i]

		$oObj.text = _TabText($oThread)&"  "
	Next

	_SetActiveTab($iCurrentThread)
EndFunc

Func _TabText($oThread)
	Switch $oThread.type
		Case $V4_TT_IMAGE
			$name = _WinAPI_PathCompactPathEx($oThread.name, 24)
			$zoom = $oThread.zoom*100

			Return $name&" ("&$zoom&"%)"
		Case $V4_TT_AUDIO
			Return $oThread.name
	EndSwitch
EndFunc

Func _SetActiveTab($iTab)
	For $i = 1 To $aTabs[0]
		$iIndex = _Tiles_GetButtonIndexFromCtrl($aTabs[$i])
		$oObj = $__Tiles_aButtonObjectList[$iIndex]

		$color1 = 0xFFF0F0F0
		$color2 = 0xFFE0E0E0
		$color3 = 0xFF444444
		$font = $v4Setting_UI_FontFamily

		If $i = $iTab Then
			$color1 = 0xFFC0C0C0
			$color2 = 0xFFB0B0B0
			$color3 = 0xFF3E3E3E
			$font = $v4Setting_UI_FontFamily
		EndIf

		$oObj.bgcolor = $color1
		$oObj.hovercolor = $color2
		$oObj.textcolor = $color3
		$oObj.font = $font

		$oObj.Render()
	Next
EndFunc

#EndRegion
