#include-once
#include <NodeUI.au3>

Global $gi_NODEID = 0

Global Enum $NODE_VTYPE_NUMBER = 0, _
			$NODE_VTYPE_STRING, _
			$NODE_VTYPE_BITMAP, _
			$NODE_VTYPE_BRUSHPEN

Func _Node_CreateNode($sName, $sExecFunc, $iTypeID, $iX = 0, $iY = 0, $oInputs = LinkedList(), $oOutputs = LinkedList(), $sCustomRenderFunc = "_Node_CustomRenderBlank")
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, $sName)
	_AutoItObject_AddProperty($obj, "nodeId", $ELSCOPE_PUBLIC, $gi_NODEID)
	_AutoItObject_AddProperty($obj, "typeId", $ELSCOPE_PUBLIC, $iTypeID)

	_AutoItObject_AddProperty($obj, "input", $ELSCOPE_PUBLIC, $oInputs)
	_AutoItObject_AddProperty($obj, "output", $ELSCOPE_PUBLIC, $oOutputs)

	_AutoItObject_AddProperty($obj, "uiX", $ELSCOPE_PUBLIC, $iX)
	_AutoItObject_AddProperty($obj, "uiY", $ELSCOPE_PUBLIC, $iY)

	_AutoItObject_AddProperty($obj, "uiWidth", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "uiHeight", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddMethod($obj, "execFunc", $sExecFunc)
	_AutoItObject_AddMethod($obj, "exec", "_Node_ExecNode")

	_AutoItObject_AddMethod($obj, "calcSize", "_Node_CalcSize")
	_AutoItObject_AddMethod($obj, "calcInXY", "_Node_CalcInputXY")
	_AutoItObject_AddMethod($obj, "calcOutXY", "_Node_CalcOutputXY")

	_AutoItObject_AddMethod($obj, "crender", $sCustomRenderFunc)

	$gi_NODEID += 1

	Return $obj
EndFunc

Func _Node_CustomRenderBlank($oNode, $iMode, $hGpx, $tRect, $iIndex, $oObj)
	Switch $iMode
		Case 0 ; Get custom render height
			Return 0
		Case 1 ; Generic drawing
		Case 2 ; Input drawing
		Case 3 ; Output drawing
	EndSwitch
EndFunc

Func _Node_CalcSize($oSelf)
	$iCHeight = $oSelf.crender(0, 0, 0, 0, 0)
	$oSelf.uiWidth = 200
	$oSelf.uiHeight = 40+$oSelf.input.count*30+$oSelf.output.count*30+20+$iCHeight+10
EndFunc

Func _Node_CalcInputXY($oSelf, $iInput)
	Local $aPos[2] = [0, 0]
	$aPos[1] = 40+$iInput*30+$oSelf.crender(0, 0, 0, 0, 0)

	Return $aPos
EndFunc

Func _Node_CalcOutputXY($oSelf, $iOutput)
	Local $aPos[2] = [$oSelf.uiWidth-15, 0]
	$aPos[1] = 40+$oSelf.input.count*30+$iOutput*30+$oSelf.crender(0, 0, 0, 0, 0)

	Return $aPos
EndFunc

Func _Node_CreateIOItem($sName, $iType, $oNode = 0, $iNodeOut = 0)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, $sName)
	_AutoItObject_AddProperty($obj, "type", $ELSCOPE_PUBLIC, $iType)

	_AutoItObject_AddProperty($obj, "node", $ELSCOPE_PUBLIC, $oNode)
	_AutoItObject_AddProperty($obj, "nodeOut", $ELSCOPE_PUBLIC, $iNodeOut)

	Return $obj
EndFunc

Func _Node_CreateList()
	Local $obj = LinkedList()

	_AutoItObject_AddMethod($obj, "removeNode", "_Node_RemoveNodeFromList")

	Return $obj
EndFunc

Func _Node_ExecNode($oSelf, $iOutput)
	Local $iInCount = $oSelf.input.count
	Local $aInputs[$iInCount]
	Local $oInput, $oPrevNode

	For $i = 0 To ($iInCount-1)
		$oInput = $oSelf.input.at($i)
		If IsObj($oInput.node) Then
			$oPrevNode = $oInput.node
			$aInputs[$i] = $oPrevNode.exec($oInput.nodeOut)
		Else
			$aInputs[$i] = -1234
		EndIf
	Next

	$vCall = $oSelf.execFunc($iOutput, $aInputs)

	Return $vCall
EndFunc

Func _Node_RemoveNodeFromList($oSelf, $iNode)
	Local $oNode = $oSelf.at($iNode)

	For $node In $oSelf
		For $input In $node.input
			If $input.node.nodeId = $oNode.nodeId Then
				$input.node = 0
				$input.nodeOut = 0
			EndIf
		Next
	Next

	$oSelf.remove($iNode)
EndFunc
