#include-once

; #INDEX# =======================================================================================================================
; Title .........: Properties for Tiles UDF
; AutoIt Version : 3.3.10.2++
; Description ...: Customize your tiles with badges, lists etc.
; Author(s) .....: scintilla4evr
; UDF Version ...: 1.0
; ===============================================================================================================================

Func _Tiles_PropertiesCreate()
	Local $oObj = _AutoItObject_Create()

	_AutoItObject_AddProperty($oObj, "altname", Default, 0)
	_AutoItObject_AddProperty($oObj, "altnamedata", Default, 0)

	; badge options
	_AutoItObject_AddProperty($oObj, "badge", Default, 0)
	_AutoItObject_AddProperty($oObj, "badgedata", Default, 0)

	; icon instead of name
	_AutoItObject_AddProperty($oObj, "smallicon", Default, 0)
	_AutoItObject_AddProperty($oObj, "iconsrc", Default, 0)

	; list
	_AutoItObject_AddProperty($oObj, "list", Default, 0)
	_AutoItObject_AddProperty($oObj, "listdata", Default, 0)

	; header
	_AutoItObject_AddProperty($oObj, "header", Default, 0)
	_AutoItObject_AddProperty($oObj, "headerdata", Default, 0)

	; day&month
	_AutoItObject_AddProperty($oObj, "daymonth", Default, 0)
	_AutoItObject_AddProperty($oObj, "daymonth_txt1", Default, 0)
	_AutoItObject_AddProperty($oObj, "daymonth_txt2", Default, 0)

	; 80x80px thumb
	_AutoItObject_AddProperty($oObj, "thumb", Default, 0)
	_AutoItObject_AddProperty($oObj, "thumbsrc", Default, 0)

	Return $oObj
EndFunc

Func _Tiles_PropertiesClone($oTileProperties)
	If Not IsObj($oTileProperties) Then Return 0
	Local $oObj = _Tiles_PropertiesCreate()

	$oObj.altname = $oTileProperties.altname
	$oObj.altnamedata = $oTileProperties.altnamedata

	$oObj.badge = $oTileProperties.badge
	$oObj.badgedata = $oTileProperties.badgedata

	$oObj.smallicon = $oTileProperties.smallicon
	$oObj.iconsrc = $oTileProperties.iconsrc

	$oObj.list = $oTileProperties.list
	$oObj.listdata = $oTileProperties.listdata

	$oObj.header = $oTileProperties.header
	$oObj.headerdata = $oTileProperties.headerdata

	$oObj.daymonth = $oTileProperties.daymonth
	$oObj.daymonth_txt1 = $oTileProperties.daymonth_txt1
	$oObj.daymonth_txt2 = $oTileProperties.daymonth_txt2

	$oObj.thumb = $oTileProperties.thumb
	$oObj.thumbsrc = $oTileProperties.thumbsrc

	Return $oObj
EndFunc

Func _Tiles_PropertiesSetBadge($oTileProperties, $iEnableBadge = 0, $iData = 1)
	$oTileProperties.badge = $iEnableBadge
	$oTileProperties.badgedata = $iEnableBadge ? $iData : 0

	Return True
EndFunc

Func _Tiles_PropertiesSetSmallIcon($oTileProperties, $iEnableSmallIcon = 0, $sIcon = 0)
	$oTileProperties.smallicon = $iEnableSmallIcon
	$oTileProperties.iconsrc = $iEnableSmallIcon ? $sIcon : 0

	Return True
EndFunc

Func _Tiles_PropertiesSetList($oTileProperties, $iEnableList = 0, $sData = 0)
	$oTileProperties.list = $iEnableList
	$oTileProperties.listdata = $iEnableList ? StringFormat($sData, "") : 0

	Return True
EndFunc

Func _Tiles_PropertiesSetHeader($oTileProperties, $iEnableHeader = 0, $sData = 0)
	$oTileProperties.header = $iEnableHeader
	$oTileProperties.headerdata = $iEnableHeader ? $sData : 0

	Return True
EndFunc

Func _Tiles_PropertiesSetDayMonth($oTileProperties, $iEnableDayMonth = 0, $sTxt1 = @MDAY, $sTxt2 = "")
	$oTileProperties.daymonth = $iEnableDayMonth
	$oTileProperties.daymonth_txt1 = $sTxt1
	$oTileProperties.daymonth_txt2 = $sTxt2

	Return True
EndFunc

Func _Tiles_PropertiesSetThumb($oTileProperties, $iEnableThumb = 0, $sThumb = 0)
	$oTileProperties.thumb = $iEnableThumb
	$oTileProperties.thumbsrc = $iEnableThumb ? $sThumb : 0

	Return True
EndFunc

Func _Tiles_PropertiesSetAltName($oTileProperties, $iEnableAltName = 0, $sName = 0)
	$oTileProperties.altname = $iEnableAltName
	$oTileProperties.altnamedata = $sName


	Return True
EndFunc
