#include-once

Global $hMainUI, $cidDrawingArea, $cidBackgroundArea, $cidProgressBar
Global $cidForeground, $cidBackground
Global $cidBlendAdd, $cidBlendColorBurn, $cidBlendColorDodge, $cidBlendDarken
Global $cidBlendDifference, $cidBlendDiv, $cidBlendExclusion, $cidBlendHardLight
Global $cidBlendHardMix, $cidBlendLighten, $cidBlendLinearBurn, $cidBlendLinearLight
Global $cidBlendNormal, $cidBlendScreen, $cidBlendSoftLight, $cidBlendSub
Global $cidBlendVividLight, $cidBlendMul

Global $cidCompositing, $cidEnableRender

Global $cidAppModeSelect

Global $aPanelTabs[5]
Global $cidCurrentPanel, $iCurrentPanel = 0

Global $aCtrls1[0]
Global $aCtrls2[0]

Global $aViewControls[2] = [$aCtrls1, $aCtrls2]

Global $cidLayerListView

Global $hToolUIWindow = 0

Func _CreateMainUI()
	$sLanguageZone = "/Locale/MainWindow/"

	$hMainUI = GUICreate($TITLEBAR, 900, 768, -1, -1, $WS_OVERLAPPEDWINDOW)
	GUISetOnEvent(-3, "_Exit")
	GUISetBkColor(0xF0F0F0)
	GUISetFont(9, 400, 0, $v4Setting_UI_FontFamily)

	If Not @Compiled Then GUISetIcon(@ScriptDir&"\icon.ico")

	$cW = _WinAPI_GetClientWidth($hMainUI)
	$cH = _WinAPI_GetClientHeight($hMainUI)

	#Region MenuBar
	$iNextMenuBtnX = 0

	$cidFileMenuBtn = _Tiles_CreateButton(_Loc("FileMenu"), $iNextMenuBtnX, 0, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")

	$cidDummy = GUICtrlCreateDummy()
	$cidFileMenu = GUICtrlCreateContextMenu($cidDummy)

	$cidNewImage = GUICtrlCreateMenuItem(_Loc("New"), $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_New")
	$cidOpen = GUICtrlCreateMenuItem(_Loc("Open"), $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_Open")
	$cidRecentFiles = GUICtrlCreateMenu(_Loc("Recent"), $cidFileMenu)
	$cidRevert = GUICtrlCreateMenuItem(_Loc("Revert"), $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_RevertUI")
	GUICtrlCreateMenuItem("", $cidFileMenu)
	$cidClose = GUICtrlCreateMenuItem(_Loc("Close"), $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_DeleteTab")
	$cidCloseAll = GUICtrlCreateMenuItem(_Loc("CloseAll"), $cidFileMenu)
	$cidSave = GUICtrlCreateMenuItem(_Loc("Save"), $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_Save")
	$cidSaveAs = GUICtrlCreateMenuItem(_Loc("SaveAs"), $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_SaveAs")
	GUICtrlCreateMenuItem("", $cidFileMenu)
	$cidPrint = GUICtrlCreateMenuItem(_Loc("Print"), $cidFileMenu)
	GUICtrlCreateMenuItem("", $cidFileMenu)
	$cidExit = GUICtrlCreateMenuItem(_Loc("Exit"), $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_Exit")

	_Tiles_ButtonSetExtra($cidFileMenuBtn, $cidFileMenu)

	$cidEditMenuBtn = _Tiles_CreateButton(_Loc("EditMenu"), $iNextMenuBtnX, 0, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")

	$cidDummy = GUICtrlCreateDummy()
	$cidEditMenu = GUICtrlCreateContextMenu($cidDummy)

	$cidUndo = GUICtrlCreateMenuItem(_Loc("Undo"), $cidEditMenu)
	GUICtrlSetOnEvent(-1, "_Undo")
	$cidRedo = GUICtrlCreateMenuItem(_Loc("Redo"), $cidEditMenu)
	GUICtrlSetOnEvent(-1, "_Redo")

	_Tiles_ButtonSetExtra($cidEditMenuBtn, $cidEditMenu)

	$cidImageMenuBtn = _Tiles_CreateButton(_Loc("ImageMenu"), $iNextMenuBtnX, 0, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended

	$cidLayerMenuBtn = _Tiles_CreateButton(_Loc("ObjectMenu"), $iNextMenuBtnX, 0, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")

	$cidDummy = GUICtrlCreateDummy()
	$cidLayerMenu = GUICtrlCreateContextMenu($cidDummy)

	$cidAddObject = GUICtrlCreateMenu(_Loc("AddObj"), $cidLayerMenu)
	$cidAddLayer = GUICtrlCreateMenuItem(_Loc("AddLayer"), $cidAddObject)
	GUICtrlSetOnEvent(-1, "_AddLayer")
	$cidAddSelection = GUICtrlCreateMenuItem(_Loc("AddSelection"), $cidAddObject)
	GUICtrlSetOnEvent(-1, "_AddSelection")

	$cidRemoveLayer = GUICtrlCreateMenuItem(_Loc("DelObj"), $cidLayerMenu)

	_Tiles_ButtonSetExtra($cidLayerMenuBtn, $cidLayerMenu)

	$cidSelectMenuBtn = _Tiles_CreateButton(_Loc("SelectMenu"), $iNextMenuBtnX, 0, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")

	$cidDummy = GUICtrlCreateDummy()
	$cidSelectMenu = GUICtrlCreateContextMenu($cidDummy)
	$cidSelectAll = GUICtrlCreateMenuItem(_Loc("SelectAll"), $cidSelectMenu)
	$cidDeselect = GUICtrlCreateMenuItem(_Loc("Deselect"), $cidSelectMenu)
	$cidInverseSel = GUICtrlCreateMenuItem(_Loc("InvSel"), $cidSelectMenu)
	GUICtrlCreateMenuItem("", $cidSelectMenu)
	$cidFrameSel = GUICtrlCreateMenuItem(_Loc("BorderSel"), $cidSelectMenu)
	GUICtrlSetOnEvent(-1, "_ShowBorderSelectUI")

	_Tiles_ButtonSetExtra($cidSelectMenuBtn, $cidSelectMenu)

	$cidEffectMenuBtn = _Tiles_CreateButton(_Loc("FXMenu"), $iNextMenuBtnX, 0, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")

	$cidDummy = GUICtrlCreateDummy()
	$cidEffectMenu = GUICtrlCreateContextMenu($cidDummy)
	$cidRunLastEffect = GUICtrlCreateMenuItem(_Loc("FXRepeat"), $cidEffectMenu)

	GUICtrlCreateMenuItem("", $cidEffectMenu)

	$cidConvolve = GUICtrlCreateMenuItem(_Loc("Convolution"), $cidEffectMenu)
	GUICtrlSetOnEvent(-1, "_Convolve_Event")

	$cidDistort = GUICtrlCreateMenuItem(_Loc("Distort"), $cidEffectMenu)
	GUICtrlSetOnEvent(-1, "_Distort_Event")

	GUICtrlCreateMenuItem("", $cidEffectMenu)

	$cidAnaglyph = GUICtrlCreateMenuItem(_Loc("Anaglyph"), $cidEffectMenu)
	GUICtrlSetOnEvent(-1, "_Anaglyph_Event")
	$cidPolarCoords = GUICtrlCreateMenuItem("Polar Coordinates", $cidEffectMenu)
	GUICtrlSetOnEvent(-1, "_ConvertToPolar_Event")

	GUICtrlCreateMenuItem("", $cidEffectMenu)

	$cidBlendFX = GUICtrlCreateMenu(_Loc("Blend/Name"), $cidEffectMenu)
	$cidBlendNormal = GUICtrlCreateMenuItem(_Loc("Blend/Normal"), $cidBlendFX, 0)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")

	GUICtrlCreateMenuItem("", $cidBlendFX)

	$cidBlendDarken = GUICtrlCreateMenuItem(_Loc("Blend/Darken"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendMul = GUICtrlCreateMenuItem(_Loc("Blend/Multiply"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")
	$cidBlendColorBurn = GUICtrlCreateMenuItem(_Loc("Blend/ColorBurn"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendLinearBurn = GUICtrlCreateMenuItem(_Loc("Blend/LinBurn"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")

	GUICtrlCreateMenuItem("", $cidBlendFX)

	$cidBlendLighten = GUICtrlCreateMenuItem(_Loc("Blend/Lighten"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendScreen = GUICtrlCreateMenuItem(_Loc("Blend/Screen"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendColorDodge = GUICtrlCreateMenuItem(_Loc("Blend/ColorDodge"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendAdd = GUICtrlCreateMenuItem(_Loc("Blend/LinDodge"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")
	GUICtrlCreateMenuItem("", $cidBlendFX)

	$cidBlendHardLight = GUICtrlCreateMenuItem(_Loc("Blend/HardLight"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")
	$cidBlendSoftLight = GUICtrlCreateMenuItem(_Loc("Blend/SoftLight"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendLinearLight = GUICtrlCreateMenuItem(_Loc("Blend/LinLight"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")
	$cidBlendVividLight = GUICtrlCreateMenuItem(_Loc("Blend/VividLight"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendHardMix = GUICtrlCreateMenuItem(_Loc("Blend/HardMix"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")

	GUICtrlCreateMenuItem("", $cidBlendFX)

	$cidBlendSub = GUICtrlCreateMenuItem(_Loc("Blend/Subtract"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")
	$cidBlendDifference = GUICtrlCreateMenuItem(_Loc("Blend/Difference"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendExclusion = GUICtrlCreateMenuItem(_Loc("Blend/Exclusion"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_BlendEx_Event")
	$cidBlendDiv = GUICtrlCreateMenuItem(_Loc("Blend/Divide"), $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")

	$cidBlurFX = GUICtrlCreateMenu(_Loc("Blur/Name"), $cidEffectMenu)
	$cidGaussianBlur = GUICtrlCreateMenuItem(_Loc("Blur/Gauss"), $cidBlurFX)
	GUICtrlSetOnEvent(-1, "_Blur_Event")
	$cidMotionBlur = GUICtrlCreateMenuItem(_Loc("Blur/Motion"), $cidBlurFX)
	GUICtrlSetOnEvent(-1, "_MotionBlur_Event")
	$cidRadialBlur = GUICtrlCreateMenuItem(_Loc("Blur/Radial"), $cidBlurFX)
	GUICtrlSetOnEvent(-1, "_RadialBlur_Event")

	$cidColorFX = GUICtrlCreateMenu(_Loc("Color/Name"), $cidEffectMenu)
	$cidChromaKey = GUICtrlCreateMenuItem(_Loc("Color/ChromaKey"), $cidColorFX)
	GUICtrlSetOnEvent(-1, "_ChromaKey_Event")

	$cidColorReplace = GUICtrlCreateMenuItem(_Loc("Color/ColorRep"), $cidColorFX, 1)
	GUICtrlSetOnEvent(-1, "_ColorReplace_Event")
	$cidPremultiply = GUICtrlCreateMenuItem(_Loc("Color/Premul"), $cidColorFX, 2)
	GUICtrlSetOnEvent(-1, "_Premultiply_Event")
	$cidStretchHistogram = GUICtrlCreateMenuItem(_Loc("Color/StretchHistogram"), $cidColorFX, 2)
	GUICtrlSetOnEvent(-1, "_StretchHistogram_Event")
	$cidUnPremultiply = GUICtrlCreateMenuItem(_Loc("Color/Unpremul"), $cidColorFX, 3)
	GUICtrlSetOnEvent(-1, "_UnPremultiply_Event")

	$cidNoiseFX = GUICtrlCreateMenu("Noise", $cidEffectMenu)
	$cidGenerateNoise1 = GUICtrlCreateMenuItem("Grayscale noise", $cidNoiseFX, -1)
	GUICtrlSetOnEvent(-1, "_GrayscaleNoise_Event")
	$cidGenerateNoise2 = GUICtrlCreateMenuItem("RGB (color) noise", $cidNoiseFX, -1)
	GUICtrlSetOnEvent(-1, "_ColorNoise_Event")
	$cidMedian = GUICtrlCreateMenuItem("Median", $cidNoiseFX, -1)
	GUICtrlSetOnEvent(-1, "_UEZFXEv_Median")

	$cidRenderFX = GUICtrlCreateMenu(_Loc("Render/Name"), $cidEffectMenu)
	$cidGenerateSTriangle = GUICtrlCreateMenuItem(_Loc("Render/And"), $cidRenderFX, -1)
	GUICtrlSetOnEvent(-1, "_GenerateSTriangle_Event")
	$cidGenerateXOR = GUICtrlCreateMenuItem(_Loc("Render/Xor"), $cidRenderFX, -1)
	GUICtrlSetOnEvent(-1, "_GenerateXOR_Event")

	$cidStylizeFX = GUICtrlCreateMenu(_Loc("Stylize/Name"), $cidEffectMenu)
	$cidInterlace = GUICtrlCreateMenuItem(_Loc("Stylize/Interlace"), $cidStylizeFX)
	GUICtrlSetOnEvent(-1, "_Interlace_Event")
	$cidPixelize = GUICtrlCreateMenuItem(_Loc("Stylize/Pixelize"), $cidStylizeFX)
	GUICtrlSetOnEvent(-1, "_Pixelize_Event")
	$cidTiles = GUICtrlCreateMenuItem(_Loc("Stylize/Tiles"), $cidStylizeFX)
	GUICtrlSetOnEvent(-1, "_Tiles_Event")
	$cidjitter = GUICtrlCreateMenuItem("Jitter", $cidStylizeFX)
	GUICtrlSetOnEvent(-1, "_UEZFXEv_Jitter")

	If $aExternalPlugins[0] > 0 Then
		GUICtrlCreateMenuItem("", $cidEffectMenu)

		For $i = 1 To $aExternalPlugins[0]
			$obj = $aExternalPlugins[$i]

			$cidPluginMenu = GUICtrlCreateMenu($obj.name, $cidEffectMenu)
			For $dll In $obj.dlls
				$cidPluginCtrl = GUICtrlCreateMenuItem($dll.menuItem, $cidPluginMenu)
				GUICtrlSetOnEvent(-1, "_EffectPlugin_Event")
				$dll.eventCtrl = $cidPluginCtrl
			Next
		Next
	EndIf

	_Tiles_ButtonSetExtra($cidEffectMenuBtn, $cidEffectMenu)

	#cs

		Shhhh!

	$cid3DMenuBtn = _Tiles_CreateButton("3D ", $iNextMenuBtnX, 0, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")

	$cidDummy = GUICtrlCreateDummy()
	$cid3DMenu = GUICtrlCreateContextMenu($cidDummy)

	$cidManageMaterials = GUICtrlCreateMenuItem("Manage materials...", $cid3DMenu)
	$cidManageTextures = GUICtrlCreateMenuItem("Manage textures...", $cid3DMenu)
	$cidManageLights = GUICtrlCreateMenuItem("Manage lights...", $cid3DMenu)

	GUICtrlCreateMenuItem("", $cid3DMenu)

	$cidImportPovFile = GUICtrlCreateMenuItem("Import POV-Ray file...", $cid3DMenu)
	GUICtrlSetOnEvent(-1, "_ImportPovFile")

	GUICtrlCreateMenuItem("", $cid3DMenu)

	$cidAdd3DObject = GUICtrlCreateMenu("Add 3D object...", $cid3DMenu)
	GUICtrlCreateMenuItem("Plane", $cidAdd3DObject)

	GUICtrlCreateMenuItem("", $cidAdd3DObject)

	GUICtrlCreateMenuItem("Box", $cidAdd3DObject)
	GUICtrlCreateMenuItem("Cone", $cidAdd3DObject)
	GUICtrlCreateMenuItem("Cylinder", $cidAdd3DObject)
	GUICtrlCreateMenuItem("Ovus (egg)", $cidAdd3DObject)
	GUICtrlCreateMenuItem("Sphere", $cidAdd3DObject)
	GUICtrlCreateMenuItem("Torus", $cidAdd3DObject)

	_Tiles_ButtonSetExtra($cid3DMenuBtn, $cid3DMenu)

	#ce

	$cidViewMenuBtn = _Tiles_CreateButton(_Loc("ViewMenu"), $iNextMenuBtnX, 0, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended

	$cidHelpMenuBtn = _Tiles_CreateButton(_Loc("HelpMenu"), $iNextMenuBtnX, 0, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")

	$cidDummy = GUICtrlCreateDummy()
	$cidHelpMenu = GUICtrlCreateContextMenu($cidDummy)

	$cidAbout = GUICtrlCreateMenuItem(_Loc("About"), $cidHelpMenu)
	GUICtrlSetOnEvent(-1, "_AboutWindow")

	_Tiles_ButtonSetExtra($cidHelpMenuBtn, $cidHelpMenu)

	#EndRegion

	#Region Progress Bar

	$cidProgressBar = GUICtrlCreateProgress($cW-200*$iUIScaleFactor, 0, 200*$iUIScaleFactor, 30*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKRIGHT+$GUI_DOCKSIZE)
	GUICtrlSetState(-1, $GUI_HIDE)

	#EndRegion

	#Region Panel Rack

	$cidBackgroundArea = GUICtrlCreateLabel("", 40*$iUIScaleFactor, 100*$iUIScaleFactor, $cW-280*$iUIScaleFactor, $cH-100*$iUIScaleFactor)
	GUICtrlSetBkColor(-1, 0xC0C0C0)
	GUICtrlSetState(-1, $GUI_DISABLE)
	GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)

	$cidBackgroundArea2 = GUICtrlCreateLabel("", $cW-240*$iUIScaleFactor, 100*$iUIScaleFactor, 240*$iUIScaleFactor, $cH-100*$iUIScaleFactor)
	GUICtrlSetBkColor(-1, 0xE0E0E0)
	GUICtrlSetState(-1, $GUI_DISABLE)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKRIGHT+$GUI_DOCKBOTTOM+$GUI_DOCKWIDTH)

	$cidBackgroundArea3 = GUICtrlCreateLabel("", 0, 100*$iUIScaleFactor, 40*$iUIScaleFactor, $cH-100*$iUIScaleFactor)
	GUICtrlSetBkColor(-1, 0xE0E0E0)
	GUICtrlSetState(-1, $GUI_DISABLE)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKBOTTOM+$GUI_DOCKWIDTH)

	$iNextMenuBtnX = $cW-240*$iUIScaleFactor
	$cidLayers  = _Tiles_CreateButton(_Loc("Objects"), $iNextMenuBtnX, 70*$iUIScaleFactor, Default, 30*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended

	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKRIGHT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SwitchPanel")

	_Tiles_ButtonSetExtra($cidLayers, 0)

	$cidConnectedFiles = _Tiles_CreateButton("Files", $iNextMenuBtnX, 70*$iUIScaleFactor, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended

	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKRIGHT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SwitchPanel")

	_Tiles_ButtonSetExtra($cidConnectedFiles, 1)

	$cidHistory = _Tiles_CreateButton("History", $iNextMenuBtnX, 70*$iUIScaleFactor, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended

	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKRIGHT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SwitchPanel")

	_Tiles_ButtonSetExtra($cidHistory, 2)

	$cidCurrentPanel = $cidLayers

	$cidTabs = GUICtrlCreateTab(0, 0, -100, -100)
	GUICtrlSetState(-1, $GUI_HIDE)

	#Region Layer Panel

	$cidLayerTab = GUICtrlCreateTabItem("Layers")

	$cidLayerListView = GUICtrlCreateListView("", $cw-241*$iUIScaleFactor, 100*$iUIScaleFactor, 242*$iUIScaleFactor, $ch-(80+49)*$iUIScaleFactor, $LVS_NOCOLUMNHEADER+$LVS_SINGLESEL, $LVS_EX_SUBITEMIMAGES+$LVS_EX_FULLROWSELECT+$WS_EX_CLIENTEDGE+$LVS_EX_DOUBLEBUFFER)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKRIGHT+$GUI_DOCKBOTTOM+$GUI_DOCKWIDTH)
	GUICtrlSetBkColor(-1, 0xE0E0E0)

	_WinAPI_SetWindowTheme(GUICtrlGetHandle($cidLayerListView), "Explorer")

	_GUICtrlListView_AddColumn($cidLayerListView, "Layer", 174*$iUIScaleFactor)
	_GUICtrlListView_AddColumn($cidLayerListView, "Vis.", 32*$iUIScaleFactor)
	_GUICtrlListView_AddColumn($cidLayerListView, "Lck", 32*$iUIScaleFactor)

	_GUICtrlListView_EnableGroupView($cidLayerListView)
	_GUICtrlListView_InsertGroup($cidLayerListView, 0, 1, _Loc("ObjList/Layers"))
	_GUICtrlListView_SetGroupInfo($cidLayerListView, 1, _Loc("ObjList/Layers"), 0, $LVGS_COLLAPSIBLE)
	_GUICtrlListView_InsertGroup($cidLayerListView, -1, 2, _Loc("ObjList/Selections"))
	_GUICtrlListView_SetGroupInfo($cidLayerListView, 2, _Loc("ObjList/Selections"), 0, $LVGS_COLLAPSIBLE)
	_GUICtrlListView_InsertGroup($cidLayerListView, -1, 3, _Loc("ObjList/Paths"))
	_GUICtrlListView_SetGroupInfo($cidLayerListView, 3, _Loc("ObjList/Paths"), 0, $LVGS_COLLAPSIBLE)

	_GUICtrlListView_SetImageList($cidLayerListView, $hLayerImageList, 1)
	;_GUICtrlListView_SetView($cidLayerListView, 4)

	$hRgn = _WinAPI_CreateRectRgn(1, 1, 241*$iUIScaleFactor, $ch-(81+49)*$iUIScaleFactor)
	_WinAPI_SetWindowRgn(GUICtrlGetHandle($cidLayerListView), $hRgn)
	_WinAPI_DeleteObject($hRgn)

	;$cidLayerNewBtn = _CreateImgButton(_GetIconPath("content", "add"), 0, 0, 24, 24, $cW-240, $ch-30, 40, 30, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0)
	$cidLayerMenuBtn = _Tiles_CreateButton2("+", $cW-240*$iUIScaleFactor, $ch-30*$iUIScaleFactor, 40*$iUIScaleFactor, 30*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKBOTTOM+$GUI_DOCKRIGHT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_AddLayer")

	$cidLayerDeleteBtn = _Tiles_CreateButton2("*", $cW-200*$iUIScaleFactor, $ch-30*$iUIScaleFactor, 40*$iUIScaleFactor, 30*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKBOTTOM+$GUI_DOCKRIGHT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_RemoveLayer")

	$aPanelTabs[0] = $cidLayerTab

	#EndRegion

	#Region Connected Files Panel

	$cidCFilesTab = GUICtrlCreateTabItem("Connected Files")

	_Tiles_CreateButton2(ChrW(0xB9), $cW-240*$iUIScaleFactor, 100*$iUIScaleFactor, 240*$iUIScaleFactor, 240*$iUIScaleFactor, 0xFFE0E0E0, 0xFFE0E0E0, 0xFFE0E0E0, 0x22000000, "vPaint UI Glyphs", 172*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -5*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKRIGHT+$GUI_DOCKSIZE)

	$aPanelTabs[1] = $cidCFilesTab

	#EndRegion

	GUICtrlCreateTabItem("")

	#EndRegion


	#cs
		REMARK #4: How I Met Icons as Glyphs in Fonts [scintilla4evr]

		vPaint at the beginning was using Google Material Design icons.
		But there was one problem. When I was developing vPaint, I didn't
		know at the start which icons I will use. So I put all of them
		in a single folder called "Icons". But there were thousands of
		those icons. Even trying to copy vPaint elsewhere on the disk,
		or between my harddisk and flash drive was next to impossible to
		do it in a reasonable time. Solution - fonts. I designed a
		single font called "vPaint UI Glyphs" containing all of vPaint's
		icons. Plus some more. Don't even THINK ABOUT TRYING opening that
		font in Character Map. Or vPaint's UI will be set in Comic Sans!

	#ce
	#Region Tool Rack

	$cidMoveTool = _Tiles_CreateButton2("!", 0, (100+40*0)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Transform (V)")

	_Tiles_ButtonSetExtra($cidMoveTool, 0)

	$cidRectSelectTool = _Tiles_CreateButton2('"', 0, (100+40*1)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Select (M)")

	_Tiles_ButtonSetExtra($cidRectSelectTool, 1)

	$cidCropTool = _Tiles_CreateButton2("#", 0, (100+40*2)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Crop (C)")

	_Tiles_ButtonSetExtra($cidCropTool, 5)

	$cidEyedropperTool = _Tiles_CreateButton2("$", 0, (100+40*3)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Eyedropper (I)")

	_Tiles_ButtonSetExtra($cidEyedropperTool, 3)

	$cidHealingTool = _Tiles_CreateButton2("K", 0, (100+40*4)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Healing Brush (J)")

	$cidBrushTool = _Tiles_CreateButton2("%", 0, (100+40*5)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFD0D0D0, 0xFFC0C0C0, 0xFFB0B0B0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Brush (B)")

	_Tiles_ButtonSetExtra($cidBrushTool, 2)
	$cidSelectedTool = $cidBrushTool

	$cidGradientTool = _Tiles_CreateButton2("J", 0, (100+40*6)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Gradient (G)")

	_Tiles_ButtonSetExtra($cidGradientTool, 4)

	$cidEraserTool = _Tiles_CreateButton2("D", 0, (100+40*7)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Eraser (E)")

	_Tiles_ButtonSetExtra($cidEraserTool, 7)

	$cidEffectTool = _Tiles_CreateButton2("=", 0, (100+40*8)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Effect Brush (O)")

	$cidShapeTool = _Tiles_CreateButton2("L", 0, (100+40*9)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Shape (U)")

	$cidTextTool = _Tiles_CreateButton2("&", 0, (100+40*10)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Text (T)")

	$cidPathTool = _Tiles_CreateButton2("F", 0, (100+40*11)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Path (?)")

	_Tiles_ButtonSetExtra($cidPathTool, 6)

	$cidZoomTool = _Tiles_CreateButton2("'", 0, (100+40*12)*$iUIScaleFactor, 40*$iUIScaleFactor, 40*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFFC0C0C0, 0xFF000000, "vPaint UI Glyphs", 24*$iUIScaleFactor, 0, 0, 2*$iUIScaleFactor, -10*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Zoom (Z)")

	$cidForeground = GUICtrlCreateLabel("", 0, (100+40*13)*$iUIScaleFactor, 40*$iUIScaleFactor, 30*$iUIScaleFactor, $WS_BORDER)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetColor")
	GUICtrlSetBkColor(-1, _SetAlpha($iForeground, 0))

	$cidForeContextMenu = GUICtrlCreateContextMenu($cidForeground)
	$cidForeSetToBlack = GUICtrlCreateMenuItem("Set to Black", $cidForeContextMenu)
	GUICtrlSetOnEvent(-1, "_SetForeColor")
	$cidForeSetToWhite = GUICtrlCreateMenuItem("Set to White", $cidForeContextMenu)
	GUICtrlSetOnEvent(-1, "_SetForeColor")
	GUICtrlCreateMenuItem("", $cidForeContextMenu)
	GUICtrlCreateMenuItem("Swap	X", $cidForeContextMenu)
	GUICtrlSetOnEvent(-1, "_SwapForeBack")

	$cidBackground = GUICtrlCreateLabel("", 0, (100+40*13+29)*$iUIScaleFactor, 40*$iUIScaleFactor, 30*$iUIScaleFactor, $WS_BORDER)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetColor")
	GUICtrlSetBkColor(-1, _SetAlpha($iBackground, 0))

	$cidBackContextMenu = GUICtrlCreateContextMenu($cidBackground)
	$cidBackSetToBlack = GUICtrlCreateMenuItem("Set to Black", $cidBackContextMenu)
	GUICtrlSetOnEvent(-1, "_SetBackColor")
	$cidBackSetToWhite = GUICtrlCreateMenuItem("Set to White", $cidBackContextMenu)
	GUICtrlSetOnEvent(-1, "_SetBackColor")
	GUICtrlCreateMenuItem("", $cidBackContextMenu)
	GUICtrlCreateMenuItem("Swap	X", $cidBackContextMenu)
	GUICtrlSetOnEvent(-1, "_SwapForeBack")

	#EndRegion

	#cs
		REMARK #9: The Viewport [scintilla4evr]

		Previously, this section was titled "Drawing Area". But because
		of the addition of Compositing, I've decided to rename this code
		region "Viewport".

	#ce
	#Region Viewport

	#Region Drawing

	$cidDrawingArea = GUICtrlCreateLabel("", 40*$iUIScaleFactor, 100*$iUIScaleFactor, $cW-280*$iUIScaleFactor, $cH-130*$iUIScaleFactor, $SS_BITMAP)
	GUICtrlSetBkColor(-1, 0xC0C0C0)
	GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)
	GUICtrlSetOnEvent(-1, "_DrawingAreaClick")

	_AddCtrlToViewMode($cidDrawingArea, 0)

	$cidEnableRender = GUICtrlCreateCheckbox("Show compositing output", 250*$iUIScaleFactor, $cH-30*$iUIScaleFactor, 200*$iUIScaleFactor, 30*$iUIScaleFactor)
	GUICtrlSetFont(-1, 10*$iUIScaleFactor, -1, -1, "Segoe UI")
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKBOTTOM+$GUI_DOCKSIZE)
	GUICtrlSetBkColor(-1, 0xC0C0C0)
	GUICtrlSetOnEvent(-1, "_ToggleViewportRender")

	_AddCtrlToViewMode($cidEnableRender, 0)

	#EndRegion

	#Region Compositing

	$cidCompositing = _Node_CreateNodeUI($hMainUI, 40*$iUIScaleFactor, 82*$iUIScaleFactor, $cW-280*$iUIScaleFactor, $cH-112*$iUIScaleFactor, $oBlankNodeList, "_RefreshCompositor")
	GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)
	GUICtrlSetState(-1, $GUI_HIDE)

	_AddCtrlToViewMode($cidCompositing, 1)

	$iNextCompMenuX = 40*$iUIScaleFactor

	$cidAddNodeMenuBtn = _Tiles_CreateButton("Add ", $iNextCompMenuX, 52*$iUIScaleFactor, Default, 30*$iUIScaleFactor, 0xFFC0C0C0, 0xFFB0B0B0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextCompMenuX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")
	GUICtrlSetState(-1, $GUI_HIDE)

	_AddCtrlToViewMode($cidAddNodeMenuBtn, 1)

	$cidDummy = GUICtrlCreateDummy()
	$cidAddNodeMenu = GUICtrlCreateContextMenu($cidDummy)

	$cidNodeIO = GUICtrlCreateMenu("IO", $cidAddNodeMenu)

	GUICtrlCreateMenuItem("Full Input", $cidNodeIO)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")
	GUICtrlCreateMenuItem("Single-layer Input", $cidNodeIO)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")

	$cidNodeColor = GUICtrlCreateMenu("Color", $cidAddNodeMenu)

	GUICtrlCreateMenuItem("Blend", $cidNodeColor)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")
	GUICtrlCreateMenuItem("Grayscale", $cidNodeColor)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")
	GUICtrlCreateMenuItem("Invert", $cidNodeColor)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")

	$cidNodeFilter = GUICtrlCreateMenu("Filter", $cidAddNodeMenu)

	GUICtrlCreateMenuItem("De-4K-ize", $cidNodeFilter)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")
	GUICtrlCreateMenuItem("Gaussian Blur", $cidNodeFilter)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")
	GUICtrlCreateMenuItem("Glitch", $cidNodeFilter)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")
	GUICtrlCreateMenuItem("Interlace", $cidNodeFilter)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")
	GUICtrlCreateMenuItem("Ripple", $cidNodeFilter)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")

	$cidNodeMerge = GUICtrlCreateMenu("Merge", $cidAddNodeMenu)
	GUICtrlCreateMenuItem("Alpha Over", $cidNodeMerge)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")

	$cidNodeMovie = GUICtrlCreateMenu("Movie", $cidAddNodeMenu)

	GUICtrlCreateMenuItem("Chroma Key", $cidNodeMovie)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")
	GUICtrlCreateMenuItem("To 0-255", $cidNodeMovie)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")
	GUICtrlCreateMenuItem("To 16-235", $cidNodeMovie)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")

	$cidNodeRender = GUICtrlCreateMenu("Render", $cidAddNodeMenu)
	GUICtrlCreateMenuItem("AND Triangle", $cidNodeRender)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")
	GUICtrlCreateMenuItem("XOR Pattern", $cidNodeRender)
	GUICtrlSetOnEvent(-1, "_AddNodeToComposition")

	_Tiles_ButtonSetExtra($cidAddNodeMenuBtn, $cidAddNodeMenu)

	$cidRenderCompMenuBtn = _Tiles_CreateButton("Render ", $iNextCompMenuX, 52*$iUIScaleFactor, Default, 30*$iUIScaleFactor, 0xFFC0C0C0, 0xFFB0B0B0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextCompMenuX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")
	GUICtrlSetState(-1, $GUI_HIDE)

	_AddCtrlToViewMode($cidRenderCompMenuBtn, 1)

	$cidDummy = GUICtrlCreateDummy()
	$cidRenderCompMenu = GUICtrlCreateContextMenu($cidDummy)

	GUICtrlCreateMenuItem("Render Draft", $cidRenderCompMenu)
	GUICtrlCreateMenuItem("Render Full", $cidRenderCompMenu)
	GUICtrlCreateMenuItem("Render Production", $cidRenderCompMenu)

	_Tiles_ButtonSetExtra($cidRenderCompMenuBtn, $cidRenderCompMenu)

	$cidRenderComposite = GUICtrlCreateButton("Render", $cW-340*$iUIScaleFactor, 52*$iUIScaleFactor, 100*$iUIScaleFactor, 30*$iUIScaleFactor)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKRIGHT+$GUI_DOCKSIZE)
	GUICtrlSetState(-1, $GUI_HIDE)
	GUICtrlSetOnEvent(-1, "_RenderComposite")

	_AddCtrlToViewMode($cidRenderComposite, 1)

	#EndRegion

	$cidAppModeSelect = GUICtrlCreateCombo("", 44*$iUIScaleFactor, $cH-30*$iUIScaleFactor, 200*$iUIScaleFactor, 30*$iUIScaleFactor, $CBS_DROPDOWNLIST)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKBOTTOM+$GUI_DOCKSIZE)
	GUICtrlSetData(-1, "Drawing|Compositing", "Drawing")
	GUICtrlSetOnEvent(-1, "_ChangeViewMode")
	GUICtrlSetFont(-1, 11*$iUIScaleFactor, -1, -1, "Segoe UI")

	#EndRegion

	Global $aAcc[2][2] = [["^z", $cidUndo], ["^+z", $cidRedo]]
	GUISetAccelerators($aAcc, $hMainUI)

	GUIRegisterMsg($WM_MOUSEWHEEL, "WM_MOUSEWHEEL")
	GUIRegisterMsg($WM_SIZE, "WM_SIZE")
	GUIRegisterMsg($WM_USER, "WM_USER")
	GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")
	GUIRegisterMsg($WM_GESTURE, "WM_GESTURE")
	GUISetState(@SW_SHOWNORMAL)
EndFunc

HotKeySet("^!+pq`", "_RuleTheWorld")

Func _ToggleViewportRender()
	_ChangeViewportRender(1-$iViewportRenderEnabled)
EndFunc

Func _ChangeViewportRender($iEnable)
	$iViewportRenderEnabled = $iEnable
	GUICtrlSetState($cidEnableRender, $iViewportRenderEnabled ? $GUI_CHECKED : $GUI_UNCHECKED)
	_RenderDrawingArea()
EndFunc

Func _ChangeViewMode()
	Local $iTab = 0

	Switch GUICtrlRead(@GUI_CtrlId)
		Case "Drawing"
			WinSetState($hToolUIWindow, "", @SW_SHOW)
			$iTab = 0
		Case "Compositing"
			WinSetState($hToolUIWindow, "", @SW_HIDE)
			$iTab = 1
	EndSwitch

	_SetViewMode($iTab)
EndFunc

Func _SetViewMode($iTab)
	For $i = 0 To (UBound($aViewControls)-1)
		For $ctrl In $aViewControls[$i]
			GUICtrlSetState($ctrl, ($iTab = $i) ? $GUI_SHOW : $GUI_HIDE)
		Next
	Next

	_GUICtrlComboBox_SetCurSel(GUICtrlGetHandle($cidAppModeSelect), $iTab)
EndFunc

Func _AddCtrlToViewMode($cidCtrl, $idMode)
	_ArrayAdd($aViewControls[$idMode], $cidCtrl)
EndFunc

Func _ShowMenuBarMenu()
	Local $iIndex = _Tiles_GetButtonIndexFromCtrl(@GUI_CtrlId)
	Local $oObj = $__Tiles_aButtonObjectList[$iIndex]

	_ShowMenu($hMainUI, @GUI_CtrlId, $oObj.extra)
EndFunc

Func _RuleTheWorld()
	MsgBox(0, "Valve Anti-Cheat", "Read the text on the title bar.")
EndFunc

Func _TaskBarShow()
	WinActivate("[CLASS:Shell_TrayWnd]")
EndFunc

Func _Menu()
	_ShowMenu($hMainUI, $cidMenu, $cidQuickMenu)
EndFunc

Func _Minimize()
	WinSetState($hMainUI, "", @SW_MINIMIZE)
EndFunc

Func _Maximize()
	If BitAND(WinGetState($hMainUI), 32) Then
		_ImgButton_SetImage($cidMaximize, _GetIconPath("navigation", "fullscreen"))
		WinSetState($hMainUI, "", @SW_RESTORE)
	Else
		_ImgButton_SetImage($cidMaximize, _GetIconPath("navigation", "fullscreen_exit"))
		WinSetState($hMainUI, "", @SW_MAXIMIZE)
	EndIf
EndFunc

Func WM_USER($hWnd, $iMsg, $wParam, $lParam)
	Switch $wParam
		Case 0x100 ; open file
			_OpenFile(RegRead("HKCU\SOFTWARE\vPaint\"&$APPVERSION, "OpenFile"))
			RegWrite("HKCU\SOFTWARE\vPaint\"&$APPVERSION, "OpenFile", "REG_SZ", "")
			Return 1
		Case 0x600 ; check, if it's vPaint
			Return 0x1234
	EndSwitch

	Return $GUI_RUNDEFMSG
EndFunc

Func WM_SIZE($hWnd, $iMsg, $wParam, $lParam)
	If $hWnd = $hMainUI Then
		$hRgn = _WinAPI_CreateRectRgn(1, 1, 241*$iUIScaleFactor, _WinAPI_GetClientHeight($hWnd)-(81+49)*$iUIScaleFactor)
		_WinAPI_SetWindowRgn(GUICtrlGetHandle($cidLayerListView), $hRgn)
		_WinAPI_DeleteObject($hRgn)

		_RenderDrawingArea()

		$obj = _Node_GetObjFromCtrl($cidCompositing)
		$obj.render()

		If $hOverlayUI <> 0 Then _MoveOverlayUI()
	EndIf

	Return $GUI_RUNDEFMSG
EndFunc
