#include-once

#cs
	typedef unsigned int uint;
#ce

Func _CreatePluginAPIObjectInstance()
	$tAPI = DllStructCreate("ptr GetCurrentLayer; ptr GetLayerCount")

	$tAPI.GetCurrentLayer = DllCallbackGetPtr(DllCallbackRegister("_PluginAPI_GetCurrentLayer", "uint", "none"))
	$tAPI.GetLayerCount = DllCallbackGetPtr(DllCallbackRegister("_PluginAPI_GetLayerCount", "uint", "none"))

	Return DllStructGetPtr($tAPI)
EndFunc

; uint GetCurrentLayer ()
Func _PluginAPI_GetCurrentLayer()
	Return $oCurrentThread.thread.currentLayerId
EndFunc

; uint GetLayerCount ()
Func _PluginAPI_GetLayerCount()
	Return $oCurrentThread.thread.layers.count
EndFunc

; int* LockLayerData (uint)
Func _PluginAPI_LockLayerData($uiIndex)
	$hBmp = ($oCurrentThread.thread.layers.at($uiIndex)).bmp

	$iW = _GDIPlus_ImageGetWidth($hBmp)
	$iH = _GDIPlus_ImageGetHeight($hBmp)
	$tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	$iScan0 = DllStructGetData($tBData, "Scan0")

	Return $iScan0
EndFunc
