#include-once

Global $aTabletModeUIControls_Top[1] = [0]
Global $aTabletModeUIControls_Left[1] = [0]

; AdlibRegister("_CheckForTabletMode", 1000) see paint.au3 (remark "Tablet Mode: support or not?")

Func _SwitchMode($iTablet)
	$isChangingUIMode = 1

	GUIDelete($hMainUI)
	Switch $iTablet
		Case 0
			_CreateMainUI()
		Case 1
			_CreateTabletModeUI()
	EndSwitch
	$isTabletMode = $iTablet

	_RefreshTabs()
	_RenderDrawingArea()

	$isChangingUIMode = 0
EndFunc

Func _CreateTabletModeUI()
	$hMainUI = GUICreate($TITLEBAR, 800, 600, -1, -1, $WS_OVERLAPPEDWINDOW)
	GUISetOnEvent(-3, "_Exit")
	GUISetBkColor(0xF0F0F0)

	If Not @Compiled Then GUISetIcon(@ScriptDir&"\icon.ico")

	$cW = _WinAPI_GetClientWidth($hMainUI)
	$cH = _WinAPI_GetClientHeight($hMainUI)

	#Region Menu Bar

	$iNextMenuBtnX = 0

	$cidFileMenuBtn = _Tiles_CreateButton("File ", $iNextMenuBtnX, -30, Default, 30, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")
	_AddCtrlToTabletUITopBar($cidFileMenuBtn)

	$cidDummy = GUICtrlCreateDummy()
	$cidFileMenu = GUICtrlCreateContextMenu($cidDummy)

	$cidNew = GUICtrlCreateMenu("New...", $cidFileMenu)
	$cidNewImage = GUICtrlCreateMenuItem("Image	Ctrl+N", $cidNew)
	GUICtrlSetOnEvent(-1, "_New")
	$cidNewDiagram = GUICtrlCreateMenuItem("Diagram", $cidNew)
	$cidOpen = GUICtrlCreateMenuItem("Open	Ctrl+O", $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_Open")
	$cidOpenAsSmart = GUICtrlCreateMenuItem("Open as Smart Object	Ctrl+Shift+O", $cidFileMenu)
	$cidRecentFiles = GUICtrlCreateMenu("Recent Files", $cidFileMenu)
	GUICtrlCreateMenuItem("", $cidFileMenu)
	$cidClose = GUICtrlCreateMenuItem("Close	Ctrl+W", $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_DeleteTab")
	$cidCloseAll = GUICtrlCreateMenuItem("Close All	Ctrl+Alt+W", $cidFileMenu)
	$cidSave = GUICtrlCreateMenuItem("Save	Ctrl+S", $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_Save")
	$cidSaveAs = GUICtrlCreateMenuItem("Save As...	Ctrl+Shift+S", $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_SaveAs")
	GUICtrlCreateMenuItem("", $cidFileMenu)
	$cidPrint = GUICtrlCreateMenuItem("Print	Ctrl+P", $cidFileMenu)
	GUICtrlCreateMenuItem("", $cidFileMenu)
	$cidExit = GUICtrlCreateMenuItem("Exit	Alt+F4", $cidFileMenu)
	GUICtrlSetOnEvent(-1, "_Exit")

	_Tiles_ButtonSetExtra($cidFileMenuBtn, $cidFileMenu)

	$cidEditMenuBtn = _Tiles_CreateButton("Edit ", $iNextMenuBtnX, -30, Default, 30, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")
	_AddCtrlToTabletUITopBar($cidEditMenuBtn)

	$cidDummy = GUICtrlCreateDummy()
	$cidEditMenu = GUICtrlCreateContextMenu($cidDummy)

	$cidUndo = GUICtrlCreateMenuItem("Undo	Ctrl+Z", $cidEditMenu)
	GUICtrlSetOnEvent(-1, "_Undo")
	$cidRedo = GUICtrlCreateMenuItem("Redo	Ctrl+Shift+Z", $cidEditMenu)
	GUICtrlSetOnEvent(-1, "_Redo")

	_Tiles_ButtonSetExtra($cidEditMenuBtn, $cidEditMenu)

	$cidImageMenuBtn = _Tiles_CreateButton("Image ", $iNextMenuBtnX, -30, Default, 30, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444)
	$iNextMenuBtnX += @extended
	_AddCtrlToTabletUITopBar($cidImageMenuBtn)

	$cidLayerMenuBtn = _Tiles_CreateButton("Object ", $iNextMenuBtnX, -30, Default, 30, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")
	_AddCtrlToTabletUITopBar($cidLayerMenuBtn)

	$cidDummy = GUICtrlCreateDummy()
	$cidLayerMenu = GUICtrlCreateContextMenu($cidDummy)

	$cidAddLayer = GUICtrlCreateMenu("Add...", $cidLayerMenu)
	$cidAddImage = GUICtrlCreateMenuItem("Image", $cidAddLayer)

	$cidRemoveLayer = GUICtrlCreateMenuItem("Remove object", $cidLayerMenu)

	_Tiles_ButtonSetExtra($cidLayerMenuBtn, $cidLayerMenu)

	$cidSelectMenuBtn = _Tiles_CreateButton("Select ", $iNextMenuBtnX, -30, Default, 30, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")
	_AddCtrlToTabletUITopBar($cidSelectMenuBtn)

	$cidDummy = GUICtrlCreateDummy()
	$cidSelectMenu = GUICtrlCreateContextMenu($cidDummy)
	$cidSelectAll = GUICtrlCreateMenuItem("Select all	Ctrl+A", $cidSelectMenu)
	$cidDeselect = GUICtrlCreateMenuItem("Deselect	Ctrl+D", $cidSelectMenu)
	$cidInverseSel = GUICtrlCreateMenuItem("Inverse selection	Ctrl+Shift+I", $cidSelectMenu)
	GUICtrlCreateMenuItem("", $cidSelectMenu)
	$cidFrameSel = GUICtrlCreateMenuItem("Border selection", $cidSelectMenu)

	_Tiles_ButtonSetExtra($cidSelectMenuBtn, $cidSelectMenu)

	$cidEffectMenuBtn = _Tiles_CreateButton("Effect ", $iNextMenuBtnX, -30, Default, 30, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")
	_AddCtrlToTabletUITopBar($cidEffectMenuBtn)

	$cidDummy = GUICtrlCreateDummy()
	$cidEffectMenu = GUICtrlCreateContextMenu($cidDummy)
	$cidRunLastEffect = GUICtrlCreateMenuItem("Execute last	Ctrl+F", $cidEffectMenu)
	GUICtrlCreateMenuItem("", $cidEffectMenu)
	$cidConvolve = GUICtrlCreateMenuItem("Convolution", $cidEffectMenu)
	GUICtrlCreateMenuItem("", $cidEffectMenu)

	If $isEasterEgg Then
		$cidBarneyFX = GUICtrlCreateMenu("Barney's Must-Use Filters", $cidEffectMenu)
		GUICtrlCreateMenuItem("The Don't Drink That", $cidBarneyFX)
		GUICtrlSetOnEvent(-1, "_TheDontDrinkThat")
		GUICtrlCreateMenuItem("The Mrs. Stinsfire", $cidBarneyFX)
		GUICtrlSetOnEvent(-1, "_TheMrsStinsfire")
		GUICtrlCreateMenuItem("The Lorenzo von Matterhorn", $cidBarneyFX)
		GUICtrlSetOnEvent(-1, "_TheLorenzoVonMatterhorn")
		GUICtrlCreateMenuItem("The SNASA", $cidBarneyFX)
		GUICtrlSetOnEvent(-1, "_TheSNASA")
		GUICtrlCreateMenuItem("The Cheap Trick", $cidBarneyFX)
		GUICtrlSetOnEvent(-1, "_TheCheapTrick")
		GUICtrlCreateMenuItem("The He's Not Coming", $cidBarneyFX)
		GUICtrlSetOnEvent(-1, "_TheHesNotComing")
	EndIf

	$cidBlendFX = GUICtrlCreateMenu("Blend", $cidEffectMenu)
	$cidBlendMul = GUICtrlCreateMenuItem("Multiply", $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")
	$cidBlendLinearBurn = GUICtrlCreateMenuItem("Linear Burn", $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")

	GUICtrlCreateMenuItem("", $cidBlendFX)

	$cidBlendScreen = GUICtrlCreateMenuItem("Screen", $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")
	$cidBlendAdd = GUICtrlCreateMenuItem("Linear Dodge", $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")

	GUICtrlCreateMenuItem("", $cidBlendFX)

	$cidBlendHardLight = GUICtrlCreateMenuItem("Hard Light", $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")
	$cidBlendLinearLight = GUICtrlCreateMenuItem("Linear Light", $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")
	$cidBlendHardMix = GUICtrlCreateMenuItem("Hard Mix", $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")

	GUICtrlCreateMenuItem("", $cidBlendFX)

	$cidBlendSub = GUICtrlCreateMenuItem("Subtract", $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")
	$cidBlendDiv = GUICtrlCreateMenuItem("Divide", $cidBlendFX)
	GUICtrlSetOnEvent(-1, "_Blend_Event")

	If _IsExperimentEnabled("LibGdipExt32") Then
		GUICtrlSetOnEvent($cidBlendScreen, "_BlendEx_Event")

		$cidBlendDarken = GUICtrlCreateMenuItem("Darken", $cidBlendFX, 0)
		GUICtrlSetOnEvent(-1, "_BlendEx_Event")
		$cidBlendColorBurn = GUICtrlCreateMenuItem("Color Burn", $cidBlendFX, 2)
		GUICtrlSetOnEvent(-1, "_BlendEx_Event")

		$cidBlendLighten = GUICtrlCreateMenuItem("Lighten", $cidBlendFX, 5)
		GUICtrlSetOnEvent(-1, "_BlendEx_Event")
		$cidBlendColorDodge = GUICtrlCreateMenuItem("Color Dodge", $cidBlendFX, 7)
		GUICtrlSetOnEvent(-1, "_BlendEx_Event")

		$cidBlendSoftLight = GUICtrlCreateMenuItem("Soft Light", $cidBlendFX, 10)
		GUICtrlSetOnEvent(-1, "_BlendEx_Event")
		$cidBlendVividLight = GUICtrlCreateMenuItem("Vivid Light", $cidBlendFX, 12)
		GUICtrlSetOnEvent(-1, "_BlendEx_Event")

		$cidBlendDifference = GUICtrlCreateMenuItem("Difference", $cidBlendFX, 16)
		GUICtrlSetOnEvent(-1, "_BlendEx_Event")
		$cidBlendExclusion = GUICtrlCreateMenuItem("Exclusion", $cidBlendFX, 17)
		GUICtrlSetOnEvent(-1, "_BlendEx_Event")

		$cidBlendNormal = GUICtrlCreateMenuItem("Normal", $cidBlendFX, 0)
		GUICtrlSetOnEvent(-1, "_BlendEx_Event")

		GUICtrlCreateMenuItem("", $cidBlendFX, 1)
	EndIf

	$cidBlurFX = GUICtrlCreateMenu("Blur", $cidEffectMenu)
	$cidGaussianBlur = GUICtrlCreateMenuItem("Gaussian Blur", $cidBlurFX)
	GUICtrlSetOnEvent(-1, "_Blur_Event")
	$cidMotionBlur = GUICtrlCreateMenuItem("Motion Blur", $cidBlurFX)
	GUICtrlSetOnEvent(-1, "_MotionBlur_Event")
	$cidRadialBlur = GUICtrlCreateMenuItem("Radial Blur", $cidBlurFX)
	GUICtrlSetOnEvent(-1, "_RadialBlur_Event")
	$cidZoomBlur = GUICtrlCreateMenuItem("Zoom Blur", $cidBlurFX)
	GUICtrlSetOnEvent(-1, "_ZoomBlur_Event")

	If _IsExperimentEnabled("LibGdipExt32") Then
		$cidGaussianBlurNoPremul = GUICtrlCreateMenuItem("Filtered Gaussian Blur", $cidBlurFX, 1)
		GUICtrlSetOnEvent(-1, "_BlurEx_Event")
	EndIf

	$cidColorFX = GUICtrlCreateMenu("Color", $cidEffectMenu)
	$cidChromaKey = GUICtrlCreateMenuItem("Chroma Key", $cidColorFX)
	GUICtrlSetOnEvent(-1, "_ChromaKey_Event")

	If _IsExperimentEnabled("LibGdipExt32") Then
		$cidColorReplace = GUICtrlCreateMenuItem("Color Replace", $cidColorFX, 1)
		GUICtrlSetOnEvent(-1, "_ColorReplace_Event")
		$cidPremultiply = GUICtrlCreateMenuItem("Premultiply", $cidColorFX, 2)
		GUICtrlSetOnEvent(-1, "_Premultiply_Event")
		$cidUnPremultiply = GUICtrlCreateMenuItem("Unpremultiply", $cidColorFX, 3)
		GUICtrlSetOnEvent(-1, "_UnPremultiply_Event")
	EndIf

	$cidDistortFX = GUICtrlCreateMenu("Distort", $cidEffectMenu)
	$cidGlitch = GUICtrlCreateMenuItem("Glitch", $cidDistortFX)
	GUICtrlSetOnEvent(-1, "_Glitch_Event")
	$cidRipple = GUICtrlCreateMenuItem("Ripple", $cidDistortFX)
	GUICtrlSetOnEvent(-1, "_Ripple_Event")
	$cidWind = GUICtrlCreateMenuItem("Wind", $cidDistortFX)
	GUICtrlSetOnEvent(-1, "_Wind_Event")

	$cidRenderFX = GUICtrlCreateMenu("Render", $cidEffectMenu)

	If _IsExperimentEnabled("LibGdipExt32") Then
		$cidGenerateSTriangle = GUICtrlCreateMenuItem("AND-based Sierpinski Triangle", $cidRenderFX, -1)
		GUICtrlSetOnEvent(-1, "_GenerateSTriangle_Event")

		$cidGenerateXOR = GUICtrlCreateMenuItem("XOR Pattern", $cidRenderFX, -1)
		GUICtrlSetOnEvent(-1, "_GenerateXOR_Event")
	EndIf

	$cidStylizeFX = GUICtrlCreateMenu("Stylize", $cidEffectMenu)
	$cidInterlace = GUICtrlCreateMenuItem("Interlace", $cidStylizeFX)
	GUICtrlSetOnEvent(-1, "_Interlace_Event")
	$cidPixelize = GUICtrlCreateMenuItem("Pixelize", $cidStylizeFX)
	GUICtrlSetOnEvent(-1, "_Pixelize_Event")
	$cidTiles = GUICtrlCreateMenuItem("Tiles", $cidStylizeFX)
	GUICtrlSetOnEvent(-1, "_Tiles_Event")

	_Tiles_ButtonSetExtra($cidEffectMenuBtn, $cidEffectMenu)

	$cidViewMenuBtn = _Tiles_CreateButton("View ", $iNextMenuBtnX, -30, Default, 30, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444)
	$iNextMenuBtnX += @extended
	_AddCtrlToTabletUITopBar($cidViewMenuBtn)

	$cidHelpMenuBtn = _Tiles_CreateButton("Help ", $iNextMenuBtnX, -30, Default, 30, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444)
	$iNextMenuBtnX += @extended
	GUICtrlSetOnEvent(-1, "_ShowMenuBarMenu")
	_AddCtrlToTabletUITopBar($cidHelpMenuBtn)

	$cidDummy = GUICtrlCreateDummy()
	$cidHelpMenu = GUICtrlCreateContextMenu($cidDummy)

	$cidExperiments = GUICtrlCreateMenu("Experimental functions", $cidHelpMenu)
	For $i = 1 To $aExperimentalFunctions[0]
		$oExperiment = $aExperimentalFunctions[$i]
		$item = GUICtrlCreateMenuItem($oExperiment.name&" ("&$oExperiment.id&")", $cidExperiments)
		If _IsExperimentEnabled($oExperiment.id) Then GUICtrlSetState($item, $GUI_CHECKED)
	Next

	_Tiles_ButtonSetExtra($cidHelpMenuBtn, $cidHelpMenu)

	#EndRegion

	#Region Top Bar

	$cidExpandTabletModeUI = _CreateImgButton(_GetIconPath("navigation", "more_horiz"), 0, 0, 24, 24, $cW-40, 0, 40, 30, 0xFFF0F0F0, 0xFFE0E0E0, 0xFFC0C0C0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKRIGHT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_ExpandTabletModeBar")

	$cidProgressBar = GUICtrlCreateProgress($cW-240, 0, 200, 30)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKRIGHT+$GUI_DOCKSIZE)
	GUICtrlSetState(-1, $GUI_HIDE)

	#EndRegion

	#Region Background

	$cidBackgroundArea = GUICtrlCreateLabel("", 0, 30, $cW, $cH-30)
	GUICtrlSetBkColor(-1, 0xC0C0C0)
	GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)
	GUICtrlSetState(-1, $GUI_DISABLE)

	#EndRegion

	#Region Tool Rack

	$cidMoveTool = _CreateImgButton(_GetIconPath("tools", "move"), 0, 0, 24, 24, -40, 60+40*0, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Transform (V)")
	_AddCtrlToTabletUILeftBar($cidMoveTool)

	_ImgButton_SetExtra($cidMoveTool, 0)

	$cidRectSelectTool = _CreateImgButton(_GetIconPath("tools", "select"), 0, 0, 24, 24, -40, 60+40*1, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Select (M)")
	_AddCtrlToTabletUILeftBar($cidRectSelectTool)

	_ImgButton_SetExtra($cidRectSelectTool, 1)

	$cidCropTool = _CreateImgButton(_GetIconPath("image", "crop"), 0, 0, 24, 24, -40, 60+40*2, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Crop (C)")
	_AddCtrlToTabletUILeftBar($cidCropTool)

	$cidEyedropperTool = _CreateImgButton(_GetIconPath("image", "colorize"), 0, 0, 24, 24, -40, 60+40*3, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Eyedropper (I)")
	_AddCtrlToTabletUILeftBar($cidEyedropperTool)

	_ImgButton_SetExtra($cidEyedropperTool, 3)

	$cidHealingTool = _CreateImgButton(_GetIconPath("image", "healing"), 0, 0, 24, 24, -40, 60+40*4, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Healing Brush (J)")
	_AddCtrlToTabletUILeftBar($cidHealingTool)

	$cidBrushTool = _CreateImgButton(_GetIconPath("image", "brush"), 0, 0, 24, 24, -40, 60+40*5, 40, 40, 0xFF327AEB, 0xFF226ADB, 0xFF125ACB)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Brush (B)")
	_AddCtrlToTabletUILeftBar($cidBrushTool)

	_ImgButton_SetExtra($cidBrushTool, 2)
	$cidSelectedTool = $cidBrushTool

	$cidGradientTool = _CreateImgButton(_GetIconPath("image", "gradient"), 0, 0, 24, 24, -40, 60+40*6, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Gradient (G)")
	_AddCtrlToTabletUILeftBar($cidGradientTool)

	$cidEraserTool = _CreateImgButton(_GetIconPath("tools", "eraser"), 0, 0, 24, 24, -40, 60+40*7, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Eraser (E)")
	_AddCtrlToTabletUILeftBar($cidEraserTool)

	$cidEffectTool = _CreateImgButton(_GetIconPath("image", "blur_circular"), 0, 0, 24, 24, -40, 60+40*8, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Effect Brush (O)")
	_AddCtrlToTabletUILeftBar($cidEffectTool)

	$cidShapeTool = _CreateImgButton(_GetIconPath("tools", "polygon"), 0, 0, 24, 24, -40, 60+40*9, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Shape (U)")
	_AddCtrlToTabletUILeftBar($cidShapeTool)

	$cidTextTool = _CreateImgButton(_GetIconPath("editor", "format_size"), 0, 0, 24, 24, -40, 60+40*10, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Text (T)")
	_AddCtrlToTabletUILeftBar($cidTextTool)

	$cidZoomTool = _CreateImgButton(_GetIconPath("image", "loupe"), 0, 0, 24, 24, -40, 60+40*11, 40, 40, 0xFFC0C0C0, 0xFFB0B0B0, 0xFFA0A0A0)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetTool")
	GUICtrlSetTip(-1, "Zoom (Z)")
	_AddCtrlToTabletUILeftBar($cidZoomTool)

	$cidForeground = GUICtrlCreateLabel("", -40, 60+40*12, 40, 30, $WS_BORDER)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetColor")
	GUICtrlSetBkColor(-1, _SetAlpha($iForeground, 0))
	_AddCtrlToTabletUILeftBar($cidForeground)

	$cidForeContextMenu = GUICtrlCreateContextMenu($cidForeground)
	$cidForeSetToBlack = GUICtrlCreateMenuItem("Set to Black", $cidForeContextMenu)
	GUICtrlSetOnEvent(-1, "_SetForeColor")
	$cidForeSetToWhite = GUICtrlCreateMenuItem("Set to White", $cidForeContextMenu)
	GUICtrlSetOnEvent(-1, "_SetForeColor")
	GUICtrlCreateMenuItem("", $cidForeContextMenu)
	GUICtrlCreateMenuItem("Swap	X", $cidForeContextMenu)
	GUICtrlSetOnEvent(-1, "_SwapForeBack")

	$cidBackground = GUICtrlCreateLabel("", -40, 60+40*12+29, 40, 30, $WS_BORDER)
	GUICtrlSetResizing(-1, $GUI_DOCKTOP+$GUI_DOCKLEFT+$GUI_DOCKSIZE)
	GUICtrlSetOnEvent(-1, "_SetColor")
	GUICtrlSetBkColor(-1, _SetAlpha($iBackground, 0))
	_AddCtrlToTabletUILeftBar($cidBackground)

	$cidBackContextMenu = GUICtrlCreateContextMenu($cidBackground)
	$cidBackSetToBlack = GUICtrlCreateMenuItem("Set to Black", $cidBackContextMenu)
	GUICtrlSetOnEvent(-1, "_SetBackColor")
	$cidBackSetToWhite = GUICtrlCreateMenuItem("Set to White", $cidBackContextMenu)
	GUICtrlSetOnEvent(-1, "_SetBackColor")
	GUICtrlCreateMenuItem("", $cidBackContextMenu)
	GUICtrlCreateMenuItem("Swap	X", $cidBackContextMenu)
	GUICtrlSetOnEvent(-1, "_SwapForeBack")

	#EndRegion

	#Region Drawing Area

	$cidDrawingArea = GUICtrlCreateLabel("", 0, 30, $cW, $cH-30, $SS_BITMAP)
	GUICtrlSetBkColor(-1, 0xC0C0C0)
	GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)
	GUICtrlSetOnEvent(-1, "_DrawingAreaClick")

	#EndRegion

	Global $aAcc[2][2] = [["^z", $cidUndo], ["^+z", $cidRedo]]
	GUISetAccelerators($aAcc, $hMainUI)

	GUIRegisterMsg($WM_MOUSEWHEEL, "WM_MOUSEWHEEL")
	GUIRegisterMsg($WM_SIZE, "WM_SIZE")
	GUIRegisterMsg($WM_USER, "WM_USER")
	GUISetState(@SW_SHOWNORMAL)
EndFunc

Func _ExpandTabletModeBar()
	$isTabletModeBarExpanded = 1 - $isTabletModeBarExpanded

	$cW = _WinAPI_GetClientWidth($hMainUI)
	$cH = _WinAPI_GetClientHeight($hMainUI)

	GUICtrlSetPos(@GUI_CtrlId, $cW-40, $isTabletModeBarExpanded ? 30 : 0)
	GUICtrlSetPos($cidProgressBar, $cW-200-($isTabletModeBarExpanded ? 0 : 40), 0)
	GUICtrlSetPos($cidBackgroundArea, 0, $isTabletModeBarExpanded ? 60 : 30, $cW, $cH-($isTabletModeBarExpanded ? 60 : 30))
	GUICtrlSetPos($cidDrawingArea, $isTabletModeBarExpanded ? 40 : 0, $isTabletModeBarExpanded ? 60 : 30, $cW-($isTabletModeBarExpanded ? 40 : 0), $cH-($isTabletModeBarExpanded ? 60 : 30))

	For $i = 1 To $aTabletModeUIControls_Top[0]
		$ctrl = $aTabletModeUIControls_Top[$i]
		$pos = ControlGetPos($hMainUI, "", $ctrl)
		GUICtrlSetPos($ctrl, $pos[0], $isTabletModeBarExpanded ? 0 : -30)
	Next

	For $i = 1 To $aTabletModeUIControls_Left[0]
		$ctrl = $aTabletModeUIControls_Left[$i]
		$pos = ControlGetPos($hMainUI, "", $ctrl)
		GUICtrlSetPos($ctrl, $isTabletModeBarExpanded ? 0 : -40, $pos[1])
	Next

	_RefreshTabs()
	_RenderDrawingArea()
EndFunc

Func _AddCtrlToTabletUITopBar($ctrl)
	_ArrayAdd($aTabletModeUIControls_Top, $ctrl)
	$aTabletModeUIControls_Top[0] += 1
EndFunc

Func _AddCtrlToTabletUILeftBar($ctrl)
	_ArrayAdd($aTabletModeUIControls_Left, $ctrl)
	$aTabletModeUIControls_Left[0] += 1
EndFunc

Func _IsTabletMode()
	If BitAND(WinGetState("[CLASS:TabletModeCoverWindow]"), 2) Then Return 1
	Return 0
EndFunc

Func _CheckForTabletMode()
	Switch $isTabletMode
		Case 0
			If _IsTabletMode() Then _SwitchMode(1)
		Case 1
			If Not _IsTabletMode() Then _SwitchMode(0)
	EndSwitch
EndFunc
