#include-once

Func _D2D1_CreateBitmap($oRenderTarget, $iWidth, $iHeight, $srcData = 0, $iStride = 0, $oBitmapProperties = 0)
	Local $pBitmapProperties = 0
	If IsObj($pBitmapProperties) Then $pBitmapProperties = $oBitmapProperties()
	Local $oSize = _D2D1_CreateSizeU($iWidth, $iHeight)
	Local $aCall = $oRenderTarget.CreateBitmap($oSize(), Number($srcData), Number($iStride), $pBitmapProperties, 0)

	Return SetError($aCall[0], 0, $aCall[5])
EndFunc

Func _D2D1_CreateBitmapFromWicBitmap($oRenderTarget, $oWICFormatConverter, $oBitmapProperties = 0)
	Local $pProps = 0
	If IsObj($oBitmapProperties) Then $pProps = $oBitmapProperties()

	Local $aCall = $oRenderTarget.CreateBitmapFromWicBitmap($oWICFormatConverter.__ptr__, $oBitmapProperties, 0)
	ConsoleWrite($aCall[0])

	Return $aCall[3]
EndFunc

Func _D2D1_CreateBitmapFromHBITMAP($oRenderTarget, $oWICImagingFactory, $hHBITMAP, $oBitmapProperties = 0)
	Local $oWICConverter = _WIC_CreateBitmapFromHBITMAP($oWICImagingFactory, $hHBITMAP)
	Local $hBmp = _D2D1_CreateBitmapFromWicBitmap($oRenderTarget, $oWICConverter, $oBitmapProperties)

	Return $hBmp
EndFunc

Func _D2D1_CreateBitmapFromFile($oRenderTarget, $oWICImagingFactory, $sFile, $oBitmapProperties = 0)
	Local $oWICConverter = _WIC_CreateBitmapFromFile($oWICImagingFactory, $sFile)
	Local $hBmp = _D2D1_CreateBitmapFromWicBitmap($oRenderTarget, $oWICConverter, $oBitmapProperties)

	Return $hBmp
EndFunc

Func _WIC_CreateBitmapFromHBITMAP($oWICImagingFactory, $hHBITMAP, $iAlphaMode = 0)
	Local $aCall = $oWICImagingFactory.CreateBitmapFromHBITMAP(Number($hHBITMAP), 0, $iAlphaMode, 0)
	Local $hWICBitmap = $aCall[4]

	$aCall = $oWICImagingFactory.CreateFormatConverter(0)
	Local $oWICFormatConverter = _AutoItObject_WrapperCreate($aCall[1], $dtagIWICFormatConverter)

	Local $tGUID_WICPixelFormat32bppPBGRA = _AutoItObject_CLSIDFromString("{6fddc324-4e03-4bfe-b185-3d77768dc910}")
	$oWICFormatConverter.Initialize($hWICBitmap, Number(DllStructGetPtr($tGUID_WICPixelFormat32bppPBGRA)), 0, 0, 0, 1)

	Return $oWICFormatConverter
EndFunc

Func _WIC_CreateBitmapFromFile($oWICImagingFactory, $sFile)
	Local $aCall = $oWICImagingFactory.CreateDecoderFromFilename($sFile, 0, $GENERIC_READ, 0, 0)
	Local $pDecoder = $aCall[5]

	Local $oWICBitmapDecoder = _AutoItObject_WrapperCreate($pDecoder, $dtagIWICBitmapDecoder)
	Local $aCall = $oWICBitmapDecoder.GetFrame(0, 0)
	Local $hWICBitmap = $aCall[2]

	$aCall = $oWICImagingFactory.CreateFormatConverter(0)
	Local $oWICFormatConverter = _AutoItObject_WrapperCreate($aCall[1], $dtagIWICFormatConverter)

	Local $tGUID_WICPixelFormat32bppPBGRA = _AutoItObject_CLSIDFromString("{6fddc324-4e03-4bfe-b185-3d77768dc910}")
	$oWICFormatConverter.Initialize($hWICBitmap, Number(DllStructGetPtr($tGUID_WICPixelFormat32bppPBGRA)), 0, 0, 0, 1)

	Return $oWICFormatConverter
EndFunc
