#include-once

Func _D2D1_FillRect($oRenderTarget, $oRectF, $hBrush)
	$oRenderTarget.FillRectangle($oRectF(), $hBrush)
EndFunc

Func _D2D1_DrawRect($oRenderTarget, $oRectF, $hBrush, $fStrokeWidth = 1, $pStrokeStyle = 0)
	$oRenderTarget.DrawRectangle($oRectF(), $hBrush, $fStrokeWidth, $pStrokeStyle)
EndFunc

Func _D2D1_FillEllipse($oRenderTarget, $oEllipse, $hBrush)
	$oRenderTarget.FillEllipse($oEllipse(), $hBrush)
EndFunc

Func _D2D1_DrawEllipse($oRenderTarget, $oEllipse, $hBrush, $fStrokeWidth = 1, $pStrokeStyle = 0)
	$oRenderTarget.DrawEllipse($oEllipse(), $hBrush, $fStrokeWidth, $pStrokeStyle)
EndFunc

Func _D2D1_DrawLine($oRenderTarget, $fX1, $fY1, $fX2, $fY2, $hBrush, $fStrokeWidth = 1, $pStrokeStyle = 0)
	$oRenderTarget.DrawLine($fX1, $fY1, $fX2, $fY2, $hBrush, $fStrokeWidth, $pStrokeStyle)
EndFunc

Func _D2D1_DrawGeometry($oRenderTarget, $hGeometry, $hBrush, $fStrokeWidth = 1, $pStrokeStyle = 0)
	$oRenderTarget.DrawGeometry($hGeometry, $hBrush, $fStrokeWidth, $pStrokeStyle)
EndFunc

Func _D2D1_FillGeometry($oRenderTarget, $hGeometry, $hBrush)
	$oRenderTarget.FillGeometry($hGeometry, $hBrush, 0)
EndFunc

Func _D2D1_DrawBitmap($oRenderTarget, $hBitmap, $oRectF, $fOpacity = 1, $iInterpolationMode = 1, $oSourceRect = 0)
	Local $pSourceRect = 0
	If IsObj($oSourceRect) Then $pSourceRect = $oSourceRect()

	$oRenderTarget.DrawBitmap($hBitmap, $oRectF(), $fOpacity, $iInterpolationMode, $pSourceRect)
EndFunc

Func _D2D1_DrawTextLayout($oRenderTarget, $iX, $iY, $oTextLayout, $hBrush, $iOptions = 0)
	$oRenderTarget.DrawTextLayout($iX, $iY, $oTextLayout.__ptr__, $hBrush, $iOptions)
EndFunc
