#include-once

#include "COM/DirectWrite.intfc"

#include "DirectWriteTextLayout.au3"
#include "DirectWriteTypography.au3"

; #INDEX# =======================================================================================================================
; Title .........: Direct2D UDF - DirectWrite
; AutoIt Version : 3.3.14.0
; Description ...: Direct2D UDF for use in AutoIt3 scripts.
; Author(s) .....: scintilla4evr, .INTFC file by trancexx
; ===============================================================================================================================

Func _DWrite_CreateFactoryObject()
	$hDll = DllOpen("dwrite.dll")
	Local $tIID_IDWriteFactory = _AutoItObject_CLSIDFromString($sIID_IDWriteFactory)
	Local $aCall = DllCall($hDll, "long", "DWriteCreateFactory", _
			"dword", 0, _
			"ptr", DllStructGetPtr($tIID_IDWriteFactory), _
			"ptr*", 0)
	If @error Or $aCall[0] Then Return SetError(1, 0, 0)
	Local $pDWriteFactory = $aCall[3]
	Return _AutoItObject_WrapperCreate($pDWriteFactory, $dtagIDWriteFactory)
EndFunc

Func _DWrite_CreateTextFormat($oDWriteFactory, $sFontFamily, $pCollection = 0, $iWeight = 400, $iStyle = 0, $iStretch = 5, $fSize = 12, $sLocaleName = "en-us")
	Local $aCall = $oDWriteFactory.CreateTextFormat($sFontFamily, $pCollection, $iWeight, $iStyle, $iStretch, $fSize, "en-us", 0)

	Local $oTextFormat = _AutoItObject_WrapperCreate($aCall[8], $dtagIDWriteTextFormat)

	Return $oTextFormat
EndFunc
