;IMPORTANT: You are not allowed to sell this code or just parts of it in a commercial project or modify it and distribute it with a different name!
;Distributing copies of this UDF incl. _GDIPlus_BitmapApplyFilter.dll in compiled format (exe) must be free of any fee!
;
;coded by UEZ build 2016-07-08 beta
;

#include-once
#include <GDIPlus.au3>

Global $__hDLL__FX__
Global Enum $EMBOSS1 = 1, $EMBOSS2, $EMBOSS3, $EMBOSS4, $SHARPEN1, $BOX_BLUR, $GAUSSIAN_BLUR, $TRIANGLE_BLUR, $UNSHARP, $UNSHARP5x5, _
			$EDGE_DETECTION1, $EDGE_DETECTION2, $EDGE_DETECTION3, $EDGE_DETECTION4, $EDGE_DETECTION5, $EDGE_DETECTION6, _
			$ANOTHER_BLUR, $MOTION_BLUR, $SHARPEN2, $SOBEL, $LAPLACE3x3_1, $LAPLACE3x3_2, $LAPLACE5x5, $PREWITT, $KIRSCH, _
			$OUTLINE3X3, $GAUSSIAN5X5_1, $GAUSSIAN5X5_2, $LAPLACIANOFGAUSSIAN, $SOVELVSPREWITT



; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_SymmetricNearestNeighbour
; Description ...: A smoothing (noise reduction) filter. The SNN smoothing filter is designed to preserve edges in data and
;				   is very effective at noise reduction.
; Syntax ........: _GDIPlus_BitmapApplyFilter_SymmetricNearestNeighbour($hImage, $fRadius[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $fRadius             - a floating point value. The higher the value the more time will needed for calculation.
;										  The value is limited between 1 and 25.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will
;										  be returned, otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_SymmetricNearestNeighbour($hImage, $fRadius, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_SymmetricNearestNeighbour", "ptr", $hImage, "float", $fRadius, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_SymmetricNearestNeighbour

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Jitter
; Description ...: Jitters the image
; Syntax ........: _GDIPlus_BitmapApplyFilter_Jitter($hImage, $iAmount[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iAmount             - an integer value. The amount of jitter strength the image will be modified.
;										  The higher the value the more the image will be jittered.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Jitter($hImage, $iAmount, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Jitter", "ptr", $hImage, "uint", $iAmount, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Jitter

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Median
; Description ...: A smoothing (noise reduction) filter. The median filter is well known as an edge-preserving smoothing filter.
; Syntax ........: _GDIPlus_BitmapApplyFilter_Median($hImage, $fRadius[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $fRadius             - a floating point value. The higher the value the more time will needed for calculation.
;										  The value is limited between 1 and 25.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Median($hImage, $fRadius, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Median", "ptr", $hImage, "float", $fRadius, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Median

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Kuwahara
; Description ...: A smoothing (noise reduction) filter. Like the SNN filter, the Kuwahara filter is an adaptive, edge-preserving
;				   smoothing filter.
; Syntax ........: _GDIPlus_BitmapApplyFilter_Kuwahara($hImage, $iSize[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iSize               - an integer value. The higher the value the more time will needed for calculation.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Kuwahara($hImage, $iSize, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Kuwahara", "ptr", $hImage, "uint", $iSize, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Kuwahara

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Edges
; Description ...: An edge detecting function based on left neighbour color value.
; Syntax ........: _GDIPlus_BitmapApplyFilter_Edges($hImage, $bMode[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $bMode               - a boolean value. If true then the colors will be negated.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Edges($hImage, $bMode, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Edges", "ptr", $hImage, "bool", $bMode, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Edges

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Pointillism
; Description ...: Creates an image based on filled ellipses.
; Syntax ........: _GDIPlus_BitmapApplyFilter_Pointillism($hImage, $iRounds, $iSizeEllipse, $iAlpha[, $bBorder = False[,
;                  $bGDI_Bmp = False]])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iRounds             - an integer value. The amount of drawn filled ellipses.
;                  $iSizeEllipse        - an integer value. The size of the ellipses.
;                  $iAlpha              - an integer value. Alpha color channel. Possible values are between 0 and 255 whereas
;										  0 is transparent and 255 is opaque.
;                  $bBorder             - [optional] a boolean value. Default is False. If true ellipses will have borders.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Pointillism($hImage, $iRounds, $iSizeEllipse, $iAlpha, $bBorder = False, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Pointillism", "ptr", $hImage, "uint", $iRounds, "uint", $iSizeEllipse, "byte", $iAlpha, "bool", $bBorder, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Pointillism

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Linellism
; Description ...: Creates an image based on filled rectangles (similar to Pointillism fx).
; Syntax ........: _GDIPlus_BitmapApplyFilter_Linellism($hImage, $iRounds, $iSizeRect, $iAlpha[, $iMode = 1[, $bBorder = False[,
;                  $bGDI_Bmp = False]]])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iRounds             - an integer value. The amount of drawn filled rectangles.
;                  $iSizeRect           - an integer value. The size of the rectangles.
;                  $iAlpha              - an integer value. Alpha color channel. Possible values are between 0 and 255 whereas
;										  0 is transparent and 255 is opaque.
;                  $iMode               - [optional] an integer value. Default is 1. Direction of the rectangles.
;										  1 = horizontal, 2 = vertical, 3 = randomly 1 and 2.
;                  $bBorder             - [optional] a boolean value. Default is False. If true ellipses will have borders.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Linellism($hImage, $iRounds, $iSizeRect, $iAlpha, $iMode = 1, $bBorder = False, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Linellism", "ptr", $hImage, "uint", $iRounds, "uint", $iSizeRect, "byte", $iAlpha, "byte", $iMode, "bool", $bBorder, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Linellism

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Convolution
; Description ...: In image processing, a kernel, convolution matrix, or mask is a small matrix useful for blurring, sharpening,
;				   embossing, edge detection, and more. This is accomplished by means of convolution between a kernel and an image.
; Syntax ........: _GDIPlus_BitmapApplyFilter_Convolution($hImage, $fFactor, $fBias[, $iMode = 1[, $bGDI_Bmp = False]])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $fFactor             - a floating point value. Adjustment for the color value (the factor will be multiplied with the result).
;                  $fBias               - a floating point value. Adjustment for the color value (brightness).
;                  $iMode               - [optional] an integer value. Default is 1.
;										  Convolution modes (matrixes):
;										  0: Manual odd matrix -> 3x3, 5x5, 7x7, 9x9
;										  1: Emboss 3x3
;										  2: Emboss 45 Degree 3x3
;										  3: Emboss Top Left Bottom Right 3x3
;										  4: Intense Emboss 5x5
;										  5: Sharpen 3x3
;										  6: Box Blur (normalized) 3x3
;										  7: Gaussian Blur (approximation) 3x3
;										  8: Triangle Blur 3x3
;										  9: Unsharp(with no image mask) 5x5
;										 10: Unsharp 3x3
;										 11: Edge Detection 1 3x3
;										 12: Edge Detection 2 3x3
;										 13: Edge Detection 3 3x3
;										 14: Edge Detection 4 3x3
;										 15: Edge Detection 5 3x3
;										 16: Edge Detection 6 3x3
;										 17: Another Blur 5x5
;										 18: Motion Blur 9x9
;										 19: Sharpen 2 3x3
;										 20: Sobel 3x3 with 2 matrixes (h/w)
;										 21: Laplace 3x3 v1
;										 22: Laplace 3x3 v2
;										 23: Laplace 5x5
;										 24: Prewitt 3x3
;										 25: Kirsch 3x3
;										 26: Gaussian3x3 blur
;										 27: Gaussian5x5 Type1 blur
;										 28: Gaussian5x5 Type2 blur
;										 29: Laplacian of Gaussian 5x5
;										 30: Sovel vs Prewitt 3x3
;                  $tMatrix             - [optional] an integer value. Default is 0. You can provide a convolution matrix manually.
;										  The struct must have same amount of columns & rows whereas columns / rows must be odd!
;										  E.g. struct of array has following structure for a 3x3 matrix:
;										  $iMatrix = 3 * 3
;										  $tStruct = DllStructCreate("float Matrix[" & $iMatrix & "]")
;										  $tStruct.Matrix((1)) = 0.1
;										  $tStruct.Matrix((2)) = 0.2
;										  $tStruct.Matrix((3)) = 0.3
;										  $tStruct.Matrix((4)) = 1.1
;										  $tStruct.Matrix((5)) = 1.2
;										  $tStruct.Matrix((6)) = 1.3
;										  $tStruct.Matrix((7)) = 2.1
;										  $tStruct.Matrix((8)) = 2.2
;										  $tStruct.Matrix((9)) = 2.3
;										  As an array:
;										  [0.1, 0.1, 0.1]
;										  [1.1, 1.1, 1.1]
;										  [2.1, 2.1, 2.1]
;                  $iMatrix             - [optional] an integer value. Default is 0. The amount of matrix elements. E.g. a 3x3 matrix
;										  has 9 elements.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Convolution($hImage, $fFactor, $fBias, $iMode = 1, $tMatrix = 0, $iMatrix = 0, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Convolution", "ptr", $hImage, "float", $fFactor, "float", $fBias, "byte", $iMode, "struct*", $tMatrix, "ushort", $iMatrix, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Convolution

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Raster
; Description ...: Creates a raster effect based on ellipses.
; Syntax ........: _GDIPlus_BitmapApplyFilter_Raster($hImage[, $iSizeW = 8[, $iSizeH = 8[, $fDensity = 0.0[, $fbrightness = 0[,
;                  $fBias = 0[, $iMode = 1[, $bGDI_Bmp = False]]]]]]])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iSizeW              - [optional] an integer value. Default is 8. Width of the raster ellipse.
;                  $iSizeH              - [optional] an integer value. Default is 8. Height of the raster ellipse.
;                  $fDensity            - [optional] a floating point value. Default is 0.0. Represents the pixel density.
;                  $fbrightness         - [optional] a floating point value. Default is 0. Represents the brightness of the ellipse color.
;                  $fBias              - [optional] a floating point value. Default is 0. Adjusts the size of the ellipse.
;                  $iMode               - [optional] an integer value. Default is 1. 1 = colorized, >1 = b/w.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Raster($hImage, $iSizeW = 8, $iSizeH = 8, $fDensity = 0.0, $fbrightness = 10, $fBias = 0, $iMode = 1, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Raster", "ptr", $hImage, "uint", $iSizeW, "uint", $iSizeH, "float", $fDensity, "float", $fbrightness, "float", $fBias, "byte", $iMode, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Raster

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Pixelate
; Description ...: Pixelates an image.
; Syntax ........: _GDIPlus_BitmapApplyFilter_Pixelate($hImage[, $iPixelate = 8[, $bGDI_Bmp = False]])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iPixelate           - [optional] an integer value. Default is 8. The divisor for the width / height of the image.
;										  The higher the value the more pixelated will be the image.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Pixelate($hImage, $iPixelate = 8, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Pixelate", "ptr", $hImage, "byte", $iPixelate, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Pixelate

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Dilatation
; Description ...: Gradually enlarges the boundaries of regions of foreground pixels (i.e. white pixels, typically).
; Syntax ........: _GDIPlus_BitmapApplyFilter_Dilate($hImage[, $iSize = 5[, $bGDI_Bmp = False]])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iSize               - [optional] an integer value. Default is 5. The higher the value the more time will
;										  needed for calculation. $iSize is limited to a value between 2 and 32.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Dilatation($hImage, $iSize = 5, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Dilatation", "ptr", $hImage, "byte", $iSize, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Dilatation

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Erosion
; Description ...: Erodes away the boundaries of regions of foreground pixels (i.e. white pixels, typically).
; Syntax ........: _GDIPlus_BitmapApplyFilter_Erosion($hImage[, $iSize = 5[, $bGDI_Bmp = False]])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iSize               - [optional] an integer value. Default is 5. The higher the value the more time will
;										  needed for calculation. $iSize is limited to a value between 2 and 32.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Erosion($hImage, $iSize = 5, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Erosion", "ptr", $hImage, "byte", $iSize, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Erosion

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_OilPainting
; Description ...: Applies an oil painting look to the image.
; Syntax ........: _GDIPlus_BitmapApplyFilter_OilPainting($hImage, $iRadius, $fIntensityLevels[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iRadius             - an integer value. The size of the brush. $iRadius is limited to a value between 1 and 32.
;                  $fIntensityLevels    - a floating point value. The higher the value the more details will be drawn and also
;										  more time will needed for calculation. Lower values mean more solid colors.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_OilPainting($hImage, $iRadius, $fIntensityLevels, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_OilPainting", "ptr", $hImage, "byte", $iRadius, "float", $fIntensityLevels, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_OilPainting

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_ColorAccent
; Description ...: Make the image greyscale except the selected Hue value.
; Syntax ........: _GDIPlus_BitmapApplyFilter_ColorAccent($hImage[, $iHue = 0[, $fRange = 15[, $bGDI_Bmp = False]]])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iHue                - [optional] an integer value. Default is 0°. A Hue value which will be skipped to be greyscale.
;										  Range: 0° - 360°
;                  $fRange              - [optional] a floating point value. Default is 15. Range of Hue value.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........: http://www.rapidtables.com/convert/color/rgb-to-hsv.htm
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_ColorAccent($hImage, $iHue = 0, $fRange = 15, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_ColorAccent", "ptr", $hImage, "ushort", $iHue, "float", $fRange, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_ColorAccent

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_PenSketch
; Description ...: A bundle of several filters to produce a pen sketch effect.
; Syntax ........: _GDIPlus_BitmapApplyFilter_PenSketch($hImage, $iThreshold[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iThreshold          - an integer value. This value is used for _GDIPlus_BitmapApplyFilter_Convolution (Sobel)
;				   						  filter.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_PenSketch($hImage, $iThreshold, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_PenSketch", "ptr", $hImage, "float", $iThreshold, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_PenSketch

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_PenSketch2
; Description ...: A bundle of several filters to produce a pen sketch effect.
; Syntax ........: _GDIPlus_BitmapApplyFilter_PenSketch2($hImage, $iThreshold[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iThreshold          - an integer value. This value is used for _GDIPlus_BitmapApplyFilter_Convolution (Sobel)
;				   						  filter.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_PenSketch2($hImage, $iThreshold, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_PenSketch2", "ptr", $hImage, "ubyte", $iThreshold, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_PenSketch2

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Cartoon1
; Description ...: Creates a cartoon effect image
; Syntax ........: _GDIPlus_BitmapApplyFilter_Cartoon1($hImage, $iRadius, $fIntensityLevels, $iThreshold[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $iRadius             - an integer value. The size of the brush. $iRadius is limited to a value between 1 and 32.
;                  $fIntensityLevels    - a floating point value. The higher the value the more details will be drawn and also
;										  more time will needed for calculation. Lower values mean more solid colors.
;                  $iThreshold          - an integer value. The lower the value the more black contour lines will be drawn.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Cartoon1($hImage, $iRadius, $fIntensityLevels, $iThreshold, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_Cartoon1", "ptr", $hImage, "ubyte", $iRadius, "float", $fIntensityLevels, "ubyte", $iThreshold, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Cartoon1

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_TiltShift
; Description ...: Create a tilf shift effect
; Syntax ........: _GDIPlus_BitmapApplyFilter_TiltShift($hImage, $fPosY[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $fPosY               - a floating point value. This value is the area in the image where no blurring occurs whereas
;                                         $fPosY is the start and $fPosY + $fPosY / 2 the end position.
;                  $iIntensity          - an integer value. The higher the value the more the image will be blurred.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_TiltShift($hImage, $fPosY, $iIntensity, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_TiltShift", "ptr", $hImage, "float", $fPosY, "uByte", $iIntensity, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_RadialBlur
; Description ...:
; Syntax ........: _GDIPlus_BitmapApplyFilter_RadialBlur($hImage, $fPosX, $fPosY, $fRadius, $iIntensity[, $bGDI_Bmp = False])
; Parameters ....: $hImage              - a handle to a GDIPlus bitmap.
;                  $fPosX               - a floating point value. X position if the circle.
;                  $fPosY               - a floating point value. Y position if the circle.
;                  $fRadius             - a floating point value. Radius of the non blur circle.
;                  $iIntensity          - an integer value. The higher the value the more the image will be blurred.
;                  $bGDI_Bmp            - [optional] a boolean value. Default is False. If false a GDIPlus bitmap handle will be returned,
;										  otherwise a GDI bitmap handle.
; Return values .: A bitmap handle (GDI/GDI+) depending on $bGDI_Bmp value.
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_RadialBlur($hImage, $fPosX, $fPosY, $fRadius, $iIntensity, $bGDI_Bmp = False)
	If Not IsPtr($hImage) Then Return SetError(1, 0, 0)
	Local Const $aReturn = DllCall($__hDLL__FX__, "ptr", "_GDIPlus_BitmapApplyFilter_RadialBlur", "ptr", $hImage, "float", $fPosX, "float", $fPosY, "float", $fRadius, "uByte", $iIntensity, "bool", $bGDI_Bmp)
	If Not $aReturn[0] Then Return SetError(2, 0, 0)
	Return $aReturn[0]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Open
; Description ...: Initialises the DLL and starts GDIPlus
; Syntax ........: _GDIPlus_BitmapApplyFilter_Open([$sPath = @ScriptDir & "\_GDIPlus_BitmapApplyFilter.dll"])
; Parameters ....: $sPath               - [optional] a string value. Default is @ScriptDir & "\_GDIPlus_BitmapApplyFilter.dll".
; Return values .: A dll "handle".
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Open($sPath = @ScriptDir & "\_GDIPlus_BitmapApplyFilter.dll")
	_GDIPlus_Startup()
	If @error Then Return SetError(1, 0, 0)
	If Not FileExists($sPath) Then Return SetError(2, 0, 0)
	$__hDLL__FX__ = DllOpen($sPath)
	If $__hDLL__FX__ = -1 Then Return SetError(3, 0, 0)
	Return $__hDLL__FX__
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Open

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Close
; Description ...: Shut down GDIPlus and close the DLL handle.
; Syntax ........: _GDIPlus_BitmapApplyFilter_Close()
; Parameters ....:
; Return values .: None
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Close()
	DllClose($__hDLL__FX__)
	_GDIPlus_Shutdown()
	Return 1
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Close

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_BitmapApplyFilter_Ver
; Description ...: Displays the version information about the _GDIPlus_BitmapApplyFilter.dll in a MessageBox.
; Syntax ........: _GDIPlus_BitmapApplyFilter_Ver()
; Parameters ....: None
; Return values .: None
; Author ........: UEZ
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDIPlus_BitmapApplyFilter_Ver()
	DllCall($__hDLL__FX__, "none", "Ver")
	Return 1
EndFunc   ;==>_GDIPlus_BitmapApplyFilter_Ver