#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>

; *************************
; Create application object
; *************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationClose Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; **********************************************************************
; Create a new presentation, write some data and close it without saving
; **********************************************************************
; Create the new presentation
Global $oPresentation = _PPT_PresentationNew($oPPT)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationClose Example 1", "Error creating new presentation." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
; Add a slide
Global $oSlide = _PPT_SlideAdd($oPresentation, 1, 1, $ppLayoutTextAndTwoObjects)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationClose Example 1", "Error adding a slide to the new presentation." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
; Write something to the slide
$oSlide.Shapes.Title.Textframe.TextRange.Text = "Test-Title"
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationClose Example 1", "Error writing to slide 1." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; Close the presentation without saving
MsgBox(64, "PowerPoint UDF: _PPT_PresentationClose Example 1", "Click OK to close the presentation without saving.")
_PPT_PresentationClose($oPresentation, False)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PrsentationClose Example 1", "Error closing presentation." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_PresentationClose Example 1", "Presentation has been successfully closed without saving.")
