#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>

; *************************
; Create application object
; *************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationSave Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; Open an existing presentation
Global $sPresentation = @ScriptDir & "\Presentation1.pptx"
Global $oPresentation = _PPT_PresentationOpen($oPPT, $sPresentation, True)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationSave Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; *********************
; Save the presentation
;**********************
_PPT_PresentationSave($oPresentation)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationSave Example", "Error saving presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
If @extended Then
	MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_PresentationSave Example", "Presentation '" & $sPresentation & "' has been saved because it has been changed since the last save or file open.")
Else
	MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_PresentationSave Example", "Presentation '" & $sPresentation & "' has not been saved because it has not been changed since the last save or file open.")
EndIf