#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>

; *************************************************
; Create application object and open a presentation
; *************************************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeDelete Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
; Open presentation
Global $sPresentation = @ScriptDir & "\Presentation1.pptx"
Global $oPresentation = _PPT_PresentationOpen($oPPT, $sPresentation)
If @error Then
	MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeDelete Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
	_PPT_Close($oPPT)
	Exit
EndIf

Global $aShapes[] = [3,4,5]
_PPT_ShapeDelete($oPresentation, 1, $aShapes)
ConsoleWrite(@error & @CRLF)
exit

; **********************************
; Delete Shape 1 from Slides 1 and 2
; **********************************
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeDelete Example 1", "Presentation before Delete!", 5)
_PPT_ShapeDelete($oPresentation, "1-2", 1)

If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeDelete Example 1", "Error deleting Shapes." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeDelete Example 1", @extended & " Shapes deleted in the specified range!")

; More Examples
; _PPT_ShapeDelete($oPresentation, "1-2", "Titel 1")     ; Delete Shape named "Titel 1" from Slides 1 and 2
; _PPT_ShapeDelete($oPresentation, "Slide2", "Titel 1")  ; Delete Shape named "Titel 1" from Slide named "Slide2"