#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>

; *****************************************************************************
; Create application object
; *****************************************************************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationOpen Example", "Error creating the Excel application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; *****************************************************************************
; Create a new presentation and add 3 slides (including title slide)
; *****************************************************************************
Global $oPresentation = _PPT_PresentationNew($oPPT)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_TableSet Example 1", "Error creating new presentation." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

_PPT_SlideAdd($oPresentation, 1, 3)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_TableSet Example 1", "Error adding slides to the presentation." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; *****************************************************************************
; Example 1
; Add a Table Shape to Slide 2, search for the first Table Shape and write
; the array to this Shape
; *****************************************************************************
Global $aData[][] = [["DataTable1", "Col1", "Col2", "Col3", "Col4", "Col5"], ["Row1", 11, 21, 31, 41, 51], ["Row2", 12, 22, 32, 42, 52], ["Row3", 13, 23, 33, 43, 53], ["Row4", 14, 24, 34, 44, 54]]
Global $aTableShape = _PPT_ShapeAdd($oPresentation, 2, $MsoTable, Default, Default, Default, Default, 3, 4)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_TableSet Example 1", "Error adding Table Shape!" & @CRLF & "@error = " & @error & ", @extended = " & @extended)

_PPT_TableSet($oPresentation, 2, 0, $aData)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_TableSet Example 1", "Error adding data to the Table Shape!" & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; *****************************************************************************
; Example 2
; Add another Table Shape to Slide 2, write the array to this Shape starting
; in row 2, column 2 of the Table Shape with the second row and column of the array
; *****************************************************************************
$aTableShape = _PPT_ShapeAdd($oPresentation, 2, $MsoTable, _PPT_ConvertUnits(2.33, 1), _PPT_ConvertUnits(10, 1), Default, Default, 5, 5)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_TableSet Example 2", "Error adding Table Shape!" & @CRLF & "@error = " & @error & ", @extended = " & @extended)

_PPT_TableSet($oPresentation, 2, 3, $aData, 2, 2, 1, 1)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_TableSet Example 2", "Error adding data to the Table Shape!" & @CRLF & "@error = " & @error & ", @extended = " & @extended)