#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>

; *************************************************
; Create application object and open a presentation
; *************************************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_SlideCopyMove Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
; Open presentation 1
Global $sPresentation = @ScriptDir & "\Presentation1.pptx"
Global $oPresentation1 = _PPT_PresentationOpen($oPPT, $sPresentation)
If @error Then
	MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_SlideCopyMove Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
	_PPT_Close($oPPT)
	Exit
EndIf

; **************************************************
; Example 1:
; Copy slides 1 and 2 to the end of the presentation
; **************************************************
_PPT_SlideCopyMove($oPresentation1, "1-2", Default, 4, 1)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_SlideCopyMove Example 1", "Error copying slides." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_SlideCopyMove Example 1", "Slides 1 and 2 copied to the end of the presentation.")

; **************************************************
; Example 2:
; Duplicate slides 3 and 4
; **************************************************
_PPT_SlideCopyMove($oPresentation1, "3-4", Default, Default, 3)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_SlideCopyMove Example 2", "Error copying slides." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_SlideCopyMove Example 2", "Slides 3 and 4 successfully duplicated.")

; **************************************************
; Example 3:
; Move slide 2 from presentation1 to Presentation 2.
; Insert the moved slide before slide 2
; **************************************************
; Open presentation 2
$sPresentation = @ScriptDir & "\Presentation2.pptx"
Global $oPresentation2 = _PPT_PresentationOpen($oPPT, $sPresentation)
If @error Then
	MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_SlideCopyMove Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
	_PPT_Close($oPPT)
	Exit
EndIf
; Move slide
_PPT_SlideCopyMove($oPresentation1, 2, $oPresentation2, 2, 2)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_SlideCopyMove Example 3", "Error moving slide." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_SlideCopyMove Example 3", "Slide 2 from Presentation1 moved to Presentation2 before slide 2.")
