#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <Excel.au3>
#include <MsgBoxConstants.au3>
#include <Array.au3>

; https://www.dummies.com/software/microsoft-office/excel/sending-excel-data-to-a-powerpoint-presentation/

; *************************
; Create application object
; *************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ExcelImport Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; ******************************************
; Create a new presentation and add 3 Slides
; ******************************************
; Create a new Presentation
Global $oPresentation = _PPT_PresentationNew($oPPT)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ExcelImport Example", "Error creating a new Presentation." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
; Add two Slides to the Presentation
Global $oSlide1 = _PPT_SlideAdd($oPresentation, Default, 3, $ppLayoutTitleOnly)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ExcelImport Example", "Error adding a Slide." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
Global $oSlide2 = $oPresentation.Slides(2)
Global $oSlide3 = $oPresentation.Slides(3)

; *********************************
; Start Excel and open the Workbook
; *********************************
; Open Excel
Global $oExcel = _Excel_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ExcelImport Example", "Error creating the Excel application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; Open the Workbook
Global $oWorkbook = _Excel_BookOpen($oExcel, @ScriptDir & "\ExcelImport.xlsx")
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ExcelImport Example", "Error opening Excel Workbook." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; ****************************************
; Example 1
; Copy Excel Sheet to Slide 1 as a Picture
; ****************************************
Global $oShape = _PPT_ExcelImport($oPresentation, $oSlide1, Default, $oWorkbook.Sheets(1).Range("Table1"), 1)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ExcelImport Example 1", "Can't copy Workbook as a picture." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; Enlarge the picture, center and move 50 points down
; msoAlignCenters and msoAlignMiddles
$oShape.Width = $oShape.Width * 1.7
$oShape.Height = $oShape.Height * 1.7
$oSlide1.Shapes.Range(2).Align(1, -1)
$oSlide1.Shapes.Range(2).Align(4, -1)
$oShape.Top = $oShape.Top + 50

; Add the title to the slide
$oSlide1.Shapes.Title.TextFrame.TextRange.Text = "Named Range copied from Excel, inserted as Picture and enlarged"

; **************************************
; Example 2
; Copy Excel Sheet to Slide 2 as a Table
; **************************************
$oShape = _PPT_ShapeAdd($oPresentation, 2, $MsoTable, Default, Default, Default, Default, 2, 2)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ExcelImport Example 2", "Error creating Table Shape on Slide 2." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
$oShape = _PPT_ExcelImport($oPresentation, $oPresentation.Slides(2), $oShape[0], $oWorkbook.Sheets(1).Range("Table1"), 2)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ExcelImport Example 2", "Can't copy Workbook as a Table." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; Enlarge the picture, center and move 150 points down
; msoAlignCenters and msoAlignMiddles
$oSlide2.Shapes.Range(2).Align(1, -1)
$oSlide2.Shapes.Range(2).Align(4, -1)
$oShape.Top = $oShape.Top + 150

; Add the title to the slide
$oSlide2.Shapes.Title.TextFrame.TextRange.Text = "Named Range copied from Excel, inserted as Table and enlarged"

; ***************************
; Example 3
; Copy Excel Chart to Slide 3
; ***************************
$oShape = _PPT_ExcelImport($oPresentation, $oPresentation.Slides(3), Default, $oWorkbook.Sheets(2).Chartobjects(1), 3)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ExcelImport Example 3", "Can't copy Chart." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; Add the title to the slide
$oSlide3.Shapes.Title.TextFrame.TextRange.Text = "Chart copied from Excel"

; ***********
; Close Excel
; ***********
_Excel_Close($oExcel, False)
