#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>

; *************************
; Create application object
; *************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_HeaderFooterSet Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; ***********************
; Open a presentation
; ***********************
Global $sPresentation = @ScriptDir & "\PresentationHeaderFooter.pptx"
Global $oPresentation = _PPT_PresentationOpen($oPPT, $sPresentation)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_HeaderFooterSet Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; ****************************************
; Example 1
; Set the Footer , DateAndTime and
; SlideNumber for Slides 2 and 3
; ****************************************
Global $oSlideRange = _PPT_SlideRangeSet($oPresentation, "2-3")
_PPT_HeaderFooterSet($oPresentation, 16+64, "TestFooter Slides 2-3", Default, $ppDateTimeddddMMMMddyyyy, True, "2-3")
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_HeaderFooterSet Example 1", "Error setting Footer." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
$oPresentation.Slides(2).Select
MsgBox($MB_IconInformation,"PowerPoint UDF: _PPT_HeaderFooterSet Example 1", "Footer for Slides 2 and 3 successfully set.")

; ****************************************
; Example 2
; Set the Footer in the SlideMaster
; ****************************************
_PPT_HeaderFooterSet($oPresentation, 1, "SlideMaster TestFooter", Default, Default, True)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_HeaderFooterSet Example 2", "Error setting Footer." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_IconInformation,"PowerPoint UDF: _PPT_HeaderFooterSet Example 2", "Footer for SlideMaster successfully set.")

; ****************************************
; Example 3
; Set Header/Footer in the NotesMaster
; ****************************************
_PPT_HeaderFooterSet($oPresentation, 2, "NotesMaster TestFooter", "NotesMaster TestHeader", Default, True)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_HeaderFooterSet Example 3", "Error setting Header/Footer." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_IconInformation,"PowerPoint UDF: _PPT_HeaderFooterSet Example 3", "Header/Footer for NotesMaster successfully set.")

; ****************************************
; Example 4
; Set Header/Footer in the HandoutMaster
; ****************************************
_PPT_HeaderFooterSet($oPresentation, 4, "HandoutMaster TestFooter", "HandoutMaster TestHeader", Default, True)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_HeaderFooterSet Example 4", "Error setting Header/Footer." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_IconInformation,"PowerPoint UDF: _PPT_HeaderFooterSet Example 4", "Header/Footer for HandoutMaster successfully set.")

; ****************************************
; Example 5
; Clearing all individual Header/Footer information from Slide 2
; ****************************************
_PPT_HeaderFooterSet($oPresentation, 32, Default, Default, 2)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_HeaderFooterSet Example 5", "Error clearing Header/Footer information from Slides." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_IconInformation,"PowerPoint UDF: _PPT_HeaderFooterSet Example 5", "Header/Footer information successfully cleared from the specified Slides.")