#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>
#include <File.au3>

; *************************
; Create application object
; *************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationSaveAs Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; Open an existing presentation
Global $sPresentation = @ScriptDir & "\Presentation1.pptx"
Global $oPresentation = _PPT_PresentationOpen($oPPT, $sPresentation, True)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationSaveAs Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; ********************************************************************************
; Save the presentation to the tempdir as slideshow and overwirte an existing file
;*********************************************************************************
Global $sDrive = "", $sDir = "", $sFilename = "", $sExtension = ""
Global $aPathSplit = _PathSplit($oPresentation.Name, $sDrive, $sDir, $sFilename, $sExtension)
_PPT_PresentationSaveAs($oPresentation, @TempDir & "\" & $sFilename, $ppSaveAsShow, True)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_PresentationSaveAs Example", "Error saving presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_PresentationSaveAs Example", "Presentation '" & $sPresentation & "' has been saved as '" & @TempDir & "\" & $oPresentation.Name & "'.")
