#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>

Global $aShape
; *************************************************
; Create application object and open a presentation
; *************************************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeAdd Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
; Open presentation
Global $sPresentation = @ScriptDir & "\Presentation1.pptx"
Global $oPresentation = _PPT_PresentationOpen($oPPT, $sPresentation)
If @error Then
	MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeAdd Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
	_PPT_Close($oPPT)
	Exit
EndIf

; ***********************************************************************************************
; Example 1
; Add a line to Slides 1 and 2
; See: https://docs.microsoft.com/en-us/office/vba/api/powerpoint.shapes.addline
; ***********************************************************************************************
_PPT_ShapeAdd($oPresentation, "1-2", $MsoLine, 10, 10, 250, 250)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeAdd Example 1", "Error adding Shape!" & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeAdd Example 1", "Line Shape added to Slides 1 and 2.")

; ***********************************************************************************************
; Example 2
; Add a picture to Slide 3
; See: https://docs.microsoft.com/en-us/office/vba/api/powerpoint.shapes.addpicture2
; ***********************************************************************************************
_PPT_ShapeAdd($oPresentation, 3, $MsoPicture, 10, 280, 250, 250, @ScriptDir & "\Microsoft_PowerPoint_2013_logo.png", False, True, 1)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeAdd Example 2", "Error adding Shape!" & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeAdd Example 2", "Picture Shape added to Slide 3.")

; ***********************************************************************************************
; Example 3
; Add a TextBox to Slide 3
; See: https://docs.microsoft.com/en-us/office/vba/api/powerpoint.shapes.addtextbox
; ***********************************************************************************************
$aShape = _PPT_ShapeAdd($oPresentation, 3, $MsoTextBox, 300, 280, 250, 250, 1)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeAdd Example 3", "Error adding Shape!" & @CRLF & "@error = " & @error & ", @extended = " & @extended)
Global $oShapeTextFrame = $aShape[0].TextFrame
Global $oTextRange = $oShapeTextFrame.TextRange
$oTextRange.Text = "TextBox Shape"
$aShape[0].ShapeStyle = 10016
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeAdd Example 3", "TextBox Shape added to Slide 3.")

; ***********************************************************************************************
; Example 4
; Add a Table to Slide 2
; See: https://docs.microsoft.com/en-us/office/vba/api/powerpoint.shapes.addtable
; ***********************************************************************************************
_PPT_ShapeAdd($oPresentation, 2, $MsoTable, 100, 300, 250, 70, 3, 4)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeAdd Example 4", "Error adding Shape!" & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeAdd Example 4", "Table Shape added to Slide 2.")

; ***********************************************************************************************
; Example 5
; Add a Chart to Slide 2
; See: https://docs.microsoft.com/en-us/office/vba/api/powerpoint.shapes.addchart2
; ***********************************************************************************************
_PPT_ShapeAdd($oPresentation, 2, $MsoChart, 300, 20, 250, 150, -1, -4102, 0)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeAdd Example 5", "Error adding Shape!" & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeAdd Example 5", "Chart Shape added to Slide 2.")