#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>
#include <Array.au3>

; *************************
; Create application object
; *************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeCopyMove Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; ***********************
; Open a presentation
; ***********************
Global $sPresentation = @ScriptDir & "\Presentation1.pptx"
Global $oPresentation = _PPT_PresentationOpen($oPPT, $sPresentation, True)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeCopyMove Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)

; ****************************************
; Example 1
; Copy Shapes named "Ellipse 3" and
; "Rechteck 4" to Slide 2 and 3
; ****************************************
Global $aShapes2Copy[] = ["Ellipse 3", "Rechteck 4"]
_PPT_ShapeCopyMove($oPresentation, 1, $aShapes2Copy,  Default, "2-3", 1)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeCopyMove Example 1", "Error copying the Shapes." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeCopyMove Example 1", "Shapes successfully copied to Slides 2 and 3.")

; ****************************************
; Example 2
; Duplicate Shapes named "Ellipse 3" and
; "Rechteck 4"
; ****************************************
_PPT_ShapeCopyMove($oPresentation, 1, $aShapes2Copy,  Default, Default, 3)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeCopyMove Example 2", "Error duplicating the Shapes." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeCopyMove Example 2", "Shapes successfully duplicated.")

; ****************************************
; Example 3
; Copy Shapes named "Ellipse 3" and
; "Rechteck 4" to Slide 2 and 3 in
; Presentation 2
; ****************************************
$sPresentation = @ScriptDir & "\Presentation2.pptx"
Global $oPresentation2 = _PPT_PresentationOpen($oPPT, $sPresentation, True)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeCopyMove Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
_PPT_ShapeCopyMove($oPresentation, 1, $aShapes2Copy,  $oPresentation2, "2-3", 1)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeCopyMove Example 3", "Error copying the Shapes." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeCopyMove Example 3", "Shapes successfully copied to Slides 2 and 3 in Presentation 2.")
$oPresentation.Windows(1).Activate

; ****************************************
; Example 4
; Move Shape 4 (the arrow) to Slide 2
; ****************************************
_PPT_ShapeCopyMove($oPresentation, 1, 5, Default, 2, 2)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeCopyMove Example 4", "Error moving the Shapes." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeCopyMove Example 4", "Shape successfully moved to Slide 2.")

; ****************************************
; Example 5
; Copy Shape 4 (the arrow) to the Clipboard
; ****************************************
_PPT_ShapeCopyMove($oPresentation, 1, 5, Default, Default, 4)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeCopyMove Example 5", "Error copying the Shape to the Clipboard." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeCopyMove Example 5", "Shape successfully copied to the Clipboard.")

; ****************************************
; Example 6
; Move Shape 4 (the arrow) to the Clipboard
; ****************************************
_PPT_ShapeCopyMove($oPresentation, 1, 5, Default, Default, 5)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeCopyMove Example 6", "Error moving the Shape to the Clipboard." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeCopyMove Example 6", "Shape successfully moved to the Clipboard.")