#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <Array.au3>
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>

; **********************************************************
; Create application object and open an example presentation
; **********************************************************
Global $sPresentation = @ScriptDir & "\Presentation1.pptx"
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeRangeSet Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
Global $oPresentation = _PPT_PresentationOpen($oPPT, $sPresentation)
If @error Then
	MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeRangeSet Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
	_PPT_Close($oPPT)
	Exit
EndIf

; *****************************************************************************
; Create a Shape Range
; *****************************************************************************
Global $oShapeRange
Global $aSlides[] = [1, 2]
Global $aShapes[] = [1, 2, 3]

MsgBox($MB_ICONQUESTION, "", "Select one or multiple shape(s)")
$oShapeRange = _PPT_ShapeRangeSet($oPresentation, $oPresentation.Slides(1), -1)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_ShapeRangeSet Example 1", "Error creating a shape range for '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
$oShapeRange.ShapeStyle = 10001
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_ShapeRangeSet Example 1", "ShapeRange created")

; More examples
; $oShapeRange = _PPT_ShapeRangeSet($oPresentation, $oPresentation.Slides(1), 0)											; Slide 1 all shapes
; $oShapeRange = _PPT_ShapeRangeSet($oPresentation, $oPresentation.Slides(1), $oPresentation.Slides(1).Shapes.Range(3))		; Slide 1 shape 3 (ShapeRange)
; $oShapeRange = _PPT_ShapeRangeSet($oPresentation, $oPresentation.Slides(1), $oPresentation.Slides(1).Shapes(3))			; Slide 1 shape 3 (Shape)
; $oShapeRange = _PPT_ShapeRangeSet($oPresentation, $oPresentation.Slides(1), $aShapes)										; Slide 1 shapes defined in an array
; $oShapeRange = _PPT_ShapeRangeSet($oPresentation, $oPresentation.Slides(1), "2-*")										; Slide 1 shape 2 to the last
; $oShapeRange = _PPT_ShapeRangeSet($oPresentation, $oPresentation.Slides(1), "2-3")										; Slide 1 shapes 2 and 3
