#include-once

Global Const $__g_ADVMATHUDF_QNG_x1[5] = [ _
  0.973906528517171720077964012084452, _
  0.865063366688984510732096688423493, _
  0.679409568299024406234327365114874, _
  0.433395394129247190799265943165784, _
  0.148874338981631210884826001129720]

Global Const $__g_ADVMATHUDF_QNG_w10[5] = [ _
  0.066671344308688137593568809893332, _
  0.149451349150580593145776339657697, _
  0.219086362515982043995534934228163, _
  0.269266719309996355091226921569469, _
  0.295524224714752870173892994651338]

Global Const $__g_ADVMATHUDF_QNG_x2[5] = [ _
  0.995657163025808080735527280689003, _
  0.930157491355708226001207180059508, _
  0.780817726586416897063717578345042, _
  0.562757134668604683339000099272694, _
  0.294392862701460198131126603103866]

Global Const $__g_ADVMATHUDF_QNG_w21a[5] = [ _
  0.032558162307964727478818972459390, _
  0.075039674810919952767043140916190, _
  0.109387158802297641899210590325805, _
  0.134709217311473325928054001771707, _
  0.147739104901338491374841515972068]

Global Const $__g_ADVMATHUDF_QNG_w21b[6] = [ _
  0.011694638867371874278064396062192, _
  0.054755896574351996031381300244580, _
  0.093125454583697605535065465083366, _
  0.123491976262065851077958109831074, _
  0.142775938577060080797094273138717, _
  0.149445554002916905664936468389821]

Global Const $__g_ADVMATHUDF_QNG_x3[11] = [ _
  0.999333360901932081394099323919911, _
  0.987433402908088869795961478381209, _
  0.954807934814266299257919200290473, _
  0.900148695748328293625099494069092, _
  0.825198314983114150847066732588520, _
  0.732148388989304982612354848755461, _
  0.622847970537725238641159120344323, _
  0.499479574071056499952214885499755, _
  0.364901661346580768043989548502644, _
  0.222254919776601296498260928066212, _
  0.074650617461383322043914435796506]

Global Const $__g_ADVMATHUDF_QNG_w43a[10] = [ _
  0.016296734289666564924281974617663, _
  0.037522876120869501461613795898115, _
  0.054694902058255442147212685465005, _
  0.067355414609478086075553166302174, _
  0.073870199632393953432140695251367, _
  0.005768556059769796184184327908655, _
  0.027371890593248842081276069289151, _
  0.046560826910428830743339154433824, _
  0.061744995201442564496240336030883, _
  0.071387267268693397768559114425516]

Global Const $__g_ADVMATHUDF_QNG_w43b[12] = [ _
  0.001844477640212414100389106552965, _
  0.010798689585891651740465406741293, _
  0.021895363867795428102523123075149, _
  0.032597463975345689443882222526137, _
  0.042163137935191811847627924327955, _
  0.050741939600184577780189020092084, _
  0.058379395542619248375475369330206, _
  0.064746404951445885544689259517511, _
  0.069566197912356484528633315038405, _
  0.072824441471833208150939535192842, _
  0.074507751014175118273571813842889, _
  0.074722147517403005594425168280423]

Global Const $__g_ADVMATHUDF_QNG_x4[22] = [ _
  0.999902977262729234490529830591582, _
  0.997989895986678745427496322365960, _
  0.992175497860687222808523352251425, _
  0.981358163572712773571916941623894, _
  0.965057623858384619128284110607926, _
  0.943167613133670596816416634507426, _
  0.915806414685507209591826430720050, _
  0.883221657771316501372117548744163, _
  0.845710748462415666605902011504855, _
  0.803557658035230982788739474980964, _
  0.757005730685495558328942793432020, _
  0.706273209787321819824094274740840, _
  0.651589466501177922534422205016736, _
  0.593223374057961088875273770349144, _
  0.531493605970831932285268948562671, _
  0.466763623042022844871966781659270, _
  0.399424847859218804732101665817923, _
  0.329874877106188288265053371824597, _
  0.258503559202161551802280975429025, _
  0.185695396568346652015917141167606, _
  0.111842213179907468172398359241362, _
  0.037352123394619870814998165437704]

Global Const $__g_ADVMATHUDF_QNG_w87a[21] = [ _
  0.008148377384149172900002878448190, _
  0.018761438201562822243935059003794, _
  0.027347451050052286161582829741283, _
  0.033677707311637930046581056957588, _
  0.036935099820427907614589586742499, _
  0.002884872430211530501334156248695, _
  0.013685946022712701888950035273128, _
  0.023280413502888311123409291030404, _
  0.030872497611713358675466394126442, _
  0.035693633639418770719351355457044, _
  0.000915283345202241360843392549948, _
  0.005399280219300471367738743391053, _
  0.010947679601118931134327826856808, _
  0.016298731696787335262665703223280, _
  0.021081568889203835112433060188190, _
  0.025370969769253827243467999831710, _
  0.029189697756475752501446154084920, _
  0.032373202467202789685788194889595, _
  0.034783098950365142750781997949596, _
  0.036412220731351787562801163687577, _
  0.037253875503047708539592001191226]

Global Const $__g_ADVMATHUDF_QNG_w87b[23] = [ _
  0.000274145563762072350016527092881, _
  0.001807124155057942948341311753254, _
  0.004096869282759164864458070683480, _
  0.006758290051847378699816577897424, _
  0.009549957672201646536053581325377, _
  0.012329447652244853694626639963780, _
  0.015010447346388952376697286041943, _
  0.017548967986243191099665352925900, _
  0.019938037786440888202278192730714, _
  0.022194935961012286796332102959499, _
  0.024339147126000805470360647041454, _
  0.026374505414839207241503786552615, _
  0.028286910788771200659968002987960, _
  0.030052581128092695322521110347341, _
  0.031646751371439929404586051078883, _
  0.033050413419978503290785944862689, _
  0.034255099704226061787082821046821, _
  0.035262412660156681033782717998428, _
  0.036076989622888701185500318003895, _
  0.036698604498456094498018047441094, _
  0.037120549269832576114119958413599, _
  0.037334228751935040321235449094698, _
  0.037361073762679023410321241766599]

Func IntegralQuadpackQNG($fnFunction, $vStart, $vEnd, $vEpsAbs, $vEpsRel, $aAdditionalParams = 0)
	If IsFunc($fnFunction) Then $fnFunction = FuncName($fnFunction)

	Local $fv1[5], $fv2[5], $fv3[5], $fv4[5]
	Local $savfun[21]
	Local $res10, $res21, $res43, $res87
	Local $result_kronrod, $err
	Local $resabs, $resasc

	Local $half_length = 0.5*($vEnd-$vStart)
	Local $abs_half_length = Abs($half_length)
	Local $center = 0.5*($vEnd+$vStart)
	Local $f_center = __IntegralCall($fnFunction, $center, $aAdditionalParams)

	Local $k

	If $vEpsAbs <= 0 And $vEpsRel < 0.5e-28 Then
		Return SetError(2, 0, 0)
	EndIf

	; Compute the integral using the 10- and 21-point formula.
	$res21 = $__g_ADVMATHUDF_QNG_w21b[5]*$f_center
	$resabs = $__g_ADVMATHUDF_QNG_w21b[5]*Abs($f_center)

	For $k = 0 To 4
		Local $abcissa = $half_length * $__g_ADVMATHUDF_QNG_x1[$k]
		Local $fval1 = __IntegralCall($fnFunction, $center+$abcissa, $aAdditionalParams)
		Local $fval2 = __IntegralCall($fnFunction, $center-$abcissa, $aAdditionalParams)
		Local $fval = $fval1 + $fval2
		$res10 += $__g_ADVMATHUDF_QNG_w10[$k]*$fval
		$res21 += $__g_ADVMATHUDF_QNG_w21a[$k]*$fval
		$resabs = $__g_ADVMATHUDF_QNG_w21a[$k]*(Abs($fval1)+Abs($fval2))
		$savfun[$k] = $fval
		$fv1[$k] = $fval1
		$fv2[$k] = $fval2
	Next

	For $k = 0 To 4
		Local $abcissa = $half_length * $__g_ADVMATHUDF_QNG_x2[$k]
		Local $fval1 = __IntegralCall($fnFunction, $center+$abcissa, $aAdditionalParams)
		Local $fval2 = __IntegralCall($fnFunction, $center-$abcissa, $aAdditionalParams)
		Local $fval = $fval1 + $fval2
		$res21 += $__g_ADVMATHUDF_QNG_w21b[$k]*$fval
		$resabs = $__g_ADVMATHUDF_QNG_w21b[$k]*(Abs($fval1)+Abs($fval2))
		$savfun[$k+5] = $fval
		$fv3[$k] = $fval1
		$fv4[$k] = $fval2
	Next

	$resabs *= $abs_half_length

	Local $mean = 0.5*$res21
	$resasc = $__g_ADVMATHUDF_QNG_w21b[5]*Abs($f_center-$mean)

	For $k = 0 To 4
		$resasc += ($__g_ADVMATHUDF_QNG_w21a[$k] * (Abs($fv1[$k]-$mean) + Abs($fv2[$k]-$mean)) _
					+ $__g_ADVMATHUDF_QNG_w21b[$k] * (Abs($fv3[$k]-$mean)+Abs($fv4[$k]-$mean)))
	Next
	$resasc *= $abs_half_length

	$result_kronrod = $res21*$half_length

	$err = __QuadpackRescaleError(($res21 - $res10)*$half_length, $resabs, $resasc)

	; Test for convergence
	If $err < $vEpsAbs Or $err < $vEpsRel*Abs($result_kronrod) Then
		Return SetExtended(21, $result_kronrod)
	EndIf

	; Compute the integral using 43-point formula.
	$res43 = $__g_ADVMATHUDF_QNG_w43b[11]*$f_center

	For $k = 0 To 9
		$res43 += $savfun[$k]*$__g_ADVMATHUDF_QNG_w43a[$k]
	Next

	For $k = 0 To 10
		Local $abcissa = $half_length*$__g_ADVMATHUDF_QNG_x3[$k]
		Local $fval = __IntegralCall($fnFunction, $center+$abcissa, $aAdditionalParams)+__IntegralCall($fnFunction, $center-$abcissa, $aAdditionalParams)
		$res43 += $fval*$__g_ADVMATHUDF_QNG_w43b[$k]
		$savfun[$k+10] = $fval
	Next

	; Test for convergence

	$result_kronrod = $res43*$half_length
	$err = __QuadpackRescaleError(($res43 - $res21)*$half_length, $resabs, $resasc)

	If $err < $vEpsAbs Or $err < $vEpsRel*Abs($result_kronrod) Then
		Return SetExtended(43, $result_kronrod)
	EndIf

	; Compute the integral using 87-point formula.
	$res87 = $__g_ADVMATHUDF_QNG_w87b[22]*$f_center

	For $k = 0 To 20
		$res87 = $savfun[$k]*$__g_ADVMATHUDF_QNG_w87a[$k]
	Next

	For $k = 0 To 21
		Local $abcissa = $half_length*$__g_ADVMATHUDF_QNG_x4[$k]
		$res87 += $__g_ADVMATHUDF_QNG_w87b[$k] * (__IntegralCall($fnFunction, $center+$abcissa, $aAdditionalParams)+__IntegralCall($fnFunction, $center-$abcissa, $aAdditionalParams))
	Next

	; Test for convergence

	$result_kronrod = $res87*$half_length
	$err = __QuadpackRescaleError(($res87 - $res43)*$half_length, $resabs, $resasc)

	If $err < $vEpsAbs Or $err < $vEpsRel*Abs($result_kronrod) Then
		Return SetExtended(87, $result_kronrod)
	EndIf

	Return SetError(1, 0, $result_kronrod)
EndFunc
