#include-once

#Region Properties

Func _Blender_ActionGetFCurve($Action, $iItem)
	If Not IsObj($Action) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return __bpy_CreateObject($Action.pyexpr&".fcurves["&$iItem&"]")
EndFunc

Func _Blender_ActionGetFCurveCount($Action, $bCallBpy = False)
	If Not IsObj($Action) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? __bpy_RequestData("len("&$Action.pyexpr&".fcurves") : $Action.fcurves.count
EndFunc

#EndRegion

#Region F-Curves

Func _Blender_FCurveGetExtrapolation($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("extrapolation") : $Object.Query("extrapolation")
EndFunc

Func _Blender_FCurveGetKeyframe($FCurve, $iItem)
	If Not IsObj($FCurve) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return __bpy_CreateObject($FCurve.pyexpr&".keyframe_points["&$iItem&"]")
EndFunc

Func _Blender_FCurveGetKeyframeCount($FCurve, $bCallBpy = False)
	If Not IsObj($FCurve) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? __bpy_RequestData("len("&$FCurve.pyexpr&".keyframe_points") : $FCurve.keyframe_points.count
EndFunc

#EndRegion

#Region Keyframes

Func _Blender_KeyframeGetInterpolation($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.interpolation : $Object.Query("interpolation")
EndFunc

Func _Blender_KeyframeGetType($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.type : $Object.Query("type")
EndFunc

Func _Blender_KeyframeGetEasing($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.easing : $Object.Query("easing")
EndFunc

Func _Blender_KeyframeGetTime($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.co.x : $Object.Query("co.x")
EndFunc

Func _Blender_KeyframeSetTime($Object, $fTime)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("co.x", $fTime)
EndFunc

Func _Blender_KeyframeGetValue($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.co.y : $Object.Query("co.y")
EndFunc

Func _Blender_KeyframeSetValue($Object, $fValue)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("co.y", $fValue)
EndFunc

Func _Blender_KeyframeGetLeftHandleTime($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.handle_left.x : $Object.Query("handle_left.x")
EndFunc

Func _Blender_KeyframeSetLeftHandleTime($Object, $fTime)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("handle_left.x", $fTime)
EndFunc

Func _Blender_KeyframeGetLeftHandleValue($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.handle_left.y : $Object.Query("handle_left.y")
EndFunc

Func _Blender_KeyframeSetLeftHandleValue($Object, $fValue)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("handle_left.y", $fValue)
EndFunc

Func _Blender_KeyframeGetRightHandleTime($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.handle_right.x : $Object.Query("handle_right.x")
EndFunc

Func _Blender_KeyframeSetRightHandleTime($Object, $fTime)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("handle_right.x", $fTime)
EndFunc

Func _Blender_KeyframeGetRightHandleValue($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.handle_right.y : $Object.Query("handle_right.y")
EndFunc

Func _Blender_KeyframeSetRightHandleValue($Object, $fValue)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("handle_right.y", $fValue)
EndFunc

#EndRegion