#include-once

#Region Getting data from mesh

Func _Blender_MeshGetVertex($Mesh, $iVert)
	If Not IsObj($Mesh) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return __bpy_CreateObject($Mesh.pyexpr & ".vertices["&$iVert&"]", $Mesh)
EndFunc

Func _Blender_MeshGetVertexCount($Mesh, $bCallBpy = False)
	If Not IsObj($Mesh) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? __bpy_RequestData("len(" & $Mesh.pyexpr & ".vertices)") : $Mesh.vertices.count
EndFunc

Func _Blender_MeshGetEdge($Mesh, $iEdge)
	If Not IsObj($Mesh) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return __bpy_CreateObject($Mesh.pyexpr & ".edges["&$iEdge&"]", $Mesh)
EndFunc

Func _Blender_MeshGetEdgeCount($Mesh, $bCallBpy = False)
	If Not IsObj($Mesh) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? __bpy_RequestData("len(" & $Mesh.pyexpr & ".edges)") : $Mesh.edges.count
EndFunc

Func _Blender_MeshGetFace($Mesh, $iFace)
	If Not IsObj($Mesh) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return __bpy_CreateObject($Mesh.pyexpr & ".polygons["&$iFace&"]", $Mesh)
EndFunc

Func _Blender_MeshGetFaceCount($Mesh, $bCallBpy = False)
	If Not IsObj($Mesh) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? __bpy_RequestData("len(" & $Mesh.pyexpr & ".polygons)") : $Mesh.polygons.count
EndFunc

Func _Blender_MeshGetMaterial($Mesh, $iMat)
	If Not IsObj($Mesh) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	$pyMat = $Mesh.materials.at($iMat)

	Return __bpy_ParseMaterial($pyMat)
EndFunc

Func _Blender_MeshGetMaterialCount($Mesh, $bCallBpy = False)
	If Not IsObj($Mesh) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? __bpy_RequestData("len(" & $Mesh.pyexpr & ".materials)") : $Mesh.materials.count
EndFunc

#EndRegion

#Region Getting data from vertices

Func _Blender_VertGetLocation($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("co") : $Object.Query("co")
EndFunc

Func _Blender_VertSetLocation($Object, $Vector)
	If Not IsObj($Object) Or Not IsObj($Vector) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("co", $Vector)
EndFunc

Func _Blender_VertGetNormal($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("normal") : $Object.Query("normal")
EndFunc

Func _Blender_VertSetNormal($Object, $Vector)
	If Not IsObj($Object) Or Not IsObj($Vector) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("normal", $Vector)
EndFunc

Func _Blender_VertGetUndeformedLocation($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("undeformed_co") : $Object.Query("undeformed_co")
EndFunc

Func _Blender_VertGetBevelWeight($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("bevel_weight") : $Object.Query("bevel_weight")
EndFunc

Func _Blender_VertSetBevelWeight($Object, $fWeight)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("normal", $fWeight)
EndFunc

Func _Blender_VertIsSelected($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("select") : $Object.Query("select")
EndFunc

Func _Blender_VertSelect($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("select", $bValue)
EndFunc

Func _Blender_VertIsHidden($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("hide") : $Object.Query("hide")
EndFunc

Func _Blender_VertHide($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("hide", $bValue)
EndFunc

#EndRegion

#Region Getting data from edges

Func _Blender_EdgeGetVertex($Object, $iVert)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	$id = __bpy_RequestData($Object.pyexpr & ".vertices["&$iVert&"]")

	Return _Blender_MeshGetVertex($Object.parentObj, $id)
EndFunc

Func _Blender_EdgeGetBevelWeight($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("bevel_weight") : $Object.Query("bevel_weight")
EndFunc

Func _Blender_EdgeSetBevelWeight($Object, $fWeight)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("normal", $fWeight)
EndFunc

Func _Blender_EdgeIsSelected($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("select") : $Object.Query("select")
EndFunc

Func _Blender_EdgeSelect($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("select", $bValue)
EndFunc

Func _Blender_EdgeIsHidden($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("hide") : $Object.Query("hide")
EndFunc

Func _Blender_EdgeHide($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("hide", $bValue)
EndFunc

Func _Blender_EdgeIsMarkedSeam($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("use_seam") : $Object.Query("use_seam")
EndFunc

Func _Blender_EdgeMarkSeam($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("use_seam", $bValue)
EndFunc

Func _Blender_EdgeIsMarkedSharp($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("use_edge_sharp") : $Object.Query("use_edge_sharp")
EndFunc

Func _Blender_EdgeMarkSharp($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("use_edge_sharp", $bValue)
EndFunc

Func _Blender_EdgeIsMarkedFreestyle($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("use_freestyle_mark") : $Object.Query("use_freestyle_mark")
EndFunc

Func _Blender_EdgeMarkFreestyle($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("use_freestyle_mark", $bValue)
EndFunc

#EndRegion

#Region Getting data from faces (polygons in Blender API)

Func _Blender_FaceGetVertex($Object, $iVert)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	$id = __bpy_RequestData($Object.pyexpr & ".vertices["&$iVert&"]")

	Return _Blender_MeshGetVertex($Object.parentObj, $id)
EndFunc

Func _Blender_FaceIsSelected($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("select") : $Object.Query("select")
EndFunc

Func _Blender_FaceSelect($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("select", $bValue)
EndFunc

Func _Blender_FaceIsHidden($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("hide") : $Object.Query("hide")
EndFunc

Func _Blender_FaceHide($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("hide", $bValue)
EndFunc

Func _Blender_FaceIsSmooth($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("use_smooth") : $Object.Query("use_smooth")
EndFunc

Func _Blender_FaceSmooth($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("use_smooth", $bValue)
EndFunc

Func _Blender_FaceGetNormal($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("normal") : $Object.Query("normal")
EndFunc

Func _Blender_FaceGetCenter($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("center") : $Object.Query("center")
EndFunc

Func _Blender_FaceGetMaterial($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return _Blender_MeshGetMaterial($Object.parentObj, $bCallBpy ? $Object.Get("material_index") : $Object.Query("material_index"))
EndFunc

#EndRegion
