#include-once

#Region Properties

Func _Blender_SceneGetCamera($Scene)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return __bpy_ParseObject($Scene.camera)
EndFunc

Func _Blender_SceneGetWorld($Scene)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return __bpy_ParseWorld($Scene.camera)
EndFunc

Func _Blender_SceneGetAnimInfo($Scene, $bCallBpy = False)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Local $aRet[5]

	$aRet[0] = $bCallBpy ? __bpy_RequestData($Scene.pyexpr&".frame_current") : $Scene.frame_current
	$aRet[1] = $bCallBpy ? __bpy_RequestData($Scene.pyexpr&".frame_subframe") : $Scene.frame_subframe
	$aRet[2] = $bCallBpy ? __bpy_RequestData($Scene.pyexpr&".frame_start") : $Scene.frame_start
	$aRet[3] = $bCallBpy ? __bpy_RequestData($Scene.pyexpr&".frame_end") : $Scene.frame_end
	$aRet[4] = $bCallBpy ? __bpy_RequestData($Scene.pyexpr&".frame_step") : $Scene.frame_step

	Return $aRet
EndFunc

Func _Blender_SceneSetAnimInfo($Scene, $aInfo)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	$Scene.Set("frame_current", $aInfo[0])
	$Scene.Set("frame_subframe", $aInfo[1])
	$Scene.Set("frame_start", $aInfo[2])
	$Scene.Set("frame_end", $aInfo[3])
	$Scene.Set("frame_step", $aInfo[4])
EndFunc

Func _Blender_SceneGetRenderInfo($Scene, $bCallBpy = False)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)
	Local $Render = __bpy_CreateObject($Scene.pyexpr & ".render")

	Local $aRet[10]

	$aRet[0] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".resolution_x") : $Render.resolution_x
	$aRet[1] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".resolution_y") : $Render.resolution_y
	$aRet[2] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".resolution_percentage") : $Render.resolution_percentage
	$aRet[3] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".tile_x") : $Render.tile_x
	$aRet[4] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".tile_y") : $Render.tile_y
	$aRet[5] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".preview_start_resolution") : $Render.preview_start_resolution
	$aRet[6] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".pixel_aspect_x") : $Render.pixel_aspect_x
	$aRet[7] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".pixel_aspect_y") : $Render.pixel_aspect_y
	$aRet[8] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".fps") : $Render.fps
	$aRet[9] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".fps_base") : $Render.fps_base

	Return $aRet
EndFunc

Func _Blender_SceneSetRenderInfo($Scene, $aInfo)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)
	Local $Render = __bpy_CreateObject($Scene.pyexpr & ".render")

	$Render.Set("resolution_x", $aInfo[0])
	$Render.Set("resolution_y", $aInfo[1])
	$Render.Set("resolution_percentage", $aInfo[2])
	$Render.Set("tile_x", $aInfo[3])
	$Render.Set("tile_y", $aInfo[4])
	$Render.Set("preview_start_resolution", $aInfo[5])
	$Render.Set("pixel_aspect_x", $aInfo[6])
	$Render.Set("pixel_aspect_y", $aInfo[7])
	$Render.Set("fps", $aInfo[8])
	$Render.Set("fps_base", $aInfo[9])
EndFunc

Func _Blender_SceneGetOutputInfo($Scene, $bCallBpy = False)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)
	Local $Render = __bpy_CreateObject($Scene.pyexpr & ".render")
	Local $Format = __bpy_CreateObject($Render.pyexpr & ".image_settings")

	Local $aRet[9]

	$aRet[0] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".filepath") : $Render.filepath
	$aRet[1] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".use_overwrite") : $Render.use_overwrite
	$aRet[2] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".use_file_extension") : $Render.use_file_extension
	$aRet[3] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".use_placeholder") : $Render.use_placeholder
	$aRet[4] = $bCallBpy ? __bpy_RequestData($Render.pyexpr&".use_render_cache") : $Render.use_render_cache
	$aRet[5] = $bCallBpy ? __bpy_RequestData($Format.pyexpr&".file_format") : $Format.file_format
	$aRet[6] = $bCallBpy ? __bpy_RequestData($Format.pyexpr&".color_mode") : $Format.color_mode
	$aRet[7] = $bCallBpy ? __bpy_RequestData($Format.pyexpr&".color_depth") : $Format.color_depth
	$aRet[8] = $bCallBpy ? __bpy_RequestData($Format.pyexpr&".compression") : $Format.compression

	Return $aRet
EndFunc

Func _Blender_SceneSetOutputInfo($Scene, $aInfo)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)
	Local $Render = __bpy_CreateObject($Scene.pyexpr & ".render")
	Local $Format = __bpy_CreateObject($Render.pyexpr & ".image_settings")

	$Render.SetString("filepath", $aInfo[0])
	$Render.Set("use_overwrite", $aInfo[1])
	$Render.Set("use_file_extension", $aInfo[2])
	$Render.Set("use_placeholder", $aInfo[3])
	$Render.Set("use_render_cache", $aInfo[4])
	$Format.SetString("file_format", $aInfo[5])
	$Format.SetString("color_mode", $aInfo[6])
	$Format.SetString("color_depth", $aInfo[7])
	$Format.Set("compression", $aInfo[8])
EndFunc

Func _Blender_SceneGetGravity($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("gravity") : $Object.Query("gravity")
EndFunc

Func _Blender_SceneSetGravity($Object, $Vector)
	If Not IsObj($Object) Or Not IsObj($Vector) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("gravity", $Vector)
EndFunc

Func _Blender_SceneIsGravityEnabled($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("gravity") : $Object.Query("gravity")
EndFunc

Func _Blender_SceneGravityEnable($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("gravity", $bValue)
EndFunc

Func _Blender_SceneGetViewSettings($Scene)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return __bpy_CreateObject($Scene.pyexpr&".view_settings")
EndFunc

#EndRegion

#Region Lists

Func _Blender_SceneGetObject($Scene, $iItem)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return __bpy_CreateObject($Scene.pyexpr&".objects["&$iItem&"]")
EndFunc

Func _Blender_SceneGetObjectCount($Scene, $bCallBpy = False)
	If Not IsObj($Scene) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? __bpy_RequestData("len("&$Scene.pyexpr&".objects") : $Scene.objects.count
EndFunc

#EndRegion

#Region ViewSettings

Func _Blender_ViewSettingsGetGamma($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("gamma") : $Object.Query("gamma")
EndFunc

Func _Blender_ViewSettingsSetGamma($Object, $Vector)
	If Not IsObj($Object) Or Not IsObj($Vector) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("gamma", $Vector)
EndFunc

Func _Blender_ViewSettingsGetExposure($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("exposure") : $Object.Query("exposure")
EndFunc

Func _Blender_ViewSettingsSetExposure($Object, $Vector)
	If Not IsObj($Object) Or Not IsObj($Vector) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("exposure", $Vector)
EndFunc

Func _Blender_ViewSettingsIsCurvesEnabled($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("use_curve_mapping") : $Object.Query("use_curve_mapping")
EndFunc

Func _Blender_ViewSettingsCurvesEnable($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("use_curve_mapping", $bValue)
EndFunc

#EndRegion