#
#	BLENDER UDF ADDON
#	Version 1.0
#	by scintilla4evr
#

import bpy
from bpy.types import (Operator, Panel, UIList, Scene, PropertyGroup)
from bpy.props import (BoolProperty, CollectionProperty, FloatProperty, IntProperty, PointerProperty, StringProperty)

from mathutils import *
from math import *

from threading import Timer

import winreg

bl_info = {
	"name": "Integration with AutoIt",
	"author": "scintilla4evr",
	"version": (0, 0, 1),
	"blender": (2, 76, 0),
	"location": "Properties > Render",
	"description": "Enables automating Blender with Blender UDF for AutoIt scripting language.",
	"warning": "beta",
	"wiki_url": "",
	"category": "Development",
}

class budfSceneProperties(PropertyGroup):
	requestStop = BoolProperty(name="Stop Request", default=True)
	interval = FloatProperty(name="Interval", description="Interval between function calls (in seconds)", default=1, min=0.01, max=10)
	sendAdvPropData = BoolProperty(name="Send advanced property data", description="Send additional property data to AutoIt, like default values, minimums and maximums, etc.", default=False)


def budfParseRequestedData():
	key = winreg.OpenKey(winreg.HKEY_CURRENT_USER, "Software\Blender UDF for AutoIt", 0, winreg.KEY_ALL_ACCESS)
	id = int(winreg.QueryValue(key, None))

	data = winreg.QueryValueEx(key, "PythonInput")[0]

	if (id == 1):
		# We've got job to do!
		out = eval(data)
		winreg.SetValueEx(key, "PythonOutput", 0, winreg.REG_SZ, str(out))
		winreg.SetValue(key, None, winreg.REG_SZ, str(3)) # UDF! Now, you've got some job to do!
	elif (id == 2):
		# We've got job to do!
		out = exec(data)
		winreg.SetValue(key, None, winreg.REG_SZ, str(3)) # Done!
	elif (id == 4): # If the UDF wants an object, let's give it one!
		obj = eval(data)
		props = obj.rna_type.properties
		keys = props.keys()

		key2 = winreg.OpenKey(key, "PythonObjectData", 0, winreg.KEY_ALL_ACCESS)

		winreg.SetValue(key2, None, winreg.REG_SZ, str(len(keys)))

		for k in keys:
			value = eval("obj.%s" % k)
			winreg.SetValueEx(key2, str(k), 0, winreg.REG_SZ, str(value))

			prop = props[k]
			if (prop.type == "COLLECTION"):
				c = value[:]
				ckey = winreg.CreateKeyEx(key2, k, 0, winreg.KEY_ALL_ACCESS)
				winreg.SetValue(ckey, None, winreg.REG_SZ, str(len(c)))

				for i in range(len(c)):
					item = c[i]
					winreg.SetValueEx(ckey, str(i), 0, winreg.REG_SZ, str(item))

		winreg.SetValue(key, None, winreg.REG_SZ, str(3)) # Done

	if not (id == 0):
		winreg.SetValue(key, None, winreg.REG_SZ, str(3))

	return 0

def budfCheckTimer():
	if bpy.context.scene.au3udf.requestStop == True:
		return 0

	budfParseRequestedData()

	Timer(bpy.context.scene.au3udf.interval, budfCheckTimer).start()


class budfStartTimer(Operator):
	bl_idname = "budf.start"
	bl_label = "Start UDF"

	def execute(self, context):
		context.scene.au3udf.requestStop = False
		budfCheckTimer()

		return {"FINISHED"}

class budfStopTimer(Operator):
	bl_idname = "budf.stop"
	bl_label = "Stop UDF"

	def execute(self, context):
		context.scene.au3udf.requestStop = True

		return {"FINISHED"}

class budfSetIntervalFromFramerate(Operator):
	bl_idname = "budf.pairfps"
	bl_label = "FPS"

	def execute(self, context):
		context.scene.au3udf.interval = 1/(context.scene.render.fps/context.scene.render.fps_base)

		return {"FINISHED"}

class budfUDFPanel(Panel):
	bl_label = "Blender UDF for AutoIt"
	bl_idname = "OBJECT_PT_layout"
	bl_space_type = 'PROPERTIES'
	bl_region_type = 'WINDOW'
	bl_context = "render"

	def draw(self, context):
		layout = self.layout

		scene = context.scene

		if not scene.au3udf.requestStop:
			layout.label("Status: Running")
		else:
			layout.label("Status: Stopped")

		row = layout.row(align=True)
		row.operator("budf.start", icon="PLAY")
		row.operator("budf.stop", icon="CANCEL")

		row = layout.row(align=True).split(0.75)
		row.prop(scene.au3udf, "interval")
		row.operator("budf.pairfps")

		layout.prop(scene.au3udf, "sendAdvPropData")



def register():
	bpy.utils.register_class(budfStartTimer)
	bpy.utils.register_class(budfStopTimer)
	bpy.utils.register_class(budfSetIntervalFromFramerate)
	bpy.utils.register_class(budfUDFPanel)
	bpy.utils.register_class(budfSceneProperties)

	bpy.types.Scene.au3udf = PointerProperty(type=budfSceneProperties)


def unregister():
	bpy.utils.unregister_class(budfStartTimer)
	bpy.utils.unregister_class(budfStopTimer)
	bpy.utils.unregister_class(budfSetIntervalFromFramerate)
	bpy.utils.unregister_class(budfUDFPanel)
	bpy.utils.unregister_class(budfSceneProperties)

	del bpy.types.Scene.au3udf

if __name__ == "__main__":
	register()
