#include-once

#Region Getting type-specific data

Func _Blender_ObjectGetMesh($Object)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)
	If Not $Object.type = "MESH" Then Return SetError($BUDF_ERR_TYPE, 0, 0)

	$pyMesh = $Object.data

	Return __bpy_ParseMesh($pyMesh)
EndFunc

#EndRegion

#Region Universal object properties

Func _Blender_ObjectGetLocation($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("location") : $Object.Query("location")
EndFunc

Func _Blender_ObjectSetLocation($Object, $Vector)
	If Not IsObj($Object) Or Not IsObj($Vector) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("location", $Vector)
EndFunc

Func _Blender_ObjectGetScale($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("scale") : $Object.Query("scale")
EndFunc

Func _Blender_ObjectSetScale($Object, $Vector)
	If Not IsObj($Object) Or Not IsObj($Vector) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("scale", $Vector)
EndFunc

Func _Blender_ObjectGetDimensions($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("dimensions") : $Object.Query("dimensions")
EndFunc

Func _Blender_ObjectSetDimensions($Object, $Vector)
	If Not IsObj($Object) Or Not IsObj($Vector) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("dimensions", $Vector)
EndFunc

Func _Blender_ObjectIsSelected($Object, $bCallBpy = False)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $bCallBpy ? $Object.Get("select") : $Object.Query("select")
EndFunc

Func _Blender_ObjectSelect($Object, $bValue = True)
	If Not IsObj($Object) Then Return SetError($BUDF_ERR_NOTOBJECT, 0, 0)

	Return $Object.Set("select", $bValue)
EndFunc

#EndRegion