#region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseX64=N
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#AutoIt3Wrapper_AU3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#Tidy_Parameters=/gd /gds
#AutoIt3Wrapper_Run_Obfuscator=y
#Obfuscator_Parameters=/striponly
#endregion ;**** Directives created by AutoIt3Wrapper_GUI ****
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <GuiTreeView.au3>
#include <TabConstants.au3>
#include <EditConstants.au3>
#include <AD.au3>
#include <GuiTab.au3>

_AD_ErrorNotify(2)

Global $sTitle = "ADAT - Active Directory Admin Tool"
Global $iCurrTab = 0, $iPrevTab = 0, $iMsg, $iResult, $iLine, $sIniFile = @ScriptDir & "\ADAT.INI"
Global $bIsConnected = False, $sReturnValue = ""
#region ### Hold the input of the GUI ###
Global $sT0_AdminUserName, $sT0_AdminUserPassword, $sT0_DomainName, $sT0_DomainController, $sT0_ConfigurationContext
Global $sT1_ComputerName, $sT1_OU, $sT1_Usergroup, $sT1_Description
Global $sT2_ComputerName, $sT2_UserID, $sT2_Password
Global $sT3_UserID
#endregion ### Hold the input of the GUI ###
#region ### Position and dimension of controls ###
Global $iDLeft = 16, $iDTop = 38, $iDWidth = 600, $iDHeight = 17 ; description line
Global $iLLeft = 16, $iLTop = 74, $iLWidth = 191, $iLHeight = 17, $iLSpace = 17 ; Label control
Global $iILeft = 208, $iITop = 72, $iIWidth = 209, $iIHeight = 21, $iISpace = 13 ; Input control
Global $iBLeft = 426, $iBTop = 72, $iBWidth = 25, $iBHeight = 21, $iBSpace = 13 ; Addional Button control
#endregion ### Position and dimension of controls ###
; Fill the fields of the "General" tab from an INI file
$sT0_AdminUserName = IniRead($sIniFile, "ADAT", "AdminUserName", "")
$sT0_DomainName = IniRead($sIniFile, "ADAT", "DomainName", "")
$sT0_DomainController = IniRead($sIniFile, "ADAT", "DomainController", "")
$sT0_ConfigurationContext = IniRead($sIniFile, "ADAT", "ConfigurationContext", "")
#region ### START Koda GUI section ###
Global $hGUI = GUICreate($sTitle, 625, 448, 192, 124)
Global $hTab = GUICtrlCreateTab(8, 8, 609, 400, BitOR($GUI_SS_DEFAULT_TAB, $TCS_MULTILINE))
;---------------
; Tab 0: General
;---------------
$iLine = 0
Global $hT0 = GUICtrlCreateTabItem("&General")
GUICtrlCreateLabel("Enter admin credentials to be used for all other functions or empty for the current user.", $iDLeft, $iDTop, $iDWidth, $iDHeight)
GUICtrlSetFont(-1, 9, 800) ; bold
; Line 1
GUICtrlCreateLabel("Admin user name", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT0_AdminUserName = GUICtrlCreateInput($sT0_AdminUserName, $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
GUICtrlSetState(-1, $GUI_Focus)
; Line 2
$iLine += 1
GUICtrlCreateLabel("Admin user password", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT0_AdminUserPassword = GUICtrlCreateInput("", $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight, BitOR($GUI_SS_DEFAULT_INPUT, $ES_PASSWORD))
; Line 3
$iLine += 1
GUICtrlCreateLabel("Active Directory domain name", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT0_DomainName = GUICtrlCreateInput($sT0_DomainName, $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
; Line 4
$iLine += 1
GUICtrlCreateLabel("Name of Domain Controller", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT0_DomainController = GUICtrlCreateInput($sT0_DomainController, $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
; Line 5
$iLine += 1
GUICtrlCreateLabel("Configuration naming context", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT0_ConfigurationContext = GUICtrlCreateInput($sT0_ConfigurationContext, $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
;-----------------------
; Tab 1: Create computer
;-----------------------
$iLine = 0
Global $hT1 = GUICtrlCreateTabItem("&Create Computer")
GUICtrlCreateLabel("Create a computer in the specified OU.", $iDLeft, $iDTop, $iDWidth, $iDHeight)
GUICtrlSetFont(-1, 9, 800) ; bold
; Line 1
GUICtrlCreateLabel("Computername", $iLLeft, 74, $iLWidth, $iLHeight)
Global $hT1_ComputerName = GUICtrlCreateInput(@ComputerName, $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
Global $hT1_ButtonComputer = GUICtrlCreateButton("...", $iBLeft, $iBTop + $iLine * $iBHeight + $iLine * $iBSpace, $iBWidth, $iBHeight)
; Line 2
$iLine += 1
GUICtrlCreateLabel("OU to create the computer in", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT1_OU = GUICtrlCreateInput("", $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
Global $hT1_ButtonOU = GUICtrlCreateButton("...", $iBLeft, $iBTop + $iLine * $iBHeight + $iLine * $iBSpace, $iBWidth, $iBHeight)
; Line 3
$iLine += 1
GUICtrlCreateLabel("User/group allowed to join the comp.", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT1_Usergroup = GUICtrlCreateInput(@UserName, $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
; Line 4
$iLine += 1
GUICtrlCreateLabel("Description", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT1_Description = GUICtrlCreateInput("", $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
;---------------------
; Tab 2: Join computer
;---------------------
$iLine = 0
Global $hT2 = GUICtrlCreateTabItem("&Join Computer")
GUICtrlCreateLabel("Join the specified computer to the domain defined on the 'General' tab.", $iDLeft, $iDTop, $iDWidth, $iDHeight)
GUICtrlSetFont(-1, 9, 800) ; bold
; Line 1
GUICtrlCreateLabel("Computername", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT2_ComputerName = GUICtrlCreateInput(@ComputerName, $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
Global $hT2_ButtonComputer = GUICtrlCreateButton("...", $iBLeft, $iBTop + $iLine * $iBHeight + $iLine * $iBSpace, $iBWidth, $iBHeight)
; Line 2
$iLine += 1
GUICtrlCreateLabel("User name", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT2_UserID = GUICtrlCreateInput($sT2_UserID, $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
Global $hT2_ButtonUser = GUICtrlCreateButton("...", $iBLeft, $iBTop + $iLine * $iBHeight + $iLine * $iBSpace, $iBWidth, $iBHeight)
; Line 3
$iLine += 1
GUICtrlCreateLabel("User password", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT2_Password = GUICtrlCreateInput("", $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight, BitOR($GUI_SS_DEFAULT_INPUT, $ES_PASSWORD))
;-----------------------------
; Tab 3: Query user properties
;-----------------------------
$iLine = 0
Global $hT3 = GUICtrlCreateTabItem("Query &user properties")
GUICtrlCreateLabel("Show properties of the selected user.", $iDLeft, $iDTop, $iDWidth, $iDHeight)
GUICtrlSetFont(-1, 9, 800) ; bold
; Line 1
GUICtrlCreateLabel("Username", $iLLeft, $iLTop + $iLine * $iLHeight + $iLine * $iLSpace, $iLWidth, $iLHeight)
Global $hT3_UserID = GUICtrlCreateInput(@UserName, $iILeft, $iITop + $iLine * $iIHeight + $iLine * $iISpace, $iIWidth, $iIHeight)
Global $hT3_ButtonUser = GUICtrlCreateButton("...", $iBLeft, $iBTop + $iLine * $iBHeight + $iLine * $iBSpace, $iBWidth, $iBHeight)
;---------------------------
; Terminate the tab creation
;---------------------------
GUICtrlCreateTabItem("")
;---------------------
; Buttons for all tabs
;---------------------
Global $hButton_Process = GUICtrlCreateButton("Process", 8, 416, 97, 25)
Global $hButton_Exit = GUICtrlCreateButton("Exit", 517, 415, 97, 25)
#endregion ### END Koda GUI section ###
GUISetState(@SW_SHOW)
While 1
	$iMsg = GUIGetMsg()
	Switch $iMsg
		Case $GUI_EVENT_CLOSE, $hButton_Exit
			If $bIsConnected Then _AD_Close()
			Exit
		Case $hButton_Process
			$iCurrTab = GUICtrlRead($hTab)
			Call("Process_Tab" & $iCurrTab)
		Case $hTab
			$iPrevTab = $iCurrTab
			If $iPrevTab = 0 Then ; process the general tab without pressing the "process" button
				If Process_Tab0() = 0 Then GUICtrlSetState($hT0, $GUI_Show) ; Switch back to first tab if an error occurred
			EndIf
			$iCurrTab = GUICtrlRead($hTab)
			; Set the focus to the first input field on every tab
			#region ### Set focus ###
			If $iCurrTab = 0 Then GUICtrlSetState($hT0_AdminUserName, $GUI_Focus)
			If $iCurrTab = 1 Then GUICtrlSetState($hT1_ComputerName, $GUI_Focus)
			If $iCurrTab = 2 Then GUICtrlSetState($hT2_ComputerName, $GUI_Focus)
			If $iCurrTab = 3 Then GUICtrlSetState($hT3_UserID, $GUI_Focus)
			#endregion ### Set focus ###
		#region ### Process buttons ###
		Case $hT1_ButtonOU ; Display a treeview of the OUs and let the user select one
			GUICtrlSetData($hT1_OU, GetOUTreeView())
		Case $hT1_ButtonComputer, $hT2_ButtonComputer ; List all computers and let the user select one
			$sReturnValue = List_Computer()
			If $sReturnValue <> "" Then
				If $iMsg = $hT1_ButtonComputer Then GUICtrlSetData($hT1_ComputerName, $sReturnValue)
				If $iMsg = $hT2_ButtonComputer Then GUICtrlSetData($hT2_ComputerName, $sReturnValue)
			EndIf
		Case $hT2_ButtonUser, $hT3_ButtonUser ; List all users and let the user select one
			$sReturnValue = List_User()
			If $sReturnValue <> "" Then
				If $iMsg = $hT2_ButtonUser Then GUICtrlSetData($hT2_UserID, $sReturnValue)
				If $iMsg = $hT3_ButtonUser Then GUICtrlSetData($hT3_UserID, $sReturnValue)
			EndIf
		#endregion ### Process buttons ###
	EndSwitch
WEnd

; #FUNCTION# ====================================================================================================================
; Name...........: Process_Tab0
; Description ...: Process the data entered on the first tab - General settings
; ===============================================================================================================================
Func Process_Tab0()

	Local $iReturnCode = 1
	; Retrieve data from the tab
	$sT0_AdminUserName = GUICtrlRead($hT0_AdminUserName)
	$sT0_AdminUserPassword = GUICtrlRead($hT0_AdminUserPassword)
	$sT0_DomainName = GUICtrlRead($hT0_DomainName)
	$sT0_DomainController = GUICtrlRead($hT0_DomainController)
	$sT0_ConfigurationContext = GUICtrlRead($hT0_ConfigurationContext)
	; Process data
	If $bIsConnected Then _AD_Close()
	$bIsConnected = False
	_AD_Open($sT0_AdminUserName, $sT0_AdminUserPassword, $sT0_DomainName, $sT0_DomainController, $sT0_ConfigurationContext)
	If @error Then
		Local $sError = @error, $sExtended = @extended
		Local $sAD_Hive = "HKLM", $sErrorMsg
		If @OSArch = "IA64" Or @OSArch = "X64" Then $sAD_Hive = "HKLM64"
		Local $sAD_OSVersion = RegRead($sAD_Hive & "\SOFTWARE\Microsoft\Windows NT\CurrentVersion", "CurrentVersion")
		$sAD_OSVersion = StringSplit($sAD_OSVersion, ".")
		If Int($sAD_OSVersion[1]) >= 6 Then ; Delivers detailed error information for Windows Vista and later if debugging is activated
			Local $aAD_Errors = _AD_GetLastADSIError()
			If $aAD_Errors[4] <> 0 Then $sErrorMsg = $aAD_Errors[5]
		EndIf
		MsgBox(16, $sTitle, "Error accessing the Active Directory. @Error: " & $sError & ", @extended: " & $sExtended & @CRLF & $sErrorMsg)
		$iReturnCode = 0
	Else
		$bIsConnected = True ; Set status of connection
	EndIf
	Return $iReturnCode

EndFunc   ;==>Process_Tab0

; #FUNCTION# ====================================================================================================================
; Name...........: Process_Tab1
; Description ...: Process the data entered on the second tab - Create a computer account
; ===============================================================================================================================
Func Process_Tab1()

	; Retrieve data from the tab
	$sT1_ComputerName = GUICtrlRead($hT1_ComputerName)
	$sT1_OU = GUICtrlRead($hT1_OU)
	$sT1_Usergroup = GUICtrlRead($hT1_Usergroup)
	$sT1_Description = GUICtrlRead($hT1_Description)
	; Check data
	If $sT1_ComputerName = "" Then Return MsgBox(16, $sTitle, "Computername is missing!")
	If $sT1_OU = "" Then Return MsgBox(16, $sTitle, "OU is missing!")
	If $sT1_Usergroup = "" Then Return MsgBox(16, $sTitle, "User/Group is missing!")
	If $sT1_Description = "" Then Return MsgBox(16, $sTitle, "Description is missing!")
	; Process data
	$iResult = _AD_CreateComputer($sT1_OU, $sT1_ComputerName, $sT1_Usergroup)
	If $iResult <> 1 Then
		Switch @error
			Case 1
				MsgBox(16, $sTitle, "Specified OU does not exist!")
			Case 2
				MsgBox(16, $sTitle, "The computer is already defined in the specified OU!")
			Case 3
				MsgBox(16, $sTitle, "Specified user/group does not exist!")
			Case Else
				MsgBox(16, $sTitle, "Error creating computer. @error: " & @error & ", @extended: " & @extended)
		EndSwitch
	Else
		$iResult = _AD_ModifyAttribute($sT1_ComputerName & "$", "description", $sT1_Description)
		If $iResult <> 1 Then
			Switch @error
				Case 1
					MsgBox(16, $sTitle, "Specified computer does not exist!")
				Case Else
					MsgBox(16, $sTitle, "Error setting description. @error: " & @error & ", @extended: " & @extended)
			EndSwitch
		EndIf
	EndIf

EndFunc   ;==>Process_Tab1

; #FUNCTION# ====================================================================================================================
; Name...........: Process_Tab2
; Description ...: Process the data entered on the third tab - Join a computer to the domain
; ===============================================================================================================================
Func Process_Tab2()

	; Retrieve data from the tab
	$sT2_ComputerName = GUICtrlRead($hT2_ComputerName)
	; Check data
	If $sT2_ComputerName = "" Then Return MsgBox(16, $sTitle, "Computername is missing!")
	; Process data
	$iResult = _AD_JoinDomain($sT2_ComputerName, $sT2_UserID, $sT2_Password)
	If $iResult <> 1 Then
		Switch @error
			Case 1
				MsgBox(16, $sTitle, "Computer account does not exist in the domain!")
			Case 3
				MsgBox(16, $sTitle, "WMI object could not be created! @error: " & @error & ", @extended: " & @extended)
			Case 4
				MsgBox(16, $sTitle, "The computer is already a member of the domain!")
			Case Else
				MsgBox(16, $sTitle, "Joining the domain was not successful. @error: " & @error & ", @extended: " & @extended)
		EndSwitch
	EndIf

EndFunc   ;==>Process_Tab2

; #FUNCTION# ====================================================================================================================
; Name...........: Process_Tab3
; Description ...: Process the data entered on the fourth tab - Query properties of an user
; ===============================================================================================================================
Func Process_Tab3()

	; Retrieve data from the tab
	$sT3_UserID = GUICtrlRead($hT3_UserID)
	; Check data
	If $sT3_UserID = "" Then Return MsgBox(16, $sTitle, "Username is missing!")
	; Process data
	Local $aResult = _AD_GetObjectProperties($sT3_UserID)
	If @error Then
		MsgBox(16, $sTitle, "Joining the domain was not successful. @error: " & @error & ", @extended: " & @extended)
	Else
		_ArrayDisplay($aResult)
	EndIf

EndFunc   ;==>Process_Tab3

; #FUNCTION# ====================================================================================================================
; Name...........: GetOUTreeView
; Description ...: Display a TreeView of the OUs and return the selected FQDN to the main GUI
; ===============================================================================================================================
Func GetOUTreeView()

	Local $Msg, $hSelection
	Local $sOU = "" ; FQDN of the OU where to start
	Local $sTitle = "Active Direcory OU Treeview"
	#region ### START Koda GUI section ### Form=
	Local $hGUI2 = GUICreate($sTitle, 743, 683, -1, -1, Default, Default, $hGUI)
	Local $hTree = GUICtrlCreateTreeView(6, 6, 600, 666, -1, $WS_EX_CLIENTEDGE)
	Local $bExit = GUICtrlCreateButton("Exit", 624, 8, 97, 33)
	Local $bExpand = GUICtrlCreateButton("Expand", 624, 56, 97, 33)
	Local $bCollapse = GUICtrlCreateButton("Collapse", 624, 104, 97, 33)
	Local $bSelect = GUICtrlCreateButton("Select OU", 624, 152, 97, 33)
	#endregion ### END Koda GUI section ###
	Local $aTreeView = _AD_GetOUTreeView($sOU, $hTree)
	If @error <> 0 Then MsgBox(16, "Active Direcory OU Treeview", "Error creating list of OUs starting with '" & $sOU & "'." & @CRLF & _
			"Error returned by function _AD_GetALLOUs: @error = " & @error & ", @extended =  " & @extended)
	GUISetState(@SW_SHOW)
	While 1
		$Msg = GUIGetMsg()
		Switch $Msg
			Case $GUI_EVENT_CLOSE, $bExit
				GUIDelete($hGUI2)
				Return ""
			Case $bExpand
				_GUICtrlTreeView_Expand($hTree)
			Case $bCollapse
				_GUICtrlTreeView_Expand($hTree, 0, False)
			Case $bSelect
				$hSelection = _GUICtrlTreeView_GetSelection($hTree)
				For $i = 1 To $aTreeView[0][0]
					If $hSelection = $aTreeView[$i][2] Then ExitLoop
				Next
				GUIDelete($hGUI2)
				Return $aTreeView[$i][1]
		EndSwitch
	WEnd

EndFunc   ;==>GetOUTreeView

; #FUNCTION# ====================================================================================================================
; Name...........: _AD_GetOUTreeView
; Description ...: Fills a given TreeView control with all OUs starting with a given OU.
; Syntax.........: _AD_GetOUTreeView($sAD_OU, $hAD_TreeView)
; Parameters ....: $sAD_OU       - FQDN of the OU where to start. "" displays all OUs
;                  $hAD_TreeView - Handle of the TreeView where the OUs will be displayed. Has to be created in advance
; Return values .: Success - 1
;                  Failure - Returns 0 and sets @error:
;                  |x - Function _AD_Open or _AD_GetAllOUs failed. @error and @extended are set by _AD_Open or _AD_GetAllOUs
; Author ........: ReFran - http://www.autoitscript.com/forum/topic/84119-treeview-read-to-from-file
; Modified.......: water
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _AD_GetOUTreeView($sAD_OU, $hAD_TreeView)

	Local $sSeparator = "\", $aAD_Temp, $sAD_Line, $iAD_Level
	Local $aAD_OUs = _AD_GetAllOUs($sAD_OU, $sSeparator)
	If @error <> 0 Then Return SetError(@error, @extended, 0)
	Local $aAD_TreeView[$aAD_OUs[0][0] + 1][3] = [[$aAD_OUs[0][0], 3]]
	For $i = 1 To $aAD_OUs[0][0]
		$aAD_Temp = StringSplit($aAD_OUs[$i][0], $sSeparator)
		$aAD_TreeView[$i][0] = StringFormat("%" & $aAD_Temp[0] - 1 & "s", "") & "#" & $aAD_Temp[$aAD_Temp[0]]
		$aAD_TreeView[$i][1] = $aAD_OUs[$i][1]
	Next
	_GUICtrlTreeView_BeginUpdate($hAD_TreeView)
	Local $ahAD_Node[50]
	For $iAD_Index = 1 To $aAD_TreeView[0][0]
		$sAD_Line = StringSplit(StringStripCR($aAD_TreeView[$iAD_Index][0]), @TAB)
		$iAD_Level = StringInStr($sAD_Line[1], "#")
		If $iAD_Level = 0 Then ExitLoop
		If $iAD_Level = 1 Then
			$ahAD_Node[$iAD_Level] = _GUICtrlTreeView_Add($hAD_TreeView, 0, StringMid($sAD_Line[1], $iAD_Level + 1))
			$aAD_TreeView[$iAD_Index][2] = $ahAD_Node[$iAD_Level]
		Else
			$ahAD_Node[$iAD_Level] = _GUICtrlTreeView_AddChild($hAD_TreeView, $ahAD_Node[$iAD_Level - 1], StringMid($sAD_Line[1], $iAD_Level + 1))
			$aAD_TreeView[$iAD_Index][2] = $ahAD_Node[$iAD_Level]
		EndIf
	Next
	_GUICtrlTreeView_EndUpdate($hAD_TreeView)
	Return $aAD_TreeView

EndFunc   ;==>_AD_GetOUTreeView

; #FUNCTION# ====================================================================================================================
; Name...........: List_Computer
; Description ...: Create a list of computer accounts
; ===============================================================================================================================
Func List_Computer()

	Local $Msg, $sTitle = "Active Direcory Computer List"
	Local $sComputer = InputBox($sTitle, "Computer account(s) to search for." & @CRLF & "Wildcards are allowed.", "*", "", 300, 150, Default, Default, Default, $hGUI)
	If @error = 1 Then Return
	Local $aUser = _AD_GetObjectsInOU("", "(&(objectcategory=computer)(Samaccountname=" & $sComputer & "))", 2, "cn, description,distinguishedname")
	If @error = 3 Then
		MsgBox(16, $sTitle, "No computer account found using the specified search pattern!")
		Return ""
	EndIf
	Local $hGUI2 = GUICreate($sTitle, 743, 683, -1, -1, Default, Default, $hGUI)
	Local $hListView = GUICtrlCreateListView("Name (cn)|Description|Distinghuishedname", 6, 6, 600, 666)
	Local $bExit = GUICtrlCreateButton("Exit", 624, 8, 97, 33)
	Local $bSelect = GUICtrlCreateButton("Select Computer", 624, 56, 97, 33)
	For $i = 1 To $aUser[0][0]
		GUICtrlCreateListViewItem($aUser[$i][0] & "|" & $aUser[$i][1] & "|" & $aUser[$i][2], $hListView)
	Next
	GUISetState(@SW_SHOW)
	While 1
		$Msg = GUIGetMsg()
		Switch $Msg
			Case $GUI_EVENT_CLOSE, $bExit
				GUIDelete($hGUI2)
				Return ""
			Case $bSelect
				Local $aSelected = StringSplit(GUICtrlRead(GUICtrlRead($hListView)), "|")
				GUIDelete($hGUI2)
				Return $aSelected[1]
		EndSwitch
	WEnd

EndFunc   ;==>List_Computer

; #FUNCTION# ====================================================================================================================
; Name...........: List_User
; Description ...: Create a list of user accounts
; ===============================================================================================================================
Func List_User()

	Local $Msg, $sTitle = "Active Direcory User List"
	Local $sUser = InputBox($sTitle, "User account(s) to search for." & @CRLF & "Wildcards are allowed.", "*", "", 300, 150, Default, Default, Default, $hGUI)
	If @error = 1 Then Return
	Local $aUser = _AD_GetObjectsInOU("", "(&(objectcategory=person)(Samaccountname=" & $sUser & "))", 2, "samaccountname, name, description, name")
	If @error = 3 Then
		MsgBox(16, $sTitle, "No user account found using the specified search pattern!")
		Return ""
	EndIf
	Local $hGUI2 = GUICreate($sTitle, 743, 683, -1, -1, Default, Default, $hGUI)
	Local $hListView = GUICtrlCreateListView("SamAccountName|Name|Description", 6, 6, 600, 666)
	Local $bExit = GUICtrlCreateButton("Exit", 624, 8, 97, 33)
	Local $bSelect = GUICtrlCreateButton("Select User", 624, 56, 97, 33)
	For $i = 1 To $aUser[0][0]
		GUICtrlCreateListViewItem($aUser[$i][0] & "|" & $aUser[$i][1] & "|" & $aUser[$i][2], $hListView)
	Next
	GUISetState(@SW_SHOW)
	While 1
		$Msg = GUIGetMsg()
		Switch $Msg
			Case $GUI_EVENT_CLOSE, $bExit
				GUIDelete($hGUI2)
				Return ""
			Case $bSelect
				Local $aSelected = StringSplit(GUICtrlRead(GUICtrlRead($hListView)), "|")
				GUIDelete($hGUI2)
				Return $aSelected[1]
		EndSwitch
	WEnd

EndFunc   ;==>List_User
