#include <GUIConstantsEx.au3>
#include <GDIPlusPathCombine.au3>

Example()

Func Example()
	Local $hGUI, $hGraphic, $hBrush, $hPath, $hPath1, $hPath2

	; Create GUI
	$hGUI = GUICreate("GDI+", 600, 480)
	GUISetState(@SW_SHOW)

	_GDIPlus_Startup()
	$hGraphic = _GDIPlus_GraphicsCreateFromHWND($hGUI) ;Create a graphics object from a window handle
	_GDIPlus_GraphicsClear($hGraphic, 0xFFFFFFFF)
	_GDIPlus_GraphicsSetSmoothingMode($hGraphic, 5)

	$hBrush = _GDIPlus_BrushCreateSolid(0x7F8800AA)

	$hPath1 = _GDIPlus_PathCreate() ;Create new path object
	_GDIPlus_PathAddRectangle($hPath1, 30, 80, 80, 60)

	$hPath2 = _GDIPlus_PathCreate() ;Create new path object
	_GDIPlus_PathAddEllipse($hPath2, 80, 60, 80, 60)

	_GDIPlus_GraphicsDrawString($hGraphic, "2 paths", 50, 30)
	_GDIPlus_GraphicsFillPath($hGraphic, $hPath1, $hBrush)
	_GDIPlus_GraphicsFillPath($hGraphic, $hPath2, $hBrush)

	_GDIPlus_GraphicsDrawString($hGraphic, "intersection", 50, 180)
	_GDIPlus_PathTranslate($hPath1, 0, 150)
	_GDIPlus_PathTranslate($hPath2, 0, 150)
	$hPath = _GDIPlus_PathCombine($hPath1, $hPath2, 1)
	_GDIPlus_GraphicsFillPath($hGraphic, $hPath, $hBrush)
	_GDIPlus_PathDispose($hPath)

	_GDIPlus_GraphicsDrawString($hGraphic, "union", 250, 180)
	_GDIPlus_PathTranslate($hPath1, 200, 0)
	_GDIPlus_PathTranslate($hPath2, 200, 0)
	$hPath = _GDIPlus_PathCombine($hPath1, $hPath2, 2)
	_GDIPlus_GraphicsFillPath($hGraphic, $hPath, $hBrush)
	_GDIPlus_PathDispose($hPath)

	_GDIPlus_GraphicsDrawString($hGraphic, "xor", 450, 180)
	_GDIPlus_PathTranslate($hPath1, 200, 0)
	_GDIPlus_PathTranslate($hPath2, 200, 0)
	$hPath = _GDIPlus_PathCombine($hPath1, $hPath2, 3)
	_GDIPlus_GraphicsFillPath($hGraphic, $hPath, $hBrush)
	_GDIPlus_PathDispose($hPath)

	_GDIPlus_GraphicsDrawString($hGraphic, "path1 sub path2", 50, 330)
	_GDIPlus_PathTranslate($hPath1, -400, 150)
	_GDIPlus_PathTranslate($hPath2, -400, 150)
	$hPath = _GDIPlus_PathCombine($hPath1, $hPath2, 4)
	_GDIPlus_GraphicsFillPath($hGraphic, $hPath, $hBrush)
	_GDIPlus_PathDispose($hPath)

	_GDIPlus_GraphicsDrawString($hGraphic, "path2 sub path1", 250, 330)
	_GDIPlus_PathTranslate($hPath1, 200, 0)
	_GDIPlus_PathTranslate($hPath2, 200, 0)
	$hPath = _GDIPlus_PathCombine($hPath1, $hPath2, 5)
	_GDIPlus_GraphicsFillPath($hGraphic, $hPath, $hBrush)
	_GDIPlus_PathDispose($hPath)

	; Loop until the user exits.
	Do
	Until GUIGetMsg() = $GUI_EVENT_CLOSE

	; Clean up resources
	_GDIPlus_PathDispose($hPath1)
	_GDIPlus_PathDispose($hPath2)
	_GDIPlus_PathDispose($hPath)
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_GraphicsDispose($hGraphic)
	_GDIPlus_Shutdown()
EndFunc   ;==>Example

Func _GDIPlus_PathTranslate($hPath, $dX, $dY)
	Local $hMatrix = _GDIPlus_MatrixCreate()
	_GDIPlus_MatrixTranslate($hMatrix, $dX, $dY)
	_GDIPlus_PathTransform($hPath, $hMatrix)
	_GDIPlus_MatrixDispose($hMatrix)
EndFunc
