#include-once
#include <GDIPlus.au3>

; #INDEX# =======================================================================================================================
; Title .........: GDI+ Path Combine
; AutoIt Version : 3.3.14.2
; Language ......: English
; Description ...: Function for combining two path objects together.
; Author ........: scintilla4evr
; Dll ...........: GDIPlus.dll
; ===============================================================================================================================

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDIPlus_PathCombine
; Description ...:
; Syntax ........: _GDIPlus_PathCombine($hPath1, $hPath2[, $iCombineMode = 2])
; Parameters ....: $hPath1              - the first Path object.
;                  $hPath2              - the second Path object.
;                  $iCombineMode        - [optional] combine mode. Default is 2. (See: _GDIPlus_RegionCombinePath)
; Return values .: New Path object
; Author ........: scintilla4evr
; ===============================================================================================================================
Func _GDIPlus_PathCombine($hPath1, $hPath2, $iCombineMode = 2)
	Local $hPath

	Switch $iCombineMode
		Case 1
			$hPath = __GDIPlus_PathCombineAND($hPath1, $hPath2)
		Case 2
			$hPath = __GDIPlus_PathCombineOR($hPath1, $hPath2)
		Case 3
			$hPath = __GDIPlus_PathCombineXOR($hPath1, $hPath2)
		Case 4
			$hPath = __GDIPlus_PathCombineSubtractFrom1($hPath1, $hPath2)
		Case 5
			$hPath = __GDIPlus_PathCombineSubtractFrom2($hPath1, $hPath2)
	EndSwitch

	Return $hPath
EndFunc

Func __GDIPlus_PathCombineXOR($hPath1, $hPath2)
	Local $hPath = _GDIPlus_PathCreate()

	_GDIPlus_PathAddPath($hPath, $hPath1, False)
	_GDIPlus_PathAddPath($hPath, $hPath2, False)

	Return $hPath
EndFunc

Func __GDIPlus_PathCombineOR($hPath1, $hPath2)
	Local $hPath = _GDIPlus_PathCreate(1)

	_GDIPlus_PathAddPath($hPath, $hPath1, False)
	_GDIPlus_PathAddPath($hPath, $hPath2, False)

	_GDIPlus_PathWindingModeOutline($hPath)

	Return $hPath
EndFunc

Func __GDIPlus_PathCombineAND($hPath1, $hPath2)
	Local $hPathXOR = __GDIPlus_PathCombineXOR($hPath1, $hPath2)
	Local $hPathOR = __GDIPlus_PathCombineOR($hPath1, $hPath2)

	Local $hPath = __GDIPlus_PathCombineXOR($hPathXOR, $hPathOR)

	_GDIPlus_PathDispose($hPathXOR)
	_GDIPlus_PathDispose($hPathOR)

	Return $hPath
EndFunc

Func __GDIPlus_PathCombineSubtractFrom1($hPath1, $hPath2)
	Local $hPathAND = __GDIPlus_PathCombineAND($hPath1, $hPath2)

	Local $hPath = __GDIPlus_PathCombineXOR($hPath1, $hPathAND)

	_GDIPlus_PathDispose($hPathAND)

	Return $hPath
EndFunc

Func __GDIPlus_PathCombineSubtractFrom2($hPath1, $hPath2)
	Local $hPathAND = __GDIPlus_PathCombineAND($hPath1, $hPath2)

	Local $hPath = __GDIPlus_PathCombineXOR($hPath2, $hPathAND)

	_GDIPlus_PathDispose($hPathAND)

	Return $hPath
EndFunc
