#cs ----------------------------------------------------------------------------

 Remmanaut, the autoit RMM tool

 Script function:		Displays the file log.txt in a GUI
 Version:				0.2.3

 Author:				Faldo / Erik Ribbhammar
 UDF Credits:			lod3n (_RunReadStd), dantay9 (TCP File Transfer),
						Prog@ndy (MySQL)
 Helping Credits:

#ce ----------------------------------------------------------------------------

#NoTrayIcon
#include <GUIConstantsEx.au3>
#include <GuiListBox.au3>
#include <Array.au3>
#include <WindowsConstants.au3>

Global $LogFileSize = FileGetSize("log.txt")

;Create main GUI
$hGUI = GUICreate("Remmanaut Log", 500, 500)

;Create Listbox
$Log_Listbox = _GUICtrlListBox_Create ( $hGUI, "", 10, 10, 480, 450)

;Create Clear-button
$ClearLog_Btn = GUICtrlCreateButton("Clear log", 200, 450, 100)

;Fill Listbox
$LogArray = FileReadToArray("log.txt")
If IsArray($LogArray) then
	For $i = 0 to UBound($LogArray)-1
		_GUICtrlListBox_InsertString ( $Log_Listbox, $LogArray[$i])
	Next
	$last_entry = $LogArray[$i-1]

	GUISetState(@SW_SHOW, $hGUI)
	_GUICtrlListBox_UpdateHScroll($Log_Listbox)
	_GUICtrlListBox_SetCurSel ( $Log_Listbox, $i-1 )
Else
	$last_entry = ""
	GUISetState(@SW_SHOW, $hGUI)
EndIf

AdlibRegister("UpdateLog", 1000)

;Gui loop
While 1
	Switch GUIGetMsg()
		Case $ClearLog_Btn
			FileDelete("log.txt")
			FileWrite("log.txt", "")
			$LogFileSize = FileGetSize("log.txt")
			$last_entry = ""
			_GUICtrlListBox_ResetContent ( $Log_Listbox )

		Case $GUI_EVENT_CLOSE
			ExitLoop

	EndSwitch
WEnd
GUIDelete($hGUI)

;Functions-------------------------------------------------------------
Func UpdateLog()
	If FileGetSize("log.txt") <> $LogFileSize Then
		$LogArray = FileReadToArray("log.txt")
		$FindLastEntry = _ArraySearch($LogArray, $last_entry)
		For $i = $FindLastEntry+1 to UBound($LogArray)-1
			_GUICtrlListBox_InsertString ( $Log_Listbox, $LogArray[$i])
		Next
		_GUICtrlListBox_SetCurSel ( $Log_Listbox, $i-1 )
		$last_entry = $LogArray[$i-1]
		$LogFileSize = FileGetSize("log.txt")
		_GUICtrlListBox_UpdateHScroll ( $Log_Listbox )
	EndIf
EndFunc
