#cs ----------------------------------------------------------------------------

 Remmanaut, the autoit RMM tool

 Script function:		Agent process, communicates with Remmanaut agent connector
 Version:				0.2.3

 Author:				Faldo / Erik Ribbhammar
 UDF Credits:			lod3n (_RunReadStd), dantay9 (TCP File Transfer),
						Prog@ndy (MySQL)
 Helping Credits:

#ce ----------------------------------------------------------------------------
#RequireAdmin
;~ #NoTrayIcon
Opt("TrayIconDebug", 1)
#include <File.au3>
#include <Array.au3>
#include <Process.au3>
#include <Crypt.au3>

;Predefined variables
Global $sIni = "settings.ini"
Global $Remmanaut_Server_IP = IniRead ( $sIni, "variables", "Remmanaut_Server_IP", "0.0.0.0" )
Global $MsgPort = IniRead ( $sIni, "variables", "MsgPort", "5074" )
Global $FilePort = IniRead ( $sIni, "variables", "FilePort", "5075" )
Global $sSerial = DriveGetSerial(@HomeDrive & "\")
Global $Recv, $RecvArray, $timeout

;Start Log GUI if defined in settings.ini and not running as system
If IniRead ( $sIni, "general", "log-gui", "1" ) = 1 then
	$cmd_return = _RunReadStd("whoami",0,@WorkingDir,0,1,@LF)
	IF $cmd_return <> "nt instans\system" then Run("Log-GUI.exe", @ScriptDir)
EndIf

;Initial checkin with computername and HWID
SendMsg("online|"&@ComputerName&"|"&$sSerial)
If $RecvArray[1] = "online" Then
	;Ask server for agent settings
	SendMsg("agent_settings|"&$sSerial, -1)
	Global $CheckinInterval = $RecvArray[1]
	Global $WorkingDir = $RecvArray[2]
	DirCreate($WorkingDir)

	;System files verification loop
	While 1
		;Ask server for file verification details and check all needed files
		SendMsg("verify_local_files|"&$sSerial, 10000)
		$Update_needed = 0
		For $i = 2 to $RecvArray[0]-1 step 2
			If FileExists($WorkingDir &"\"&$RecvArray[$i]) Then
				If _Crypt_HashFile ( $WorkingDir &"\"&$RecvArray[$i], $CALG_MD5 ) <> $RecvArray[$i+1] then $Update_needed = 1
			Else
				$Update_needed = 1
			EndIf
		Next
		If $Update_needed = 1 Then
			;If file hashes don't match or if they're missing, download and run file update script
			_ReceiveFile($WorkingDir, "fileupdate.exe")
			ShellExecuteWait($WorkingDir & '\fileupdate.exe',"", $WorkingDir, "", @SW_HIDE)
			_FileWriteLog(@ScriptDir & "\log.txt", "System files updated.")
		EndIf
		If $Update_needed = 0 then ExitLoop
	WEnd
EndIf
_FileWriteLog(@ScriptDir & "\log.txt", "Connection to server successful.")


;Main loop
While 1
	;Check in with Agent_ID and await queued action
	SendMsg("request_action|"&$sSerial, 10000)

	If $RecvArray[1] = "new_checkin_interval" Then
		$CheckinInterval = $RecvArray[2]
		_FileWriteLog(@ScriptDir & "\log.txt", "Server requesting new checkin interval of " & $RecvArray[2]/1000 & " seconds")
	EndIf

	If $RecvArray[1] = "cmd_sysuser" Then
		$command = $RecvArray[2]
		$interactive = $RecvArray[3]
		$runwait = $RecvArray[4]
		_FileWriteLog(@ScriptDir & "\log.txt", "Server requesting execution of command *" & $command & "* as system user")
		If $runwait = 1 Then
			ShellExecuteWait($WorkingDir & '\psexec', $interactive & ' -h -d -s -accepteula cmd /c ' & $command, $WorkingDir, "", @SW_HIDE)
		Else
			ShellExecute($WorkingDir & '\psexec', $interactive & ' -h -d -s -accepteula cmd /c ' & $command, $WorkingDir, "", @SW_HIDE)
		EndIf
	EndIf

	If $RecvArray[1] = "cmd_asuser" Then
		$command = $RecvArray[2]
		$interactive = $RecvArray[3]
		$user = $RecvArray[4]
		$password = $RecvArray[5]
		$runwait = $RecvArray[6]
		_FileWriteLog(@ScriptDir & "\log.txt", "Server requesting execution of command *" & $command & "* as user " & $user)
		If $runwait = 1 Then
			ShellExecuteWait($WorkingDir & '\psexec', $interactive & ' -h -d -u ' & $user & ' -p ' & $password & ' -accepteula cmd /c ' & $command, $WorkingDir, "", @SW_HIDE)
		Else
			ShellExecute($WorkingDir & '\psexec', $interactive & ' -h -d -u ' & $user & ' -p ' & $password & ' -accepteula cmd /c ' & $command, $WorkingDir, "", @SW_HIDE)
		EndIf
	EndIf


	;Filetransfer from agent. Recieve filename and path then send the file.
	If $RecvArray[1] = "filetransfer_from_agent" Then
		$agent_file = $RecvArray[2]
		_FileWriteLog(@ScriptDir & "\log.txt", "Uploading file " & $agent_file)
		_SendFile($agent_file)
	EndIf

	;Filetransfer to agent. Recieve filename and path then wait for the file.
	If $RecvArray[1] = "filetransfer_to_agent" Then
		$agent_path = $RecvArray[2]
		$server_filename = $RecvArray[3]
		_FileWriteLog(@ScriptDir & "\log.txt", "Downloading file "&$server_filename&" to " & $agent_path)
		_ReceiveFile($agent_path, $server_filename )
	EndIf

	;Prepare remote control. Ask server for setup-file
;~ 	If $RecvArray[1] = "prepare_rc" Then
;~ 		_ReceiveFile($WorkingDir )
;~ 		ShellExecuteWait('sc',"stop uvnc_service", "", "", @SW_HIDE)
;~ 		IniWrite($WorkingDir&"\ultravnc.ini", "Setup", "Dir", $WorkingDir&"\UltraVNC")
;~ 		IniWrite($WorkingDir&"\ultravnc.ini", "admin", "service_commandline", "-autoreconnect -id:"&StringLeft($sSerial,9)&" -connect "&$Remmanaut_Server_IP&":5077")
;~ 		FileCopy($WorkingDir&"\ultravnc.ini", $WorkingDir&"\UltraVNC\ultravnc.ini", 9)
;~ 		ShellExecuteWait($WorkingDir & '\uvnc.exe','/verysilent /loadinf="ultravnc.ini"', $WorkingDir, "", @SW_HIDE)
;~ 		ShellExecuteWait('sc',"config uvnc_service start=demand", "", "", @SW_HIDE)
;~ 		ShellExecuteWait('sc',"stop uvnc_service", "", "", @SW_HIDE)
;~ 	EndIf

	Sleep($CheckinInterval)
WEnd



;-------------------------------Functions----------------------------

Func _SendFile($LocalFile)
	Local $BytesRead = 0

	;Get file size
	$iFileSize = FileGetSize($LocalFile)

	;Get file name
	$Reg = StringRegExp($LocalFile, "(.)+\\((.)+)?", 3)
	Select
		Case Not IsArray($Reg)
			$FileName = $Reg
		Case UBound($Reg) < 2
			Return SetError(2, 0, -1)
		Case Else
			$FileName = $Reg[1]
	EndSelect

	;Initiate TCP session
	TCPStartup()
	$FileSocket = TCPConnect($Remmanaut_Server_IP, $FilePort)

	;Seq1: Wait until server replies
	Do
		$Receive = TCPRecv($FileSocket, 1000)
		Sleep(10)
	Until $Receive <> ""

	;Seq2: Send transfer direction, filename and file size to server
	TCPSend($FileSocket, "from_agent|"& $FileName & "|" & $iFileSize)

	;Open file to read in binary
	$FileHandle = FileOpen($LocalFile, 16)

	;Seq3: Wait until server replies with "Start Upload"
	Do
		$Receive = TCPRecv($FileSocket, 1000)
	Until $Receive <> ""

	;Seq4: Loop sending file in chunks as binary until size exceeds offset
	Local $iOffset = 0
	Do
		FileSetPos($FileHandle, $iOffset, $FILE_BEGIN)
		TCPSend($FileSocket, FileRead($FileHandle, 4096))
		$iOffset += 4096
	Until $iOffset >= $iFileSize

	;Seq5: Send "End of file" to finish transfer and close socket
	TCPSend($FileSocket, @CRLF & "{EOF}")
	FileClose($FileHandle)
	TCPCloseSocket($FileSocket)
	TCPShutdown()
EndFunc   ;==>_SendFile


Func _ReceiveFile($LocalPath, $ServerFile)
	;Initiate TCP session
	TCPStartup()
	$FileSocket = TCPConnect($Remmanaut_Server_IP, $FilePort)

	;Seq1: Wait until server replies
	Do
		$Receive = TCPRecv($FileSocket, 1000)
		Sleep(10)
	Until $Receive <> ""

	;Seq2: Send transfer direction, filename and file size to server
	TCPSend($FileSocket, "to_agent|"& $ServerFile)

	;Seq3: Wait for file name and size to be sent from server
	Do
		$Receive = TCPRecv($FileSocket, 1000)
		Sleep(5)
	Until $Receive <> ""
	$FileData = StringSplit($Receive, "|", 2)

	$LocalPath &= "\" & $FileData[0]
	$FileHandle = FileOpen($LocalPath, 16 + 2 + 8)

	$bEOF = Binary(@CRLF & "{EOF}") ;binary code for the end of the file
	$iEOFLen = BinaryLen($bEOF) ;length of the binary code
	$bData = Binary("") ;empty binary data which will contain the binary data of the file
	$iDataLen = 0 ;store the length of the data received
	$bEOFReached = False ;end of file bool

	;Seq4: Wait until server replies with "Start Download"
	Do
		$Receive = TCPRecv($FileSocket, 1000)
	Until $Receive <> ""

	;Seq5/6: Loop receive file as binary until "end of file" is recieved
	Do
		$bData = TCPRecv($FileSocket, 4096, 1)

		$iDataLen = BinaryLen($bData)

		; If nothing is received, retry for the incoming data.
		If $iDataLen = 0 Then ContinueLoop

		; If the end of the file is reached.
		If BinaryMid($bData, 1 + $iDataLen - $iEOFLen, $iEOFLen) = $bEOF Then
			; Strip the EOF code from the file data.
			$bData = BinaryMid($bData, 1, $iDataLen - $iEOFLen)

			; Set the EOFReached to True.
			$bEOFReached = True
		EndIf

		FileWrite($FileHandle, $bData)
	Until $bEOFReached

	FileClose($FileHandle)
	TCPCloseSocket($FileSocket)
	TCPShutdown()

EndFunc


Func _RunReadStd($doscmd,$timeoutSeconds=0,$workingdir=@ScriptDir,$flag=@SW_HIDE,$nRetVal = -1, $sDelim = @TAB)
    local $aReturn,$i_Pid,$h_Process,$i_ExitCode,$sStdOut,$sStdErr,$runTimer
    dim $aReturn[3]

    ; run process with StdErr and StdOut flags
    $runTimer = TimerInit()
    $i_Pid = Run($doscmd, $workingdir, $flag, 6) ; 6 = $STDERR_CHILD+$STDOUT_CHILD

    ; Get process handle
    sleep(100) ; or DllCall may fail - experimental
    $h_Process = DllCall('kernel32.dll','ptr', 'OpenProcess','int', 0x400,'int', 0,'int', $i_Pid)

    ; create tab delimited string containing StdOut text from process
    $aReturn[1] = ""
    $sStdOut = ""
    While 1
        $sStdOut &= StdoutRead($i_Pid)
        If @error Then ExitLoop
    Wend
    $sStdOut = StringReplace($sStdOut,@cr,@tab)
    $sStdOut = StringReplace($sStdOut,@lf,@tab)
    $aStdOut = StringSplit($sStdOut,@tab,1)
    for $i = 1 to $aStdOut[0]
        $aStdOut[$i] = StringStripWS($aStdOut[$i],3)
        if StringLen($aStdOut[$i]) > 0 then
            $aReturn[1] &= $aStdOut[$i] & $sDelim
        EndIf
    Next
    $aReturn[1] = StringTrimRight($aReturn[1],1)

    ; create tab delimited string containing StdErr text from process
    $aReturn[2] = ""
    $sStderr = ""
    While 1
        $sStderr &= StderrRead($i_Pid)
        If @error Then ExitLoop
    Wend
    $sStderr = StringReplace($sStderr,@cr,@tab)
    $sStderr = StringReplace($sStderr,@lf,@tab)
    $aStderr = StringSplit($sStderr,@tab,1)
    for $i = 1 to $aStderr[0]
        $aStderr[$i] = StringStripWS($aStderr[$i],3)
        if StringLen($aStderr[$i]) > 0 then
            $aReturn[2] &= $aStderr[$i] & $sDelim
        EndIf
    Next
    $aReturn[2] = StringTrimRight($aReturn[2],1)

    ; kill the process if it exceeds $timeoutSeconds
    if $timeoutSeconds > 0 Then
        if TimerDiff($runTimer)/1000 > $timeoutSeconds Then
            ProcessClose($i_Pid)
        EndIf
    EndIf

    ; fetch exit code and close process handle
    If IsArray($h_Process) Then
        Sleep(100) ; or DllCall may fail - experimental
        $i_ExitCode = DllCall('kernel32.dll','ptr', 'GetExitCodeProcess','ptr', $h_Process[0],'int*', 0)
        if IsArray($i_ExitCode) Then
            $aReturn[0] = $i_ExitCode[2]
        Else
            $aReturn[0] = -1
        EndIf
        Sleep(100) ; or DllCall may fail - experimental
        DllCall('kernel32.dll','ptr', 'CloseHandle','ptr', $h_Process[0])
    Else
        $aReturn[0] = -2
    EndIf

    ; return single item if correctly specified with with $nRetVal
    If $nRetVal <> -1 And $nRetVal >= 0 And $nRetVal <= 2 Then Return $aReturn[$nRetVal]

    ; return array with exit code, stdout, and stderr
    return $aReturn
EndFunc

Func SendMsg($message, $timeout = 60000)
	AdlibRegister("timeout", $timeout)
	$retry = 0
	While 1
		TCPStartup()
		$CmdSocket = TCPConnect($Remmanaut_Server_IP, $MsgPort)
		If @error Or $CmdSocket = '-1' Then
			If $retry = 5 then
				_FileWriteLog(@ScriptDir & "\log.txt", "Lost connection to server, retrying in 1 minute...")
				sleep(60000)
			Else
				_FileWriteLog(@ScriptDir & "\log.txt", "Could not connect to server, retrying in 1 second...")
				sleep(1000)
				$retry = $retry +1
			EndIf
		Else
			If $retry > 0 then _FileWriteLog(@ScriptDir & "\log.txt", "Connection to server successful.")
			TCPSend($CmdSocket, $message)
			Do
				$Recv = TCPRecv($CmdSocket, '1000')
				Sleep('100')
			Until $Recv <> ''

			$RecvArray = StringSplit($Recv, "|")

			TCPCloseSocket($CmdSocket)
			TCPShutdown()
			ExitLoop
		EndIf

	WEnd
	AdlibUnRegister()
EndFunc   ;==>SendMsg


Func Timeout()
	If $timeout > 1 then
		_FileWriteLog(@ScriptDir & "\log.txt", "Timeout for server communication reached, exiting.")
		Exit
	EndIf
EndFunc   ;==>Timeout