#cs ----------------------------------------------------------------------------

	Remmanaut, the autoit RMM tool

	Script function:		Remmanaut suite installer
	Version:				0.2

	Author:				Faldo / Erik Ribbhammar
	UDF Credits:			lod3n (_RunReadStd), dantay9 (TCP File Transfer),
	Prog@ndy (MySQL, _TCPconnect), Greg Laabs (_http)
	Helping Credits:		argumentum

#ce ----------------------------------------------------------------------------
#RequireAdmin
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <FileConstants.au3>
#include <File.au3>
#include <array.au3>
#include <MySql.au3>
#include <http.au3>
#include <GuiListBox.au3>

Global $recvarray, $ExternalIP, $PortStatus, $VerifyOK, $CreateDB, $InstName
Global $FilePort, $MsgPort, $MgmPort, $ServerIP

;Create Main GUI
$mGUI = GUICreate("Remmanaut Installer", 400, 500)

GUICtrlCreateLabel("Select which part of the suite you want to install/uninstall:", 10, 10, 500, 20)
$server_radio = GUICtrlCreateRadio("Remmanaut server", 20, 30, 200, 20)
$agent_radio = GUICtrlCreateRadio("Remmanaut agent", 20, 50, 200, 20)
$mgm_radio = GUICtrlCreateRadio("Remmanaut management tool", 20, 70, 200, 20)

GUICtrlCreateLabel("Choose installation path or leave as default:", 10, 110, 500, 20)
$inst_dir_input = GUICtrlCreateInput("", 20, 130, 250, 20)
$dir_browse_btn = GUICtrlCreateButton("Browse folders", 280, 128, 100)

;Port controls
$DefPorts_label = GUICtrlCreateLabel("Define server listeing ports or leave as default:", 10, 160)
$FilePort_label = GUICtrlCreateLabel("File transfer port:", 10, 182)
$FilePort_input = GUICtrlCreateInput("5074", 100, 180, 50, 20)
$MgmPort_label = GUICtrlCreateLabel("Management port:", 208, 182)
$MgmPort_input = GUICtrlCreateInput("5075", 300, 180, 50, 20)
$MsgPort_label = GUICtrlCreateLabel("Command port:", 10, 210)
$MsgPort_input = GUICtrlCreateInput("5076", 100, 210, 50, 20)

$ServerIP_label = GUICtrlCreateLabel("Remmanaut server IP-adress:", 10, 252)
$ServerIP_input = GUICtrlCreateInput("", 160, 250, 100, 20)

$StartLog_check = GUICtrlCreateCheckbox("Start with log window", 20, 300)
GUICtrlSetState($StartLog_check, $GUI_CHECKED)
$DeskShort_check = GUICtrlCreateCheckbox("Create desktop shortcut", 20, 320)
GUICtrlSetState($DeskShort_check, $GUI_CHECKED)


$Verify_btn = GUICtrlCreateButton("Verify connections", 150, 360, 100)
$Install_btn = GUICtrlCreateButton("Install", 90, 400, 100)
GUICtrlSetState($Install_btn, $GUI_DISABLE)
$Uninstall_btn = GUICtrlCreateButton("Uninstall", 210, 400, 100)
GUICtrlSetState($Uninstall_btn, $GUI_DISABLE)

;Create connection status GUI
$VerifyGUI = GUICreate("Verify connections", 220, 210, -1, -1, $WS_EX_TOOLWINDOW, -1, $mGUI)
$StatusListbox = _GUICtrlListBox_Create ( $VerifyGUI, "", 0, 0, 215, 150, BitOR($LBS_SORT, $WS_HSCROLL, $WS_VSCROLL, $WS_BORDER, $LBS_NOSEL))
$VerifyGUI_Close_btn = GUICtrlCreateButton("Close", 60, 150, 100)

GUISetState(@SW_SHOW, $mGUI)
ControlClick("Remmanaut Installer", "", $server_radio)

;Main GUI loop
While 1
	Switch GUIGetMsg()

		Case $server_radio
			$InstName = "Remmanaut server"
			GUICtrlSetState($Install_btn, $GUI_DISABLE)
			GUICtrlSetState($ServerIP_label, $GUI_HIDE)
			GUICtrlSetState($ServerIP_input, $GUI_HIDE)
			GUICtrlSetState($MgmPort_label, $GUI_SHOW)
			GUICtrlSetState($MgmPort_input, $GUI_SHOW)
			GUICtrlSetState($MsgPort_label, $GUI_SHOW)
			GUICtrlSetState($MsgPort_input, $GUI_SHOW)
			GUICtrlSetData($inst_dir_input, @HomeDrive & "\"&$InstName)
			GUICtrlSetState($StartLog_check, $GUI_CHECKED)
			;Check if already installed
			CheckInst()

		Case $agent_radio
			$InstName = "Remmanaut agent"
			GUICtrlSetState($Install_btn, $GUI_DISABLE)
			GUICtrlSetState($ServerIP_label, $GUI_SHOW)
			GUICtrlSetState($ServerIP_input, $GUI_SHOW)
			GUICtrlSetState($MgmPort_label, $GUI_HIDE)
			GUICtrlSetState($MgmPort_input, $GUI_HIDE)
			GUICtrlSetState($MsgPort_label, $GUI_SHOW)
			GUICtrlSetState($MsgPort_input, $GUI_SHOW)
			GUICtrlSetData($inst_dir_input, @HomeDrive & "\"&$InstName)
			GUICtrlSetState($StartLog_check, $GUI_CHECKED)
			;Check if already installed
			CheckInst()

		Case $mgm_radio
			$InstName = "Remmanaut management"
			GUICtrlSetState($Install_btn, $GUI_DISABLE)
			GUICtrlSetState($ServerIP_label, $GUI_SHOW)
			GUICtrlSetState($ServerIP_input, $GUI_SHOW)
			GUICtrlSetState($MgmPort_label, $GUI_SHOW)
			GUICtrlSetState($MgmPort_input, $GUI_SHOW)
			GUICtrlSetState($MsgPort_label, $GUI_HIDE)
			GUICtrlSetState($MsgPort_input, $GUI_HIDE)
			GUICtrlSetData($inst_dir_input, @HomeDrive & "\"&$InstName)
			GUICtrlSetState($StartLog_check, $GUI_UNCHECKED)
			;Check if already installed
			CheckInst()

		Case $dir_browse_btn
			$sFileSelectFolder = FileSelectFolder("Select a folder", @HomeDrive)
			If Not @error Then GUICtrlSetData($inst_dir_input, $sFileSelectFolder)

		Case $Verify_btn
			$FilePort = GUICtrlRead($FilePort_input)
			$MgmPort = GUICtrlRead($MgmPort_input)
			$MsgPort = GUICtrlRead($MsgPort_input)
			$ServerIP = GUICtrlRead($ServerIP_input)

			ShellExecute('netsh', 'advfirewall firewall add rule name="Remmanaut outgoing ports" dir=out action=allow protocol=TCP localport='&$FilePort&","&$MgmPort&","&$MsgPort, "", "", @SW_HIDE)

			;If server installation, verify incomming ports and MySQL
			If GUICtrlRead($server_radio) = $GUI_CHECKED Then
				FileInstall("libmysql.dll", @ScriptDir & "\libmysql.dll", 1)
				GUISetState(@SW_SHOW, $VerifyGUI)
				VerifyServer()
				If $VerifyOK = 4 Then
					_GUICtrlListBox_InsertString($StatusListbox, "")
					_GUICtrlListBox_InsertString ( $StatusListbox, "All connections verified, ready to install!" )
					GUICtrlSetState($Install_btn, $GUI_ENABLE)
				Else
					_GUICtrlListBox_InsertString ($StatusListbox, "")
					_GUICtrlListBox_InsertString ( $StatusListbox, "Remmanaut not ready to install :(" )
					_GUICtrlListBox_InsertString ( $StatusListbox, "Check errorlog.txt for details." )
				EndIf
				FileDelete(@ScriptDir&"\libmysql.dll")
			EndIf

			;If agent installation, verify communication with Remmanaut server
			If GUICtrlRead($agent_radio) = $GUI_CHECKED Then
				If $ServerIP <> "" then
					GUISetState(@SW_SHOW, $VerifyGUI)
					VerifyAgent()
					If $VerifyOK = 2 Then
						_GUICtrlListBox_InsertString($StatusListbox, "")
						_GUICtrlListBox_InsertString ( $StatusListbox, "All connections verified, ready to install!" )
						GUICtrlSetState($Install_btn, $GUI_ENABLE)
					Else
						_GUICtrlListBox_InsertString($StatusListbox, "")
						_GUICtrlListBox_InsertString ( $StatusListbox, "Remmanaut not ready to install :(" )
						_GUICtrlListBox_InsertString ( $StatusListbox, "Check errorlog.txt for details." )
					EndIf
				Else
					MsgBox(0, "No IP-adress", "Please enter IP adress to the Remmanaut server", 0, $mGUI)
				EndIf
			EndIf

			;If management installation, verify communication with Remmanaut server
			If GUICtrlRead($mgm_radio) = $GUI_CHECKED Then
				If $ServerIP <> "" then
					GUISetState(@SW_SHOW, $VerifyGUI)
					VerifyManagement()
					If $VerifyOK = 2 Then
						_GUICtrlListBox_InsertString($StatusListbox, "")
						_GUICtrlListBox_InsertString ( $StatusListbox, "All connections verified, ready to install!" )
						GUICtrlSetState($Install_btn, $GUI_ENABLE)
					Else
						_GUICtrlListBox_InsertString($StatusListbox, "")
						_GUICtrlListBox_InsertString ( $StatusListbox, "Remmanaut not ready to install :(" )
						_GUICtrlListBox_InsertString ( $StatusListbox, "Check errorlog.txt for details." )
					EndIf
				Else
					MsgBox(0, "No IP-adress", "Please enter IP adress to the Remmanaut server", 0, $mGUI)
				EndIf
			EndIf


		Case $VerifyGUI_Close_btn
			GUISetState(@SW_HIDE, $VerifyGUI)
			_GUICtrlListBox_ResetContent ( $StatusListbox )


		Case $Install_btn
			$StartLog = GUICtrlRead($StartLog_check)
			$DeskShort = GUICtrlRead($DeskShort_check)
			$Installpath = GUICtrlRead($inst_dir_input)

			;Install server
			If GUICtrlRead($server_radio) = $GUI_CHECKED Then
				FileInstall("libmysql.dll", @ScriptDir & "\libmysql.dll", 1)
				ShellExecute('netsh', 'advfirewall firewall add rule name="Remmanaut incomming ports" dir=in action=allow protocol=TCP localport='&$FilePort&","&$MgmPort&","&$MsgPort, "", "", @SW_HIDE)

				If @OSArch = "X64" Then
					RegWrite("HKLM64\SOFTWARE\"&$InstName, "InstallPath", "REG_SZ", $Installpath)
				Else
					RegWrite("HKLM\SOFTWARE\"&$InstName, "InstallPath", "REG_SZ", $Installpath)
				EndIf

				DirCreate($Installpath & "\file_in")
				DirCreate($Installpath & "\file_out")
				IniWrite($Installpath & "\Settings.ini", "General", "Log-GUI", $StartLog)
				IniWrite($Installpath & "\Settings.ini", "Variables", "MsgPort", $MsgPort)
				IniWrite($Installpath & "\Settings.ini", "Variables", "FilePort", $FilePort)
				IniWrite($Installpath & "\Settings.ini", "Variables", "MgmPort", $MgmPort)
				CreateDB()
				FileInstall("Remmanaut-agent connector.exe", $Installpath & "\Remmanaut-agent connector.exe", 1)
				FileInstall("Remmanaut-management connector.exe", $Installpath & "\Remmanaut-management connector.exe", 1)
				FileInstall("Remmanaut-transfer connector.exe", $Installpath & "\Remmanaut-transfer connector.exe", 1)
				FileInstall("Remmanaut-server maintenance.exe", $Installpath & "\Remmanaut-server maintenance.exe", 1)
				FileInstall("Remmanaut-server launcher.exe", $Installpath & "\Remmanaut-server launcher.exe", 1)
				FileInstall("fileupdate.exe", $Installpath & "\file_out\fileupdate.exe", 1)
				FileInstall("Log-GUI.exe", $Installpath & "\Log-GUI.exe", 1)
				FileInstall("libmysql.dll", $Installpath & "\libmysql.dll", 1)

				If $DeskShort = 1 then FileCreateShortcut ( $Installpath&"\Remmanaut-Server launcher.exe", @DesktopCommonDir&"\"&$InstName&".lnk" , $Installpath)
				FileDelete(@ScriptDir&"\libmysql.dll")
				Exit MsgBox(0, "Done!", "Server installation finished."&@CRLF&"Exiting...")
			EndIf

			;Install agent
			If GUICtrlRead($agent_radio) = $GUI_CHECKED Then
				If @OSArch = "X64" Then
					RegWrite("HKLM64\SOFTWARE\"&$InstName, "InstallPath", "REG_SZ", $Installpath)
				Else
					RegWrite("HKLM\SOFTWARE\"&$InstName, "InstallPath", "REG_SZ", $Installpath)
				EndIf
				DirCreate($Installpath)
				IniWrite($Installpath & "\Settings.ini", "General", "Log-GUI", $StartLog)
				IniWrite($Installpath & "\Settings.ini", "Variables", "FilePort", $FilePort)
				IniWrite($Installpath & "\Settings.ini", "Variables", "MsgPort", $MsgPort)
				IniWrite($Installpath & "\Settings.ini", "Variables", "Remmanaut_Server_IP", $ServerIP)
				FileInstall("Log-GUI.exe", $Installpath & "\Log-GUI.exe", 1)
				FileInstall("Remmanaut-agent.exe", $Installpath & "\Remmanaut-agent.exe", 1)
				FileInstall("PsExec.exe", $Installpath & "\PsExec.exe", 1)
				If $DeskShort = 1 then FileCreateShortcut ( $Installpath&"\Remmanaut-agent.exe", @DesktopCommonDir&"\"&$InstName&".lnk" , $Installpath)
				Exit MsgBox(0, "Done!", "Agent installation finished."&@CRLF&"Exiting...")
			EndIf

			;Install management
			If GUICtrlRead($mgm_radio) = $GUI_CHECKED Then
				$Installpath = GUICtrlRead($inst_dir_input)
				$FilePort = GUICtrlRead($FilePort_input)
				$MgmPort = GUICtrlRead($MgmPort_input)

				If @OSArch = "X64" Then
					RegWrite("HKLM64\SOFTWARE\"&$InstName, "InstallPath", "REG_SZ", $Installpath)
				Else
					RegWrite("HKLM\SOFTWARE\"&$InstName, "InstallPath", "REG_SZ", $Installpath)
				EndIf
				DirCreate($Installpath)
				IniWrite($Installpath & "\Settings.ini", "General", "Log-GUI", $StartLog)
				IniWrite($Installpath & "\Settings.ini", "Variables", "FilePort", $FilePort)
				IniWrite($Installpath & "\Settings.ini", "Variables", "MgmPort", $MgmPort)
				IniWrite($Installpath & "\Settings.ini", "Variables", "Remmanaut_Server_IP", $ServerIP)
				FileInstall("Log-GUI.exe", $Installpath & "\Log-GUI.exe", 1)
				FileInstall("Remmanaut-management.exe", $Installpath & "\Remmanaut-management.exe", 1)
				If $DeskShort = 1 then FileCreateShortcut ( $Installpath&"\Remmanaut-management.exe", @DesktopCommonDir&"\"&$InstName&".lnk" , $Installpath)
				Exit MsgBox(0, "Done!", "Management tool installation finished."&@CRLF&"Exiting...")
			EndIf


		Case $Uninstall_btn
			If @OSArch = "X64" Then
				$Installpath = RegRead("HKLM64\SOFTWARE\"&$InstName, "InstallPath")
				RegDelete("HKLM64\SOFTWARE\"&$InstName)
			Else
				$Installpath = RegRead("HKLM\SOFTWARE\"&$InstName, "InstallPath")
				RegDelete("HKLM\SOFTWARE\"&$InstName)
			EndIf
			DirRemove ( $Installpath, 1 )
			FileDelete(@DesktopCommonDir&"\"&$InstName&".lnk")
			MsgBox(0, "Done!", $InstName&" uninstall complete."&@CRLF&"Exiting...")
			Exit



		Case $GUI_EVENT_CLOSE
			ExitLoop

	EndSwitch

WEnd
GUIDelete($mGUI)




;Functions----------------------------------------------
Func VerifyServer()
	$VerifyOK = 0
	_GUICtrlListBox_InsertString ( $StatusListbox, "Verifying incomming port " & $FilePort & "..." )
	_GUICtrlListBox_InsertString ( $StatusListbox, "Verifying incomming port " & $MgmPort & "..." )
	_GUICtrlListBox_InsertString ( $StatusListbox, "Verifying incomming port " & $MsgPort & "..." )
	_GUICtrlListBox_InsertString ( $StatusListbox, "Verifying MySQL connection..." )

	;Verify File port
	WANCheck($FilePort)
	If $PortStatus = "BUSY" Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Port " & $FilePort & " could not be initiated, maybe another service is listening on this port?")
	ElseIf $PortStatus = "FAILED" Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Port " & $FilePort & " did not respond for incomming trafic, please open the port and/or create a port forward to this machine in the firewall.")
	EndIf
	_GUICtrlListBox_ReplaceString ( $StatusListbox, 0, "Verifying incomming port " & $FilePort & "..."&$PortStatus )
	If $PortStatus = "OK" Then $VerifyOK = $VerifyOK + 1

	;Verify Management port
	WANCheck($MgmPort)
	If $PortStatus = "BUSY" Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Port " & $MgmPort & " could not be initiated, maybe another service is listening on this port?")
	ElseIf $PortStatus = "FAILED" Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Port " & $MgmPort & " did not respond for incomming trafic, please open the port and/or create a port forward to this machine in the firewall.")
	EndIf
	_GUICtrlListBox_ReplaceString ( $StatusListbox, 1, "Verifying incomming port " & $MgmPort & "..."&$PortStatus )
	If $PortStatus = "OK" Then $VerifyOK = $VerifyOK + 1


	;Verify Command port
	WANCheck($MsgPort)
	If $PortStatus = "BUSY" Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Port " & $MsgPort & " could not be initiated, maybe another service is listening on this port?")
	ElseIf $PortStatus = "FAILED" Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Port " & $MsgPort & " did not respond for incomming trafic, please open the port and/or create a port forward to this machine in the firewall.")
	EndIf
	_GUICtrlListBox_ReplaceString ( $StatusListbox, 2, "Verifying incomming port " & $MsgPort & "..."&$PortStatus )
	If $PortStatus = "OK" Then $VerifyOK = $VerifyOK + 1

	MySQLCheck()
	If $CreateDB = 0 Then
		_GUICtrlListBox_ReplaceString ( $StatusListbox, 3, "Verifying MySQL connection...FAILED" )
	Else
		_GUICtrlListBox_ReplaceString ( $StatusListbox, 3, "Verifying MySQL connection...OK" )
		$VerifyOK = $VerifyOK + 1
	EndIf
EndFunc   ;==>VerifyServer

Func VerifyAgent()
	$VerifyOK = 0
	_GUICtrlListBox_InsertString ( $StatusListbox, "Connecting to server on port " & $FilePort & "..." )
	_GUICtrlListBox_InsertString ( $StatusListbox, "Connecting to server on port " & $MsgPort & "..." )

	TCPStartup()
	$Socket = _TCPConnect($ServerIP, $FilePort, 1000)
	If @error Or $Socket = '-1' Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Could not connect to Remmanaut server on " & $ServerIP & ":" & $FilePort)
		_GUICtrlListBox_ReplaceString ( $StatusListbox, 0, "Connecting to server on port " & $FilePort & "...FAILED" )
		TCPCloseSocket($Socket)
	Else
		TCPSend($Socket, "test")
		TCPCloseSocket($Socket)
		_GUICtrlListBox_ReplaceString ( $StatusListbox, 0, "Connecting to server on port " & $FilePort & "...OK" )
		$VerifyOK = $VerifyOK + 1
	EndIf

	$Socket = _TCPConnect($ServerIP, $MsgPort, 1000)
	If @error Or $Socket = '-1' Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Could not connect to Remmanaut server on " & $ServerIP & ":" & $MsgPort)
		TCPCloseSocket($Socket)
		_GUICtrlListBox_ReplaceString ( $StatusListbox, 1, "Connecting to server on port " & $MsgPort & "...FAILED" )
	Else
		TCPSend($Socket, "test")
		TCPCloseSocket($Socket)
		_GUICtrlListBox_ReplaceString ( $StatusListbox, 1, "Connecting to server on port " & $MsgPort & "...OK" )
		$VerifyOK = $VerifyOK + 1
	EndIf
	TCPShutdown()
EndFunc   ;==>VerifyAgent


Func VerifyManagement()
	$VerifyOK = 0
	_GUICtrlListBox_InsertString ( $StatusListbox, "Connecting to server on port " & $FilePort & "..." )
	_GUICtrlListBox_InsertString ( $StatusListbox, "Connecting to server on port " & $MgmPort & "..." )

	TCPStartup()
	$Socket = _TCPConnect($ServerIP, $FilePort, 1000)
	If @error Or $Socket = '-1' Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Could not connect to Remmanaut server on " & $ServerIP & ":" & $FilePort)
		_GUICtrlListBox_ReplaceString ( $StatusListbox, 0, "Connecting to server on port " & $FilePort & "...FAILED" )
		TCPCloseSocket($Socket)
	Else
		TCPSend($Socket, "test")
		TCPCloseSocket($Socket)
		_GUICtrlListBox_ReplaceString ( $StatusListbox, 0, "Connecting to server on port " & $FilePort & "...OK" )
		$VerifyOK = $VerifyOK + 1
	EndIf

	$Socket = _TCPConnect($ServerIP, $MgmPort, 1000)
	If @error Or $Socket = '-1' Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Could not connect to Remmanaut server on " & $ServerIP & ":" & $MgmPort)
		TCPCloseSocket($Socket)
		_GUICtrlListBox_ReplaceString ( $StatusListbox, 1, "Connecting to server on port " & $MgmPort & "...FAILED" )
	Else
		TCPSend($Socket, "test")
		TCPCloseSocket($Socket)
		_GUICtrlListBox_ReplaceString ( $StatusListbox, 1, "Connecting to server on port " & $MgmPort & "...OK" )
		$VerifyOK = $VerifyOK + 1
	EndIf
	TCPShutdown()
EndFunc   ;==>VerifyManagement


Func WANCheck($port)
	$host = "www.remmanaut.com"
	$page = "/porttest.php?port=" & $port

	$Socket = _HTTPConnect($host)
	$get = _HTTPGet($host, $page, $Socket)

	TCPStartup()
	$Listen = TCPListen("0.0.0.0", $port)
	If @error Or $Listen = '-1' Then
		$PortStatus = "BUSY"
	Else
		$Client = TCPAccept($Listen)
		$recv = _HTTPRead($Socket, 1)
		TCPCloseSocket($Client)
		$recvarray = StringSplit($recv[4], "|")
		$ExternalIP = $recvarray[1]
		$PortStatus = $recvarray[2]
	EndIf
	TCPCloseSocket($Listen)
	TCPShutdown()
EndFunc   ;==>WANCheck

Func MySQLCheck()
	$CreateDB = 0
	_MySQL_InitLibrary()
	If @error Then
		_FileWriteLog(@ScriptDir & "\errorlog.txt", "Could not initiate MySQL library")
	Else
		$MysqlSession = _MySQL_Init()
		$Connection = _MySQL_Real_Connect($MysqlSession, "localhost", "root", "")
		If $Connection = 0 Then
			_FileWriteLog(@ScriptDir & "\errorlog.txt", _MySQL_Error($MysqlSession))
		Else
			;Create Databse "Remmanaut"
			$query = "CREATE DATABASE IF NOT EXISTS remmanaut"
			$SQL_Return = _MySQL_Real_Query($MysqlSession, $query)
			If $SQL_Return <> 0 Then
				_FileWriteLog(@ScriptDir & "\errorlog.txt", "SQl Error: " & _MySQL_Error($MysqlSession))
			Else
				$CreateDB = 1
			EndIf
			;Close the MySql session
			_MySQL_Close($MysqlSession)
			;Close the MySql library
			_MySQL_EndLibrary()
		EndIf
	EndIf
EndFunc   ;==>MySQLCheck

Func _TCPConnect($sIPAddr, $iPort, $iTimeOut = -1)
	Local $hWs2 = DllOpen("Ws2_32.dll")
	Local $iDllErr, $fError = False, $aRes
	Local $hSock = DllCall($hWs2, "uint", "socket", "int", 2, "int", 1, "int", 6)
	If @error Then
		$iDllErr = 3
	ElseIf $hSock[0] = 4294967295 Or $hSock[0] = -1 Then
		$fError = True
	Else
		$hSock = $hSock[0]
		$aRes = DllCall($hWs2, "ulong", "inet_addr", "str", $sIPAddr)
		If @error Or $aRes[0] = -1 Or $aRes[0] = 4294967295 Then
			$iDllErr = 1
		Else
			$iPort = DllCall($hWs2, "ushort", "htons", "ushort", $iPort)
			If @error Then
				$iDllErr = 2
			Else
				$iPort = $iPort[0]
			EndIf
		EndIf
		If 0 = $iDllErr Then
			Local $tSockAddr = DllStructCreate("short sin_family;ushort sin_port; ulong sin_addr;char sin_zero[8];")
			DllStructSetData($tSockAddr, 1, 2)
			DllStructSetData($tSockAddr, 2, $iPort)
			DllStructSetData($tSockAddr, 3, $aRes[0])

			If IsKeyword($iTimeOut) Or $iTimeOut = 0 Then $iTimeOut = Opt("TCPTimeout")

			If $iTimeOut > -1 Then DllCall($hWs2, "int", "ioctlsocket", "int", $hSock, "long", 0x8004667e, "uint*", 1)
			$aRes = DllCall($hWs2, "int", "connect", "int", $hSock, "ptr", DllStructGetPtr($tSockAddr), "int", DllStructGetSize($tSockAddr))

			Select
				Case @error
					$iDllErr = 4
				Case $aRes[0] <> 0
					$aRes = DllCall($hWs2, "int", "WSAGetLastError")
					If Not @error And $aRes[0] = 10035 Then ContinueCase
					$fError = True
				Case $iTimeOut > -1
					If IsKeyword($iTimeOut) Or $iTimeOut = 0 Then $iTimeOut = Opt("TCPTimeout")
					Local $t = DllStructCreate("uint;int")
					DllStructSetData($t, 1, 1)
					DllStructSetData($t, 2, $hSock)
					Local $to = DllStructCreate("long;long")
					DllStructSetData($to, 1, Floor($iTimeOut / 1000))
					DllStructSetData($to, 2, Mod($iTimeOut, 1000))
					$aRes = DllCall($hWs2, "int", "select", "int", $hSock, "ptr", DllStructGetPtr($t), "ptr", DllStructGetPtr($t), "ptr", 0, "ptr", DllStructGetPtr($to))
					If Not @error And $aRes[0] = 0 Then
						$aRes = DllCall($hWs2, "int", "WSAGetLastError")
						If Not @error And $aRes[0] = 0 Then
							$iDllErr = 10060
						Else
							$fError = True
						EndIf
					Else
						DllCall($hWs2, "int", "ioctlsocket", "int", $hSock, "long", 0x8004667e, "uint*", 0)
					EndIf
			EndSelect
		EndIf
	EndIf
	If $iDllErr Then
		TCPCloseSocket($hSock)
		$hSock = -1
	ElseIf $fError Then
		$iDllErr = DllCall($hWs2, "int", "WSAGetLastError")
		If Not @error Then $iDllErr = $iDllErr[0]
		If $iDllErr = 0 Then $iDllErr = 5
		TCPCloseSocket($hSock)
		$hSock = -1
	EndIf
	DllClose($hWs2)
	Return SetError($iDllErr, 0, $hSock)
EndFunc   ;==>_TCPConnect

Func CreateDB()

	;Initiate MySql library
	_MySQL_InitLibrary()
	If @error Then Exit MsgBox(0, 'Error', "Could not initiate library")

	;Initiate MySQL connection and connect to root
	$MysqlSession = _MySQL_Init()
	$Connection = _MySQL_Real_Connect($MysqlSession, "localhost", "root", "")
	If $Connection = 0 Then
		$errno = _MySQL_errno($MysqlSession)
		MsgBox(0, "Error:", $errno & @LF & _MySQL_error($MysqlSession))
		If $errno = $CR_UNKNOWN_HOST Then Exit MsgBox(0, "Error:", "$CR_UNKNOWN_HOST" & @LF & $CR_UNKNOWN_HOST)
	EndIf

	;Delete old DB
	$query = "DROP DATABASE remmanaut"
	$SQL_Result = _MySQL_Real_Query($MysqlSession, $query)

	;Create Databse "Remmanaut"
	$query = "CREATE DATABASE remmanaut"
	$SQL_Return = _MySQL_Real_Query($MysqlSession, $query)
	If $SQL_Return <> 0 Then MsgBox(0, "", "SQl Error: " & _MySQL_Error($MysqlSession))

	;Use DB for table creation
	$query = "USE remmanaut"
	$SQL_Return = _MySQL_Real_Query($MysqlSession, $query)
	If $SQL_Return <> 0 Then MsgBox(0, "", "SQl Error: " & _MySQL_Error($MysqlSession))

	;Create table "agents"
	$query = "CREATE TABLE IF NOT EXISTS agents (" & _
			"agent_id VARCHAR(100) NOT NULL," & _
			"agent_name VARCHAR(100) NOT NULL," & _
			"last_checkin TIMESTAMP NOT NULL," & _
			"status VARCHAR(100) NOT NULL," & _
			"first_checkin TIMESTAMP NOT NULL," & _
			"checkin_interval int(100) NOT NULL," & _
			"working_dir VARCHAR(250) NOT NULL," & _
			"PRIMARY KEY (`agent_id`) ," & _
			"UNIQUE INDEX agent_id_UNIQUE (`agent_id` ASC) );"
	$SQL_Return = _MySQL_Real_Query($MysqlSession, $query)
	If $SQL_Return <> 0 Then MsgBox(0, "", "SQl Error: " & _MySQL_Error($MysqlSession))

	;Create table "action_queue"
	$query = "CREATE TABLE IF NOT EXISTS action_queue (" & _
			"RowID INT NOT NULL AUTO_INCREMENT," & _
			"agent_id VARCHAR(100) NOT NULL," & _
			"schedule TIMESTAMP NOT NULL," & _
			"action VARCHAR(100) NOT NULL," & _
			"parameter1 VARCHAR(100) NOT NULL," & _
			"parameter2 VARCHAR(100) NOT NULL," & _
			"parameter3 VARCHAR(100) NOT NULL," & _
			"parameter4 VARCHAR(100) NOT NULL," & _
			"parameter5 VARCHAR(100) NOT NULL," & _
			"PRIMARY KEY (`RowID`) ," & _
			"UNIQUE INDEX RowID_UNIQUE (`RowID` ASC) );"
	$SQL_Return = _MySQL_Real_Query($MysqlSession, $query)
	If $SQL_Return <> 0 Then MsgBox(0, "", "SQl Error: " & _MySQL_Error($MysqlSession))

	;Create table "agent_systemfiles"
	$query = "CREATE TABLE IF NOT EXISTS agent_systemfiles (" & _
			"RowID INT NOT NULL AUTO_INCREMENT," & _
			"filename varchar(100) NOT NULL," & _
			"hash varchar(100) NOT NULL," & _
			"PRIMARY KEY (`RowID`) ," & _
			"UNIQUE INDEX RowID_UNIQUE (`RowID` ASC) );"
	$SQL_Return = _MySQL_Real_Query($MysqlSession, $query)
	If $SQL_Return <> 0 Then MsgBox(0, "", "SQl Error: " & _MySQL_Error($MysqlSession))

	;Insert row defining systemfile psexec.exe
	$query = 'INSERT INTO agent_systemfiles (filename,hash) VALUES (' & _
			'"psexec.exe","0xA7F7A0F74C8B48F1699858B3B6C11EDA");'
	$SQL_Result = _MySQL_Real_Query($MysqlSession, $query)
	If $SQL_Return <> 0 Then MsgBox(0, "", "SQl Error: " & _MySQL_Error($MysqlSession))

	;Create table "hw_audit"
	$query = "CREATE TABLE IF NOT EXISTS hw_audit (" & _
			"RowID INT NOT NULL AUTO_INCREMENT," & _
			"agent_ref INT NOT NULL," & _
			"hw_name varchar(100) NOT NULL," & _
			"hw_info varchar(100) NOT NULL," & _
			"PRIMARY KEY (`RowID`) ," & _
			"UNIQUE INDEX RowID_UNIQUE (`RowID` ASC) );"
	$SQL_Return = _MySQL_Real_Query($MysqlSession, $query)
	If $SQL_Return <> 0 Then MsgBox(0, "", "SQl Error: " & _MySQL_Error($MysqlSession))

	;Create table "sw_audit"
	$query = "CREATE TABLE IF NOT EXISTS sw_audit (" & _
			"RowID INT NOT NULL AUTO_INCREMENT," & _
			"agent_ref INT NOT NULL," & _
			"sw_name varchar(100) NOT NULL," & _
			"sw_info varchar(100) NOT NULL," & _
			"PRIMARY KEY (`RowID`) ," & _
			"UNIQUE INDEX RowID_UNIQUE (`RowID` ASC) );"
	$SQL_Return = _MySQL_Real_Query($MysqlSession, $query)
	If $SQL_Return <> 0 Then MsgBox(0, "", "SQl Error: " & _MySQL_Error($MysqlSession))

	;Create table "monitor"
;~ 	$query =	"CREATE TABLE IF NOT EXISTS monitor (" & _
;~ 				"agent_id INT NOT NULL," & _
;~ 				"agent_name TEXT NOT NULL," & _
;~ 				"PRIMARY KEY (`agent_id`) ," & _
;~ 				"UNIQUE INDEX agent_id_UNIQUE (`agent_id` ASC) );"
;~ 	$SQL_Return = _MySQL_Real_Query($MysqlSession, $query)
;~ 	If $SQL_Return <> 0 then MsgBox(0, "", "SQl Error: "&_MySQL_Error($MysqlSession))


	;Close the MySql session
	_MySQL_Close($MysqlSession)
	;Close the MySql library
	_MySQL_EndLibrary()
EndFunc   ;==>CreateDB

Func CheckInst()
	If @OSArch = "X64" Then
		$Installpath = RegRead("HKLM64\SOFTWARE\"&$InstName, "InstallPath")
		If @error then
			GUICtrlSetState($Uninstall_btn, $GUI_DISABLE)
		Else
			GUICtrlSetState($Uninstall_btn, $GUI_ENABLE)
		EndIf
	Else
		$Installpath = RegRead("HKLM\SOFTWARE\"&$InstName, "InstallPath")
		If @error then
			GUICtrlSetState($Uninstall_btn, $GUI_DISABLE)
		Else
			GUICtrlSetState($Uninstall_btn, $GUI_ENABLE)
		EndIf
	EndIf
EndFunc
