#cs ----------------------------------------------------------------------------

 Remmanaut, the autoit RMM tool

 Script function:		Agent process, communicates with Remmanaut agent connector
 Version:				0.2.3

 Author:				Faldo / Erik Ribbhammar
 UDF Credits:			lod3n (_RunReadStd), dantay9 (TCP File Transfer),
						Prog@ndy (MySQL)
 Helping Credits:

#ce ----------------------------------------------------------------------------
#NoTrayIcon
#include <GUIConstantsEx.au3>
#include <GuiListView.au3>
#include <GuiImageList.au3>
#include <ButtonConstants.au3>
#include <WindowsConstants.au3>
#include <GuiDateTimePicker.au3>
#include <Date.au3>

#include <File.au3>
#include <Array.au3>
#include <Process.au3>
#include <Crypt.au3>

;Predefined variables
Global $Remmanaut_Server_IP = IniRead ( "settings.ini", "variables", "Remmanaut_Server_IP", "0.0.0.0" )
Global $MgmPort = IniRead ( "settings.ini", "variables", "MgmPort", "5076" )
Global $FilePort = IniRead ( "settings.ini", "variables", "FilePort", "5075" )
Global $sSerial = DriveGetSerial(@HomeDrive & "\")
Global $Recv, $RecvArray, $AgentListArray, $timeout, $Agent_ListView


;Start Log GUI if defined in settings.ini and not running as system
If IniRead ( "settings.ini", "general", "log-gui", "1" ) = 1 then
	Run("Log-GUI.exe", @ScriptDir)
EndIf

;Create Main GUI
$mGUI = GUICreate("Remmanaut Management", 800, 300)

	;Create ListView
	$Agent_ListView = GUICtrlCreateListView ("", 25, 10, 750, 220)
	_GUICtrlListView_SetExtendedListViewStyle($Agent_ListView, BitOR($LVS_EX_FULLROWSELECT, $LVS_EX_SUBITEMIMAGES))

	; Add columns
	_GUICtrlListView_InsertColumn($Agent_ListView, 0, "Agent name", 150)
	_GUICtrlListView_InsertColumn($Agent_ListView, 1, "Last checkin", 120)
	_GUICtrlListView_InsertColumn($Agent_ListView, 2, "Checkin interval", 100)
	_GUICtrlListView_InsertColumn($Agent_ListView, 3, "Working directory", 200)
	_GUICtrlListView_InsertColumn($Agent_ListView, 4, "Agent ID", 175)

	;Define status colors
	$hImage = _GUIImageList_Create()
	_GUIImageList_Add($hImage, _GUICtrlListView_CreateSolidBitMap($Agent_ListView, 0xFF0000, 16, 16))
	_GUIImageList_Add($hImage, _GUICtrlListView_CreateSolidBitMap($Agent_ListView, 0x00B200, 16, 16))
	_GUIImageList_Add($hImage, _GUICtrlListView_CreateSolidBitMap($Agent_ListView, 0x0000FF, 16, 16))
	_GUICtrlListView_SetImageList($Agent_ListView, $hImage, 1)

	;Create context menu
	$idListcontext = GUICtrlCreateContextMenu($Agent_ListView)
	$idMenu_Shell = GUICtrlCreateMenuItem("Remote shell", $idListcontext)
	$idMenu_Shedule = GUICtrlCreateMenuItem("Scheduled actions", $idListcontext)

	;Create lables
	$mGUI_Info = GUICtrlCreateLabel("Right-click an agent from the list and choose function.",25, 230)

	;Create buttons
	$mGUI_Upd_Btn = GUICtrlCreateButton("Update list", 600, 250, 100)

;Create CMD GUI
$ShellGUI = GUICreate("Execute shell command", 250, 200, -1, -1, $WS_EX_TOOLWINDOW, -1, $mGUI)
	$ShellGUI_info_label = GUICtrlCreateLabel("", 10, 5, 180, 40)
	GUICtrlCreateLabel("Enter command to execute: ", 10, 25, 180, 20)
	$command = GUICtrlCreateInput("", 10, 40, 220, 20)
	GUICtrlCreateLabel("Schedule the command to run at: ", 10, 65, 180, 20)
	$DTP = GUICtrlGetHandle(GUICtrlCreateDate("", 10, 80, 120, 20))
	_GUICtrlDTP_SetFormat($DTP, "yyyy-MM-dd HH:mm")
	$ShellGUI_Close_Btn = GUICtrlCreateButton("Close", 20, 130, 100)
	$ShellGUI_Send_Btn = GUICtrlCreateButton("Send", 130, 130, 100, -1, $BS_DEFPUSHBUTTON)

;Create Schedule GUI
$SchedGUI = GUICreate("View scheduled actions", 400, 250, -1, -1, $WS_EX_TOOLWINDOW, -1, $mGUI)
	$ShedGUI_info_label = GUICtrlCreateLabel("", 10, 5, 180, 40)
	$AgentShed_ListView = _GUICtrlListView_Create ($SchedGUI, "", 10, 25, 370, 150)
	_GUICtrlListView_SetExtendedListViewStyle($AgentShed_ListView, BitOR($LVS_EX_FULLROWSELECT, $LVS_EX_SUBITEMIMAGES))
	_GUICtrlListView_InsertColumn($AgentShed_ListView, 0, "Action type", 70)
	_GUICtrlListView_InsertColumn($AgentShed_ListView, 1, "Action parameters", 180)
	_GUICtrlListView_InsertColumn($AgentShed_ListView, 2, "Scheduled at", 120)
	$SchedGUI_Close_Btn = GUICtrlCreateButton("Close", 150, 180, 100)





GUISetState(@SW_SHOW, $mGUI)
UpdateAgentList()
GUIRegisterMsg($WM_NOTIFY, "WM_Notify_Events")

;Main GUI loop
While 1
	Switch GUIGetMsg()

		Case $idMenu_Shell
			GUICtrlSetData ( $DTP, _Now())
			; Set system time
			Local $a_Date[7] = [False, @YEAR, @MON, @MDAY, @HOUR, @MIN, @SEC]
			_GUICtrlDTP_SetSystemTime ( $DTP, $a_Date)
			$Selected = _GUICtrlListView_GetSelectedIndices ($Agent_ListView)
			IF $Selected and _GUICtrlListView_GetItemText ( $Agent_ListView, $Selected) <> "No agents available" Then
				$Selected = $Selected +1
				GUICtrlSetData($ShellGUI_info_Label, "Agent: "&$AgentListArray[$Selected*7-5])
				GUICtrlSetData($command, "")
				GUISetState(@SW_SHOW, $ShellGUI)
			Else
				MsgBox ( 0, "No agent selected", "Please right-click an agent from the list.", 0, $mGUI)
			EndIf
		Case $idMenu_Shedule
			$Selected = _GUICtrlListView_GetSelectedIndices ($Agent_ListView)
			IF $Selected and _GUICtrlListView_GetItemText ( $Agent_ListView, $Selected) <> "No agents available" Then
				$Selected = $Selected +1
				GUICtrlSetData($ShedGUI_info_Label, "Schedule for agent: "&$AgentListArray[$Selected*7-5])
				UpdateSheduleList()
				GUISetState(@SW_SHOW, $SchedGUI)
			Else
				MsgBox ( 0, "No agent selected", "Please right-click an agent from the list.", 0, $mGUI)
			EndIf


		Case $mGUI_Upd_Btn
			UpdateAgentList()

			Case $ShellGUI_Send_Btn
				$g_tDate = _GUICtrlDTP_GetSystemTimeEx($DTP)
				If GUICtrlRead($command) <> "" then
					$agentID = _GUICtrlListView_GetItem ($Agent_ListView, $Selected-1, 4 )
					$Schedule = StringFormat("%04d-%02d-%02d", DllStructGetData($g_tDate, "Year"), DllStructGetData($g_tDate, "Month"), DllStructGetData($g_tDate, "Day")) &" "&StringFormat("%02d:%02d", DllStructGetData($g_tDate, "Hour"), DllStructGetData($g_tDate, "Minute"))
					SendMgm("cmd_sysuser|"&$agentID[3]&"|"&$Schedule&"|"&GUICtrlRead($command))
					If $RecvArray[1] = 0 then
						GUISetState(@SW_HIDE, $ShellGUI)
					Else
						MsgBox(0, "", "Error scheduling command, please check the server log.")
					EndIf
				Else
					MsgBox ( 0, "No command entered", "Please enter a command and click Send.")
				EndIf


			Case $ShellGUI_Close_Btn
				GUISetState(@SW_HIDE, $ShellGUI)

		Case $ShellGUI_Send_Btn


		Case $SchedGUI_Close_Btn
			GUISetState(@SW_HIDE, $SchedGUI)

		Case $GUI_EVENT_CLOSE
			ExitLoop

	EndSwitch

WEnd
GUIDelete($mGUI)




;-------------------------------Functions----------------------------

Func UpdateAgentList()
	;Update agent inventory list
	SendMgm("agent_inv|"&@ComputerName&"|"&$sSerial)
	$AgentListArray = StringSplit($Recv, "|")
	_GUICtrlListView_DeleteAllItems ( $Agent_ListView )
	If $AgentListArray[1] = "no agents" then
		_GUICtrlListView_AddItem($Agent_ListView, "No agents available",4)
	Else

		$Row = 0
		For $i = 1 to $AgentListArray[0]-1 Step 7
			If $AgentListArray[$i+3] = "offline" then
				$Color = 0
			Else
				$Color = 1
			EndIf
			_GUICtrlListView_AddItem($Agent_ListView, $AgentListArray[$i+1], $Color)
				_GUICtrlListView_AddSubItem($Agent_ListView, $Row, $AgentListArray[$i+2], 1)
				_GUICtrlListView_AddSubItem($Agent_ListView, $Row, $AgentListArray[$i+5]/1000&" seconds", 2)
				_GUICtrlListView_AddSubItem($Agent_ListView, $Row, $AgentListArray[$i+6], 3)
				_GUICtrlListView_AddSubItem($Agent_ListView, $Row, $AgentListArray[$i], 4)
		$Row = $Row+1
		Next
	EndIf
EndFunc

Func UpdateSheduleList()
	;Update agent schedule list
	$agentID = _GUICtrlListView_GetItem ($Agent_ListView, $Selected-1, 4 )
	SendMgm("agent_shed|"&$agentID[3]&"|"&@ComputerName&"|"&$sSerial)
	$ShedListArray = StringSplit($Recv, "|")
;~ _ArrayDisplay($ShedListArray)
	_GUICtrlListView_DeleteAllItems ( $AgentShed_ListView )
	If $ShedListArray[1] = "nothing scheduled" then
		_GUICtrlListView_AddItem($AgentShed_ListView, "",4)
		_GUICtrlListView_AddSubItem($AgentShed_ListView, 0, "Nothing scheduled",1)
	Else

		$Row = 0
		For $i = 1 to $ShedListArray[0]-1 Step 3
			_GUICtrlListView_AddItem($AgentShed_ListView, $ShedListArray[$i+1])
				_GUICtrlListView_AddSubItem($AgentShed_ListView, $Row, $ShedListArray[$i+2], 1)
				_GUICtrlListView_AddSubItem($AgentShed_ListView, $Row, $ShedListArray[$i], 2)
		$Row = $Row+1
		Next
	EndIf
EndFunc


Func SendMgm($message, $timeout = 60000)
	AdlibRegister("timeout", $timeout)
	While 1
		TCPStartup()
		$CmdSocket = TCPConnect($Remmanaut_Server_IP, $MgmPort)
		If @error Or $CmdSocket = '-1' Then
			Exit MsgBox(0, "", "Could not connect to server, Exiting")
		Else
			TCPSend($CmdSocket, $message)
			Do
				$Recv = TCPRecv($CmdSocket, '1000')
				Sleep('100')
			Until $Recv <> ''

			$RecvArray = StringSplit($Recv, "|")

			TCPCloseSocket($CmdSocket)
			TCPShutdown()
			ExitLoop
		EndIf

	WEnd
	AdlibUnRegister()
EndFunc   ;==>SendMsg


Func Timeout()
	If $timeout > 1 then
		_FileWriteLog(@ScriptDir & "\log.txt", "Timeout for server communication reached, exiting.")
		Exit
	EndIf
EndFunc   ;==>Timeout


Func WM_Notify_Events($hWndGUI, $MsgID, $wParam, $lParam)
    #forceref $hWndGUI, $MsgID, $wParam
    Local $tagNMHDR, $event, $hwndFrom, $code
    $tagNMHDR = DllStructCreate("int;int;int", $lParam)
    If @error Then Return
    $event = DllStructGetData($tagNMHDR, 3)
    Select
        Case $wParam = $Agent_ListView
            Select
                Case $event = $NM_RCLICK

            EndSelect
    EndSelect
    $tagNMHDR = 0
    $event = 0
    $lParam = 0
EndFunc   ;==>WM_Notify_Events
