#EndRegion # zConfig

Opt("TrayAutoPause", 0)
Opt("TrayMenuMode", 1)
OnAutoItExitRegister("_EXIT")

#include <ButtonConstants.au3>
#include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#include <GDIPlus.au3>

#Region # GUI
Global Const $AC_SRC_ALPHA = 1
Global $TempDir = @TempDir
If FileExists($TempDir) = 0 Then $TempDir = @ScriptDir
Global $iGUIIMAGE = $TempDir & '\zConfig.png'
Global $iGUIIMAGETSTART = $TempDir & '\bStart.png'
Global $imgTRANSPARENT = $TempDir & '\grey.gif'
FileInstall('zConfig.png', $iGUIIMAGE, 1)
FileInstall('bStart.png', $iGUIIMAGETSTART, 1)
FileInstall('grey.gif', $imgTRANSPARENT, 1)
_GDIPlus_Startup()
Global $hImage = _GDIPlus_ImageLoadFromFile($iGUIIMAGE)
Global $iWidth = _GDIPlus_ImageGetWidth($hImage)
Global $iHeight = _GDIPlus_ImageGetHeight($hImage)
Global $bGUI = GUICreate("zConfig - Mu Laucher", $iWidth, $iHeight, -1, -1, $WS_POPUP, $WS_EX_LAYERED)
_SetCtrlBitmap($bGUI, $hImage, 0)
GUIRegisterMsg($WM_NCHITTEST, "WM_NCHITTEST")
GUISetState()
For $i = 0 To 255 Step 15
	_SetCtrlBitmap($bGUI, $hImage, $i)
Next
Global $iBkColor = 0xF6F4F4
Global $lBkColor = 0x3D107B
Global $cGUI = GUICreate("Dao Van Trong - Trong.CF", $iWidth, $iHeight, 4, 0, $WS_POPUP, BitOR($WS_EX_LAYERED, $WS_EX_MDICHILD), $bGUI)
GUICtrlCreatePic($imgTRANSPARENT, 0, 0, $iWidth, $iHeight)
GUICtrlSetState(-1, $GUI_DISABLE)
GUICtrlCreateLabel("Account ID:", 226, 96, 79, 17)
GUICtrlSetFont(-1, 9, 800)
GUICtrlSetBkColor(-1, $iBkColor)
GUICtrlSetColor(-1, $lBkColor)
GUICtrlCreateLabel("Screen:", 250, 130, 80, 17)
GUICtrlSetFont(-1, 9, 800)
GUICtrlSetBkColor(-1, $iBkColor)
GUICtrlSetColor(-1, $lBkColor)
GUICtrlCreateLabel("Sound:", 265, 189, 44, 17)
GUICtrlSetFont(-1, 9, 800)
GUICtrlSetBkColor(-1, $iBkColor)
GUICtrlSetColor(-1, $lBkColor)
GUICtrlCreateLabel("Color Depth:", 232, 160, 75, 17)
GUICtrlSetFont(-1, 9, 800)
GUICtrlSetBkColor(-1, $iBkColor)
GUICtrlSetColor(-1, $lBkColor)
GUICtrlCreateLabel("Screen Resolution:", 200, 216, 112, 17)
GUICtrlSetFont(-1, 9, 800)
GUICtrlSetBkColor(-1, $iBkColor)
GUICtrlSetColor(-1, $lBkColor)
Global $iMuID = GUICtrlCreateInput("", 300, 93, 121, 21)
Global $cWindowsMode = GUICtrlCreateCheckbox("Windows Mode", 312, 130, 110, 17)
GUICtrlSetBkColor(-1, $iBkColor)
Global $cSoundEffects = GUICtrlCreateCheckbox("Sound Effects", 312, 189, 110, 17)
GUICtrlSetBkColor(-1, $iBkColor)
Global $cMusic = GUICtrlCreateCheckbox("Backgroud Music", 425, 189, 120, 17)
GUICtrlSetBkColor(-1, $iBkColor)
GUICtrlCreateGroup("", -99, -99, 1, 1)
Global $rColor16bit = GUICtrlCreateRadio("Min Color (16 bit)", 312, 160, 110, 17)
GUICtrlSetBkColor(-1, $iBkColor)
Global $rColor32bit = GUICtrlCreateRadio("Max Color (32 bit)", 425, 160, 110, 17)
GUICtrlSetBkColor(-1, $iBkColor)
GUICtrlCreateGroup("", -99, -99, 1, 1)
GUICtrlSetFont(-1, 9, 800)
Global $r800x600 = GUICtrlCreateRadio("800x600", 312, 216, 80, 17)
GUICtrlSetBkColor(-1, $iBkColor)
Global $r1024x768 = GUICtrlCreateRadio("1024x768", 400, 216, 80, 17)
GUICtrlSetBkColor(-1, $iBkColor)
Global $r1280x1024 = GUICtrlCreateRadio("1280x1024", 490, 216, 80, 17)
GUICtrlSetBkColor(-1, $iBkColor)
GUICtrlCreateGroup("", -99, -99, 1, 1)
Global $bSAVE = GUICtrlCreateButton("SAVE", 430, 90, 81, 49)
GUICtrlSetTip(-1, "Save settings.")
GUICtrlSetFont(-1, 9, 800)
Global $bEXIT = GUICtrlCreateButton("EXIT", 585, 210, 45, 25)
GUICtrlSetFont(-1, 9, 800)
Global Const $Play = GUICtrlCreateButton("", 550, 70, 110, 95, BitOR($BS_BITMAP, $BS_CENTER))
GUICtrlSetTip(-1, "Click to Start Game.")
Global Const $hImageX = _GDIPlus_ImageLoadFromFile($iGUIIMAGETSTART)
Global Const $hHBitmapX = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImageX)
_WinAPI_DeleteObject(_SendMessage(GUICtrlGetHandle($Play), $BM_SETIMAGE, $IMAGE_BITMAP, $hHBitmapX))
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
#EndRegion # GUI

GUICtrlSetData($iMuID, "Trong")
GUICtrlSetState($cWindowsMode, $GUI_CHECKED)
GUICtrlSetState($r800x600, $GUI_CHECKED)
GUICtrlSetState($rColor16bit, $GUI_CHECKED)
GUICtrlSetState($cSoundEffects, $GUI_CHECKED)
GUICtrlSetState($cMusic, $GUI_CHECKED)

GUISetState(@SW_SHOW)

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE, $bEXIT
			_EXIT()
		Case $bSAVE
			MsgBox(32, "!", "SAVE", 10, $cGUI)
		Case $Play
			MsgBox(32, "!", "Start", 10, $cGUI)
	EndSwitch
	Sleep(10)
WEnd

Func _EXIT()
	GUIDelete($cGUI)
	For $i = 255 To 0 Step -15
		_SetCtrlBitmap($bGUI, $hImage, $i)
	Next
	_WinAPI_DeleteObject($hImage)
	_GDIPlus_Shutdown()
	Exit
EndFunc   ;==>_EXIT

Func WM_NCHITTEST($hWnd, $iMsg, $iwParam, $ilParam)
	If ($hWnd = $bGUI) And ($iMsg = $WM_NCHITTEST) Then Return $HTCAPTION
EndFunc   ;==>WM_NCHITTEST
Func _SetCtrlBitmap($hGUI, $hImage, $iOpacity)
	Local $hScrDC, $hMemDC, $hBitmap, $hOld, $pSize, $tSize, $pSource, $tSource, $pBlend, $tBlend
	$hScrDC = _WinAPI_GetDC(0)
	$hMemDC = _WinAPI_CreateCompatibleDC($hScrDC)
	$hBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImage)
	$hOld = _WinAPI_SelectObject($hMemDC, $hBitmap)
	$tSize = DllStructCreate($tagSIZE)
	$pSize = DllStructGetPtr($tSize)
	DllStructSetData($tSize, "X", _GDIPlus_ImageGetWidth($hImage))
	DllStructSetData($tSize, "Y", _GDIPlus_ImageGetHeight($hImage))
	$tSource = DllStructCreate($tagPOINT)
	$pSource = DllStructGetPtr($tSource)
	$tBlend = DllStructCreate($tagBLENDFUNCTION)
	$pBlend = DllStructGetPtr($tBlend)
	DllStructSetData($tBlend, "Alpha", $iOpacity)
	DllStructSetData($tBlend, "Format", $AC_SRC_ALPHA)
	_WinAPI_UpdateLayeredWindow($hGUI, $hScrDC, 0, $pSize, $hMemDC, $pSource, 0, $pBlend, $ULW_ALPHA)
	_WinAPI_ReleaseDC(0, $hScrDC)
	_WinAPI_SelectObject($hMemDC, $hOld)
	_WinAPI_DeleteObject($hBitmap)
	_WinAPI_DeleteDC($hMemDC)
EndFunc   ;==>_SetCtrlBitmap
