#include-once
; #INDEX# =======================================================================================================================
; Title .........: _Axis()
; AutoIt Version.: 3.3.6.1
; Language.......: Portuguese (Brazil) - 0416
; Description ...: Compressed file embedded
; Author ........: Usurio
; ===============================================================================================================================

; #CURRENT# =====================================================================================================================
; _Axis()
; ===============================================================================================================================

; #INTERNAL_USE_ONLY# ===========================================================================================================
; __Axis() ; _LZNTDecompress renamed!
; __Axis() ; _Base64 renamed!
; ===============================================================================================================================

; #VARIABLES# ===================================================================================================================
; ===============================================================================================================================

; #FUNCTION# ====================================================================================================================
; Name ..........: _Axis()
; Description ...: Compressed file embedded in your .au3 file
; Syntax ........: _Axis( [ lToSave [, sPath [, lExecute ]]] )
; Parameters ....: lToSave             - [optional] If True, save the file, else, return binary data. Default is False.
;                  sPath               - [optional] The path of the file to be save. Default is @TempDir
;                  lExecute            - [optional] Flag to execute file saved. Default is False
; Return values .: Success             - Returns decompressed Axis.msstyles binary data or saved.
;				     Failure             - Returns 0 and set @error to 1.
; Author(s) .....: Joo Carlos (Jscript FROM Brazil)
; Modified ......: 
; Remarks .......: This function uses _LZNTDecompress() and _Base64Decode() by trancexx.
; Related .......: 
; Link ..........: 
; Example .......; _Axis()
; ===============================================================================================================================
Func _Axis( $lToSave = False, $sPath = @TempDir, $lExecute = False )
	Local $hFileHwnd, $bData, $sFileName = $sPath & "\Axis.msstyles"

	; Original: D:\AutoIt v3 - Projects\Skins-Project\USkinLibrary\Skins\Axis.msstyles
	$bData = "y74ATVqQAAMAAACCBAAw//8AALgAOB0BAEAEOBkAAawOH7oADgC0Cc0huAEATM0hVGhpcyAAcHJvZ3JhbSAAY2Fubm90IGIAZSBydW4gaW4AIERPUyBtb2RAZS4NDQokBIZpgDfR2i1Wv4kFA6CuXuGJLAIH5QIHMFJpY2gBFw17UEUAAABMAQMAPecEfz4FE+AADiELoAEHAADAAAyAAANAsBwAUHodAA8cIwAPAAcAABAAAQAAjgID7wEABQcAAB6BDn8CAAMPAAaCB4UDBgMCAEww9R0AmAEEgCtMdTWPjeSADwygoS0AVVD8WDACBIBtBkgHYgIAAH264IATMQIGgYWBf7yPE4GA8eAucnNyYwQN/cJIdsQMywlMBD8APwA/AA8/AD8APwAWADMuMDcBwYshDQkICU8bADKk+YTNY05RUB0AT7pAB2DCw3RAnt/+kgAIQIBoAA6AIgEAgH6OADSf53mS7KwaAAO+fZrP827aAPQE/"
	$bData &= "DYF//69AKdGEMQOAo5OAFkLgAYOMjMdAIAQb+9vPmA2AAoAQwBPAEwGAFI+AEEATd97AO39AEUAUwAJACsWQgpEKlQGAAwA3rU770YAAElSRUZbCA5JAFh7v/ceRBpQAFZIAA2fJkdnAO97b9pbEEZBAL5LU0UqX2vfAHvfAFarU1ZPAFIJE1prxMLuAHXHVA5YCqMBABzaoN0BAgA6ANovCQRvS9rXAFI4YhEyLLZvAAByAP++NvhtAABhAGwaFmwfAADieABpAHM9AF1oYz8Bz6a0ALnareEGBU8AAPPM2rmK59wQAJ8CQgPkAcF7AAQWBZMEAkCaAM0JHAIsEu75AOGgw9tNckxeAFgASYd39+JfACNJOiY6R2KGANTOh0a7VEu3AGCrvW1Sh19LANNtC9gWJ+NbABimtoDzWwBbAG1OIA8yA0oDAFoTwUa7pDIUAA8Dpz7PBTKGAJ6uRgHH7Y9JAEJ6dQBlCy5+ANGbit1uBi9NAB"
	$bData &= "p0I4rYYu9sAB5jG0/ae+9oAEjWbTpTPmVCAGQfQZEqNlcLAG1zAjkMBSQFADQVMgJADtglAAODTguu57lmAHZOJ71Gg4NTACp6Sp9hKme7AEcH7xZGPm52AHNveBIug4ktAFhhPwEHl3/+AG1NBhwQgDoOAObrAYBglskDAID++eefjl6uAAWAtAyMB4DaALBwCYD46iCmAH86TguAFkcSAA6iOoCXFksSAACuA7iLEj8OABwU4A5fCitiAEW1wOrvITfbAKGbNAcyRBeiAOQBiwsM3g2aAFtmsmKn/aK9AIouXSu2ZF9EAABrPR246MpoADN3DyAAPaydAOf7BjQAMAs1ADZ3l6E9PQ5pAJNnODj3TOwuADEWa0hn4vfaAGi3TA90f2YyAIMOpNhCboc0AHcWKAgUX8/nAHV4DymHdnl2AN4wfM2bcneTAEEWdKThvfciAHY2Q75wGxpuAN5Bu4NCUm5rAC5yVnULbkfwAFpkEzVXNiM"
	$bData &= "BAPvesTdndE5mAHNlWwVDhmHbAGwrGNbgEmdPAKv5NRGs10IDAEgrtZvYzzNqAFv41e62S0dUADZib+ssV3vRAK0HD0JHZH9UAFvSYHvOeH/3ADcfhyFmpzlrAHOOYtd075BtAGOOdxoedg4MAE3Liy6TcxczABfawVEnMo8PAGZc/HgHkmxeAHQzbo5z3TfCABGncrJHRxaxAFHH16dpR3RjANtRe0NLk0kKAGGbrIrFcHmbANeWYhpxi2tjADmiiaXLMm81AMKm73Ywa29TAHI7jzsoejJnAGNJTiPcquO9AFZ02mW3bhYoAFg1c7t7AVYFAInTg61t61jLAFMPNmjYsd+7ABNHk8ts1RNTADk5LWBYuzHWAFNTrlBxsVujAP/n1dqCR0ofAF9HD28YRoczAGcb7yhwbl9pAB9EbnDrho09AGhzr3P2XVxAANAneHNTQnLaAIIA7a8CYj9WADnawbtAV1JkAA9TRQQ4F89OAKdqQBvJ"
	$bData &= "MJJNAIuCQfuxEzhjAFeAY6SFX9p0AKBLwHAvZ5NuAPCGuhb/f1h6AGxvhJYYu3JlAELibKYJt3jWAC5WRo9COniDAPMydBY6QwZlADgmXLzTYq+jAGPQY1X4i7//AG7g8IaKf2dCAHk+RgcPhh9pAMNnK38j9uC2AGVPoldyw4R4ANuCMtsLb+OjADUYsWcTOA9gAN+CXGMPd3VnAHo3W+wyQ8tlADJD9MQNVR9cAIZCj4cnvYLuAFiSQjIXgFywAFCPMjPBExYlAFJ5+xpdDMH3AHYDl2M83sSeAKdfU2c+6x0UAA8mq0QWaXYEAJitex8x6zY3AK0DNowHCzg7AI49hhwzojtyAMZsBb8jciNLAGZEm+54k5dDAK9f7cJ70E0TALcXPOhGW/ILAHK/GEa0I8dvAC8dZLuQ60M/ABjehqMnU9d/AK/aGKmNa+56AHQV2C54aFtrAGuTCnY00lWPAGYrS0EZtttPAHSnazvroPeHAEULD"
	$bData &= "lYivVezAElNY0xvdGOwAGfdC59OrnpSAE/tCK5ts88oACPfa3RtCmQCAJ9hOmwfKTeOALAAE4fLBRK0AFXvAosCjdp0ANs3MS4mYudwAI/mqwGrgtPPAEiXLmjvbrOKAEYpYr8HY7eKAIq3oPe/t6CKALfvx/dMOiqKAM9HS4IK68JwAE/bH2wVBBNvAE8AbjRhdT15AN9PKVgwYUuLAHV38BiLLpptABqKbouwmu+bAAMszFUH1hd7ADNg0IHQC3sUAIpiUMdvTzjoAC5r/3AbHzGWAKMC80YPIXCFAAQ30wLvoWAiAEiORGJXbUSJAFRLP2+a8N5bAAZGAlMyVK86ANBGbDBfGlnCAEUUER7dV04DAGUD2wulgi97ADAXwRpTRKtQAC76jWDG2mIrAAOhYkpxay81AOWoEOM0C1RTAMSMfzMLVrWKAEUHA8mQXDFPAExWSlSfSH9XAFhVbQ/uLA9HAFpVNWJPR4lVANNqP/c66QhBAD"
	$bData &= "MGZXLoxIKoAGPfGgxQrbMoAFqqVmFNNzPfAFgFD6knryGCABFUr18IMYgRAHOPvpVgg+cDAKvaoODSs9PEAKitCePfiSm2ACpP01AxKqJVABvzhKgKxCd7AEwEDDAHUkNvACqlgiKvI7ogACKsrzjCxVCcACtSd6cuGp6CAAJVmlQ2A7QQAElOmzMRp1YlAE8YQaUGhwWlAFbNt9cgKLVrAFvblUrBlbOXAJVWbQH746EkAEsQ86otiErnAPtiCaLS6/OgACouFcfnYAOoAFTT+6lQVKT3AJbqFkTrU23HAKSokFLPn2LnAIoqjzELOigUANrTszGlIBFEAAvTIiaMThcTAEED6NQTDmrQAKob40Kp1DAKAA+fRs1Y0YNbADBjRTUXX60bAIpGyy6CUD0IAPcycA7ubgvEABjEcF0395HgABoF20FTgxEmAJtoZzWlpWE/AJOHW8CItSt3AGOVtmBYz0NsADBCwReDAsW1AGY3I6BrVTE"
	$bData &= "rACeDoTIlYxK2AKYBIE8eZw8GABESKaeCY0CzAFczih0rmGTvAB+/MCqwIOOqAFErGMtfTcJAAMdbRqMoOLhiAOdF+x5d6NKqAJPna6MIuBB7ADGOTUQDLhN0AKO4UgzAN3+wAKAbiU/ClzFQADNSr7EIggVjADP2ZYyodxpwAFcFjojHyjNbABYEphBXMyOoAC6ahzA7hgR7ABN6Dw8rgUWwAB/DZmIxE8PrAFHFNKwnMV8bADRMsXcy/2/HAM6FQhJ05zAVAGu6aE8yW09xADs6UpJIbyYRABNWkTvvtEWqACJPKgskRnRiAJ9EDDgouzi/AEINCYZHQ4hgAAUVQ/tiQVRCADsB55uC90M/AHOrjgVQZ184AIQFFesrD3fCAAoe846KDmENAAdDEL4C4E+aAGaLdJgRWqLfADvX7CY+tBZSAAc4UsQBXyuIACi+KVD3XaeKAINQMK+Ho4MIALkINqVVxrtJADIXS6g6EtC7ABMgHvRg"
	$bData &= "U7NjAJs4pkurD49zADNAyOUiMzFhADRsWFc/BYMWAHUP+4URXBhvACkYRtBfewCsAKoLRySpY1A7AEMdfSgLr9JwAL/3EgVwn1u7AIAVVMdkU0QcAKMq/8soiHSMAG9jq4Jy4Dg3AJ+CUkSkOGfIAEQc61/rcxERAB4WMwuIMDEzADcLMAt4F1IIAFMPQtCxfDcyALfVtaoGi6eaAAm4gVsxMRsmACAQF1OPimvVAIBst6fEoKrUAGtnxaqoC/cwAICAEg9xUiLEAEMTjRgVwFefAAE1YlWPFDIUAMhTONCKgFSPAAqOQZxzU9AaAGhvTB+mdhN3AFoIBCdXRXGwAIpbWzsTcRdXAC0/CusBqSIVADvT+HVw50l7AG2pAgSid2swALsCljXvFzCgAGiAiL8yA6oIACu5VquGBZ3CAD8fWMUppD9uALUQBEtPiloVACADG0vYsIICALejESiAwBcYAIHR9FP3RxbNAMKgR6JrECN7AMPSI"
	$bData &= "pqUi+siAEaUH39GIgEdAD87L8yxCI9QAEMYiJVGZ5t7AMWRSoZikxBaAIEMcwYMxIifALvBpWMhH9dWANuASwFGjmhrAFojtVXfWzYMAKvp2RMHn5z4AIIW3mELFlSkAFDjKxSEqh+7AJRWNUZvMy1tANAqT/N1qTDRAPMxnw7RA0dQAMdTw3KJSF9bAK8mcm9r92KVAFIVwz+BBaGiANPPhRhCURf7AEMihlSH84MMACkIRU9zlSnEAEAxezUxqiJAACA7I4hiUz9LACnQAEXPMTPGAIKiFXPPaPi2AA6mK19YVVsBAFNwbwViq77/AJKJCDWCG21jAKWQCXSDqBjBAIWjA60IuEDDAG8qrYeh325/ADuqbgCLa5hBAFrBa192pBZxAHzrbo9KDQxiAOMvFYSiCju/ABmiqKAXVIIOAHiAwkLmVoAhAKgfN1MgRq2wANOHvQQwuFayAI9uq6JVBD93AEdBlAN3hzZRAE5oDQvDhyBAAA"
	$bData &= "YEyEizMe4xADGBFRQNN5M3ACaInpOHR5e0AIgKr3Dzj/8/oFhEgzvXLiARpKurUQexKAcLkKJYlx/gXQEVp1JaUEbqe0dqElYLVFeAUVCxtztXXJP7QsdBJ1U0Sq93InQPhFxxIK9UiB4EAmYzrGIViU8/AmvBKGtjgY+Do1MmUk8DB90juxdXfkyCAut6Z0g+e5CGBMFTM25qUKXT97U2AKufB32sEkcx6xeotZKpRzJXEXStrU8/wBpBrVeB9bCCL28vQIE1FTEz4ECKK//HWESA70ibegusaQSUp1N4S70JP1VidF9LHFMqTx9aDgIma7EfwzjAw8G/U/9MBAeW6mNURRdChStTEIqKY0NUBQfBWI/GR4AV61q3WyCiGFAnUwgYWGBMG4YACDWlk8MyVAyII8sxaH1qRVOBe6tpgpuLNrCqCsHvIwjJFJefMBTFqltbZwFQsSnHZ4qHhqandJZbQC65gDEwFDBUA9dCVUCkYl+T2IW"
	$bData &= "FFtILgESyDV+Gt2FQclHXdAVArm67QwlzyEIXQgcWFb+vbVc7lAsHGtPXmJAgCuPDqFbVohOLQGjnqDULgmNB3C+PFBwZkQOPJEYlFjdUHYtih3+iSowxVS4rlHg0JnLrLwqkMlUwMYIqcRFrL1QiTZhirzt1RMUVMGdwqEgTE3d0D1iXCBkyPj7q4XQibCPrZbiFVRIDcyGgRaJvbKDYCtELB8UgIg2bm1TCadAeRJNEFYBQP4ANG1Y3M1VyUBUzVHVBI1ijR3WwmoV/40kgUSe38skYwFdzNYaYUgRPaFUA0xeTXwpqWoDjX4CAacHjXxXAtMSeR1ZQ0yEqPxgRMA3aN5JGBByPSEFN44NTSFBMKedfulUQGxf3YcZCFw/HUMv6xQZWDVc/lBqgbXe7nDY8WM8/NjNySIkaCDOqGAZ026OGVURSo//SzQysf2cGYBCl3govV1xBIOc3NzSLAypuHzOzMy8IVAC9E8PJWFFRn5Lj1Ih3"
	$bData &= "o2OrSBWhEw8aQlVKM+40S3caQ8M0MYVQULe7KiCGVs+iSkDV5x9hcFEBB0HRqk5jW/C8eDFUP1RPTkxWYWz4h0crk5RCBsFWH/ckYkgU8xDFqiD/B6IoDgJbEybok7pNB+9RUufBG23TIlyEAUszNy1CgGQwxyEFE9SPMF+kjlEVF7MhEQc2/+fpgYmxfxMy3zirihAKN4ASqwrrL7CqA6vTMQ2iMsffASMwEkMaMahGw78pCAWrx7cKtKIBT/8HVg2L9/swKCrOC26iKo5nF1AK2kG9lndzq3FBUw0nRpsuaDVSQ7cDDujA4zXLIhQ0aBtCqgatExvaoFsuMzkSJxi0gshfD41QHIvTx91HLGbfYRrC92LYgRGHz3obCCS3z4gTq2LTO46qdi13Q0liArFAJ8TqtrCnxEKt4pfbCKoO6pM4q2FU1btNalWfE1cshNP/ME4IKYDPD6s6saBPqkV1AB+70ggGpCuAGrCoBz8w1sO6VeNyJ"
	$bData &= "wpgMtVfZiciDuqiNruQEUCWx19Cw4gIV3cAo6IwRwAmhlVXrzW2NhCUDzIPBtZBrZ0wY5sqIYDRy3doGhJxN5NparReYwt1Vy9gUBTATxLQdAlP37GqxArTd2pKUZE3Y2AzFoTnQ5ZS0QmXUWUNoj9DwFiRiAcQgJDnH3RV1QBSc4eIQalphyfhvVXV13MHOlJFZB8XWxUFlSMHqIgISq/IiBTFsz8N2KpQB5uFqBKwf3fAgkBwDxepVAZi5zMzMgJVJArXjhECusumYsBAjQB3cwQQqhmrkdo7YA9TdzJkf1ERKAXHsSiohH8ANFxMny5DcnlEVIIKZ4uMuwZGrkICXmvpBadHT1U+RIqFKKJ7o4XNDkDGAq8BDECzDzaAIxZYe+YGsWpIwXMzHFSqGHf3qATJEVMpEFA98qMGkAmJb39qUAJiF2O1BQ8udOtw5wJkBtQM4Gs/iQhsKwMPnySARhAX5IKYCA9jPTBXoudJ002BQBFb4w"
	$bData &= "iqVhHzw4BRjFCXgmgUsRt7h4h1YCjPLxBHbFXPSFEEqwanf1YCeKB/aL8YLoqoG3T3IlVANRutis6yH59YEES0q5+EokUUO5uktoAO2+8BNCAO+18UAopqX22rqFqfY/OtrAVRZ/ZBtQoKa0+qRysB91uFRgkgkoOoVktB2yuiotCgm4AodLVLpwAVGoW2s0EREVID1VZQocv7oUARYUMNiKJK449DN4gK+/4NVCSgB7Zrkrp7O8vyRnInaNEgYjlbO0GUBgL/KYBYwjAroweNRitTLseKUPreRF5MI0ibLoIRQLs3BmIyUws2/yoorCA7VUAtrGdGCqumi6eqKaeRK6/CgJALMRTmwM3jUCNVmDYFYg9XbyqSMSpjgEI0DdsQUQ3iizcjTSGm26+kYJam011bIsAKJm8XAB5GIM6DWBHEF8YULIgP/y6twliFl6uCREQo+7uRikDCu+uGDqibNq9DgioCI+PQsCMAt9sVs4BRb6ADmIx"
	$bData &= "TNBQUgQo7Ayqi2I17B5qJo0L3Urvg7YCwZ6ZDCI8FHbcTSJ1QIg6L2y6UgIobv3AQCpobq9vaqgoDdycFC6AC47Mt4JASu0agIuPjGxAUqyLTt4JVxYG3q0hQFSmnLIKKRFurLKiKFa+vEYwqIu+nQoKoCJ+KYKyRl7sh4oKuZseVFlFaK0vGGhYFsyhUisFrLxkDwQrjLqCSCUrrdAyCk0KvKimkAgNPozg1AJuxCiYKH9wtI8Grt2TAASiQXykCjhHLMIIGEaO6qSOaIy6PAURBBevqxQzARdNB11JUBAImv3cit4VQT0IEo4iHj0gaiCqXcEAqutDLdK+OwIigb4qqqsAVOlSDEaLaxi9YXEjA1/OZQKDg94DEsIrvC0MaBrGTIwtVBDZCX+MGYBq7RAKBVUFgg0sNFlE7ytoSUhQKb4JJoyAPSxU0CQtDDTQGijsuB0cxAQgHYxSIAhofwGFNxad0uwDrkDJzm4kEwGKvg01NUQEj"
	$bData &= "MSQIEkQLzxTGmiWbX6rBWBXrgMswjH9iaDhLWBVLfkHIEBwbVoRMFDJ0Y4WQ4gjbLyYAOEbzMTGGIzj3dJeDAhAb5z8UyBGxMrMzImoUdEw3kDJRVWtUA6GA2Q/QNQgKs5cquFIoc49cKS2Md4/IBGwVszNlsmsUj+oaQEhWH10Fh5CHdAXIQXSPNmasUxj3FyFVowgnFmDRTdtHCJkidrcyAKtArjNBRKCgU6IIsIrjU4IQ30Lz37jexqJui1VwXSqqf65AzbqqK3OqQSEAVxDiA4urw0RoGlCvLg2gAZdzpRTHoieCS1qFv3O1HSG2k7ejAVsqWSMCJqAKm3MgEYG4U78KF0Ehm3RUhABi1+MqEsMIp/OiqDioVvdDnTLalmWLQslUMAPXU6oapFCjWFVFwpOQTmHihy4LLixoJn9bl43BqibnKhTbWF/QwqoK/yZLg4Brk2MQl7CLGNggCt/PLmIvMUPr7yesFk3UQ6KtKowHU3fjM"
	$bData &= "LCCd4/UKha2bSO/cHFUhWNG88J4kAxrdlDIGCqk4kk4dAxHmPc5S4s3lY0BQb9vNVAYFfegBpoGIyjUbmNN+6tfurcDi+pmAgOwVUF4y1/DWx2GRjfLEYFKBQd7rVJtywNw08ejiSMB72X7NYxXo95XXaegOilEZmOC1wGhXqp/IFBUK3sBNYmBxzGLEYXQMnR7dhChIturWEFdkN9wVBCB90O6jQMOz5bjYlQBjMtSNAuryyMHgQzQmzM0VclBIDUYFBeMa1e7ggPXMjszBrQKCIsMaNcqT08KI1FyUjVTVCcwIsPSRVFjxy4opKoYS4ohrZivU4VVMSIXxiqi0ifPlEKO049vEBwBER9mGxURABjnAGFRrxMsYxSAGNFvNxEhigFzxKoqEntrsbGIgF+jsKpYQFvCqmHZP+ewqobU0+s4IhpWF+9IEdCMXg9w/6IZqyIr+wJkKhaXMkCuALkzNBmrkis1TlGDiOefaqwYKyc3kAKSjz"
	$bData &= "cAMw1osBoLM3gHAy4SAScDyFFsVZMyHAFyBDM0RiVHgDWUHAGX11OACnADNK6fakA1EBPSGbhGEziXMCBGKkXzEVAD298LsGaANU1DTagL1MwjRGsOIAQQ5zWIJaoGC1cjqLQQKwoWVAMLG8W0OpXLG0J0AS3WSddYQIWWt6tKWntLc+NgEHFLS1AgQuCjlxy4oNHLMaOUMRXIMTYsTIG0MzRUFFOCqlP3AcF0hUPviwORIVciessaVUz7hhQxHSvz7iECaYkzlzFtIVFN8yDCkXXjA/OY1rCAZ/8rQr6qQQBYCCMC5DMAN74I6NTmp2kAbjmKrUqTMiNAjgAzqOQIkDQ1WFTEwn9xq6IJRxowAgGFuzjGgqBP56kFdECfIEpdwEdz7xJjdaT/k4mAJkSvQRNSFDe/FMgQbaMygRwFcjM0hREgRzUqgUVFD7egoDUq+2EBo7EfmRLYNocPxzggEZECF+FW1STPFghQA7Qba9hprAIrwwC"
	$bData &= "tqBH7VlQYRadvURuBOPtTIBHIBTMXVW2kf2c1RyhCKjUDooAZWKMCzGxrU79MIzRGDCwjIhhRzDezXNUMBL82ChFIK6szQZeRaFMXXMbBYceaFwSFTFU1wWWsiocrwGWsSH8rxLAhRD/7IIrLGD8qfAHA679ArgqMRzDTUm6kh0SSbqgnOgL3iCRdATjzkaRBKO77UZJKVWOYJC0WLiMRpGSKMiMERZJC2ySgpHIwMA1pVIFJSlT0R59HFxAwAzO7kjQqkDc6tahiN0elABWLywgGBCcDRyNBVSR3EdiKHHtDVEw0Uj8SJmIYOy6pDBUErzAwBUcIIvNFxCQhwwkpoqITEYwqJvd/ikVRImurqiSEKCsCUYwgy8sVVBJfaSMFlTRmoJKwqqcvKKRZpmlmrhNQiD9iwaxAk/MfWFSFUT8iG19pF6PnOAUlCOdaFY0Il+pIEIxPUyuqwkL/IwixEAMbKFGXhXNnRTzGAN9imqpI0Z/TLWDA"
	$bData &= "MAH7NwOjQkAho6YhERwrW2IGrKoyo5PDaGEINUM2EpWiCbMKAS1i/3M4iAOM61OiKkKhIxntJDHT1xlao7AXg1wEElQXh8osYBUvGEJVmpcDAiYTgYNqFULArzIGwWnbcDasap/jeMkKxQ+6YAw8EoJBGgDEQDEnN4vQENL7NWPhToSqrwNwignWiCcTlYlUMN8fCIpGBfMiSgVXc/MkPwUlF2VGFINCB5ZWxYI3VscAaF8XlCZWkfMXNVhKAUsRwEhqy9Sk1YBbg1ZVmlgDiFZQIZd7wSgIkZOjEYRIEJOEWFVp43eByWwQCzMMkFZVj9sAxgBjBwjrqJvzTFgNE0DHMSsErYLZ26DGoirXQ4xEXaMrogAWAw+XDoyItIcz0GgAq8NBlTAWX00AqWFzjBQkVuMjB0JFMWunEauCVaMSUDDaNg+vhgFVMt8HhkRHAh8jqmiEIkuSCDUsJymq6RxfOwawogvXqGQsaL/jRjQRK0+MEf8/F"
	$bData &= "TIzioBVoc8jwgBCLC9FELDqb1tECo5BD6A6Vo0nLygoTAWzGkCc0vemVhCYryBYRBwHtxAQkhpTd9GiOKVLS1VNKgT/LapIWH8xCLpJazKLClR/FyY1iih/EcWq4odvEdBNKje4SYWC41esYsCIp4o3OCXTC1vkFLUA+yxqQFRblylWVBtjMjCdpEYk20AnqVVrQqKKEfcoSQ1oK9PERY2qp4hIxnJmf5IKdASzDqoqfHdrcjAAxaAXMFXFKrSnX2EQVWFvKQKRXGJwV5ptrJAwF0FUpTAjggIJhiuHGlh1jM8VJ5CA2595BlJt+8sRQYLa6/PBCk4gbwtbPoFVk/+IAR1QLssIOJGKQ1NYVMBLKm4Bq3u7IUScuDZDKBqgT4PHGhQM0Hcp7EJoU19VNAbFg3+EYBgEg4ZV1CmTGwIAnMKjBHEKGxezqhCgiuc3xIUNqysjkQKaQmNdGBQxo8cq1kprj3dWcQmrfxRiVZfjI0IqjkEXiG"
	$bData &= "MEnNM3FaEIpK+QCeBYP3Y5EDCKSwgLqMQ/wCgCq9NrADigVWfBDWDD1/MWkWII61YFo+pDo0AsBwJzh6AAUTd79coEBnNWClIUEeebyHNEhcNMKAFMQFTDgUBEgZsXRUWp36tWqmhUIHOh5UDAJweVgrr/48CgIgZTaBBwAgMCVsQgT6iORQRzJyM3AKQ7VQCLqDcjAVCNVeeARYOhWwI4qip7ckAAhIBnM1jBoBU76ACAAkdyZaWqKuuCU1jBo8MCyEWMkyG8qYIbTg5FCgHN6ntF84JjQJR7x1hBBRDLAhSK6OcQQitgQ8dAdQlXckuwIIqAC8AlLIoDr6NgEEZPS0gEDBtWDSuorxNhgiqWX3INgQAusxsQcAgDLnclnFxIs1zCFNHPcstBMVIVB3AVNFYveQqPa/ATV2YWTijpgQsLpjWTWtW706PqEhJTAM1YDUczVQUCsZ9rozZCsLvP0KAmAQ9dGKPqU1JZ4I1EKbceC1hVKG9"
	$bData &= "CFaOAP5ONIDDAQy5f6NIiALqboCpICYdFKWnDQ1sWFElKT7obAjg/T66mWuCIqONPb04rMYKq84tLSgAVn1hBgVWTf6wgTgNDRBUIVYt7gcEta1tKKQJ5ezXMuAAm9zOnJIoqUfMBRFcKowP2KiCEk/7rDkFACNsO/AaI3ZMghAVRASEsKoNzCgghUWMQQqKACJIREFNRQAipQ4AQUkEBIQyAMyMCQggAE4QQAqCEFQQFA0gI4BbzuAUhAeMtCKMAQUgEwNMQIiJuw0ZQ3YKzCqhbEKNVdQvCkwhuQRiDdQvCgnNuQVhAYwvCqAAQBlFwUzCIiltDRlDdgjMqgFsQIwTcgrAT4BaEFQO1IIwK8wVhRAUEkqqq46AWhETTtSAsCsMFYQFQIIyKqrOEEQW1ozAoqBaTBkHUgoMogloQc6CiFDTXUFULwlOQoCAaZ1ZQ1IIzCqhaECMBUQvCE4BaEEYDBbMgLPMoZkEY4zQLwgLTZkEYQcMs"
	$bData &= "CIOiBWEF0bMgLAiao2FRALOThIKaBYMWhFV1f4IwoGhzEAYRzWPCIIhZU0ZFMAtDI6BZEDMQwSwII4BmQRgTBLMgjAOKBWEE88SCMADjFoRBEAvCCijTIEcUFMMwUhTyADIANa+gWBCzMAAICQqQMmFFRSyjoyCIBZNXQCwIgzXBAGIE/7+gIBaEhxWxIIx3IBaEQWc2HbogMu8sH+iADgzDOCEEJBPHOOQgiAVfMrEgpKhPBWEABdXGiog/AxAiIIFDQATEgj+gIBaEL0KCQr4yADXSRRULHzYiFoQh7zYfsSAkCg8UhFUUICyA4P+ERESn7yEC4BTfRsApCM+LilMQv0HBKQivqk5BWJ/UKQgLj05BGAB/CsICKBAWEHVvsCioU19EBZ2CTwgLgqo7YUXQKT+LijoFLwDUKQgfiE5BGA9QCkIi/xSEVFWCMICi7xBWVJTfwqiKUs8YRFEKv4ugSkGvEFQpCJ+AKgVhjwGlIKR/SkFIU"
	$bData &= "W8KwqAIQVhBVV8VEgBKT6oUhAQ/lIKwoC8UgEERCsIiqu8QVkRUD7CAiFH/VRSMgu+jYBSE30bBKAjPAqhREL8UjIKwrygYBWGfADUKwo+CURBWf0AmgI2nMhAmk6szEAioUU9hEIyCP8IgGAUvBgA1Ch8qglEQD1GFgjD/glAQRu8AEBKoICIUhN9RoSAMzwgFYQS/KAgLoFAQBkCvZIi2qp+LMw4AOQA0NUJBmExfCkICgkEYEBBPCIOIQj9hEEUoLyMqCAUfG1UoCA+HclUyQTIzclVyVTQ1dAnCZL9LEEJVZIC2qK+DMuSo5KgzNITJ5Kg1JADoEl8BFZcgTwK6BGE/QVyCMC/oEoRBH3AJwiIPqghJVBBUCUL/AKoEYe9UJQgr31QyQFuDMlRyVHIzNAnCZHI1EAJEUY8wqopKf20BVIJvk3IEyEAyM0eAHAE0NZUgTCYfBCFEFAgLCKgPWBXBJP+MgiZB7wFFkyDfoGgShM9UTI"
	$bData &= "Kwv4BJEBavTIKwKp8xpFEQBxKEVUSGtApgf4KwACIvEFZRTF/CCqJJT5BENQk/JAiJokEYVcEvwgAAJh8YEDUJDygAIkH/QBAJwu8EBBIG7yoShAHPFAnCqL9IEEYAghAIgK8hVBREnyuoiASPRUAkCH8qIkEYbyQA5KAwQVGRIF+QoggkRQBEgk8qKhKEPwVFgrAvgiJBWB9RJAirDzoEYUH/hyAMKO8QhAFEgrAo6t8QVlEdz7AigEO/FhAdgq8KgEMQnwEcghCPOAQhEH+CMAoIiCQQHW/AIQgjXxkQQgUhCAOgo6poUdU/i9EhCKsfOAQhQA8hCCkAEAIBVf+QgoJC7wUBFILfAApBSM9VCMKov0IQBgXaUCiir4UgpKinn1AVchUyAKoQhI8BFIKwf6oQhAVvFYIwIl9D7V9RrskDAL7ZBqAPBMQp8zIAOUQgUyEwDEEgUzAwFMgQhTAUyRDINzcDdcrQOe82QyETITYwGUEVISC"
	$bData &= "JqABIFgFUguSiojAVJYkgBIFcFDCgqpBEKIAA5DEHURFIMAkVACGyCKACZBFABckigAohF1UUMREyQAEwoiKQEJIKgOQwyVURETACMgQUMOQooEAwQoaiKjCKZCogMEUUkqBTBURyMHYQEML7rgUAhr4G3Y9laEBUsoggOusKGVQEVCAJICJIFgEgiGSKMBVVJKsVBIVMMJCJoJIxIIsKCoRMQAAwAggJQAAVSKoAKpBFAVQgiwooQhaBAggZMWQIAJIwMBQkAyIUkQxVMKBDEEJ7pwyNIOuiCklBEgoKmTAQFlEBDSCgQvsUAacM64IKQRjbnTK0KOsAyFURMKACZASUofaHJIwHADScBnxCJgLi6zSCU4aGOOdOGRoiOOOUoQkIOGVoguLfOCGQKTjbNYGSKZI1OImQiZA0NEUEFIQ4xypARlEAFUgoiiiSRYJOGbo40xUlKSKnDB0FOM9CAhUElKGDqDiECgjgy3RFFIE4EUCcMscC"
	$bData &= "qEBSBFCBLAigAlkVFEWyAXHK0DjDnDI0FTi/iEASUeiUoQs4uxEhqQCnDB0VOLdhTABFOAUhBJFTV1EEAaM4VMUpQ69xytBEOKsyNBQQOCREQJ2nZeiCIjifKiA6o8hwCQBBQAjb2IAGYt1HlKEVUMigiOiPKGQREFCBrIKIIFkE6JShKziLRZIqgsrQUVA4JFBBcYdl6IqiOKkgCjiDHQUAIDhVFKcMfwAqkEABVCCLAqhAFkRFhCxAnDJ0OHunDE0ROHdBSABACKMoIhOoIAgoX0dVQcg4FNEpQ2+gQxASM6cMjSBriEJGAIpTho44ZyEIiYqGBhBQs6yIgFNjFEGFIJOIThlaXzhl6Kg4WwpCKAKPKgICR1JOcmiQ/wsAYl4LAOwKAFtGKEEJD2p1oxMnKGFhf0Q3gy50GjJs62FSH3KLSBtPnnOhd1Z6dlUnikpkb6Tphh8u9gti7yq9Nl+fVIJwnxrpO9RaU0tBP2i9N5WyW262d"
	$bData &= "kpnSKt08MdzV4vYHfvQypJ5Vy8eO9AMQ29wLnLf4ErawTAjrk4t3uDd4JpTBoISUsZrDgje+390njq+LyMuJWvwDvZlKx5D3cFbzypjS563Nzxst1tur0vrZWHFQztacjsjhSOAq+tUXyLQhyuKM1cvU1mLPcm7T+8mDS5fyzsyLd6aZX0DIFuGY13pbcffc0cDN7aJga1XUy6BOBJMy7/tWDIdX3RLERnCovvr1bYUbO9j/6Ou1mFnLQMgEzPacMNfZo+jvg2rbbcTZfN/t2AbDW+PmysR09qqp2v/VKKEtUdf20QoSAdLFawC2wdrCxGsTSBvG1tNhIIUG1UwqLALLxaKIC1/R3OaRh2rP/Zi16re406uBnXXatNWdbwybHfHLi0VmAFPbcNH3RuoSl9JbmMiqK2NoVpkf6ejaC0xDQtPVcfaoFNPh96PgYqHQ6tzAkSA4sXiDm5faXdQdQEM/+9IoHCAQwGLAqkvQw1rD4uLUzeL1R"
	$bData &= "DaW0/3J6w2AoIHt8GqGBAHQweQqBgB+4JtVXEbGycbRBTbIGc7VYSCYCdbxSgIVid73w4sAQEEAQZ+YQuACs2n+Zqesg4SsNqK1gan+TSbYjrvMEr2YppP8/lGCwyAjhIsysIv/E+z2Xy+NSRj7jd2EubTfJpDqGJM5OZNp/k0zxZkUlCWiJCbyj/N9q/EhjMNgPI1KmVPU2k2tmdaaYxG5tN8mmu2zmziXnjneZrNEmZajV7alvZpPs0ap8I+svA6x05P853NKGc2zQ6I0pras9l8mtfULN0IaCjj03yaTzwk6WaU65Rms/n8kAAOgNq0CxppNAyn+TSfWOQPjpQTzPk0m83oHgJqeCo0CDvvPs2nZrhBnLRWjg7E82k2m1sOaxSJXAyM2XyaT6wEj/r4kUJsfZpPs+yUlsSX5rSa03zas84sbaUObsivpGw2n+aYsNKIsQZu3Lw0n+bTOGzIdmjOwNn8p/nI9f5ADQ+AQG88Imw+zad"
	$bData &= "8VDvIFEQUcD7Np9nUTGKUVapUXs1mU2ngYBZxnGJOT1NpPuRkgGayWLPZfJqv9ijPMnKI581/mk966P/KHIUQgBpzfObTfJqTZNyhriyy02w2n/78tUh0zLmA+fOf5hz20NSNEYAIdRYSgER5mk/zVBd0DBmwjNNstu7mHxoOFnZMM0D5NJ/mjExysFe40Hinvc2n8vCZRnfOpA6K7m0+zTS6zFTbKnjO3i723qf5DlTi6LDlnnm+6Q6bzeefhCwKE4Dc5BcqevQlzaf5NGgUR5oQXOKn2Ww+QF4me4BgbPNpPs3AYq7wZPAAc+55mmcifIBkgKIfNNv7tIEO5lisfn0OCNSCPs2n+djVuIj9+Bj/5jN3bDB+HqAAFA44BLP5NJ+syA/qmBsqf/k0n2ZoJ2T4MqCENjSbzafegEsUgHxgSD7Np/l4dYjAd8hUp2m29/8/afRcuU6BDtTfOH+aT/OE+FqU/4SQFBWAs/k0n6hcNdwMOQaC"
	$bData &= "+TSfZgg/JjhBcFxMaT7Np5qsVc4wV/g+zWZTXCqD4JFiQLnTVP5pjtA8FoC0PuT5NM/mAHEMhHM2kHRpPs2nWBh2fKiBpDabT/OklugklxiFZLCaT/NpPIi7YoTQkp/m03yA1sDS2/Qk4ebTbDYmhnbmUnLsp/k0n35u8qDe9MbNp9n82gkXgASH/hQ8fhVyT/NpPi4ZoN4c1jKaT7O9KE6IDsIzLlJEWJ/m03wCS4b+X7wOZTTb82lO6F6SiQ5WlXb2ab77Tpg+DkKb/DaeXk/zac9IiqEOkP6jzjLnaTabrwiLErk24qf5NJ9c0rqIJsayac/23bbRzg6y114qjP8OYObTfP6KFhiAmoYrzp5E03yazRKNXk1WHlaceTaf5t5e3J5nCo5paT7Npzjma2gubpJ8mk9TcLyiuPhy2PNPs9ksj9LwbDIJGYC0bDaf5vZx/FaAPpC2jjaf5tOABp/I1qIKkZ/m02ympjr24oLyNmw+zecag"
	$bData &= "LKyouYyow6SU9qn2eqkQmqlHnAOT6s035guKr+62A7kjprPN5vjIpOuBBuAVM4loN7m03yqMNwSRhaUrmdtKu3TDmyyah7EbhqV82k+7X5xDmrqdKYKlmk2m0/2wqM8ltKxcua7T/Py0pzu564OHurTfJrNGJde7Fae7pCsNJ/mzvDK3v70CxzzPO01hphODA5k3qBsNp/mNjjY5l8smbZhNJ/m01pmiZL2isJs3qf5foz4FpCOmqab03ya7w52p5xGs858ms3m1r4Cm2LCOF7XPv/u02Za7J4OVgEdgMqeA1QMwGgZe2EmUsJCC08IExEp+19htQlkHxNnKxm2SjNPFbaoCRCfV8DuCBkUVhqrC5FYyRhDFlIQnA+bCDbZMw8dV4SEtEW7WqJgTJszdw530LCTRB7+3pUc8k5HKEUiUPfhxftPUhZSa1JjQYYSHCKFRZN4V8nzoxhQPk773jtoM0YeRWJEv1QSDNp7umNFTB5F2w0jMi"
	$bData &= "WDMk8MkmMnTWMc2OqAJZNzvucKZB9TWntHw1Ygx38ZZxbH2h0kTAYaVFsbSEsYJAbJsFG/bxeGcYkUJ+sKQAuB09MombZjFKdsGo5Az1CnmD4MFG9IL1AraO9KDiVMH05WYkcQ/eNXzxuXrJLnLW8VJUsIVPsJgYLRMyOGrZhoV28aQAowQhOZVu2oVx1rf1bJtR3jdxzItOW9Uj5UcxmgpRhGL2ctAlpCq2CRCBRfbJFc3ANTRlCvgW0lQyITDHSsaDbT9x9qsbSVYkzHQboBuyh3Hn9PR6rvhBvvU0ZrS5cQG8SOGnvnbUH7NVTnQ+d7gAgUIE8SbcApB2PgCHDkv4NnMsAS0aAzd88ZElYyHiDPGzW3exlYJNNGZyYJD1wb45o4sBoMj9N0YFC7J5ujhJCCYDurCotZO8cO6Ua0I5uPUCnIkLBIscSwghNzp5mWCFJTnyIyUDACKyBkiGAEDxpoAimsww1gQ9WvFmsTTkgU73rHNqh"
	$bData &= "a13+jZxISVQk3DFtUm4N7JFdwYpBfHk1UDGiTo1CRETrwX0nX+1Ygz1uDHVsxYiHT03ZVhNCEL0sA7BeE606XijYUYG8mlxVtKsBrI5vIFk2HanePQVsdehsrawq52oLvaxshB2zBw28Y1wg2WJZj7trVhKfrKyFj7ABGDDcdhwEytRH/IybY8nRO6lePJwmyMEi0FMGCm6eftMCqEqf2io1qV28kn5MOADkYTcZVTUKsxCOr+9cUS1CQx59gEfK8kxvoqBGKo3NTgdJCceOfL12qae1SryNq2xbtoucXd9vX3YCFQVe8QAEWn3cBFkYRQ3ZQYjDzpxRfWaAAo39TEjugBetHERxQoBfTYxTyvIscDZJYEV8kz1tQz6chq2QKRi8gVu2gAjMugwh2RIGbL7tRMLowT3tgVwVK2yu7q4pNI1PzBduIS8eHNxHAFFYrAMjzVq8mGpA8b5seCZAQ6k+j5Hmj32MjgOKtGx8j84aiVewhj/ci"
	$bData &= "bKpYxYcfIItWsI9VU4NYMJsQP4u2paAPg+congAJb+88bwikmoMekKgYkH/bqliUN4cMW5A8H38tBytYhAujFEtEoFBDt11ACoKj11QsYgcbf5chvF1KO3OBWGqGq3taIo1Ri8d7iA1VC4cfe4PYVDV7HH9g1a5Icx1zyBAGMeshz1sUe3sarhWnBoOvJUIMobv+4BMOhLPHQ9CeGgb7UCJ/a+FWY1vbmpMw5KBLFYPUNNhRD1e3F0zC2hE/YxCMTMJoR1MtmoTUh0NiNQmJ3zNNwSSsJyMUElbDqGcjCenQagNPwgoWFfMnwgoSRePjhLUQRNO7MCYkisMPMWABkbNjtYOIhKMVb2CADFtXEhJShRaTm1ihsCpzz1jDoEhjezRiEx17EFOsIiFApzNWIiEULyNEkZAo4xNCwQJ2F4d/IayK1V9bDmFtxePz04RUAavbITCtOsNLCEWrDrP3WNGqQ6OHsFqqQ5NXsI4QhdOPtoYEh3PHj"
	$bData &= "xzCkiseU4ewqlGzQ4QxIRC7BrArODMWaykOYdXHE7CqBrAWa++EtUSF81OEFSQq4wOEFaQq08sbtSkowxVrV8WolUwiBwphRBonk6hUwaAb0Ch2VacfiwijE/ibZyxiR1VjI5dRCKNi30MhNmpXHHvvRxXCkhYjEoRVNGhbP2nUhioDFFdSMAirV+OgQRiVi9OrYhC7GoMjERIxCLOzsIBBWKMFDcK6U5MRpwK0h1+xKxqEcx+LYTUQV1XrwmqrBlNbWCFWDEOrWNGqQTO/wlqiQSNTGJMSDROvUTuKQQMZdwJhxajn4whrwIBHwtlWFNOPI9pBBcMgj3AghGCDo4BACFSXkzxvRLsgj4MXhCBYgHNWW0AgY+9UFCgQU3MGjQqEQ9O1FYGwM7e1IQiEIxZnBcIqWBMD1TViExBPTy4kuoHjp5ARN7DTjRjBLhh7r7uoG1izHZewmnAUU/crNhE3kypzVTuiGXsrq4pgNWObW9WumpG7J6"
	$bData &= "swqjgao5MhglU3QxdqF3QDMyKfg5DnDYsa4gZCVG8D1MCaMN/zAymGVeOwgh1V4x53qIEVF1fDFZBii3MDq43aRRRzx2ITUQOTGnNqYFUMD3OFRWwoG3cBNTAqy1NVMIAdFqdzsIMGILcXbw0kKBYnBkJtVRNrUAI2ogNrKNEWDONrMAMrBoPTCrBiFxlji03BDKyzFrW6NIBrExlYMlSPGzOwtoKDb3MEASwQAf3fNoTnIp4LADKul+eZtgbgEUsoFTYgH3tKfoO4EZVvgAeampqxd/KeCkoOXw83BzZsJF////83lABsNpvNWZ/yq/+v/6n/noZir9n6k6Q2IaeWzWaz2QBXrv6x/6j/nf/ZbDabkf+T/47/hPlu0JTnoHH0DgOn9pnNNrMAAqn3sJeKALPZ/P//dHZ3/1ZkbP9hY2T/Zv96/4GBprxm/2yMrganfwOzfY5+pgD/oR//O3SU/wSBZvv/t8YwjNj/AoTL/xRunv9AVmH"
	$bData &= "/YAD/cG0gec3/XHmmEZoAz9luN5uY/5D/UHKmAIrWBpzy/s1ms6H5n/ab8I3a/x5bff9VsWaz2QD/aPs8RCMCp/Zmsw2TAOeM/4P/JXimIPaObNuX6Qaj+w6l/qD4xvGubDtrzZLiYOZXALfODAALEWy2AdYEp4oA5oL/doN38N7/F3mupuo/n1dm+3/L9deN2/8uSlr/UgD/R4s2gLw0pgh/AMkHsyPbW3IA/xxxoH6R4JvvB5mt/Tab7ZbolOQ3DWxGSwD/bYA1m1OGEwundgB9bLY3m3P/bv8rYn+GidOO2xdn79mQ3t8O3R+N2W7XsLaB/f8Bgsj/QQD/xA8ADqf2ZrMNcQAQbP1p/0VRWCD52Tbbe70GhcuGzxaH0M7/B23lt/8SitL/FYvSpn7A/0JCQtYXAAzZbENE518AuWT/UPx/s73/Gl+Dpnq8fMD/GIPF/yOIyv8yj5rtm99OoN3/N5MJZZb/QwD/Ucw12xDypglMABZY"
	$bData &= "+fx/xd+nQUZJ/wVmnFZysP8dfLj/b7Dl/7fltvgF1pWsVne0/yxEUT//SGxDrNkAlSMGp0YABUcFi67ZX03/vu5ESB5dbUHFgonmaqIejl5ioKAMHe7gomn2KkdY716nL2zdFXsOAacCrz0AhUXgdrPZ/0T/Pv8tQb4kRFirffemNkI1ODr/Pqc6ALHt81yoh98GAwo4AGQ+F5p7ZvWnB6c+wDefa6HWAAinrwQGNmyf12wAHTCIBtj7MQD3L1YwoNnKLl9/5ynvGgcDtgUeBxCKdZMJLwGnV76gKM+SkpKDg4N/yEMknJycYmz/YGIfkVz5Y/9lZWWAgIBsk/9L0zTNBHF5c2FTNH8o5G9vb09sg/8AeIf+N03TjIqGe9r/HVJ8/1RUVEABs1U7AEQXz8i2aQ4kbIOO+w6P/rDWbO+L+Mbxrn/iVkZWAFHgtBbPCAALz3hvTwgmdQD/Fmqtpuq3HNksVon2jfuJ9deuLLDqetteRlnPh"
	$bData &= "jSCDVHgps95AOzTbHcnGmOefn3ggoXvB87+e++E7R7oUOQ3DF6g/0oAr1hQYISGJs8F2i8ebqb/KFh8IHfOTdM0TXx+fn18e9vB3jR5cMj/PwC3xAkAzDZEAc9rAP1nNBVoK75LUyBrznN10zRN03Z0dXl6wIHObG3ATgCn1nYEsw1Rz14AuWKpQLNhdqZSgGrObKZpmqZyeICShPIWMMJYlh/Opgmg2aYkRAAWV/kFmkVbHz9CPlibYs5+0zRNbKTgw2e0/yk+ToHHBSw/1pWemM02RM8uAAVEX0kCBX8LhzU9Q/8IUIjmXB1sm6bOgZRZnp5AVu/dFXvPRw4vbgGnAq86237PbACFQm8W/yo7xiE9jtwCo38qPlD/NDY4/9bPOTk59nkulN8GAwo0APeMcM1kOPV/LrcPALkFNgfPNTU18zzvFq8EBgYdiGDfq8DYvvsG9xbKLQDeDaEozwcDtgUCbvJOBx4JLwDkgajPjY2NMH0BHn"
	$bData &= "N0dp5fa/9fYbbyBbyOjsfOa2trCz4gFIY6YzYEX9GqpgLOZmDuE1TW4AmzJnRgvgCe3mxDUM+XAP+P/01mgaZpKtAgZM5xdHMvB2yacGZJe2/WAxW4o/tGRK7PiwXaDWQAVyNgpCBuzk3TNE13eXd1cmuvGR744v8cTIJ/Rs6mCziEKHAGz1fcBO9nVhRcq6bqP3af9WkHDVf1bvDWbWfb7gDGWE4/V082NKY32xAFz3gA/23/F1TwaUe2m35p4G/vBnBu7Xji71lObOjkNwtPn/9DFLgD1oamz3FAs8BsAP9p9kt3Y2mapqnOaGlqaWjAEpumZ2Zex79fiALn/sTPnv1jaSrQ/GNj/zc/SVjOYGGmaZqmYmFiZ2cocN7XWr+XptbPC3h8hD65V340Tf8/Be4QQXmuzllgZzFuTdNvg3KmCEmVFxtC3oOmzKYJMwBo/wNeFu75NiwwNP8DSZkwU03TNBXOXpnWuVhC3s34tP8mOEv/laY"
	$bData &= "GB5jNFwAFQF9D76YCBX8qMDf/BUGG5k3OdbmHi5qITPYlOFOXT8BdIe8OL6YBAq+B2To01oVXOQD/Mu7h/YJbMnYdM1E2NUz/MDI1L5dbVcA/z983c81mewosAGQz9Tb/BxZvgWeGjgCf5hbABaCAAkbPXrN1uK8ERyAAHSqIvtgC9yrwBvu+9wbKFnVyEIrPXgIFLcDk3f8HHgnH/+pUqqcPKrALADrAdnkH8gsAUCYxSkIYJ/Ybe18+EwsHAapBLSgF/x+kAB4ALyQiYU1JYVBMXaqQ7v9OSlZIRVJGQk5DPwVC/P/+W8pPQ0BRRUFUR0P6Y1JOY09KMCUjAC4ycnYXJl1LRgoFLSMh6VKwFVNZI8HwVm1HBGA6muq5wUYnW0lFKN4FgfJBoiZfTEjWIFHt91lIRAootv8FrXxBxQZiRydYR0O1/0ceJKoFJ0YhVySq/USuCii0/wVUeyEXJiFcSrP/BaodIEgnsv8F1Q4QJCew/wVq"
	$bData &= "BwgSJ6//BbUDBIknrv8F2gGCRCet/wXtAEGiJ6v/BXaAIFEnqv8FO0CQqCep/wUdIEhUJ6j/whQkqgUnLkhU27QHLqf/Bfs8IT4GXkxHV1xKRqX/BZyOSFR/SLT//0/OTklxYl1fU09RRkROREFKQT8F/v/KBUJNQ0FPRUJmWVVzY19jT0v/f4Unz4qPf3uLfHmFd3R/cW98b2vzqJDueGxpBWt5bDH473ZtaXvifXFt+ox+epGBfSYIFCC4R28iAq0iaShQCBZTbwqUqHai/wVvAiWqvaH/BW9AiWqvoP8FQqLaq2+e/wWQqPaqB53/BUhUO0AnnP8FJKodICeb/wUS1Q4QJ5r/BYlqBwgnmP8FRLUDBCeX/wWi2gGCJ5b/BVHtAEEnlf8FqHaAICeU/wVUO0CQJ5L/BdVeBUpvkf8FtVeBEm+Q/wUVQaBEb93duE1cClVHRIpNQj4FQQWyVCHKelBQoBPgREBTGPpvoAUFSmmJal9Qb"
	$bData &= "/Lw7wVR7alAb/Hv7QWqPRUob/Dt7AW1pwIlb+/s6gX2VIVEB+7r6QX2VZCoJ+3p5wX2VZCoJ+zo5gUKQpEkJwgS1b7r5+QFJwWJagfl4wUnBYlqX+rk4QUnBYlqX+nj4AUnBYlqX+jh3gUnBYlqX+fg3QUnQIlqX+bf2wUoUe2pb+Xd2gUlqj0Vb+Tc2AVv/AMCb1JHRU5FQpz0lwNoBUtOREJPRv9/MAhvJpKCfpCAfIx9eYh5doY7T0D7eHSDdnIFhHZz4ggC/feHeXX6kIF9k4N/b//VQSzvotYLALLmCydpDuQAiBgNnGAYLAALIAVPWGAfAGlVUAVPBcEwos82c4n2VUE8BUsT6gGh1mUpQU/qASywh2hPUML/BU+JghgFsbZEe2hP5N/dBU+lIYT8BN7Uz88YQRGABb8F9iDiD7D/BTEDo4BPUcCIiCMPMApYYu9PhCKOxW0PnrCqIm+jRiwFFz9PVltV4UJPT4QIRuxUTwEtBB"
	$bData &= "sR30/DYVV1YT9YCi488z9PtqrCjUKfT0Zbu8KTVU8KFlsV11XfS3WNBVUfVWFVdSAvLAUXVgU/T1tV4UZCn0+jrV1hk1VPdaytCtdVD96qYxtVD1UnLAA4D/MRS8GFP08ItFGB2U8Eo60la1VP8QUKFgtV3yFLdYxVD1UAbVV1P09CEDcSX4n2BcFP5uPhBRxKtG9P4tvYBW8ArgRAH4BQxAD/IAS2Zu//BugGX7xvkuYKNsA+xA4HQUtACF8/MAIZUfL/6gJ/YvYLAHIGDADUFC3kJEc/rBRDPij23v//B5s7mGJvFVifNwcUWIG2p58IIBRbpwhgW0U/pwLYAkE/pwC2QBA/p5E8FIQ/mzuYQ4E8RJs7mJuBPBTIO5ibO5iuAMlDmzuYhypCAKE/BLAqwNcKBoQgP39ShQDerz9hFwvFp78BB4i2oALPByJCgFqnx4oSwII3KAEkwsc3ASRCIMckQiAoN8d5KCgBN5s7mAJ5iCKbO5h"
	$bData &= "5KJCHmzuYmzuYAZKHAps7mJQAQl2HN2BVgFXXFAhBCTcnVSWARTebW9GBd38HeaigCMeNjY2KAQQALxhAIqzHBrAFgi+niuShIC+bO5geCuQhmzuYmzuYCuShQJs7mHUFSB6bO5iHVhEDCC8xgFUB1y8WUSAEJwdWxQAvdyJsbkV/B8dQCFgoB0D+XwV3XgsMAG4bDACkIEZykuYrP3wgMKh2Eo4FBCFqTwdbyf8FB0LUTgTI/wUQonYKB8f/BYIQtVMHxv8FByFqJwLE/wUIUTsFB8P/BaJ2IiAHwv8FELVTEAfB/wWEqJ2CB8D/BVE7ERAHv/8FiNopCAe9/wVC1E5BB7z/BaidCAgHu/8FRO0UhAe6/wVGACcu+p8CkkAxp1MQova5/wUHuJ2CELX/BQe3/+0UhKgFB7b/BYmAIEQHTkGI2rX/BQe0/3YKQtQFB7P/BURAEKIHpyBE7bL/BQew/zsFIWoFB6//BSIgCFEHUxCidq7/"
	$bData &= "BQetnYIQtf8FB6z/ERCEqAUHKQhRO6v/BQcgRojaqv8Fp0LUHgr08vEFCFH7CAfz8fAFIETtIwfy7+4FghC1jwfx7u0FBwhC1D7w7esFB6SoCMD/EKL2EQfu6ugFRUUARge/igCMIAefARhBigeQghQVfwcEIyoCXwdSVARgP6gIwAgHH6L2EaQH6OLfBR0ARhAH37WPIEUH5t/cBdQ+ghAH5d7aBVH7CEIH5N3ZBUTtIwgH49vXBWAEcCKf5P9VAQ8qLAwAOjwMAIgDSC5pDggkAzWioIUFI7Q5QF/aL+o/7lvSHEgFCyE+NttutQErCUwAKIybl0g412zflfIPH7NVnlc2K04OBngANI93Msxm6Hz/dO4Ptq7Zuh+LAOlkPV8dABGS//+YaNgeVmBl/yh9pv8VjsP/JYTN1pH4rv9SY2vnhwDbFBko+DebfF6F/2RrcP8MmeLGsO8/25jYBge0p+3/WGpzvz3t7XtmYv6YdwD/MnahR"
	$bData &= "qitxM1mswYdtSm6I7crhbPSaLbGT3IAmnCes9ne9i4kfjgApE6uBkC/U8oGT+JmWs43l832h/w0qoygLnVGMGuzfddFtp2OVm/WBrP/W0vjZqD5QoStz14AeENW8G82HV/zUVNW/w6F2q6eTlvzm81fxaH1Ybjo/0tXWwDzPL3ZdjDxBFMAXVL8SkxPq6CCra5nvhx1Hid+SFKuaDsaZ/xPAGAPAnFNIeFfflDbBhfxnJVfDwbaZmwfRlhRT5YmAAYlzWaz2RAlGjJBNVgzQHQY7XMfBhEnAAffazab7QllACmVnJ7fnPIPyvOarZYAnGIsTg4GY8NstocANJjoiu+7eO5ZfgAPH37pBj1fv8XHgw4RTth3aXF4/zR+1sSK/7L/HoXM/y+BuJZyfVeaeA8fVtsOGX5eK6Lh9n5xdy4PiuXGmMgb9jcXfpwJle//ZnaB12IGPE/F3ZjnO3aqxpKXoGfizfOkoTOBu//G+NhotnsAmnaeRi"
	$bData &= "p4wHme56nGj5qst7vN1tO4PI7S33MAoGh18Wnam2v/OGyh9osrb8ftcrPZHrP7oOtJgrRmAHio+DebUh1i81laXv8Ret3GjZW/2eweX7ah6GOt6f9UXmjz2XgZF3YgVqDd/qamXfxQUVX/LmSwHm68vmiiwHC2YE1Wfi8eYPKarbsPAl9IAFBJ2wb/1iLsXdouUU/PBwBrNpvNBggQCBomQStYDshV+9xAHwYRBgAHjgM1m802SwApipyV35PyUVUfzg8ffiyP5Hme5lxkXWBgXPM8zQtobmVvceaVPM9zbWRfm57neZ5ucnuBfWQ8T/NKX7Nsd4t5Jc/zmJ1yWJDneZ6na32s5NOn2bySbFJVYNNvCeR5np3SlVOQ/83mS0xQV5Nctv8oWp//SVBauzLgDb5Pfo8HHmbVnRYH2r9PlvLoNturJscFNwAtOUQ44K2ZaCxnT+T/1CRn1jUMAOZFDAAIAva+SY4M4MI6CwcBgJwAOcEAxiA"
	$bData &= "nQE4AywDQyAmQEwDVANpyAuQEAN8A5JwAOQEA6QDuJ0BOgADzAPgPOBIgXwY4UWBsNhZI/ApPUiM5yRXUCiYYVDtQBQfqCgpS1AEHFQEkCQSsKLkEW1tzQf9DUwYoCTlJc1CvEDAACZ2ntggFUTMzAcuegl9WODgFX9iAjX1bPT0FL19fLNG+YEJCBV9lR0e0L5ZoBV9qTEwFJdoXS19vUVEFxRLti190VlYFX/tiifZ5W1sFX35gYAWBfbFEX4NlZQXGvlhqKV+IamoFZF9swC9fjW9vBQTcF3AfknR0BAKmRUCrC1MwvSkcAQsVlKBoegELtHZBwBEYATEldtQRGAERX90aRed6TAyS5kD+AIpcDABcAQ4HHBBGcjQBq0QovBFXwSgW2LMzjHhzBVcoRjCEDweEbDYH/k0OXtgEreQlz1AFsAQ0lwGkAABBPDW2qj3TQE0BrTRtlqgvMwA4PNI0zZEuFUs8GFAbBK12kGAwwMzr3wGa"
	$bData &= "pmmuE0qOfzghailArSakXQTfPAAzGUCapmlCbnUzFKloKa2/prn2BigAAS8tVXJpmhoxLwCLIEFtrd8inqkA/1JjS5oDKaY1UTj/mTeSNQBGCmhTTm1aVTBIBe1wXVgFrgFFkGC60+eKgJIAs1JB+3RhXQUfhIj2FX9taAWiaE8Q55WFgQUA1FZB5wEE1A6C00YBQe2oiE8AAahBOljfXVhFBavnoyigGF+SQUQkmcIqoIDtjyL/iAwAvpgGOCeTNAeBB0IyEFCwIJInj6AIthUBgwQAwZYBjy4gIEn/MRYUMdnfVUSw2AGJEhXboI8BoiJYhx+JAqo0Uq4/mUwWjI+TyWQyMplMJiaTyWRkMplMTCaTyclkMpmZTCaTk8lkMjKZTCYmk8lkZDKZTGItk8l/ag0CoA/JZLKtAZlMJpOTyWQyMplMJiaTyWSIqLVMD6haQIIj/28QkB8OsAwAHsAMAGiDkBNyIMhAg1HE/qdUPDZaRD4UC"
	$bData &= "AYFokANaIivdjweA3iEnVHEPjqvXUdCBbTz+2HUSzk1BF1LRxegimMRr8gGRMejFyYMiOqvD0QikUhIJBKJiUQikZFIJBISiUQiLJFIJEYsy7K/IIOiiCiSUBBYFLGHYUxHBQTt/H7UZVRQBFZFQRfEPuBYr25aVAV+GyBVX01JBGxcWXUsgnYXr8MAij2HdXAF1CJo5/dkVVIEdGRhFwHBUsevAQpq6xivAWyQ7+YAH33/BCF+fxdOMtFSBX4ffaGqPUyfAWlPUB2vAGHmBOe22hu56ABi6R0XBdrdsAvqEehSXgVECIDj5q8RiNqC/AFA2tvPr8Ds/8DtBcHuFuy9ad+dwu8Fw/D/xP8/8RHFFzluf89TTV6/6/++BL3q/68oY1S1dAEiFBFMlAW5pEQkX3qVUqqIBT80ighED0ApIkUdiIqhRS9gBcURr3UEom4/ryQTVhUPRCKRSEgkEomJRCKRkUgkEhKJRCJZlkgkBCOWZb8qAE"
	$bData &= "kUAFHIqhE7iAjuBZSehRBPEsYiqj8dFkXsFwXIjEVUKT8KQLEx0gUjqqhSP/+HCkI/njMNAK5DDQDYAXJJcyAFGwGhFGRHLwC/bFUKskEA3x8bGgYRny0AtM40TRkTLh8aAEJN60zTShVlMQBujtM60zRLNX91AH80rTNNPEAfMAA5O1XxQcjt/xQUNs81RQgyH43khBxL4DEQSwGoARopQDRIG0QEg2fFuseIoJJBIugmsA2YwOhSDwgEAaIrxyBFNBJJI6hR0LoHUEGiaAXHFd0AFpnRbSUIx7sKDo0AUccUkoIAolkaULkprVgBZzSCBVHRxwxSRJfpukhERAjflfyr21/OZw0A3nebpyJE/ml5aAFpDiJSRxoEikYlJ0ABQY0QsIeHc24FRTBgkf8Ps3lAMQAfXmtue1zyXEhgBBo4sO1ghPvBFzWtCBUTL2DAs3nmbPZ8Cy9GcpLmLxRAC4GAWARpgUBnA5dGTF1Ve2wFYAnHIuB"
	$bData &= "LWbEIhKojWTgWgcEeUSwCoyofEYB8cFEeWEdD4EAEzkaxopCvqh8hXEoqaUIAni7Cpwik6XMCQO7eXEpGYE0g4BSB2eAUgUEe0Z8gVCBPdngNAKI4JeCGiA0nEAUSAkJh+1dyjQ0Agp0GWAAXJCdpDgQEMABhwWVhawNswWWP//LPhGw+Ap4YGTIqDaTkJfAYFFIBl/f7axmw449bTEgYAQOCH1QjISBeNBRCcC2PLyFqP2s8WAQ4KKP/BQuMwuEiIB82PC9wSC0Dn5KKCm1gLgmvYHR4IR8eNk4vWEcqtIHzQ1NFQhEnOfgpIB4eV0guRiFXCFFb+UZCUURBn/8FDSSQPy5VR0RcSigYUaEhL0SFNpApAyukYC4dGkZUaDFfUaENJDk2kCgYL6JgRIVBLxEV2kBJaAOJgi8kCkZUUS8aUaENWYSonagfk/8FQhtINF9pLHkwoi5WSAwutwwHJi5PUaENcSEfH6QQSuFZSkccz4eqER9K"
	$bData &= "WktH/11NCG0g8klgTUiHNnCwCi/JSAWEj0qa5rvHAQECBAUwBncB7voGwGUDqaN3EMSNVO8pqoSAKUJAoBvv0I0UVVHviiohIHnUHuhG7/Ds6wX2QBNCP+/r6QVgUBCiL0SKKiHxJMEeKM/t6OYFfdCQKl/s5+QfFISoBS/q5eMHBSFqBS/pQUGI2uThBS8paoSAqYjaBwUv5+HeBaL2QVUf5uDcBSFg0BBf6EaKKiHvRZUQEEkjQHEj74uxqg4tX1RAaAMPURuqobcBAYCJGUr3AOQfYDJXMqcNAEK3DRC1ryjSyMMFjIIIggcDBJMBV1YCiBL6sg0AZsK/HwTJAlLHDVFMIPAAYtcN7wuAPECcutBPP1UIwvdOzQ0AXl2SI/ndDQAqBSgHEohCEJQL9wADjgAAoysgQv6g0g0AsOJRxFio8jYC6EekKkpSAKt0gETiVO3+AVVR40DjDQBQ8x9QFQX3POkNOTil7QBM+QZIAhNa9pGcp"
	$bData &= "AIgAq6knwUA+SsAAAAtGRQ84NAKz6zromCEdta8+6tQQRIgAHebwKguuBAOBwooRuvMCxB1SPgOANwbDrN0CcLtTAz2XBwOQz0BSTMMGAAtjMn//6kFInDbRYLaaJXZiqfY6OvyADGSSv7/TyJx3UWE22iW24qp2ejr8wA1l1Py/38ic95Fhd1omNyKqtvo7PMAOZ0in9ru/3TgRYbfaJneiqvdRz2iBSJ14kX/lPz/h+BomuCKrN7o7PQAQagiduRFiOJo/6e2+5vhiq3gR0WtBSJ35UWK5Gic44r+PyX/r+Lo7fUASbMieedFi+VonuWKsOP3/6ntR024BSJ66EWM52if5oqx5Uf+/09tUb4FInvqRY3paKDoirLn6O72AFXD2/1/SiJ87EWO6mih6oqz6EdYyAUd7f9TIn3tRY/saKLrirTqRvdgztv9f2oFIn7vRZHuaKPtirbsR2DTBZL//1MigPFFku9ope6Kt+3o7/cAZNmU/P"
	$bData &= "+fIoHyRZPxaKbwirjv6O/4AGjep7b7/yKC9EWU8min8oq58Eds5AUigz8l///2RZX0aKj0irry6PD5AHDpIoT3RZf/qe3+9mip9Yq89Ed07wUihvlFmPhoq/9Pyf/3ir316PD6AHj0Iof6RZn5aKz4ir77/5X89+jx+gB8Ioj8RZr7aK36ir/5R9r/p7aA/wUiif5Fm/xorvyKwPpG+0o2B6hf/A8MINAtkmcYDMl8h8NhcIOyAE6csVgsDuo4htRGo8fjInC+DFrpdBqNqPZEkiLaKtXgKF+PaPR4LKz6SJ1Op9GW5DKAztdrtVocargGVIABXq+i8D4DDBhgjNoodihTwADEEo+dTqPRNoTSIG7VarU6vApYpvQDvF6vQpDeLBgwwAB6yBaggAEGZLIAiWYKKE6cj2jA1el0Og5cqvhGer1Wq5TiMH4AAwzwzBpoBhhgwLYEUqAooIAB7jyKTpkDCtgmj0pqtTqdmOY0ggFer9fQHmy"
	$bData &= "6CAYYYIBWpPIwwAADQI7cQAEFFCp4xjIHHHAUYrCPK0+lndQE+vD57/iTlZEv9+ju9u31SDyVy+z08+vyQv6PiIusEw4AvCMOACynZJJmFC8EY08qCC8IPhTAot0KfUZcSgUw0JrJyF5Iaku0IISgSuaHgVSE9/L/WYUByFzoHMO5tMG3sv/////AtrG+tK+9s668say6sKu5rqm4rai2q6a1qqWzqKOypzKwk/iisaWgrx6inZDoMCBwRlMBG4oZU3dPajElBIfEYHcGTAZWbMWUEERC3neCyIBdS2rAkimaE1x3QaKQmwFKg3ZyyQNKDiIuJCrouBXur3JRVJUHJILaQFFCdxSRWUIUnwnhFGLORSGEVcz2d55yCRcEdK4kLcE8FF9TTxBScUKOn2CFEIyacGHuiCF8luJJRR6ZISglZFoIYlyiBUyaE0IIShjuIPmvTjMAHw4AEC8OQAAQC5UIp4kRMzSRqPZABUS1UeIzWgWdEqeJ"
	$bData &= "M3Q4TSSqBTMiUW2VjgVqr8RpM6gFBlgEiR/CsAgS1QUfESSqGdwFH0hUU2D2BagmwiIfEAXNhEWQHyoFCosgUR8WQaKaRAUfgkQ1F14FH4lqQix4BdWMWAQfkgUlnCYSMyJRTYmsBaj2xGkzraGcBajgNJEzA6nGH5AqDgCgOh4QMJJLmg1oEIRBFLIrBJelOIlBT7CihTrfT9gC1LRFT2KhZlvrT4IQBKE/34UQDIvPQoqqkju2hVHTV9vCKuArSlm4VeEoS00LKSKA2xZGVytWbQur4S0kijgPCloYA4G7BS2sAnFCouhYDwBqoeo/T7Aq4EI/VlXVtJsLIwg4D38RRE2bIDsOADCTNBPySw4AiCARYEfBQiEFAGKnBZKZTY34Ba3Yixa/jPgFiRZip02C8gW/7Q4xWhl/8AS/YhiwO3brBFNp7rTbrb9y6QS/a+QELXtL0JuDZeEFv7V3p70XO1/eBL9T3rIHsb8xwwW/WNqsvTvtB"
	$bData &= "DtU1wS/U3vLFjEnBb9L0gRo2O60v0jQBDvz0+40rP8+ywS/PQgtULvKBKe/lnBZYgMdvv8AUZTr0EEOAOBRDlDVTAvbAoKQQQNbMXXMVv5mBugElUpzUFcJkASAh3A3kgQBUlBQGwjkm61uAAC0ALq8vAAVFbBnIiAP/1e1hNPcWw4A7GsOACi3pDmQLQ/wPlhI0oDrHuv//4pmC2dZUm5oX4eGf5OVjoeH/my1u38WIl9TamGoqaXEtrsL0gDFFiIua9O0v9tfWXFtZLKysbkAoIg70zRNf4eUqC46N+3fsmVfYFelpaOuAIZjaG53pvn/O26lKHLBN3a3aXuOhJk6Rv6b9mNfeHRtogCCR1RlCW/mAHj/7Ez77wV5/wJ4+0hyoHwAl0ZftPbtfYWCfyJPAA5eyABwUnEEco+d/a8HdP8DcvhhbHl7AEZfh4W8abfbhIsAOD9HGPkAbFJtbv8addnbISkYIdA7ZqBtAP9v29hGX+B7gA"
	$bData &= "AtN0UAYu0AZfEAZvKxM///HW75WJT/gbP/Z5//N2CgYkZf//9N+25raXQAPgRVxwBd3wBe4S5w7YWw/8jt+7Ez//+Lt/9CVnVfRl9mYVtoAPn//01SHjphAFXMAFfPHWHWYY/2gKj/LVqrT7T/2J1eRl9lXlZdXVxdAEW7+//fIjhZCUehAE27BUuxHkeCRUdJjjpGmvcHil9hXVVRUlEARz1nmqZpOT5ESy43s0BxOl9lYExNSuJ4L7FGASJgWd9xnP0fYFpSVFNMT1BKUwoW3+2IIAqfpgCUMk3TNI6Sm6r/f7sin5EAd3+CSJeyMaTKQKHAdJCZ/wHRmYxqn42NjWF2fw3tN03zq+oAuLm6uPtSkqqFAJnNfyoyn2xsbBmV0wCusNnfUWkEsQfeBK/5bH2EgQDTND8Vn1ljaACipafRzTRNqK60akOGqBqa5qein09eZwCZm538m6ZppMPfzf8/gahra2tpmv+UW1tbCIfLAJGSoZT"
	$bData &= "8m6bZ/97/TG1/ZmZmpmma/15eXjVgeACEh4+2AZFpb7gzf7FaAGKfmf//21QANVlsDnGmAHq7B3e0JmeKUFJUVhmkXRGfTQBKSxMBRKZOn6NpmqZpAJCJjpip/6MVkZ9EcHd7Q4itLpJfiOj+xz2RvW+IlHCfNFlqgd91/HcMlekAoOShBQKg+0+Hp3+Rik5u0J/oFYHPAJdN0zRFnpiZmpuZaX5K/vlpd4F/f39OVl0AjZCbaZqmkZOZoGRAejQ/FdmlcgCfQ1FbAIWH3zRN04iQsM67/zx1pfOfikYan1JSUgd0ygB99rY0TX6OyGRJZXxjAKI/SkWfbi1TcABznmm/aZp1fqe//zFyr1YAYV+BAZGfdC9NZgxiRWT/t6QquwZnsyNbh0xOUFUAn6ZpmnZLAEZERklIBBCZTZ+MRVBc34KQQdR/TvkngmZeVVxeVFEKn+IA7hYin2ZeVXEB3J35dGmMjoYKFl6MRAHFnxbavxqfLIkO"
	$bData &= "ADyZBtCQhanZqxG6EMkpY6gCT/jmQmz5AeoXT0MWiGWJF0/vBkBBCD8ExyJK/2RzgGjvJIw0nAtAkCiJT0AsAIN5TygKQrDvP5sDFYXvHI8snyXPhTTMEQ0qsBTJpAWKNhaClxdnomUL2FsXZ2hQULCfiGRzgOcQkiCiglVVx6+fUSg2iAXnoc3mAQSVFKWwApM0B4WjGAmIFnugkAIoiv8FLVRQ2i+fLxZ7W+y5/wUviP8FhSLA2C8xYm+LvS+3/wUvhv8FhQZK2y9fC82CsS85L1DaFnuE/wUvFowtFL8vtthbKKEvg/8//wUvLVQAxmkvWagUjOEvNcNO+z6O/12gBTGGL6e1rRmkjQUuobrFBadtQzAxH2JArs4FQI3SxpphL7bZBS6mtJjWDMbhBUBeRAuiIBGvcyHN5tyX7KfICS4RcskYoDcvQEEYPzcqtlsdnwQ3t7dgbLcEN2/dqthWN5cEC3uwvzdzzP+g3AVcwzcFagq1E"
	$bData &= "DdXCimFXQQ3lauL0rY3na0qSmM3pcFqorQ3rb8UBNYcvtMFvrTd6BqV1wTXdqvrN38ENydbVe9WBDfPBCFI7bE3gf8Fv5KCwJqrxgW+nkUPEI3fzJoO5qo0BzU2DAtfNhFoq5KT5AoFUFwHoUctOghEu2RrR+4CMcITWGS2DgLRa0dbuxEMi0zbayaTyWRkMplMRCaTyYUEFRRHlaxQQV+dAtFuEWRrFAYQJ3+iNQNE/6a2BrjNmIoFqzNnPLEqOZAJpt6KUVuqBRdft2JGPBAuBUA2aMRiX8tfQRypqH8m2yCiPwVnMplMIlQETV8Qtn9Vv+CvDgDwvwaoAE7SHAR/BQiAACEjFkofzQGCEJ+wsMAv5EKawMgGoABgqwoIHyerQkQi50EQhfygsQ4AsMEIoEL+9LwOAATNFaOk/4TIDgCU2A5jbRMPUIDODgEUtNDwDqOCABlEBQSRhKgFIGegjW8q/vUFDwBQF+SS5qBrSxoXFRMJJK"
	$bData &= "M1jRQEDwCB/FdYDQ8AaB0PkTxQsAeOuDBbbbGHXQdPp7vabQSHAgcBp8nFLRRvBbwNGTBO3hgOGxUEY9WmuwOnqK1AnvoBp2rAWEHXu27RXAhnp5+soBKMBJtgXLQwv6cFV20FleunA8ElGA5HO4JxAVunBUKwFVyLp7aCSzDbp6FguKsBrytYQDQRAT9BHkLBe0tNUBFTQP4obaH/SVNajwEYBGM7Ba1AVN+b7YquVYcDB2gLut4ED4cHRiioBafUQltaQgenEa12C4cCBz+e591GbwUODRUYbsE4eRsVS9KtipDHnwGazWZ7CWgAKJiboN+f8hZWBOcPHxYrr6cIYwWh10VzIQhLZ6eCgDC6nwSbcdHCsL+nBbUVBITrpwNhOFwDRzvGBWwFpwXBVjAQi6cKBsII24ThrtqnAa8B0UQUKwE/HygIY3svZJ3/MQXk/x9vvf8raaT/TlZfj8lrthcESQBPStsG/0QuCGPKUAtDICLHD3d"
	$bData &= "4YxOtPQAt5gYs0bUO0IOHhHO7XQMHBA8CFQpQQMePpKCQEaFEJWGbSsIIRY/rEYpCqY+FUp2EO486CSMUi0YoCqWPFEp1EtuPKiaMUCsYqyi0j1AoUUx7jwJVWxEH/6vTIItUIg8AZDIPAE7SHMjwGFEayBgMspBCoYlEIpGRSCQSEolEIiKRSCQkEolEsiyRSCKyLMuKqphsq1czBQ2DbKQ5kP87DwB8Sw8AmAgPLYNakZxwCJaF2uwVF+oBTV9BsARs6gFfjQVgH+fl4wVf2KqdKWoFX2ksAPvh2tYFX8ZW7SyUBV+tIkrBBT9IVlAQn69CDCh/LERHFAHyDwA8VOwjigD5TA8A/FwRRYD8rFUPALxlQcJi4Wxe/m4PEkkzFDsHEiWHChLTUMK2tvYuKAUvKTWNS+3eLyIFLrWoAAf5h0oOggUfsG1t7d0oBS8pNUKX2r0vIgUuAIJVJBkfalMp+WlVUJWr29S2LxUaC0JIb1YECy4f"
	$bData &= "H7J5Dij/YHAgAgLJJVMV+CUvFijhL1DCWGqLYs8pX7W1lbwotDUvpWK1bTUvnxbFYqkpL/8Ee7HUKV8oni9qa6u9NS81L8VSG8XPKS+VOlK7KC9fNmCrMIcvNcGR2rYvNY9rRLJ5tGLEchBLcK1TXy/HWgCuvy8oayt5tb8otCmuEAtdXy/v1lYgp1CwL1vJqz0ovyieKYVY6FqPL1YFWO01Lx9bao/QLyhfKVWAN3kvKR8DirB5/GQMdR+wWIoDjylsxVo4jzXhL2Fsdbw1XzUOhIoks4/hwGKDKY9iW3NrNRe/NVglV8HaH56BxQIdjym35tbCjzUpvzUVjI2K/zUf5pmgWP9md5qDEsBMSEc5UQYByEkkSIQ8RNEHpxagbxUAGCd/UAUragfHvHa6rVcEKwAIBgs0TQSk8gsKhiCChccYzWaz2QABGAMbBh0IHw7ZbDabIRQjGSUfJSAns9k+nQcbFyYADyYJKA0CEEEEx78fZ7PZb"
	$bData &= "AADIAghECEXI9lsNpskLkJEX2FqbWabzWazaFtVMDUoJigaKkZRYTYRK6/tFYEIx38FHAAOs9lsnhwdLF9qebx+d7LMZux6/3VeD7PZnqx2hwD6j9WOwUXNZph4SicWlwbPYlUFy8dms9mufxsADSAfTFB+/zebzc90/1//U/82YX3/GH2+/wiP5v///+f/AZf6/wOY+P8Okeb/JYrM/0uGrP+DjZP/kzloNs/gl45ILg/WB3ltiEA/xAAUBisieJ7nPTkjBMdsNtsLAx4ABxscX2N+OxmQ2fJqszlO5HlK+13/CoTTYKAGq6zof/C5qKT/5zCLxv+AkJnZbB0J+6oA7rK6ted5XrOXu4AGiJi0nit5ntP1//vYAILneaZpIMfMZrO9BR4ADVRCf/Jnwd+SgFsuU2n/Aozlli553kmirAavsK694uYK16MGlPHujbP/mJvNZrMA/6X/q/+x/7L/s88zRDMHyWMFm+0VBccGHwAVfsZoTP"
	$bData &= "FvNv9R/zJIVP8Eg9V/poNugRzGqh+tzmz/DpOrH5n8/zuMwf+WAP+eNQuz2f+n/6i3BxcUPEPgUMcJ9ndqtmwARnf+9zxBRP8PbqdQlxw9zZj7oaVOqK0XXdEVf61nqZekA7roeQaflnZFirfMHlgDm5wA16IABwpEMASQx81ms/XfGQAMfZVr/0j/mGKz4idFVYaE15r9j6PetQsuz6fXqgepJ/63YAq/osd2AY7r/2yElDB7ZA/PlAB/mQAHgFXBEIPHBmS2158ReQDHYWaz4I57GlR1Zo7pmPnknbyTnKEGpKUOpjneruClt6BXm/8HdRBg/5Py/yyDvP+FAHeQ5wLYgQDfB/ubbQCCIsciAAQdE3OxAW023lr/OZpTfFlwFVyHRozmAJf5n5wOruQ9ngagn7ad/Wb7TplWl/oGlfWR7/8LhtWzDQcEA4YA/4eCIWBm/4gHbsd/0W0gbQDhVVVGMz9G/xRdiGbBKTaI35eS796V9Lf"
	$bData &= "Ykc2W95j6m/4HJr/Bw9ma/D+V9je+fwKFsBDghdlv/gjY4ClmB94HOBGAanQf1q1QiSc2ET7N1z6bzYIXjlZ9hoHUht6K47LZbDaM547rkO6R8DsEBzuU9AcHr4/tbgTwm2eN6eWH4P8OesEDPLN1D3AA/3YHtquCIWAHNscDzdYbtx0ADV6isNm2/2Y8PD3/GU1pOHjHBoDTg9mPmuZZ3oXc34kMhg+ODZv/v+gG6f8Ykez/HZPt/yGVHZIGGv1wZMOQ6TaI4YTbTy1trQFGcM4en24A/weGgJlvB6x3mc12BRoACFJXUay4EwRrI0JULmal3yzYHM7Ge8tufs9/0v8ah+Y3izY7mX5HoE2k8/9TqZfb/v5Xq/j/XrD7JyGL3W6C1VfeNqDffHzN/wZ0VFxi/2Ji9jgCOGuGXgcR4hkAwQzPldlsFyIAE07bQyZsNit+O0D/EVN6fm+4c791whYtWNF5rkKVhn7ALrPsN9un2Yi+9Mu2"
	$bData &= "7gaCw02c5MNthhWuf80vdiABcboebL0kaFtvm1wA/12eoZrZ/14H+YbbVcR4BV8iAAw+wN9sNlRF/Dz/Jj9M/whbfLPgGG6w1m20b7f/J33BTKHad7MeagH3x7aLwKboUpmedr9O64Thy3C6AmqtTg5PAOA54QhnRgfPM0QbpgfylyJmu6Ib7yQABx+ON5vNFjyAPv04/yI+Td7N/2bTWI2+Y6RmqP8HaKv/Mnu6obXqplVGcqnuTI3JDnGz/Gaz2cZprGirZ6lcj/85SFPZbI0Bl0oA7EvJTPO8ZrO0TK9NvQbU8PM8V8j//NWZsKpDz1IJf2az2R6+HwALJB80bjjmL8DN7TX/KTYGD0pu/wFYkjt5NttdmgZem1+cnZwvvh6N+A1Ugj5YB8YGeDoBghnVADEfBTdOnue1RAASBjRRX01VMOl5LghHzdbggL7PKAANKBjfbDabLDM0lTXjM/8rMTb/r1i14BlAWd5HazZKcl5KcP8Wr"
	$bData &= "33/rkaGIEBV/S05QNVWjS8AQo4k2izgeQYUDN8yWASUn8+b7ZQyb08XJwAjKkYsPM9rNngukwagm4q9V6X3Zy4w9iAGFhYOULCIYo/H4ILVChdPCM871MBvxoYeBiUnLgJtdyYHIS0AHdfWybtoDy8HfgQBzXYK4vcDKgAGKAzBc/CaKQ8GEM4QDK+wiLh1BveQoBUDx3kAtimjCBe3sBBFEMcHrKoJCD/thEARx5YHQagiCMeP5HmedwIOBQgLChdwcLsJNwPfF4ILUhBvB5fJ8zzvEAYWGR8eQXDyuh8VVg0Dxzm4ilBnBn4MNpv3ORsmPABdWWJsXeei2WxmTFkgOq4viOR5niIXDwhiFRcQF5vN9rlvGidhAGV8uYHre33ICzAHBnGbzWazAP9y/377gNh+nmXBRVc0UccRhwbPYlUFJ8fZbFusf3cWTQBJhMt2/d+JgC86X4H/GGy7/wh75v9/NwX6+f8Cgff/Cnri/xtywv852W"
	$bData &= "wd/mua/2RsdP8HgwDjgaBtwDm6qFWPD4e6YlVdF4cZ/1AHVWZXVvE2TFxq/w5y8rz3tM5YiI4Gkg6TlMX/4HOQjP/nIG22/1hlcdfNZrvWBp0A76O/rpmr6gKas4MXN5vtAT5VAD6I8W3/R1rPOyn4a/8EeOKWi5QOlZa/rZs8lx+UP04Dfu4APAz1/zZolhcOACNg4KfOx0B1AbkfF6g7Pb0GDrbFz1JWWSdPQZfs0IaHjZLxDGwFzweTkWup/1zPiYL8/yVqq35OwBhYBpZPMKoLsKYAH802URcXdwA+ef7BDnWYW+5bVoH7xl3J0UmJj1aRk39aLLgnkMfnhoD4/ylmezDWY5tWz40A/5uoC3gBHhdGVweElgaQRxTV+lA+BHHXHv2Pi11wwYrPjteQB+8mB7ePN4zGiXd46v9DDRxwileWpv7gBVy8DqceGbCILhefFvysgw8OxH48S1l2eOnBydNsgfmFh4uP7Tm5do0HjIqIVwD"
	$bData &= "HN7tngvt98v8aZL6A2Rq9vv+DAP+JoegCXh4XWUXABccQjtxxsCz4fipPcUZ35s+C1a5oJ4U/iAevpgvo3gdXgQ5/3npq9Xvv/wam5l5wAYcRDo4fIRDBRW7HFvwhVK7fbiJPd4Z032az2Wx56XzvfvSA9+DJ7MiC+oT+B4WE/X7v4eS2/PY3b34BcNhqhIu1LpcWBVzAwebPHyRcQTV0Hw5Z8BfQNsoWKEpnhm3Um81ms3LedeN353nreu4nTVs2e/AG9P8/fn1N03QBDn17eXfgrN80dXPg/whku88JR7wMj/5GcAVcwH4fNoSrKRivCxadLsCtnz45QEjODpqmaZptb3FzdXhpmqZpeXp9f4FwZMOmfnzpNnThcNsAsxX9TxtTJk4A/1mAF2CdR2kAHnBEgLoX3k+AQRGeUMdOBekCOoRZhmcOaaZpmqZrbXWHj5qmaZqUmZugj3n8b1Zsb9WObNJqzf8DYbn/OD9GC7BHt7ZfYwAj"
	$bData &= "RF3AHhf4Ang4jubZ9iBEYzRdgAFuDmJl0zRN02iFs+DpYdM0Tfbjto5uzaSg35wvZcNguv8mQVocnYAzI6ZGX0B1AQOmF5vNdojWPQBQR/s7/wmm6QLaTYxAXA5eX5tmQppuqN6LZ7+d4HcHr08BWqz/Iz++lqSQEQhrBgJWzhRD1ghUF/AeF+3fbC/PEj4Acz39MjY5/wZJiUhTTdN0AQ5WV2yVtk3TNJ1/YVisRleryARseKkuS4quOwZegNaO/kMA4JrNZu5Hy0m3TLAGXBCoLhfPCW3/ZqsxAGU36zAxMv8RPWVQSpJNns2zBk6am1CcnWYr+O0WTS4JRH7/HDU2LgD7L0iHms3OL4oqPZYWblVdwAUXB/BFpFJvHiY7FnxwVo3e4Csv1hcy5gw7adUn+Gf/CD5wpgYOOmYaNV6z2b7WJi41+ysA0yeWHVB2NKVO3vMGJBSeDAKfIBRTAQWna7qA594aPi5xjg6q2WzfnwaaJQCOI"
	$bData &= "2sbOcdK0lS2Jx6PWimASw8FE2uiFwlnGI9ODk7eJg4lILYcD26dvIsvB34EAfdOPqYgBPYID7h1t9YH/wb3cFGxgq8EMgAXXJ8H5wa3K6ALUBeCLiAE7xdFwAWsD13AqoLHDwWATHIEC4KpuoAXBq9tki7gDg4UIAfGgk3AGzfXLghBXC+/CLN9Tg6GECMuNwBEVTSbzWZhYG1baFBVIDVAyfNcriYaEWGCLiAXDtdsthPnLFsAanW8euwO9EbEQmb2D2az2Y7OggD6itWJmHAFSdOBSpYWC0ZTUWMnDR/0N2i2RgBQes+XP12G/xpevf9dwKum5f8BaA5p9/8JZOL/F10xYaz/vv8yW5P/XGNsJ0YLaDbbjgDgkZeGSEFdwKIPF+Jm2yAfHFoAY3vyWWV5TQewThJijm5zBnY+Srjkd3VfAVKlhA/mHVyzDmrZbJ+yx5adAP+n7rACuAyzurQv4GZrEYdRAEJ88lNjzzspuIgGY+KWcX"
	$bData &= "gGeXrFE8EledcDZu6uKAEHYFqRn64CVsAFDzuMK+AXFabGYd4FU/xkZ/8LXM9/cod2BnjFCk5OeXjHzwFj/advafz/JF2qPrqAVXAPF/yrU6GeRq7+KliXSw5GFmZp+3LOdFxBt4J3twd2x3FCftMFDm1o+P8oV5oXdAErFwyr9VlXBpVuCV0eav1gcsEUj3DPc4Ptdu3XF3Q3clfGFtgFfHdiDlNrBi5j+QIPLwDcFaLfEQsuDl5Wx1Jebj7pjvnObP8MW8EkcdcHcgV02xW3b1dnagtCftMOZlaq/2BgYAEXcQEXBDYL3jROE94/WHx2X+Zl8u2k2Wxo+Wn9a20HAQfbyW5tL682TdN0DmloZmNa0Iq4gLFGD4MVXMAXx2bBu4Fe4ThUe05d3zabRcph6QZm9Gf3afp9XUhbBv79z63fe/g/Z/Y3b34BW9iwIi5gHg//aAUXF1dkZGTNPLPZbJ9RWdQGXt5g42HnPJvNZmPrZe5m8Gf"
	$bData &= "y9KbpApYOZ2XWpmmaY2FgX1O7WBEX8O4PmILrCxfnDbi1vQK+okhOVihSxpY0TdMFDllcXV7TNE3TYWJjZ2lN0zRNa2hnXl1aAt7aNFhIh4ZxAQviDxcgNAhXCLZXdAET/L4NSJ3PVQ5X0zRN01hhdX2CTdM0TYeJjn1lWUJ+0zRXVk+5/zc9RVd0AQsXEwEG4B+22ypCYmY0TdN0DlBSVXSk0zRN09Te6taoTdM0TX1cU1JPO7qAACEXtDfbqww7AFRB/BFBgzhLNE3TBQ5MTV6b0zTNhNN9Vk6XMTBNTUq+rkAKuIAPOnQFXBcHTha6gPZvgDY5PP0MPYJARA5FaZqmaUheiJJyv2maplJHR0U+iv8oM0JjwAUonv+AyzBbSADsSS/AmUEhtws0Kv5Vpm4yMzTtFzVgNjwmz7OtxkCaBkGbnJ0voOv2Fj8uBjqBvjAPs9lsBg4A+zXGNngwuIxcQDEPLzY4FAKHALXBN5seMy2VKy4z"
	$bData &= "5YcPMm66+d9uCTRv/wg0cP8MMhYwUu4sNf8FvGb7RvssANApjWZCRaVW0A+fdtIcKtYHDyAA5zWbzUYkeCWTJqAGmwrVJb2KJmeUMN4gtYikaRYOSZopimcCBcDJ87wWBh4lJyGDFSVdDh3GfyAGCzdwrw8AgL8HJURsBqgfo1+AkpM0HIAfADkItgFGqMlCgrdzOWqpAQEHUFnEBifTSgpYBFLA8EwbBz8AmC1iCZBINAQ/MCSqDvk/qhgmAokABAwrP0ABswI/BQoYgL9WQwiABT+IgIgwbVIF3EA/KILRlDtgawR0QM+23wY4GKQ5uC0/kg7EQpWcEBgFIIBiAW/EhoQQbgWMoiIBb2DLF2B5FwJAEaJvQRGCSmPJiixRF2+ZTCaTk8lkMjKZTCYmk8lkZDKZTEwmk8nJZDKZmUwmk5PJZDIymUwmJpPJZGQymUxMJpPJiIoQmb+gaNIq70BAARA/P0ABa//nDwCw9xZVdQG/mUwmK"
	$bData &= "2+TyWQyMplMJiaTyWRkMplMTCaTyclkMpmZTCaTk8lkMjKZTCYmk8lkZDKZTEwmk8lIZDKZAklRBXUBAYK/NnQzbQIQAAAMhTnJH9SrRAEAACPkhNkylmXILSKCAwSm2AFUGAEA7T4ReHD4AHsKBaS9QxAHfBEAGFXSwCLHTfMNAEEBMR4rTavMNDcjl2t0DkEkbwR1/wx3B3ZTC1QsXq0BPJUIoDKdadoURZc8ACcmnWmapoGgQzEofUQCW5dj76sMb2JxCKIFB25eZQ5YoK0BQZp2AFSXOAAOTmmapml1eGsZNyJ5+6cAXd0AZfAE8UCC/0Sx+AIHZvJerUBVATY4AZeXpmlXMwATK1pBEzjTNBwyNBDR7ENUXN3dUAXaAcViZK0dADNEUNVIl5qmadovACoKFhsSDJimaS0uAUWCoonaBXYS0qaKrS4ALwSMKKqXqJJ2QVkuAAA7KlUFlzYFFIsERFh9Ax+VXVwAl4Jwa5CAag6yBf"
	$bData &= "aqOgQ/l2n7BdO0C4gYACoT/6IyTQ4nl4Fvam5cV7vY//9rWVRoV1JmVVBjU09iUk1gUEwFXyNWLNFGNV8CtUHFR5Urnij2ccVhUU2CTmUaWCwUjpqmBNUiEV3Wl2kXEO1m9gUYAAqVaZqmK04mMZe4UQIWFmdWUeGdlPAMqFdJRlSV3I4pqkIEQVBE2xVbsTUFUXErWihiR5USi2h4cTNfKf4gSFZJRVuOrmZVURDtEFSXZfAFmqZpFxgAFlp1gRMrlWkel9IK/yoo8IBuaoAWWUtHPjY0JyS2AHL7Ix8dHR4FHDVQbFvEBadHDS9BS5VxM6QIMxEf1a/A78A5MTBYSkY4alhUcV5al6K9QB6AbmHpBdM07QIYABtaeHigMk2gK5d+bGgRi6+UJJAuKSjERxVtJdYFREb1r24AKCUknGRUT2xbV5fRTlAt1pdf4wU7CJIUGABM0zRNEkFrQzeMf8aql8ZgUUw9NQJqqyFqhAVqxn8bTwA"
	$bData &= "0LixeT0toV1TH7QKiPVzdBRgALjBN0zQdGTFBYpJIzMcMJoLa6iYjIoQFCXvUjN8AWkxIZVVSx1jWBYiBBUQnwwjTLi0AAe6IqgwywM6XcaFJBE5jU1CAaI+ax1fQBTIiUbWX7iyIqgywl5pxsyjQYVJPx7WAaI9TyAUw4jxElywsLO4FUZUQipczLiKFeGBRTscWEO1RUcIFMsKuqJcCAO6YMYKql8e1gGiHTboFJY98QJcBAQGBb2pDzBhBx0moWkC0swWXAQCYkcdULSDaSKwFl1HJzUjGV0pG7aPKEgGXB0SkBQAzFhDHtWZjEdFkQcBel0KbBQBmhALHSMzGItEB0R6ZOkGUBRYBMGPH00RiNtEZC4j22j6OBbOxCIDH0bQfMBKaR4oFQs1YQMekEVEVLzNWQQic78f+SMzG0TxCWZHtagHRBZcBMMIuqpcDAO7kiKiSh1QxG5uxx9FRi4g2GAGgVWF0Ry8tqJIbTiQhIWoWEKgB"
	$bData &= "O4oFCra/0Wt0UQFH2YulFfcAOTIwTQC6XQFVkXAAMCspipK4myZpWFWHZgGBWgE7liDYCL/R0UUtKEfhllas966K9tubzCgkI1kAeWtpgG9sBYkB44tsYmC0SXxLJlivgEVtQYcBULBVszu/i1pQLNGlrxmjR8dqWFOoaP+LAFNGQzIsKx0cHBgBEhjGnxsaGi0pJ94zrrYMdBpvXVnHAQtgEzMBoGCrZju/F7WgWNFHAF8zRsdsWlUKhhImmh73lUgyeHqoUkVCBFWbpZBRO1IpCFAstXFBVAQhILVnUuBXIRZVSERaS0g4V1oiAVgqcV9bVW1VEocBsFCzgDu/kABsUdFGF7UKR1r8KwKPb1xXbVtW7orkvdJsaVdSaARWRiwUIXaC0OoZLxaapm5cwYK6BayX7dUhyiUBb2kO5P80hRAARJUQADgOPA8fVCUnEA4xh8jP8/xgBwCC8jmSur/B3vM8pV8HTwdV255fAIb0Dg1nByfP8"
	$bData &= "2A/O5O7pKhg7XkGXQZP3y6Q5/0Afu8LBqj/37yPIHg5L4HxNQbuCkYVnBDPPgyC5wp5q903368TUgD+BgbDPc/zPP/nbSghCp6T5zZNv/Y7N/M8z4597gbw/8dz8m7PFjQ3FRYxGScTjNosnz/F5vK853kGbCokNku891HBc/U533Xqgwbbc3ue/9cZJxsj51DwnHRHj+IJP/Ke53147OcG/9oOHsA9t5N3XRbUV0/+Q3tO2qCf9oXWFyeTC553tgbmDj+OQ9SAlOF/cJ7ned7oBwbx/jMIsGnvOXn/0SGnJsvzPig4Zz9z6ZoG/8/zPM/9ZJHlOKQ9z/M84zO23iZ2ScGIlz4IMi8n1y643xcnJ8tme95HBN9s5TwG/9JncvJO2h6C4jbRxH1QcHJnq99u5gGoep7nBqD//RZvcm0RjD8v3wgWwXInP9+097yPZ+JTBv+yZx64PO/knVIWDv4eAUV5HxWcw09q5AEGglYFF+yFPxffML"
	$bData &= "k2Cj8v3xHBClLfP9+T9p73Y+BGBv/GZx6NnJycvNY2wNBatc97oAbXZeGIBv+FtUUwalc/L1gEy8nfJz9z8j4i317dEgb7G/ecPM8QyP/jL58fFJy0Jq18R2DeFd7Jc3sGKxcaJhQGLQbt5Hlp/4aXXFNOCj4T+i/fuAgOFhffP3t53gMVP1rapgb/tTt53u0DJzMeOQZVBh8UPM/+9RpHXP8/3N57nud5Bv5O7P02Ljt53snaTAZ+/0yfnpOCQT6nswIu5HlO1P0b9PM+KFDfVdgYBuVetz3P/74u1zcRPoA+Kjp5+2cHV9my8zzP8wbnLsPgH8/zPM+t6UTM/+152qA9JZ/+GecRPM87vAYsKj0/B2DEc/5lv1HVnnfyvCgG3P/oHuH7ADjRTQ9wJ6o9z3tS1poG/+0yZ7mQp8E/Kt7gBZx4Lvpsn8/zvL+nTNMKBnjR+v9gxvM85J8sB4g97yFN00EGpy9vPM9TMD4Le9P7wYznneM"
	$bData &= "GnSl/kH91aL+UkxAApKMf7KMCUTj4B31pZJ7neZ45krq/pV95K9h7B08Hbg4uWijkDac7zzt5Dj6Tu6QGXQb3RgVrT99eCwZwuECeqP/fF3DyriAvNQbuEIUcXFXPDD6rLwDBc903324GnuedPMPnBm0oIYHDyfM2Tb/2vzfzTt5VN2bwxwYW5J282zQ3FRYxGZ4sLk6eqwbF5iZsTp7neSokS7z1cJsqWN+DX9fbtedmBycbI+ePR90uCp7iCT/nV9p28m4Xp8AfXRbUV0+5XSTv/p5DhWfW5HbB7RcntvcOR45eiEPn4b/uB+T5OHnxM04IsMHJybvRpiHLZz/P08lFmv3eZJHBdvI85Tjj12cVXLGn3iaXCD9y7eTaMsffJyfLyQtxaL9GPLhdcsXSj4LRF8S4SE4u32erASuqLjnmoBZvuSgYBD/fZ+3kCjmrU7JnC07eybhSFg7+h4argpNFw08BdwUEF+yFPxffJ1fJyVOyRcM3"
	$bData &= "nVwhRsZXjZOT2yXAN9BauE3UgLXXiI+FKjm5Kt9Gxrwr5ORatRIG+1zyXJ0bfhDI46Lg5PYvn618R6EaucAGKxo/7ZLneb4ULWmGlwXKBRcTP/rfEIcmF62/txfkhi+mBgMnM8nRpAqOOa5VbhfJwfVGGt5XTnDyTq6G7DYu2kx2kVxy5n5Mp08R3G7vswYCJ9SvGz/eRXJw9N4aGKbl9Fx7Tr4u1xGA3lVycgb7Z7KO5w3NVFCv4B//2jt53umeRMztBiWfmidMLhn+vCziuQhGPT/+ZSUPEzC/KObciW7JwejO4Q9wdgUTwCea1zJnLuTgAio+3uDAiUZL32yfTZ53W6cKfnjRmHEa0Y/kDp8HEbtoCkFHL29xyXNwC8570+PEAmmafp0p8n81Qcf0oRAABLIQACglkzQTqggAab8uIudJQD0HAMmaKaCk6r4JcFHGb0E4Nk5CQKaCUHBDIPLFnRDEdjZuW1b/H1QlX35saIFvaiiSB"
	$bData &= "SBV2Ask/wYA/+KADBBCV1IhsYoj4f+38xRRxf9BODUmq0bIXf9kMplMTCaTyclkMpmZTCaTk8lkMjKZTCYmk8lkZDKZTEwmk8nJZDKZmUwmk5PJZDIymUwmJpPJZJMzmUwAgBKTV/+Xri4Fn0SWOYiEbVTCBqgDXxBRgJykDoADraAAgUdQgMCCfx9FIMBCfxBgK5iHf7AVzCJffwpmEQg3swgE2H8PBAJsBX8BtoJY539bQSwCv3+glqgAE9Rksq1/wFJQSzt/K6glKmMXUG0BfxRKVMiqtp4kxlSrYonjnxpBYFSXEBhUJZ8GValGb59VqhEER59qBIFBH0FgUJWfGFSlCvefValCEM+fohAEQqcEgUDVn6gBtip/f5vKJaCWc08CNoegn+S59MnkkiOp3jwePP8KJYzfZ1pWZVhU/f9/xWNWBFRQTT87Rzs3Qzc0QTYzPzQyPTMxPERA8pwFMjA7/3/zyDwzMT5ANTJCNjRGOjdKPT"
	$bData &= "lRQj5C1nJLUsFiSKEbqATGYmoVC6Fvtf/8TotQ3pZkV1NhVVH7f4FIBj41MyMeHRUTExIQEAXtbTOzERELERcdBRgUBwAQHdxRcaFYaiJ2OxZMQT1UeogB/gVXbAKHAygdBate1Cr/XvhiVTRNe8dSTmgoIyEIAEOOqEguTdOpp6WjTXMZIKSmp6b6TdM0ikEJJyIhS0A+P4SSUEA0BVSBlVQo/m43A1BA/vKoJiEgFEnTtBsAp9/qftM0Q96gGyUhH05BPzzwIZZABGkLQGEVuwX/07RX3EdQ+D0zMgwAr+Y0ExVJ6uamcQd10w04Ly3EXU1KAtLlAlAEU3+qJCz6F09FQRwZGABQ0rRiAN7qV5Iyzdxb7kxBPiqWvOtYSkcET2lXUv+UtL/V/05EQAwKCq4A6hR+MwWiDAsLST88BYWIj0xSTv5fCqHiCv/fTEIKKGnaPwUAy+pAiZtmwAdGPDmygW5KBbbuafmgENIF30xCP1kAIK3"
	$bData &= "OAOpumqsKxAhEOzjhEiGwWFYFQsU4C//+ASVNe0pBPgYAzOoiXslMwZQ5N0ro0p10X1BLFmkBS2GI30rfcCkUVP8QJ5Cbv/5PQ0BfT1NPaIFvK6DkkWrKysrm4pKwvwDf/l5iQYyQY96p5Iio/0IIFFUZ34qqyrj/3yqgVUX/31VprKrfUJV8RYBuatCgqir/EkmFlN//IpFIJCQSiUREIpFISCQSiYlEIpGRSCQSEolEIiKRSCQkEolERCKRSEgkEomJRCKRkUgkEhKJRCJJiUgk/wEAlRTfFlXVSP/JVFEl/10tqKpG/x0VVUnfNRohCgr/Sp6Aiv+Bb2ogNLCK/+CGvhn2BhEAkJefRnKS5phVaJcNJ3G5r8bSITgFIUDk0BthCMj4V0lFVQ4heAIz2kaiTaZdQQVEIxUMioXLuxwOhlHI1OBTgso47PyJh4qCFp4IF8pYuA40mHRkX5pWJEBGAQAuMiMIpmk3O8egc3GOP2ZViE7B"
	$bData &= "Sdw5gIKOjK5u6C6STUI/RkxeKCQUsUsFpBMwLkwqQcLG4jSUmsom/oX8NGRUUXFhXXWrFYXkj+xSJeEOYwwQLCcm/2IA0IEKLCgmQzo3i0AsTrI0mGxeTGu0iVmQAgAtv1oNKI9yhDQuLRvUHVXSGhnuUCRINzNFseVSbRe44n8Y/kEyLzoxLxwkMi0rp/irDEIqSmhaVn9yb48xMeAJ55ExQEBAP7ijSlIIPB8ARTUxA5aioncXWbri4lVFQS44oFZJR2Gapr0afG9sAwAsMTYByIRFjyyBgIq79ks+O4PfAeJjF0o9OsZSRkNgUxUhCvtQeGtoBACP1kYgqLgCIFtKRo9/IwI6W89PREFdUU513pQ8xWlmjzAwMFdTjKUCKoMXOYH8X45MQT9aT0tyZ2RbVv9UQfJWSEtAPllOS3HOB8jPZmMrKytVR0SRDQgqgxcZQv5/jkk/PVhNSXBlYgUFBVRIcwIiV0xkILkTFj9UR0NAvnioS"
	$bData &= "D48jm9kYUCKKHk6Ojp5MShor49IKMSCKM+RgGhArzRhEFWPP0U3UlTvIaKKBY8I6sZSnu8Mgjo0fxWjiiY/j0QDVkGvMCbaESoAHDeuKJqwmj8SwzRN0wA9Z0E2pg1RdO8aAFNFhWmac5wqj6Zp2hEWAFNwfiGKBpgdrzBN07QMAClLJTBNO6KojycAEw4Bdcg0Jn9g+QYC/8YgoAa/MTEI6O9/uSxLJEiRSCQSEolEIiKRSCQkEolERCKRSEgkEomJRCKRkUgkEhKJRCIikUgkJBKJREQikUhIJBKJiUQikagAABlIGhARcltWtAioSz+hVFATbxspKgr/IKhSWk7PQBXFxH+EqpigbyAqApCPFNQEpW+IouI8fX19j91ITVBv73mCAhRviaBqY08RRAzAW1a/y5JLSj8wURXJWlVJl4EzJr5vo4pFRY+AkmoDjkgKmiAMrzjLK65KjllNSnFYEBVDz6igAaePSkavVhRfcU1CXlBNdG"
	$bData &= "hlj10SnBIOflw8TRAkXMuK4h9gAFJPd2pnjwy/kcKiHBsbQzMw8wfEQhUXRNK4kdI0MXBUR0UpCgoXRHptai9GCgIY0khaBFT8KCIhSjg0jyeNf7EYLjErKllLSODwSGFxfnFujk/Iwiim3wq/kYJMVComJSolJEcAVUbME0KGoovGMy9MKSgYU/gvEF1PTGtcWIJ0cd7stLCgjxhhUfQ7QFmVth8eHR4bG2LnJ7YqBCQgHxcnALygIB70Fg4LiyL4NAX7z7SIYFyGeHUBALWFBYf/r19oIfJhUR5HPDlFO+RA/t84RAQ6OEM6N0M5N0I2oFgo2iPLcFhUwbvIhcUdztoE7UY7OQqkcuW1r19nV1N4i0YmrD/rlmGxDGhWlSRgasIpAAuaJJDZjxP4jhhYSgVGWCja5FcjyxtQwaC7BRwOyhNHWUvs+B8FAVyDS2pZVmiNwv53ZmKOf3sAAI9UWMAa79ehI/k/7I0RAPydEQDYiCSRQk4"
	$bData &= "177CIcOnhBA409nWCeMMODw97HRBuBgV/cm6jgL3tf3FuCwUjKEgQBCtzsJRigVMQaCY1pmeVDdOqYgoArKDTDAC1AeWglARwRQumS0A8iCq0FKiXP+ICFQpvJU37VZYdGRhsANTqIdMMAM1nqqtEqG5eXE1Il6q6QC1vqBRFMHPqjEEXb8Zpmqa9lj42Mg8Atdjp6ppmiCLp062CSoRpECh60qhMxovbYFVViZ8qUSuKc58h9BmDxlZSANM0TXsnIR8iALHN2eGA5JJL4uHgpl0UiTXXAMkgUWGaqyKaIEdlBmTUaJduqppILc+pFUWwc+qMQRPPxsWAAbiWXE5KpEgJaZqmaQBXjJSPjaRpmqaLiomIhzSXiYCJi43fNE3TkIhVCikjIU9DoloYgD/UspeIKjK1/6ZSFEFzCRUGRf8u+MXAsc1OVEZDRTo3ykJCFaQWng8PZaggaQQQEWTiX1gTEGomIR9DOTaVQUZAmlR0kYpgrVqX"
	$bData &= "L0RFsKpzjAURrC9oItWhN5cFNZhoJVJSWj0GJSUoPkRQCHyTBApDQU5DQHtb5VauTQU/QQsFI6uQUAWRWJxpBUBATagWV35SRUNqhBcjQQtsTGQSpldGowZUl3khaxDRAbASK8Vf9pdGRW2hyuIFBEajrpd5jkDeiDgEfH1AwSJAcwCMCkajADNCMQXHASOoqpdT7VQokXn/BXpQIAMhe4oiSLTdcwiTC1gFeVQVDnW/a1kv6qKAQMEJkIt2dv8Fd4TYopB47wUsRRFzBSgAqsl2lztVWUDxc/8FyATIVHR1CFZsROlzgkWQoou7RQBUo5cHpdGoeUiBXCU3BXBxVVuVHHLRCAYqgnNxQ6JqFaSFl5VJj8a3ZJfRqBFUeQw0JaVoBW9bQXKVcPuWoghScwUajWUKbrcYRVWFlzOKwuIZcAVcyJcM/P0Aa/5AySSX/2yKIlgya3MRO0hBK08vqlAztgXHlzzYqapm8wVn9JMMMoD19mhBc"
	$bData &= "skh9/hk5JLK+Wlo+Cl4a6HF6Q2CS1EEcwQ9xYIUm/Uvl31KsaQEjxVVHQDDl7J7hQxtYeoFYutycskF7O1jA8kgA+7vZVqipZLwg9EUwSBt7vsYcxE7x1YF7C8VVlS3BeuXOipFwQzHZNgpoJde4QXikGcCueNf5DmQC2Tl5v8/YJZYIOTnfcsoggUjDXOIrcCtBUMvAIHFWAV8zVgVqAeFxwywU1RZ2AXZXHIhk1ra2wPIM4Fc3N3YAVsgWdu/KIIVjAdzsBHBrQQ9LzxRtSCdl4Buarl9VJUHWNAFWQqZkAHR0hBySGXTWtQQCm5Lv9YBgrUURXMFVYoqBSmXl6uqKtwKL3wkF+wVWcoFy8wVWiEHyYDNzm3FlkzPTb9RBAsSDXMQS8FbBUkvBZiNsAU1VdWqRIeXAfL3US5iyAXJLmN8JEPJysvMLmXVVsmUzXGQCEa7mr8BE7EURXMFyaRqNRs1l+yrqmbHXoPZBUAOyQTahNuCjU"
	$bData &= "CO3KeiCFIwE3OCVbCWBU+7jNVshDWAfEDVx3BdWIiQoT2huv8Fu4qkMjm6u2PAbAQ1X0RVOfGXdGFdIWIfIODz/wWKkomS9POsAgRBc5fVoFkGJ5cB8hFUf21okRzUzOEF9IoKJkfzc4EBsxE1aOjpsO+UhIBMNJQ58AsWgH0sxBEdj4B8F5bahdhBEINlaANgKxFTsGqpjQtTG7AQW4W5C91WS7RRm01S2N4asRHLPVUlJi+Xpbjp5CtkigXqprnrIFiQqBNzClZJiCtAcVAQbel9ADgAYR+e2h8jGAw3fwUPOICQD/lCEjqBFTuC+Vwe+Rg9gxo+hIUdQAF5Sj4fQYYhQofce1tqQX0FobMIAsHb0QUBc4NAkKIxTkQ1FmIvBZesKAQhTwVFoSFHp6IQhE9cXGWNIJJcGgghQJt/RaEhJEdiIIQUfwJDWC2Wr2gIg6IMIUVRRxBWiwivlsKgqNvfSFEUGkerAjEKb5dQ1A0JDygKDSF"
	$bData &= "HEDckpA9URdUqkJdoW6XYXAGXQZsFi5C2oABcBNVgCYOoAZAWN6ak/4DsFhIA/CYSNtshaj9sF/58J5AB8pJnQg0JaAGoE4JSiQQK2F06Rk+4UIMtl0+QbA5wbyQZNCkLAgpKhRlgo20jO/+kU5Ci5LT+GhK4KeoqEmP+FQRBZDMSAHRDIqhoBH9FMZBU4wDJPwWkTBIAtFwSANSkgDsEIWpPyL65BQcKGAUR/wBBTTvIVxIA2GcS2fIO5AD4IBxKSzHnzYm90A0H40kgHBsFb/4/zQohHzUlHhxRKSAeaip5KyEfbtJ8zYYqiA6MK4sX9/veko0HTokqXx57fk6S+P9vJx8dVSMdGz0iHRwj9/573psBxgkGFDfmVyIdG6skkt1va+PuHfNm9iggBx73O2idpU5fJm70ZuzWGia+dhy7Iw5jnjsZ9iz4878IHhoaFr4aKFYWv1Aw/hnJMi8v/wROBXnF/wp4W8nI7sH/Cwd2vXU3/m//"
	$bData &= "DnfAVsL/B3jDdnrI/z1JUP8fGxra39PgHnZczscVC8YjIOj/vW0uOx4GpjIyM87G/xiF1P8mn/o/iq1lggcnov7/UwSe4CCR41b+QnNwe62OHb68zjfnDgYtlKH/wUvO4ASC1/8Vgc4/+Kg2ZAcilOp3HBkZh+efg++2RCsaGRgSOMZHGfq/Xe7wBX3N/yGU6wx8haRgBwt8yE95eBq//1KmNM48oRt+F3ZjDvEGd/Ykl/E+AHaUtAcPe8ef55kJvt9YOBdCIPZp/jRp8gZ1v5af/wfPIN+q3nrFXjzG5solagdyupXwb1U7QNQH3nhDLmSQw19r0q1qn5Sd/wffwshz8gxgPUNsW9U+zbmTnP8H3mcoWMl3v5IuYKvam/8H35GrDYB9mv8H39rnQJ4YQ5CY/wdcJQervnaPV21V+5f/B99zDYB9mruOlv8HSadBrt9fHv8btqp9ut+Nlf8H31yeryNBvmjxjPJqVfuU/wfed8U9vvdDF"
	$bData &= "h0aGjzWYQ7wBp6ablX735P/B9/GGatA811aBjkZFH441jS1B95ZDu8/iOrYB8CGogcLecnf3nszYVcHDh4q1kYO4oY09RH+FHrPUgXtH9UHIIbo/wV73huo9eENsQj/jh4fAv/v78Y0DqpFW2ZGyv8We9P/JYv2P4odQYwHJ478/+4Xw8QdgW53xP9Oiqvf9zxMhMP3H6YFEybb/9uDI75RGhbWS2V0/y1ihf8uYIEGXXxzqWTz/y9celt4T16F1/32Ll+ABmGE/01sfdfprmD3lOfNlxTmAgnWOAaC/Z+DXN698x0cHf8iKS4Hey4+myoPHyMl/z74zAaeNyPeb55AVwzmAQWFtvlOH940HUseSGWk+arQznHuewZ+IoM6M82rfyF8bnbG7b1mvuZT7j3eJdcGN1U0Md7PGe59A3yeLUJVGwZWaxz3QkmzBm0dc05vV3ia7z1uYX5YBkUYMh0qYGLF32fP8zxvLAZHltjt75xcJSfw7+"
	$bData &= "3xPM/z4qhOLhDx5HmL39YSIMEvU4xVNv4Eat5mMZXsTGUHY71l06Zpit5mZWdLVu9vUoyn0k3eIgYeFOP+PDGaMDI2zt5zjEVs04uO/wfpbk1T3o1+ZP5GXXDns/w87+Q1DgYlPtkEbo9qm2Leb43/ByKBnueGg+p3v0IqEZti7E5LLwVp3oCM/3XuA2AHC2nI3wdQY+WdXAYzMt5RBmUfANsU3oOL/wcPacd38rxh31YONxZX3la1T/PuBmO/gor/Bzl5BvneaMVcOzjbdGHlWQdhnoGJ/wdkkG9V3mfDXWqfQy5af4f/B/IM8q3eZsJePPZpHnI5YLl+hv8HwUreqt5lv1vVPkN9hf8H3gDsBchmhP8HgbyrYL8X3jkYVrXPfIP/B58DYJ8Le4L/B9inmWrfu3qB/wcu5NoA311ZrWqfQ3mA/wczdK3k3mS/d0mDVe1+/we/xVCaBgwVfjRTulXtNx7fff8H38Y6MF1aXxM+MS1GpWl"
	$bData &= "O7HPefP/esA+ABwtmyd9VBjaMn+d5DiY/3wRujEVtU95oe/8HpglfU95yZ9/1BkNoH2maKgkco0daaUZoEds0xd5pdnr/B4LRFGPeeW4pRPcXXsT/UISu375+Mn+hmaQeH0neTGR4FMNBSUreWJCRbdNVVXoGVHhTuk0xrlTeVVeAdhgnLe64Tml/d+Yi/3e7rd/nNTe4BvEYGRv/HSUs2SqpNCQrV05ThO4aHiPP9w7HZ2wNVjHf3xkIMxu9YhzIdlxWZgZuUmuaBn5wc3IH+57bwS9vB2Vehk0apgGsGE86I98agOZXvyAbGjZTfmzeAqgARnu2BotyG6kApo6OF49479xbB09fKSEefX5xC/mmAr5XPiEcGySA51UA5hMGM1I6gPcqtqXm4F7xpvTOUsnOlgcf9U5fbQfQtihu8iZ+6T61JRZcP2IImiM33N8fGxsVkSqAgiEOJf5QzmQT/3/GNzEv/3dubP+bk5D/pp/uRsnPXgal"
	$bData &= "nZtPqaGfp8D0/26S/3lvbf9DPDomltYP3knHVBleIQvGIMY2H4X8/28GnzYyMf+xqqn/5+Xk//Dw7//x6d+0W2/r6fa4sbD/S0dG/8/B7XU+td405w4GKUTadtEHztyLhY7i399m7u0H+7jgo+ro5+aioP+m7dY4OBXAQL4otjMA9v+7ZlQO7qSdnP/u6+v/7+wHLj0NnsjDwb//TF6VleedMN41V6We6TPsI2AHzsjH31D/aT7PMxY6I1zvo5ya/+zsA0De6ekG6M3Hxt8MA8gzVTbr7rEPANkG5+bMx8Xf2USDDF3qOAbm5HmuDQDfVjcAsH8A6eXj/+jk4gebFkq23sbETuPn4qP2AbDgB8vFw99qA2B3T+bh3gffBB6Q5xc75eHfGAA7WSgHsJu2Kr9O4OPe2wd3o/YBysXC30/i3NkpaQFgB97EK0DkpiD+OSMdnptOig2A/dr/4NrXB9/+DhzgW5+m4dvY/9/Z1YHVBsAH3x/8N"
	$bData &= "Zs+GzVVDu2tqKYu1v/eHvgA2NfTB87Jxj7eO80FXlI0/jLWTwB2wf8O7LSvrv/d2C7c1dIHm1HDPs/KyN9RHw4e/UX43ibWPg7foR7RzMn/29TQJ+A/qgfWz8z/vbm4XvuGWIT0/44eHB3eqv3wXy8OpEtJSP/J5sW/vQdNeLq/vv9oZWTfvjHmHv8H7zQFJiG+TRsZGdRUUVD/UE0lCaIHiPFVttZjYueuWhnf5+A9l+fWNQZY3rguPFOI8a7/B964kRZqB1YdHwbFeO+5PvfHBmiePN/pvaddGt4eMs5FdltJ21TiRmambW8mBnJdeFfIc3BeblZlEOPee3Ze9kzuOd7fyb8ahT/oeBIA+IgRAPIBQvNIjyhCUkLzHoiKkEhC80h/qCpCCJoSABiqkzQH8hIAtAobGYzRAaxtPwFXK2iCFo+gFTRBh03QCpp/d4ImaAVvWkETtGcEraAJX2iCVtBXTxU0QStH0AqaoD8maAVNNy8kE7"
	$bData &= "SCJ0ETFIAfraAJWheCVtAEDxRBK2gH/wqKoBX3aAVF0O/BVQci501r4ARs0iY5sn30x/8GLgdguAZes12yeDxzCl+3XgYetIqgrxbO/1GHsucIWkER369ihKDXt+SkTnIk/xIA9LQSAEAVMhgVBQ3WSC+1ggZrJ8FaQYMf0GCtoBcPK2iwVgesFRRY/wXWCgr374ICawXnWkGBtd9graDA1yiwVlDPxxUUWCu/1goKrLcCawUFr6dBgbWCn6ygmlhXJlZQTU9UEyuoRz+bphg/bH//BIC2enNxuJhCjmwGb7NusnFi2zTFtnN4fc7OjK1QTaxqPzchqCZWL1EQMQDPAxqlf0y6EgBcyscUUSzgl5LoBwSqQgKUBkUBhwJ5oGjHl5LoUROhiB8oGqVExwCIQB6XkuhuFPt/ycLA/9nRzf/a0s4Hbw9ELODOxsMHrKalOwn8//++uLb/samn/6+mpP+rVqqh/32EvJ8Gnq6mo1+7tLL/sAK"
	$bData &= "AWMCqqQe2plpG/tvrBlgDkINQlj8PEEqUnDADiF0gRh8AXxhFlCr/1AxQ0f/e7ikIEtD/uYCECGBfQqqmRP+2pa0p/uLyBjQDgZzkaJ8PDAMRW8ASAWdzgCkEt8jlFNOIZNj1T7htaUA/kfH0AiTprvmvRAkbR2RnMgGM5NAgCkAIopGghlV1d1dVQACrG0wmG1ZXyWQymZlMJpOTyWQyMplMJiaTyWRkMplMTCaTyclkMpkCRCaTXyGjqCoJiH0FZVFMBaqaCAEzAgYQe2xZVAWNVVUQ28AC4pJjtKoOUsPy/yo2r0QKEwBUGhMAkA0klzQHHScNKLhtYxsRu9JQiF1IQq8iKkkV/ocKpW/8FxMADCgTAOgpmWRKKMAoZJBBxtJjMNlGABcgEEW0r0D6r2qPDCYTABw2EyCjoIrPKElEFGHpvyAsRxMAPFcTtIciKKcCSPgHtrpJaRdPpDSCracKxVbcF6faCm5SF6cUNymtF6CEpS2n"
	$bData &= "pwGq5KECSPgSllZFP1jEFIinj1UAZouX35otIhC/lFZ0rYcFXYObF4cU1AK0B6e2Gggpf6dRwlKgp2EpFFuntGorKKentlCUsKenh4ISlqcCSBUFqJL4PyBKWP8/WqdhaRFTj0BUASin37WqhKWnSlha0YengAIirMcUgKhQjxJAlbCnRSIUhY8CCiUK/49ACUsrp7S2fxEoXBMAOGwGCAJM0hwEdx8F4KKWgZQj4CgDgXjcirhkS74LFIEMc76BYoSBm1AUMHC+w9k84DgAAF9YXmhuLnkupBgFH/ARSsBKg7AYJCALCFiMEJOlASwKG6OLwwAWK7FFRAAbHxzgGFV/mGBIlCDZqHBJmtbr8X6KQzcAQ2s0zaZpQRIAK6B4aZpN01obAB6BdY/HfZwelgB4cn48Hu5xUJafcn6WAfd4ipYfqtggHLGWH/KvIoxf2GITAOhy+noEAQhl1nXCP6DBF0cwKVQ8Nv4HgAlzYUxHblpUh3Vwk"
	$bData &= "ERRwa8R7Imih3NuBS1CgWBfYfsHUK8YcxMAKIMG2AxOyEFJ5yawDEAhw0gFVMRW0JPnCoqhELvQCW3Gp0tohMJW59tmgkAr/4AQNRLAkBNXBSlK3pj+qP6BTlDaPJEwKzckckIOIggrQRCxSActqraJR5dNhIAHNyIEbFEHYIu6bWcH1G0TIffACAFbBwjYogKHBxY1AEYXATBCwAcRAraopwewRRWANweqAIwQx2CEgC0HBGxRB1cHqDgAI+cI5AnYBzGUmAJEAMEPVjALEAOAShQlHwJFEILHDxGsYKAvDysYqECXBipQBA//ChTBCg9FsIKCZw+soKACzzioQBEPN2FRVCtvIAQFAcMgICyKD0ARhOB7DxREBIQzQFHAoa8sKjCMB4xAUSBfIKRiMCfBMEJBXwWBkKC3X4IKwwhHIxQEQl8ICSoM1zCMUBBfQSAk6GdfoMMwQvdYBYGQX9AqIsOHZBgroJ8DiZDAFzqsFXBPV1DLDa"
	$bData &= "xPB9VpaARHSY7k/3CsEwCAvBMAiCdapeWJvWA/B1Cr+DxvYiI/DgYSFFab2vIXARkn7NZtw1cVf48LrwHXPO/kXQNWDB0GJSp2Ic/zLzAyMyeJKd2uMAcsfyK0nbwerhYD5/M87+InKwY7SlKdnDzPW11fYGETuk3sDwdeV1OKaY1U5kwuLhsnz5tK1wbs7u9Ma1slVwGQpmkv4adNM00XpYnugoAHmNZUsn29fyppmqYugIGETk0XpXY0NlaD9omgYlpTJJMuUZpImn9hjVoTgHT+hpaUJpJiLoOH1hQghQaWg0hpopgvgWlNAVIOmIKFlCaKL38Wl5jWFCCAUkhpoi97HpaKaU0Bfy8gpNQl35UnRDGtKX4vAqSQ0nsulE0U0pp9r3spQAopNpOElAZg35I/MUwtBd8Xn1lUSClHXSUFAb58kFoKCClP3yCFlIZ8Vo+imNYUfC8CZkNd344HdHStlt+/ja0pYDYHfdnQRDEvgMW0JoI"
	$bData &= "Hfi+QZkMThwaKUUxrCoEvAGk2NI0GgCTFtCaILoXTbOhOXWlGBoCL0ARJjI+zSJqmJoSAjW3TNE1xioR8ergGd4SmkJOzsnpI0zRdJnyCh5Dyf94AVwa38RgaG/8cJyzQWyo5JitXGSBARoaLJ8Y6vCvumB13Qb9ebmROptryZQdlXHE7eT5GVkYh1wYnR26avwIfZg0aXbUbbv8hFyMHItWmdLtfHX8Vz7C0qjEDpxfIbQ0/BwwNed+2Yjd3zwbWBCa2rS0H7wcCoK2tQn/PEolk0D8ikUgkJBKJREQikUhIJBKJiUQikZFIJBISiUQiIpFIJCQSiUREIpFISCQSicuyLJFggLQsZxHJoii0zTEoPxklLAYkg9wqqStPPrBEREkeAJTM1tMXtgD/s1by3YtHsK+vB68222fDN7EAX7QA/4n/PLNRJ2B/AM8EgAvwxsUm7OvqhfcPqM/v7v/W1dT/YcUJHJZ/APAlDXrBwL8cPACUz9za"
	$bData &= "2Xd4dsUJf7wAT7sASgDPuQA7BDoBf//g3iGgBIDczwiBTuC5uLd/BIAfaELf3NtO4CGgz7W1tH9wDFCBnt0CKAHgns9foBP4tLOyf9/ZIaAEgNfPUqATaNyxfwkAf5LW29fWAhZDQM+xPgBusOL/v9rW1BOEgBLPvN+UAPBU2dXSz05gMASyvn8JAHcr39fT0UoeFkDPnq+AEgA+1tLPz7B5qIXfrKys0M48BJQAz7GvruAu0Al/39TPzG0IKAHPsN8AeOhav9POy2AUAkrPPvgIgU5/1tLMyRsCSgDPs94PrDiBfz4BYCEA9hP4AijPtrW1AeBtoH+aAP+4trRGeAAoz8rEwR7MNugEfwD/upogXdAGty7TzMjHwnDHAdjQ3sO+u5bqBMTENq5/m81mG1EA/8H/t/+t/6kR8mc2/6UHpKSka/QypU6/tQAQg8xm/73/ZD+DViRtBv8/qogAFF9Ws/WqINQG5HESBNQWo1EySTMFGICRG"
	$bData &= "EWxHx+Q/Kv/8NUTAADmk2IobVVMegd/1+IC0aR/3iCDokb/kTwRQJNiKDQpNQKnfwOLvQDXB1qxVXC/z0QikQw/SCQSiYlEIpGRSCQSEolEIiyRSCRILMuyoEBUxP9IJBLJP4lEIpGRSCQSEolEIiKRSCQkEolERCKRSEgkEomJRCKRkUgkEhKJRCIikUgkJBKJREQikUhIJBKJiUQikZZIJBIYiWVZ/xoUiIo/UCOxKGd/VIzE//+g/RMAsIBqi8ANFKOqQv4hMP8TAEAPFBDQVhy4AAbIEAZwSZqJ29cJHkBtg5BIN9qXlrgrNxgAqw6ua97N0gU9ADF0zgCoqQWwqO5dqGEHkzykjb0KB6MFNqKM+Rs7EgErBRwurfmwN4XuAJKUBRy7MfvDN37hAIr4B3oFHDewG/sPd9MAhOgHhekFHDcMu7H/cMYAe9kHfNsFHDdosLv7N7Byygdzywx0zAQQHDeDe/b/TIcAabuKvf2Lvv4FB2"
	$bData &= "q9Ly803O5/SYQAS4UAWJ0FS4Yin1GxqlgPR1eR1hyAggVHVxGCxTZ+/wW/uzQ19e55MAUcN+LSmg9p+QBzdQUcLq1phkdlbm8FHGObZihHX2hq+QXbNEdhkkdYYGHpBaYZihscR1JazVDc2FzbBRxHTFM0TdM0VVZWVVNv0zSHOE2qq/4FTTMgFUZONzdBIFTSNEE3/FcDIZ9QBBQAYBQUSyTNkBA8s6FCmRpBiLUHawWtug69BaI139plWbe6Bag1/95lWX7gALa3BfzrtWC2Zye0BbX/B7bNLbuVLkFfrLBbNkJ2BQexQV82QnZfwKwFB61BkGeAW1+kCQQHWveWpUFfoP9lpS6m7u1uxAU6Rl+c/2Ru2Qj5BAehQV+YEftWBpJqB50F2TXDuqebX5WZBQeaa27ZCEFfkJQFsL0RsgeVQV9shHwf9o//BAeQQQj5tbdfiPJk+AQHjfnM/m9ZQV+E6wCG8QCH8QdwBQHe7kI6BF9/417"
	$bData &= "djZBb6ATpB4M6Roi97bpfezB+32rgB4DhBSvA2106Rl920qjXBN6yEPIHethBX3HKYgV4AdDPAHTP4tAFPfB2FzpGX23CvGxZCLkEB3HIQV8XYv8O3mq9AGu9B2y+BTpC3v52Rl9isABltAS1B2a2CvB2FzpGX16mHKp2F0LeBKsHYaw6BF8stfv/WJsAWqAHXKEMXaIKBS/5/X+7Rl89bABVlhVamx9fngQdXp2/3X8BIiFgnxhcm0ZfOGcATf8D+/+MI1qWS3WrVn6yV3+zBViAs1B5rilemf8/BWhGjQU3YQBJgUxzoqTA5LPNArQ/sPAFqsXpVXqoOoLF2Ep2hzJaBTNcLgoGrAaF39auokA/iw6NBA0Ft5KOLnmIaBoWrQ6LBTleoRpqrbaHFIgFh39byae0ghyGBAeINWTX3C5GX4GEBQeFrrllI0FffYAFYctGyAeCQV/ZCNl1yH0FB35BEbJrbl94ewUHfGTX3LJBX3R3BQd4"
	$bData &= "hVBlI0HfxIY4tCXIBRHAsC6nc19vy0bsamlzBUFfsUcccWs4XQVrhisLQT/5/2pYN2KuDgWnal9qkxtxZvLeAGn4BdcM1906BJ/r8QRwZSHkB2byQZ/YEqbE40gEWgUrsd2FOkZfcF7fiF1EUCAHYOEF1wzXXTpG/9LXBL9lIeQHXNhBX1PKAFYtCyG/zwQHV9BBXxZCfu1SwmTGBAdVyEEQ8vtbX024AFC9BAdRvsjb37JBX0mwAEu0BLUHTLbb3+5COkZfR6YASKoEqwfY7kLISaw6BF92/0ZJzESgB0WhDEeiCgX/b5elL0ZfLWwAPpYVRZsfS/svIL+eBB1JnSIhTJ8YR5tGYP//t18pZwA4jCNJlktnq1ZwsldxswVPBex/WHKzUGuuKU2ZRj8pYQDsD+z/N4FMZqKktuSzw/AFqrvpVW2oOkC+QwU/JVoFXBojKhA/Rluoqx/gVvAfBqhkkmaiHx4ggAQj2IgFU6S1aQgXrw6yB"
	$bData &= "LN0a26ispW3saq7qq3UrUgFrb2kNe9strFzzQCmpwSol9zdqo6arU8oWWmmlwSiB6NnTLs3iZq3lferkaqdBUtVyXdvt479vAQHlt5mpL2Vtz6O/MIHx+4CwAWOmreBRrVzjeU/Ba/pbTWTt3rZrOMEB+20VMmC5ZTkt2r3b6mHedYHetcMe9gKBdtjlwWDmrdRkLzKEt+C5Pt0zR14zwQad3Yfef3/Y/fQFXXNmrdNiQBpuh9ywkSH0lCP2d79KZrSBUmL1SN0xJq30P5/sQeCAGGsTYfJoMr/sNgFEeDuX6fQ/1eOz46gV7eg/X9EeQBFegBXmQBYnAV2YsAKYIJXxy6KAqN/g6jAqtYOhQV/kQwrxvKBBYJ4FQgLg39WzRYCJoL/j7fOWBS/f3kFB2Njg5J6j7dStXONbjcFWeNtNYu3af0uTnur2gWVt2bxqv3TFnhr/QdsBWs8dreOmrdg5X9YNqqdBZW3s0+08FrZ8QfIBTF2LV"
	$bData &= "WO5Jq3gdr9m8Za1gdc1wxd2AoF+//YZYOatzuQAFXKElnNHV7PBIXfguQaXXYfX9DQYyeQGpq3OIlo/3fYOh9YwkRw0lB52VF6Ba8C96dJdNUjWsSafzeC/gXt/wBJrE10yaC8/7DKBafC/1d8z397VOCOfzJ5BHoAQJkAQZwq8BYkdjJ//6rGAp+wGxQAwCskQRAgC38qgoAnFACQN38EUDFfEDMUACDNxGm0QwZkrx4JJFbIJDzEIKxqmd9CXBIxeR2zMLrFvVmjWwVxahBW31HCxgaFEKVjt2KnJs+f/wVZq2HhtLdl76QHce1gl2AFNLeGWJUWW3EKN7esimgivmmu+gWGHewGNLd9WLEbsM1UjfoFNLf9ZoF4V88wB2HoDGPp7WB3iwUoNLd0WILuFts0g4XpBSg0G7D/xbdAmwda15S6/wU0YJt2sLdXWHnP/wXUo0k3NDdAlo4BU1MGBU+0ANuuVVhntwVZMpQoor8okP9q35w"
	$bData &= "2FACsRhSaEsYemUDIB7Zib3XzNwenOk0JgfOWEIotp8K2ikuDpxYILlmDpwguWcKDLlnCFqeDov8/SB4KmUDI5KFAHplAyJlAyKFAHgqZQMhQV4DkmUDIh1VcsoSDLGFVgNcwIASXg39LlvBWr2KhWKqDp78WVCDsAQfPCFAL0QenS1hQRMcSYcUlg8dAcMkSgyVLSITHIRECwYPHDwWXLIOZQMggD1EkmUDIDwXyUJlAyJlAyMjyUCCZQMgJoa5EhwCruGSDLlnCqteDLKJACCew6pIlgwJIKzp3fy8KirDHjY1ZQgCQjZAIqy6DxwWCS5aDgkuWsKeDhyiSh5lAyJlAAnkokMiZQMh5KJCHmUDImUDIIdQVIIdgFZcsg0wLWBXXRRQIQe8nVsW0gO8AaUUHd2sRBVZ/z2W8CgrvmEtEBAFQxlv3owqQVXASFP6UYBQApHAUYwoZBUDF0p8qkHUUAKCFBgJEjgIIrxIqtgr5+AE3KQbC"
	$bData &= "QEtSBISBAFPBisEC908IGBsQE9sB2yhJN6IFgGAbYDehBfehEASsk0AYWAX3bTsgWEkXmwU3R6hRWnmPJmSzOdh36IdsLzeQF0HaB39ELxvSqIhOLIKIH4cREqAKqgBJBEAByILVSFlYk1UVIP9spxQAfLcUAEHyD3S5FACEyRSCKkgCDAjkv+zfFAD87xQ/FQCQnPgUAKw/BEDJCBWs/xQAvGQQRMkPFfknIIqoFBUAuCQVSSoAAvIfRUR0NRUAhEUVrjoEUSQ5VjRJFQExUhaTp4pIRiA/H4IA+RUAME8VUEEVAAcKKORgURV0TCEgAvkVAIRcFR+oQv7EVRUA1GUVSFcVABqiCuRYZxVIRsrCVZ5YbBWTw8IIqoygqCIzAlYBlcAAAqinZEAVxV8xtAqoXwuLrUP4kaaiFaIAGimTQgGUDEAyqkJHgAwEAFhURIH8uRUAaMkVgkkEGwWoKEbKkxREADIgCABkZFQRySyMgKCSf2gAM"
	$bData &= "+g8FgD4TBb4VCyo/j5OFhHFSFmTIgBkEIKikItwP1VESBhxFgAo/ENUyYEWGHMWACiDFsg/BJCodBYAuIQWhfxDVTB2FgBAhhYu1BBAwEbQkRZEMVMkuyIKZAAO0PgnvJYWAMymFkdZuB2iPJf2TKcWFFDASJOfgKhkfLAWAAcKKOSMwBaguzKCCPkWALDLFv8UEASc0BYArOAWkgBFISBC/ouY1hYAqOYWIgb8KerbFgD666NQSb0CPOH+8ZWkohijwCoNEY7invZ/QFUU44rsFgCaB1RFgfz3hmCkLPzyFgCWAheTxB2HoPb03gYFFwVRcFvDeKggWfIJF6AYASzwGhfrIeEfKBYVFwAmJRfCeUPUs5b+pgKiRsqTpCxc9UYZVlYpF5QMKmKTRCH/FPYcFwAGLRdUyD8QSigXAFo4F0DyDwHaMxcA6kMXAEBGVIhI/olqRBcAelQXOgD8IRpLFwAqW0eykAiqJyCIkZMWYIcACPkXAC"
	$bData &= "ZwFyZlo6og+RcANnUXXAFAJGBKBhCQoaiQ/3aSFwCGoheHokL+bpUXAH6lF2aYH4gK+RcAdqgXWpsXAH8gKuRqqxdOnhcAXq7+oaCQFyahFwA2sRf5h6BCFqQXACa0F8KBCApKr5GysIj+vxcVMqKqk/4rSQEquRcAOskXkn8ISPq5FwAKyhciFhyC6rrW+sofBFEU5z7GF48AKuQATtbO0UAwSvoXAN7hF2OkIJARNvFflMrXFwDa5xcKIIDJN1xRFTIAI2CkLJOKokL+Kv8XADoPGICo5B+iFhgAsiYYExGFDJ4UAIH8KxgArjsYIaMKZL+SEES2RBgAhygC5MZUGHZNgoII8RgAhl1//lQVSTZWGABGZv+IIkD2XhgABm94RBEgtmeRsrBY/ncYkH+IqpO2aRgAxnkYQP6hCv5rGAAOfBgq+YcqRm4YAFZ+GIVPxYL+cIAYUAGMlJMiKAJkoIgA5IAIopD/urgYAMrIGBMFEMmKAhW"
	$bData &= "U/NgYAJroGL8iIEDq8BgAJKVo4foAGVNlWZZIdUsWlkNlIUUFEgQFtTPtX40gB0oJGQBaGQac5qC2oWir/gVAcpIjdGiQqIpo96KKirJTEWVhNLyzwiFEFUQCIA7KE1lYUFH3SFDFQHOKW7JwRNNk4RCiRGpVFLUzLFkIUZVYSBVFk2RhQQ3/YVUUpfOFBaNkT1VRjJJTFlySha9FcUkWs1BJFlYPRSVZWBMkWVgVkWRhQW9zBIhCErCgkCzPKopCstOCQbKwLygGycIzRgTAqsdFcUMWkyyEikb3rYhihvMMWUgR9ygaFUVT94oSsjCzYUGUKPcAFSNkE8hCqCj30YooLnP3TJCFUNNAiBVR5wRZGAVAiBFUM+cBWRgFQIgRVJPnAFkYBVCIEVTz53EbFlJThIpCAfeIYjYssyo2LKwPxIaF0fYTCqEFVGeK0rCwc1YhtIBnUBEaFtPCKoQWZwIqLsMzWFiF0GdaQMVkkwwLqxBnQguo"
	$bData &= "OPOFYWEVZ1NhYQEVMo1Fga+GhT+U/3IZAB6CGQlEAQWzkv8KKm6AGQB+kBnkHyKCzo4ZAN6eGYUMgiCV/FNUHp8ZAC6vGVTyDwHuohkA/rIZFq46BL6mls62GVBAFRizi6gqZE5RECEO4w1thQb+8wbUU5ykOThHVFWsUwgMC+ezm7AQosLCIoAbLKyqZoNCoOok66yqSsJToiokLLuoLsLCI2oiLKyLDsJCovMgLKyowsKKqlssrKgCw8KK6hYrrKhmwZOK6hQs+6hKkcIjaqYorMsRBMGK94CMgqrfBRUhFcd4IIBg9zs7O1VIVUXHvwDBB1E6Ojr3XYCFREMBFlJASGFFNasWVlSTo2FFVQB7VlQBYONFddsUS1oFUGG/qmosV3+fIKpKA38RFVTAP/IKCpJbVlVjFBWfqkhYUAdANQmr/93CQBgW11BVGFW/IiASAgeoQqYwqwaZQgoThimsqJjCiup7aqyoZuOfXiKRSFtWGamgQ"
	$bData &= "hZSADB/pBAiat8KIarYW7CiKk3DK6rRpCuiukwKk6rJpLD7ikwKK2PCpBCiMCkEgsuksIBoMwohqpubEKKqSQOBopika6IqSQrTipGkMDvC1PaPCjcaABpHBphrGkkKo387IUEV8nBrhQSlLI8FVFwkm0gKg6L3G4mimPtICoFGd0CJoohbSAqBJmdBiaIou0gKgQZXQYmiGBtFCoFmR0KJorh7RQojRjdDo6KY20UKgSYnCoGiiDsUBggtHQAGQVGKm1YQihT3IhQpjPb7EikEghYRreBX9wVxiRRbMIkUQrcSKYxW9ikEgmK7RKwgEheRSOFQl2pYG0ghUBHCaAWFd/YgKAqRewoCkULXBCKF0fbbIIVAUCCFRNw3hUFQ3DuFQcwgl0BQzCCbRJwghfdQnCCF+5QghUBXlCCFRFsghUBQIIVEhLeFQFCEu4VEXCAXQFBcIBtETCCFd1BMIIV7HCCFQdccIIVB2yCFQFAghUQUN4VVUR"
	$bData &= "Q7FBYEIJdWRRGAm1hQWxT3VkFtUfsojKhAKAxitlesgGK2WyzitCi3iuK0KLvilCisgYrSohAbtCi8oAAACo+oInsAACOqqCzbKiaLwgAAOxaFUYj2gBFVHJsjqmK2b7+qKQq7yqIaAOQfouTashpKoxoAWrMaSv6hiAKlGgAStRpSlLwhgv6SAm18Cv6mthogIwroH+BPVEVCvxoAUs8kgopGf4qipii7oJB/CoLYGgCS6Boi5B8opuMaALbzGlFQyQhRhfwTxgQbANYUGwkKQgZfRRUh5iUbGUQV8gD2NRv5J6ACwjAbANJAG3+oiAgqRhsAOlbICCiSG4lEIpH/CgIiSmcbAFp30yEqkhvKavaCmqJw2nobuxQAMogDRCT/Sm4bAFp+G6YOEJH8cRsAtoEbAnXVFIWbrhKFG7tABkRBQv6pCiKWGwAyphtFJYOoACX/VNqjGwDqsxsIpD8E6rEbAPrBz6KQAKKKAoKau/8FQUkK0xs"
	$bData &= "AGuMbkkFUIeSfAKAG6BsAFvgbkH8IAjbqGwBG+htA/iEKduwbAIb8GwD5hyi27hsAxv4bi2kcgubw/gAcIKgpCrsFADKK/qsKSfb+GwAGDxx/iCpI9gscAAYcknaIkhx2DP6GReHnivYGHRxGVBE1u7kKAEpG+Y8qAE44HABeSBwyAIoAgVwAARgBJf8R/l8cAA5wHBSFKw7OYZbecRxBQRDUu5AkIJKfIpAQfokcAP4hgOSOmRwOixwAHpsc5B+qQpaMHACmnByQfyigLpAcAD6gHOQfAqi+mxwAzqsc8YeAKo6nHACet5IoAqifND0FRV6zHLTDEUDFLF+qKQr/7r4cAP7OHLtw1QGAesIOitIcAqCaorsVFCCjABTTOHbX/uckFQBB94V/qihy7BwAgvwcARDUFLunikJGbgEcqgD5HQB+ER22A6opCneGxhMdu7iQAKrPAcggiIACWUCCApCh/4sSkjDB8zzPvz8OajMdgH6SvLrM"
	$bData &= "bD7P++I5AQo0b7bdvEsoPoIAMkQGOAAB5HlmIU+qaigieZ6L0pJkNq+S5/r2IjRaRUQNsWsGHAEEtIFhBn8IIGqg2KcCDcS2sZYLAQZqIBBERwvUBKMgBxFiqUZBT6ddNWyJAU8PvrcEQZqKVht1HkCiDgdreT1IUO0SvgyrVElQT3snzmYgCFG3KccDMx11xAY42yBvLKiHiBAPMQAW900chLd3Ay4iIES9g2ejcyOC7+2P4i5rG1vAuARR9wpWAYn7yiDTZ+hYqwF4Nhv8VxBSQpA2HQCgRh1HUATtAVDgr7KhRcgBAgA9538+kZf/RungAA4hCwEHUB0DNzd5BhALFwT3l8MWu0dgHUDnPwACLVvtbdsQZw8TAZdO4KW2Oh0v/ggbntufCi5yc3JjAOcQQN7tXNsPBUBOZWxvUAgN7WEYFxAnT0IkSZKQKwAAoJL/AIB8JAgBD4UtAQAAYL4AwBwQjb4AUOP/V4PN/+sNkJCQigZGi"
	$bData &= "AdHAdt1B4seg+78Edty7bgBAAAAAdt1B4seg+78EdsRwAHbcwt1KIseg+78EdtyH0gB23UHix6D7vwR2xHA69QB23UHix6D7vwR2xHJ61IxyYPoA3IRweAIigZGg/D/dHXR+InF6wsB23UHix6D7vwR23LMQQHbdQeLHoPu/BHbcr4B23UHix6D7vwR2xHJAdtz73UJix6D7vwR23Pkg8ECgf0A+///g9ECjRQvg/38dg6KAkKIB0dJdffpQv///4sCg8IEiQeDxwSD6QR38QHP6Sz///9ei6585R0Ajb4A8P//uwAQAABQVGoEU1f/1Y2H1wEAAIAgf4BgKH9YUFRQU1f/1VhhjUQkgGoAOcR1+oPsgDHAQMIMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
	$bData &= "AAAAAAAAAAAAAAAAAAAAAAAAAAAGW5AgAIAAgAAwCYNYAAgGgAAICuADiqqAA4zgAc6AAc6AAcYCgBAID6AXwAHBZWNgB8ABw4AA7oAA5MQQAOKAIAgAIAjogQAwCABgAOWDQAHIAQAQ4AZgnOAAABDwACAKgCBAsXCQQAAIKYAAliEQAALAscUQglAADCAFPAFD/Y/QAJ3AA/AXsVQQFDAAQSP4IYAA4sEgAA7pwfCkCUH1gADloTAACqFJwfgJQfmAAOroAfVkYCUpcfwJQf2AAONPgVAACBxZp/gNeSfwAOqnbAD05UDwfAAF7Ae6pwwA+MwAGYwAGywAGawMAB4MGDwAEGN8B+VcCBLMABOMABSsABYAvAAdEbiMAbRBcAACyi5BU8wwmwwAkO/FABAIjd2wnYwAm+MNkDAKDcE4C7AIZQvgUAhtwTKMAJNFCcBwB83BNQwAnYUIAJAGLcE3jACWKgXgsA7ApTCQSAD4JgwEu4CwC"
	$bData &= "AlMAByuDAAbzAAQgMwFbAAYIwwAESOACAWMABqkTAAYDAAXDAAajAAaqswAHQwAHewAH4wAHABjkAgCANwArAAapIwAGKwAFwwAHGwAEqmMAB+OAAwOAAMjoLYAvgAHLgABAOAICqpuAAOOAA1OAAYOAAoAw7AICI4AA84ACqsOAAbuAA2OAAmOAAoAAPAIDE4AAo4AAK9OAAUOAAQDwAgKp44AB44ACg4ACk4AAqyOAA0uAA8OAACj2wAIAYEOAE4ABA4ACqfOAAaOAAtuAAkOAAyurgALjgAB4+4B/gAIJI4AAIEQCAduAAqjDgALzgAFjgAPzgALKA4AA6P+Af4ABw4ACq0OAAruAA+OAA5OAAtCAS4JVAYAjgAEjgAKpw4AB+4ACY4AC84AAqwOAA8OAA6OAAPkGh4B8TAICO4AA44ADK3OAAYOAAJELgH+AAqnjgALDgAMjgANjgALQOQ+AfFGAe4AAo4ACqhuAAUOAAtOAAeOAA"
	$bData &= "yujgAKDgABpEYAbgACpY4ADw4ACi4AAYFctgG+AAQOAAIkXgH+AAql7gAJDgAKrgALjgAEr24ADg4ABERuAfFqvgbeAAMOAAwuAAWOAAyvjgAIDgADBH4B/gAKpi4ADQ4ACU4AD44AAC2OAAIBcAgBRIq2Af4ABc4ABw4ACs4AAqmOAA/OAAwOAARknLYBXgAJDgABAYYA7gALI44AAqSuAf4ABi4ACqiOAAsuAAsOAA6uAAEtjgACZL4B8ZAICqVuAAKOAAkuAAUOAAqsjgAHjgAPjgAKDgAKwiTGAC4ABU4ADw4ACymuAAGBrgS+AAQOAArChN4B/gAGzgAJDgAMqu4AC44AAMTmAR4QJB4AAIGwCAyuAAMFngACJP4B/gAGbgAICV4AC+4ACo4AAMUOAfVeAASuAA+OAAfOAAIJYc4FPgAEjgAAhR4B9V4ABO4ACY4ACQ4ADAleAA0uAA6OAABFLgH1Yd4CHgADjgAITgAGCV4ADI4"
	$bData &= "ACI4AAIU+AfVeAAZOAA2OAAmuAAAFAeAIDa4AAo4AASVlTgH+AAUOAAeOAAjlXgAKDgAMzgAMjgAAwWVeAf4ABG4AAYHwBUgILgAEDgAMDgAGiV4AD24ACQ4AAqVuAfVeAAauAA4OAAquAACFAgAIDW4AAw4AD2ZeAAWOAAGlfgH+AAPFXgAKjgAGbgANDgAIqV4AD44AC+4AAgIWAbZeAASOAACFjgH+AAUlXgAJjgAHxwAMBwALCVcADocADacAAQInAKVlnwD3AARHAAYHAAcFVwAIhwAJZwALBwAMaVcADYcADucAAAI7AMVlrwD3AAOnAAUHAAXlVwAHhwAIZwAKBwAMpVcADIcAD6cADwcAAeWlswAyTwBXAAQHAAdFVwAGhwAKJwAJBwANZlcAC4cAAIXPAPcAA0WXAACCWwCHAAMHAAglVwAFhwAKhwAIBwAOZlcACocAAeXfAPcABUzXAA+HECcAAgJrAEcAAqSHAA5nAAcH"
	$bData &= "AAEF6r8A9wADpwAMBwAGhwAMrocACecAAQJ/AKcACyOHAAEF8wB3AAWHAAqohwAJ5wALBwAN5wANLYcAAqYPAPKHBTcACqKHAAsHAAUHAA6nAAsnhwABhh8A9wAD5wAKrIcABqcADwcACUcAAsGClwBnAAQHAADGKrMAhwAEJwAJBwAHxwAKq4cACwcADgcAD0cAC0CCowCWPwD3AAfnAAqlhwAL5wAIBwAOxwALKocAAaZPAPcABKcADK+HAAdHAAICtwC3AAKkhwANpwAHBwAA5lq/APcABOcADAcACWcABK6HAA3nAAECwwA2arsAZwAGJwAGBwAKpwACqIcADscACwcAAcZ8vwD3AAZHAAAC3wDHAAqihwAMhwAFBwAPBwALJ4cAAkaPAPcABScACqyHAAenAA8HAAnHAALBgucCRwAEBwAARpq/APcAA2cACQcACCcACquHAAvnAA4HAA+HAAtAgv8Apq8A9wAKZwACpYcAD8cAC"
	$bData &= "AcABMa6vwD3AAiHAA0HAA2HAA0vhwAB5ssAww8CBwAKpIcAB+cABwcAC+cAAqmHAA+nAAwHAAOG3L8A9wAHJwABAx8FFwACo4cADWcABgcAAQbquwBXAARnAAsHAAgnAASthwALpwAAAy8BRvq/APcAA8cABQcAB0cACqeHAApHAAoHAA2nAAsshwABBw8A9wAEZwAKwYM/AIcABAcACwcAAqaHAA5HAAkHAAGnGr8A9wAEhwAOBwAHRwAGoI8LSscAAwcAB/hQAAANALAAAyrgtcAOCwrw8AdwL4cAI6YMALAFAmHwJ5AiCADAAAsuYLAHBfCw8AeAJIcAJi/wsALuhBvw8AdgJwcAJyBjgMANSPsfuvcAJuG7AMAKQgHwJ5AsBwArg6PAzxxg8AeALocAI06j9wBwUfAnkCEA2AAADmRQwACI+z1XoCOHACFkAP/P+begICYHACOlMMACgJBx8C+q9wAopcDABcB2+j+69wAg5eDADY"
	$bData &= "r7GrDwD3r3ECY3ARNR8C/fqvDnCywBZwTg8A+a9wAnIewBZogx8C+q9wAq48Qw3yxw8A+K9xAkUNWAAIMh8CeQKgcALeFnf/BH0CyHECeQ0AF3DpDwB4AvBwAm57DQwAYH8C+88PAAD2XnzwBHAyDwB3AkBwAoYXwBv/LHsCaHACgp0NLABYDwJ6ApBwAgKesA0AGBkfAnkCuHACWEK3Df8nfALgcAJmBsL/CXkCLbQACQQAAAgQAACAYtcNANQFABQAFAEAAZwwAJxe3Q2UACocnFgATrDiH05SgABOAugfJ6gAJ1RK7R+f0AAnUPMfJ/iBACdM+Q0ASAIbJ0AgEQAAvPuAJxQFmxNIgBO4EA4A/AoKmxNwgBPcGw4AFlgVE4QTmIATXBwOKACIA5sTwIATDCAFnxPogWMjDgAsCwmbExASwAAvDgBo5dwJOMAJoDrACcBR2QlSYMAJMEvAJwbbCYhRwAngUQ7eWbDACdywZg4A6MAC2"
	$bData &= "QnYwAlA7GsOACgt2wkAABMAADyZDgDQpdyBKMAJNJzfCVDACaAsnw4AzNwJeMAJFCCi3wmgwAkUpQ4UALDcCcjACeynDhQAyNwJ8MAJ3KoOFAAM3HcY4DAQtg4oALgJ+wRA4ATwvygOAKj8WWjgBMDAS+AT/ASQ4ASwwf9UuCngBATN/1Tg4ASU2BPgSvyBCBVgD94OAAw4J/yf4ATwBQ8AjFAX/J/gBGgdD/5ZAoDgBGQyDwDwGAP8n+AEfEsPAJgIU/yf4AQ8VP8E+OAE/FJc/wQgFuCGZf8ESIHgBHxuDwDYAfyfoeEEcA8AIPxUmOAElMRy/wTA4AQMdf8OgujhBHcPAExI/J+B4DqAvw8AqB/8n0HgBFDfDwA4/DZgKeAEsPf/BIjgBBAQMBAADIX8n+AERJUwEAA4Dvyf4ASkowX/BADgEgSyEAAoB39c+09wAlTCEACo539m+09wAiTGfwL+T3ACdPTJcAc8HwL6T3ACROAGEQ"
	$bData &= "CQlx8C+k9wAsD8nREA2IgfAvpPWXECJhL/d/1PGXAqJzgSAJB/JftPcAI0KXf/BP5PcAK0fwL/T/EEKp4S8gcPAPhP8AF0Q38Cs/5PcQdcEn+J/U8aMCPgZxIA+CAfAvpPcAIe+MB6fwL8T3ACGKoSHAC0fwf7T3AC9LQSPABA8EgPAPhPcAJcyud/B/5PcAJ863AW/yf7T1lwAvzufwL+TxvwBPI4EgA0fwL7T3AC2PXnfwL+T3ACNPl/DP5PcALAVBoTAJANHwL6T31wAgzAiSC0DwD5T3ACHCw2E38H/U8c8GNXEwd/a/1PcAI4bBMACAf/WftPcAJobhMAGOd/AvtPcAKocH8C/k9wApzocn8H/k9wAhh1fxEF/k8dsE2DEwDYDOcfAvpPcQKQE/87/U9wAg6ofwL/T/EEkRMAMA4rHwL6T3ACgLwTAA6If4n7T3ACMOQTAM6o/0r7T3ACAOb/BP5Pwh6wFg0UAGj/BPtPwXACQA8"
	$bData &= "UAGB/AvtPwXACyBAUAHD/MftPeXACYBRwB3+d+09wAvBwHxQAqH8C+09wAsDOK38C/k/wfpA3fwf+T8FwAiBDFABkfwz7T3FwAqxGFH80/U9wAqjOW38C/k9wAqRwfwL+T3FwAqCFFH+T/U9wAugAhxQAbC8AAD60AgASAAEACQQAAAAgIAAAfLcUACzgEROUBZxIAE6EyVAUAFAmG05wAE78oO8UAIgYG06YACdArAgVAOgGGyfAgQAnvA8VANQUGyeC6AAnuCQVAKQABwkZJxAhgGNFFQCISgObEziAEzRJgDsFBZsTYIATME8VAAgKApsTiIATYFEVABT8CpsTsIFPXBUAFCgJmxPYgBPUZRUIAFwBmxMAIgAAYFhnFQDYwQLYCShVwQlswEU12wlQwAkIoKIVADgn2wl4wAlAaMkVAGiD2wmgQcAJ+EwWANjcMchBwQlOFgAIMtsJ8EnACSiB3xMYI8AJgygWAGjcCUDACbiEKBYA"
	$bData &= "YNwJaMAJQIYVwBML2wmQwAnQkRYF3rO4wAnMphYAWAuVCcQJ4MAJTKcWAAQYGdsJCCQAAIyUwBb+TzDgBLDL/xOyWOAErODgBPxjgOAEoKjmFgAq/ASo4ASU+uv/BNDgBEzx/wQS+OAEnvb/EyAlACgAmvz/BEjgBJYCKBcASPx8cOAEBgWKF/4nmOAEAhoX/jGiwOAEJiUX/kDo4ASWpuAE/ZoQ4LdWKf8EgjjgBAYtFwAs/FmiYOAEWjgX/l6I4AQ06kPgBBD8n+AEelRL4BP8wtjgBCpb/ywAweCUJnAXAOj9n+AEwDZ1FwAoLfyf4ASghqIXAND8QHjgBBR+pf8EoOAEdqgXlADM/ATI4ARqq/8EgvDgBF6uFwCw/ASEGCjwDrEXAMh/AoP7T3ACJrQXAAz/HYP7T3ACWr8XALh/a4P7T3ACOskXAKgPAvP7T3ACCsrwCQ8C+09wAg76cAJ/KvxPKQAATs7Wfyr+T3AC3uFwJf9A4"
	$bData &= "/tPcALa5xd/cP1PcALAOg8YAFAXHwL6T3FwArImGP8s/U9wAq5wOxgA8P+V+09wAsZgVBgAmAgfAvpPKp3wLF1/Av5PcAJGZn8Cc/5PcAIGb38C/k9wAsYcdxh/ev1PcQJ5GADOIH8q+09wAg58fwL+Tzor8E9+fwf+T3ECgBg4AExIHwL6T3ACyshwGACoHx8C+k9wAppw6BgAOH8b+09wAvocABl/Av1PcAJaGRkYAJxoHwL6TywAAHQegvAEDh8C+k9wAn4OkH8C/k9wAt6eGQAOKH9c+09wAi6vGQDOqH9m+09wAv6yfwL+T+lwAs62cAc8HwL6T/EO4PMZANRTHwL6T3BewBpHGgCYax8C+k9xcALashr/d/1PcAJacLMaAJB/JftPcAIS7rX/BP5PcAKSfwL/T/EEDLYa/5/9Ty4AAFKOz38C/k9wApLoGn+Jg/1PcAK28xoA+P/W4/tPcALWFBt/Av1PcALg9jUbALR/B/tPcA"
	$bData &= "LA0kAbAEAVHwL6T1lwAjpWfwf+Ty9wG3c4GwBY/yf7T3AC2nqHfwL+T/EEfhsANH8Cc/tPcAK2gX8C/k9wAhIOhX8M/k9wAjKmGwAEkA0fAl20AgACAAEACQQAAAAQMAAA6rMbAFzoDQOoDwADnDgAnPqgwRsA+CAbnGAATkAa4xsA1BQbToiBACcW+BsACAIbJ4KwACdG+hsAGBwnEtgAJ4b8HycAMQAoAMb+nzsogBP2AAocnotQgBMGDxwAFNgMmxN4gRMcHABWWBUThBOggBOGoBPIQYEnHRwAMCubE/CBgBNeSBwAiCebEwAYMgAADnAcAJSoAdsJQMAJ3nHfE4JowAmOmRwAaNwTgpDACR6bHABg3AkCuMAJppwcAHADpdsJ4MAJPqDAHQvbCcAIMwAAzqvAO9wJUjDACZ633wlYwAluCsPfHYDACf7OHACKZNwxqMAJitIc3tFS0MAJhuffCfjACYIC/N8JIDQAAH4RKB0AIPx"
	$bData &= "jSOAExhMQHQBsL/UEBQA/QaAAkDQAgH7gALhV4AC84ADg4AD74AAI0DUAgDlgPjDgAO0LBQEAqOALMkQdADir+GABANDgBGrgBCj8BCr44ASS4ARk/AQgNRPgfv8EAEjgBFpFHewABvhWQQNw8Bvin+AHDOjx4AzoQAoAQwAITwBMYABSAE4AAEEATQBFAFMAogmiAk0AQqAARKACClRgAAVoAgwARgC6SaAGRaAG4QUnBwjgACpJ4AFEoAFQ4AZIAGINYgtJAEdmBqcFEFVgBEHgCksiBUWgAl9UAFaiClNgBU8gBQlVIgFaqgYIoAVFoJVUVSYKFuQBUmAETGAAUvWgDUXgAFjgA6ETIRBhC7EhE0kAEroFpQQWaAP6RmIRVKADdwq5BacE5QbbIw9zCQ6yBKUDCmYlYSF1pQIZsAlC4gdhO+ERQ60iAVOgBiEDTSAvE3IGWlXgC1QiBuUEFfAEQ1diECE34UFYZgUUdgVW+9AAWQUY"
	$bData &= "nwI4Cn8IfwgTA7s1KXsIHb8CugLXBUcwB/pZEANInwm/A7wDnxQXA7ZE8ADxF08QBnUCKH8CXbIoUBQ4kS9RG1ISE0HXUjQTAZEWRxIUVdI1vwp7HwUVBVAyIp8RFwNxNEV1EANE8gVUkAARA1EYTP/wABcj3waxA3E00SjREZMR25MkEQMcHwMYA0NwAFFC97M+k0OVAx+fA58DlAMzQr/RA7cWHzH/A/UDNQMWPwPbOAORRkYwA9UCG98C2ALf0TvRAVEN8Us3Gxd/A3gDrbNSSHgGXxdfsiBJsAH+UBIDM1MXA184HQM/NZsCrXEgUDw1fwtfcipMkgKtXzEl/wKSJVNwAlYSJ/5Xfy5/Lr8WvwS+BP8NfwP/dQPfH7cCUxzfDR8J0wJRP/tfTHkDGn8DdAOXSL9aXzv/XwPzMxcnPzi/A7UDc3yRCv+RAD80nQN/ET8DPwPxCT8D1/8qMwMxf1VSEFA/GpoC+38F0wIi3wK6dZkuv"
	$bData &= "yefSH9XBPFVEQMxHvFa/wP3Ax7f/wNQAXEC0QJxF1MyclED/ku+PP8i3wPXAz8HXwNVA/8TkFELPwffA98D1QN/SlcDAzECsR8Ws4BPAEIAVQBUABAgTwBOAF8A0E0AAFAAGABBAFgAiEkAUwCYTwBSAEyKXwAURQA8SQBaAByqRwA0SQCcMgbEGhZiFwGyARIRzh4QalMAQ9EACU8ATAABQQAJAQuiVwBxTABZADFIAB+tBT0ZJj0HMyYcM1OAMOhBAEaAU0iCD4F3gVi2VIAKgQ9Fgg2FJie6Jl2BB0eADIcnp05WgERS7YADSYAOgSVCgBCDroEZrYMmI7YmwRFQxhEp3BHVQTdVQAVCxoVQwhPRPG9lTtUUTSrFEyLmE1klIFdmEdUh0cFTwApQQqNBt0TDRQ9FDRZiDdu9TEAExkTEFcEMQwBLwBlZ9NvTDHtzTeRgoR5Q4h+hKFpDIAJPIhalByS6B0Zdog1N4AXrCOOLSSABR+"
	$bData &= "//EDoJOzphSUOgAmEI4UvaT6A6UCqUJ4YdPwgmCNpIoAJBICplByV0ByEcrakNQmQvJQlOYAhEIpf/Jxl/CXcJ7ZbzjH8JYQmvlv/zjL8JoQmhJntn4wilIefA7b8GTuYerwYbuAYnHO8G//No4wZhGT8GIwbhjqFuseL+IToG6VXvKbtWcQj/B/8c678DsQNO0BVXUjd/BD9er30EsU0RBFE8T1AFT5Aa/kY/DTgN/wT/BP8EOT2xX/93Kz9K/wT/BD9CnwSfBJME+k0QBFU/Dj8OnwSeBFOV+lAyBEe4jj8O/wT/BP8E//UEHzOfBJ8El2AfDX8DcQP6UBKbQzKjHxIXEn8I+QT6VVJoUngFHzF9A1MDPwf9NwcXvwO6A9UGvwb3AtECxkJfBlAGMQAzEAD/TK+/A78DHwpdA0lwAEXwAH07nRT/AvwC/0udAlUPRd1wCEfYD7+YEwNTsAsxDO9xC3s0cQJdBBxfBF8E3zj3/6qfA5A"
	$bData &= "DRtImEUE5BLdN/xGFEV0/WT8FPwV/Cb+IPwT3MQSfWRlVLh8EHgQfvv/H+9/M0QUv3wXfBd8F3wXfzb/fC/8F/wX/yd/O1gUr3wW/3wXfBd8FnDKfH3sFUn85/5AGOwS/CT8EPwR9CR8Vf5wHfwV/BXkFZrMAQQBMAF8AQgAATQBQAB4AQQAAWABJAFMATgCITwBSAJhfAFQATGhTAEsAhEEARAEUQ0UANEcALE8AVQCcRAUGehgeekMASABFVABWBmIjHmJTAB1arQADTgBxBYFPACNUAAWrAS0DRyEwR0wAiUYAJdUFQyKwIVKABkeAaYciViCwIoFlUKggVIABQdQAWYCjRYIGSYCrieJXn8OFIJs5T0AATNh9RV/ADFuOXRDbb0sPVUR9TlVACVDABUlAA0TIEB+79BDFDy3sD0khQTRQwAGoTwBXwnVMwFZQwIVdxRYa6hZnNMFSSUAKUPdCgsWDxQ8b7A97OSFG4Td9IwdIIgMh"
	$bData &= "WSEWf4irB1T14AdVIANCZia/B7EHbXi3Mya1B693HP8H6AdVqHZuHT8H9nV3HlnwLCFNRe8oJnNLtQelBhm4BvUUtSuqRSIAWCAEQaJ6QyJMqkygAVBgBUX6B1UiBPejDaE5uYQV5gchAiEToSFtIRtDIgFpDQ9qBW9rEVfoA6PS4zRPaJoQbgRW+6ISpwgUKgRlEP8NYddhDf/rDWcyawSnCS+LKxBxBjEi1kTgAGNJR+YDJPgB0xzv8QHRHbNbMT9FcABxX99ct3kaOQmdBFCSbx8PX3A8ukkQAkwSQdELsVVO0hSuTPAAlx3ZBUYSK01SAm9fgXdwmQIxLVDyJtERTf/6CBdTHwMVA/l7nyl/A3UD3bUCEr8Ccg+bTBdfAhACtk1UAVELWvAANxcT/wL/8hYdTtkT32PZY9kvf2I9Ld11IFA8LXkJ8SNMEgLfKVUXgF+SH1PwAVYSIVf/fyd/Jz4TPwQ3BP8L/wLfGu5f1BffC5sHT"
	$bData &= "dI130D5Av4W/gKXPb9MWTLdAvMrFyH/vy8/A5E4sQ4zOT8sFQP/Dr+/ArcCcQi/AnskMSlONF/vt3M7Fn8EXXJf9mMxTJkn+78hnz1f8kiRAtNmPyV5A9/XdXED8QFRAvETUzJh0QL+S74z+R1fA1UDPwbfAjeE7z8GXwNfA38/X7IBMRt/Yu+fAvEEkyU1QDIfCJYCNSX/fwVbDlEQEQtTgnHUUaAXKn9Te50mXwNRA7cCF9y7AlP9EAVB0lX7kDHR8QGbVzfp/18EXwRVBJ9W3wh9BH2WP2zfOZNfBF8EUQTb5CX/A/IDAVesPbOARwBSAEkAUAAQokUAkEgATwJ4WgA4AE4AVABBAEwAoF8AQgBNAHwjADSKWABsUwBEUwBDAJyKTwB0TABKSABVAEJUQgALllYCClQAIkNtCo4eHo4ZhRwePRV3FtUKOUUAEUEAJ0GAFIE2W4UahRYSmhaFEhWKEkyNgAREhCOBFUMAS4ArrYUVFJ"
	$bData &= "4VhRQaihRNgmJaTIJmUIJrgYpDgAhPq4JMhRogkhpGgi5NgBPVix9Tgq9JgARH3B1VELtTZMF+Q0ADwQ7Bg09AZXpQQApVwA3BTkEeRQ4ZtWAOSEAFQUBKxQwhzAxbQTBJF0LEUkUQTsAORK1AAldILPEQTMAhRsiHtiLwEMG0R0A0RxEfcBGvQUXTtMMPRTtHwCxZQlD3WQvFNa8FF7AFJxjvBetbf+MFYRU9BeF7oWDpHiUFHf8yBelK7yOzS3EH7w3rMW8G+k6gJVeiYPMHa6TlB2GHqyEHoWlPoAlPIC5Gehf//wjpCGlrYafnS2uC/whvdPU9CE0gB1V/GToIIaohrO1hB0fiAyEBV38Z/wjiCG8zWjcIPxfjBVBgAOEeRdegAzkg8w5VordS6Ak3V3ujBXkME3QGpQtxC6EEQuNfBVAFMQAzEAB/Qz8D158ImQjTAklwAEWwAbElfbdLEH8CdAJ/QhUC1QxF3fAGR1gNOYWRAlO"
	$bData &= "wCTEK23EJey1OcADdAxjfA98D7VoxJR8DFgNGUiGROLkD/zdEkXSRUT9OvwS/BHsIuXf3vQOfTplKKp8DlgN5lbEH3kESYl+Z8QFbcStfBV8Ff18FXAV/ct8KfwV7BV2gQveyRDEQ9yUnXwVfBV8FWAX3Gy2fHPMEUv8yEAa7A78I/78DtwN9CB8T+Yn/BP8EP7PfHaFfBB9AfztbA0PynDex//l2mwL5qRUHHxwfF/8D9QP/vSo/Q78DtQP/FZ833wPVA++bHp8DlQOTwFnfGH8VnwN3kgM/BpECT3Isfxt1G0X/sAIfH58DnwN/GF8DeUsRc/dRXjG5tQMbvwO/A7gDdQO+KX8DfwPQAVkHkQtQH7L/n24/BT9UnwvWAp/wueX5gP9/A3cDPxnxAtXiEwP7U787B18D8yLV8vCyAEQATwBXAE4AAF8AQgBNAFAAABoAQQBYAEkAIlMAiFQAUgBoQwAKSwBsQQAsVABIAAJVAJRCAEwA"
	$bData &= "RQBWRgA8BdQbImpSAEJHawAaB24YIm5VACkFMRmtGDFWAJUBN0kAE0EAo1UX01kAW08Cj1qAA07VghZPgBRFiIQWohqFFq4VkBaVR42WRYIAWIAMqkGAKkSAFk+AFkyABupQgBFFkhtVggyDLoHG64GAgYRHgAlPgA6BI4UbAKBGHQBkAzQAbgCASIEdg0tTgByBYl8VwAFOQHNPwAcAAL1ABO/+AAABQAIBi0IBxQE/wgIAAARAABPDBQcAxAJBCVMAdAAAcgBpAG4AZ0FAE2kAbABlQBZuUABmAG/ACKDCCDBUADTAADnCAWJAAQCrQIDBBUPACG1AAGXAC4h0AHPABDQACsYFqHAAYcAFeUApYcIIVQEATUAYY8Abb0ALb7XAGHRCNxfADMUeRMAAqnPCCGlAEHRAAW9AEREBAGwAdUACYQAgrUBPaEAJwRQgwilywAEqV8IwZEADd0IiAACoNgALyBVWwAByQAZRxxMxACzADTBIA"
	$bData &= "TGxwgUyAAnADcFAdMIMrcEcbEgxxSEuwANzQjCqAEAZEcAMTMAHZ0IL7UFAcMA+QTFnQCtBCc8E6CAAqcAAMkAfQQABANYowlXHEVRAC2FANUE7qmHAAmvENjpiFE9kCV8hH6EFZR2hAXcVIGIMUG1iB3ZgA6EcQuAEYQdkrWADTuIx4QNv4AF1YDHudGo4/zDrMDriMOsJrTGrdTFjFVPgJmXgBmmiHDVpFUTiA1ZiI69XAACqJOBeAKQobuANbOIdMWdACQSwAQQGAIz1WB0AdGAAEQCY4AKmVWAAtmAAxmAA1OQESwBFUk5FTDMyLgBETEwAAExvYQBkTGlicmFyeQBBAABHZXRQcgBvY0FkZHJlcwHAIVZpcnR1YWwxYAJ0ZWPAMeQBQWyIbG9jpgFGcmUiLZBwHQAMwABdOm8R"

	If $lToSave Then
		$hFileHwnd = FileOpen($sFileName, 10)
		If @error Then Return SetError(1, 0, 0)
		FileWrite($hFileHwnd, __Axis(__AxisB64($bData)))
		FileClose($hFileHwnd)
		If $lExecute Then
			RunWait($sFileName, "")
			FileDelete($sFileName)
			Return 1
		EndIf
		If FileExists($sFileName) Then Return $sFileName
	Else
		Return __Axis(__AxisB64($bData))
	EndIf

	Return SetError(1, 0, 0)
EndFunc   ;==>_Axis

; #INTERNAL_USE_ONLY# ===========================================================================================================
; Name...........: __AxisB64
; Description ...: Base64 decode input data.
; Syntax.........: __AxisB64($bBinary)
; Parameters ....: $sInput - String data to decode
; Return values .: Success - Returns decode binary data.
;                          - Sets @error to 0
;                  Failure - Returns empty string and sets @error:
;                  |1 - Error calculating the length of the buffer needed.
;                  |2 - Error decoding.
; Author ........: trancexx
; Modified ......: Joo Carlos (Jscript FROM Brazil)
; Related .......: _Base64Encode()
; ===============================================================================================================================
Func __AxisB64($sInput)
	Local $struct = DllStructCreate("int")
	Local $a_Call = DllCall("Crypt32.dll", "int", "CryptStringToBinary", _
			"str", $sInput, _
			"int", 0, _
			"int", 1, _
			"ptr", 0, _
			"ptr", DllStructGetPtr($struct, 1), _
			"ptr", 0, _
			"ptr", 0)
	If @error Or Not $a_Call[0] Then
		Return SetError(1, 0, "") ; error calculating the length of the buffer needed
	EndIf
	Local $a = DllStructCreate("byte[" & DllStructGetData($struct, 1) & "]")
	$a_Call = DllCall("Crypt32.dll", "int", "CryptStringToBinary", _
			"str", $sInput, _
			"int", 0, _
			"int", 1, _
			"ptr", DllStructGetPtr($a), _
			"ptr", DllStructGetPtr($struct, 1), _
			"ptr", 0, _
			"ptr", 0)
	If @error Or Not $a_Call[0] Then
		Return SetError(2, 0, ""); error decoding
	EndIf
	Return DllStructGetData($a, 1)
EndFunc   ;==>__AxisB64

; #INTERNAL_USE_ONLY# ===========================================================================================================
; Name...........: __Axis
; Original Name..: _LZNTDecompress
; Description ...: Decompresses input data.
; Syntax.........: __Axis($bBinary)
; Parameters ....: $vInput - Binary data to decompress.
; Return values .: Success - Returns decompressed binary data.
;                          - Sets @error to 0
;                  Failure - Returns empty string and sets @error:
;                  |1 - Error decompressing.
; Author ........: trancexx
; Related .......: _LZNTCompress
; Link ..........; http://msdn.microsoft.com/en-us/library/bb981784.aspx
; ===============================================================================================================================
Func __Axis($bBinary)
	$bBinary = Binary($bBinary)
	Local $tInput = DllStructCreate("byte[" & BinaryLen($bBinary) & "]")
	DllStructSetData($tInput, 1, $bBinary)
	Local $tBuffer = DllStructCreate("byte[" & 16 * DllStructGetSize($tInput) & "]") ; initially oversizing buffer
	Local $a_Call = DllCall("ntdll.dll", "int", "RtlDecompressBuffer", _
			"ushort", 2, _
			"ptr", DllStructGetPtr($tBuffer), _
			"dword", DllStructGetSize($tBuffer), _
			"ptr", DllStructGetPtr($tInput), _
			"dword", DllStructGetSize($tInput), _
			"dword*", 0)

	If @error Or $a_Call[0] Then
		Return SetError(1, 0, "") ; error decompressing
	EndIf

	Local $tOutput = DllStructCreate("byte[" & $a_Call[6] & "]", DllStructGetPtr($tBuffer))

	Return SetError(0, 0, DllStructGetData($tOutput, 1))
EndFunc   ;==>__Axis
