#include-once

; #FUNCTION# ====================================================================================================================
; Name ..........: _WinAPI_DwmEnableBlurBehindWindow10
; Description ...: Enables Aero-like blurred background in Windows 10.
; Syntax ........: _WinAPI_DwmEnableBlurBehindWindow10($hWnd[, $iMode = $ACCENT_ENABLE_BLURBEHIND])
; Parameters ....: $hWnd                - Window handle.
;                  $bEnable             - [optional] Enable or disable the blur effect.
; Return values .: 1 on success, 0 otherwise. Call _WinAPI_GetLastError on failure for more information.
; Author ........: scintilla4evr
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........: http://vhanla.codigobit.info/2015/07/enable-windows-10-aero-glass-aka-blur.html and http://undoc.airesoft.co.uk/user32.dll/SetWindowCompositionAttribute.php
; Example .......: Yes
; ===============================================================================================================================
Func _WinAPI_DwmEnableBlurBehindWindow10($hWnd, $bEnable = True)
	Local $tAccentPolicy = DllStructCreate("int AccentState; int AccentFlags; int GradientColor; int AnimationId")
	Local $tAttrData = DllStructCreate("dword Attribute; ptr DataBuffer; ulong Size")
	$tAccentPolicy.AccentState = $bEnable ? 3 : 0
	$tAttrData.Attribute = 19 ; WCA_ACCENT_POLICY
	$tAttrData.DataBuffer = DllStructGetPtr($tAccentPolicy)
	$tAttrData.Size = DllStructGetSize($tAccentPolicy)

	Local $aResult = DllCall("user32.dll", "bool", "SetWindowCompositionAttribute", "hwnd", $hWnd, "ptr", DllStructGetPtr($tAttrData))
	If @error Then Return SetError(@error, @extended, 0)

	Return $aResult[0]
EndFunc
