#include-once

; #INDEX# =======================================================================================================================
; Title .........: Photoshop Constants
; AutoIt Version : 3.3.14.2
; Language ......: English
; Description ...: Constants to be included in an AutoIt script when using the Photoshop UDF.
; Author(s) .....: scintilla4evr
; Resources .....: Photoshop CC VBScript Reference from Adobe Photoshop Scripting
;                  (http://www.adobe.com/devnet/photoshop/scripting.html)
; ===============================================================================================================================

; PsAdjustmentReference
Global Enum $PsRelative = 1, $PsAbsolute

; PsAnchorPosition
Global Enum $PsTopLeft = 1, $PsTopCenter, $PsTopRight, $PsMiddleLeft, $PsMiddleCenter, $PsMiddleRight, $PsBottomLeft, $PsBottomCenter, $PsBottomRight

; PsAntiAlias
Global Enum $PsNoAntialias = 1, $PsSharp, $PsCrisp, $PsStrong, $PsSmooth

; PsAutoKernType
Global Enum $PsManual, $PsMetrics, $PsOptical

; PsBatchDestinationType
Global Enum $PsNoDestination = 1, $PsSaveAndClose, $PsFolder

; PsBitmapConversionType
Global Enum $PsHalfThreshold = 1, $PsPatternDither, $PsDiffusionDither, $PsHalftoneScreen, $PsCustomPattern

; PsBitmapHalftoneType
Global Enum $PsHalftoneRound = 1, $PsHalftoneDiamond, $PsHalftoneEllipse, $PsHalftoneLine, $PsHalftoneSquare, $PsHalftoneCross

; PsBitsPerChannelType
Global Enum $PsDocument1Bit = 1, $PsDocument8Bits = 8, $PsDocument16Bits = 16, $PsDocument32Bits = 32

; PsBlendMode
Global Enum $PsPassThrough = 1, $PsNormalBlend, $PsDissolve, $PsDarken, $PsMultiply, $PsColorBurn, $PsLinearBurn, $PsLighten, $PsScreen, $PsColorDodge, $PsLinearDodge, $PsOverlay, $PsSoftLight, $PsHardLight, $PsVividLight, $PsLinearLight, $PsPinLight, $PsDifference, $PsExclusion, $PsHue, $PsSaturationBlend, $PsColorBlend, $PsLuminosity, $PsHardMix = 26, $PsLighterColor, $PsDarkerColor, $PsSubtract, $PsDivide

; PsBMPDepthType
Global Enum $PsBMP1Bit = 1, $PsBMP4Bits = 4, $PsBMP8Bits = 8, $PsBMP16Bits = 16, $PsBMP24Bits = 24, $PsBMP32Bits = 32, $PsBMP_X1R5G5B5 = 60, $PsBMP_A1R5G5B5, $PsBMP_R5G6B5, $PsBMP_X4R4G4B4, $PsBMP_A4R4G4B4, $PsBMP_R8G8B8, $PsBMP_X8R8G8B8, $PsBMP_A8R8G8B8

; PsByteOrder
Global Enum $PsIBMByteOrder = 1, $PsMacOSByteOrder

; PsCameraRAWSettingsType
Global Enum $PsCameraDefault, $PsSelectedImage, $PsCustomSettings

; PsCameraRAWSize
Global Enum $PsMinimumCameraRAW, $PsSmallCameraRAW, $PsMediumCameraRAW, $PsLargeCameraRAW, $PsExtraLargeCameraRAW, $PsMaximumCameraRAW

; PsCase
Global Enum $PsNormalCase = 1, $PsAllCaps, $PsSmallCaps

; PsChangeMode
Global Enum $PsConvertToGrayscale = 1, $PsConvertToRGB, $PsConvertToCMYK, $PsConvertToLab, $PsConvertToBitmap, $PsConvertToIndexedColor, $PsConvertToMultiChannel

; PsChannelType
Global Enum $PsComponentChannel = 1, $PsMaskedAreaAlphaChannel, $PsSelectedAreaAlphaChannel, $PsSpotColorChannel

; PsColorBlendMode
Global Enum $PsNormalBlendColor = 2, $PsDissolveBlend, $PsDarkenBlend, $PsMultiplyBlend, $PsColorBurnBlend, $PsLinearBurnBlend, $PsLightenBlend, $PsScreenBlend, $PsColorDodgeBlend, $PsLinearDodgeBlend, $PsOverlayBlend, $PsSoftLightBlend, $PsHardLightBlend, $PsVividLightBlend, $PsLinearLightBlend, $PsPinLightBlend, $PsDifferenceBlend, $PsExclusionBlend, $PsHueBlend, $PsSaturationBlendColor, $PsColorBlendMode, $PsLuminosityBlend, $PsBehindBlend, $PsClearBlend, $PsHardMixBlend, $PsSubtractBlend, $PsDivideBlend

; PsColorModel
Global Enum $PsGrayscaleModel = 1, $PsRGBModel, $PsCMYKModel, $PsLabModel, $PsHSBModel, $PsNoModel = 50

; PsColorPicker
Global Enum $PsAdobeColorPicker = 1, $PsAppleColorPicker, $PsWindowsColorPicker, $PsPluginColorPicker

; PsColorProfileType
Global Enum $PsNo = 1, $PsWorking, $PsCustom

; PsColorReductionType
Global Enum $PsPerceptualReduction, $PsSelective, $PsAdaptive, $PsRestrictive, $PsCustomReduction, $PsBlsckWhiteReduction, $PsSFWGrayscale, $PsMacintoshColors, $PsWindowsColors

; PsColorSpaceType
Global Enum $PsAdobeRGB, $PsColorMatchRGB, $PsProPhotoRGB, $PsSRGB

; PsCopyrightedType
Global Enum $PsCopyrightedWork = 1, $PsPublicDomain, $PsUnmarked

; PsCreateFields
Global Enum $PsDuplication = 1, $PsInterpolation

; PsCropToType
Global Enum $PsBoundingBox, $PsMediaBox, $PsCropBox, $PsBleedBox, $PsTrimBox, $PsArtBox

; PsDCSType
Global Enum $PsNoComposite = 1, $PsGrayscaleComposite, $PsColorComposite

; PsDepthMapSource
Global Enum $PsNoSource = 1, $PsTransparencyChannel, $PsLayerMask, $PsImageHighlight

; PsDescValueType
Global Enum $PsIntegerType = 1, $PsDoubleType, $PsUnitDoubleType, $PsStringType, $PsBooleanType, $PsListType, $PsObjectType, $PsEnumeratedType, $PsReferenceType, $PsClassType, $PsAliasType, $PsRawType, $PsLargeIntegerType

; PsDialogModes
Global Enum $PsDisplayAllDialogs = 1, $PsDisplayErrorDialogs, $PsDisplayNoDialogs

; PsDirection
Global Enum $PsHorizontal = 1, $PsVertical

; PsDisplacementMapType
Global Enum $PsStretchToFit = 1, $PsTile

; PsDitherType
Global Enum $PsNoDither = 1, $PsDiffusion, $PsPattern, $PsNoise

; PsDocumentFill
Global Enum $PsWhite = 1, $PsBackgroundColor, $PsTransparent

; PsDocumentMode
Global Enum $PsGrayscale = 1, $PsRGB, $PsCMYK, $PsLab, $PsBitmap, $PsIndexedColor, $PsMultiChannel, $PsDuotone

; PsEditLogItemsType
Global Enum $PsSessionOnly = 1, $PsConcise, $PsDetailes

; PsElementPlacement
Global Enum $PsPlaceInside, $PsPlaceAtBeginning, $PsPlaceAtEnd, $PsPlaceBefore, $PsPlaceAfter

; PsEliminateFields
Global Enum $PsOddFields = 1, $PsEvenFields

; PsExportType
Global Enum $PsIllustratorPaths = 1, $PsSaveForWeb

; PsExtensionType
Global Enum $PsLowercase = 2, $PsUppercase

; PsFileNamingType
Global Enum $PsDocumentNameMixed = 1, $PsDocumentNameLower, $PsDocumentNameUpper, $PsSerialNumber1, $PsSerialNumber2, $PsSerialNumber3, $PsSerialNumber4, $PsSerialLetterLower, $PsSerialLetterUpper, $PsMmddyy, $PsMmdd, $PsYyyymmdd, $PsYymmdd, $PsYyddmm, $PsDdmmyy, $PsDdmm, $PsExtensionLower, $PsExtensionUpper

; PsFontPreviewType
Global Enum $PsFontPreviewNone, $PsFontPreviewSmall, $PsFontPreviewMedium, $PsFontPreviewLarge, $PsFontPreviewExtraLarge, $PsFontPreviewHuge

; PsForcedColors
Global Enum $PsNoForced = 1, $PsBlackWhite, $PsPrimaries, $PsWeb

; PsFormatOptionsType
Global Enum $PsStandardBaseline = 1, $PsOptimizedBaseline, $PsProgressive

; PsGalleryConstrainType
Global Enum $PsConstrainWidth = 1, $PsConstrainHeight, $PsConstrainBoth

; PsGalleryFontType
Global Enum $PsArial = 1, $PsCourierNew, $PsHelvetica, $PsTimesNewRoman

; PsGallerySecurityTextPositionType
Global Enum $PsCentered = 1, $PsUpperLeft, $PsLowerLeft, $PsUpperRight, $PsLowerRight

; PsGallerySecurityTextRotateType
Global Enum $PsZero = 1, $PsClockwise45, $PsClockwise90, $PsCounterClockwise45, $PsCounterClockwise90

; PsGallerySecurityType
Global Enum $PsNoSecurity = 1, $PsCustomSecurityText, $PsFileName, $PsCopyright, $PsCaption, $PsCredit, $PsTitle

; PsGalleryThumbSizeType
Global Enum $PsSmall = 1, $PsMedium, $PsLarge, $PsCustomThumbnail

; PsGeometry
Global Enum $PsTriangle, $PsPentagon, $PsHexagon, $PsSquareGeometry, $PsHeptagon, $PsOctagon

; PsGridLineStyle
Global Enum $PsNoGrid = 1, $PsSmallGrid, $PsMediumGrid, $PsLargeGrid

; PsGuideLineStyle
Global Enum $PsGuideSolidLine = 1, $PsGuideDashedLine

; PsIllustratorPathType
Global Enum $PsDocumentBounds = 1, $PsAllPaths, $PsNamedPath

; PsIntent
Global Enum $PsPerceptual = 1, $PsSaturation, $PsRelativeColorimetric, $PsAbsoluteColorimetric

; PsJavaScriptExecutionMode
Global Enum $PsNeverShowDebugger = 1, $PsDebuggerOnError, $PsBeforeRunning

; PsJustification
Global Enum $PsLeft = 1, $PsCenter, $PsRight, $PsLeftJustified, $PsCenterJustified, $PsRightJustified, $PsFullyJustified

; PsLanguage
Global Enum $PsEnglishUSA = 1, $PsEnglishUK, $PsFrench, $PsCanadianFrench, $PsFinnish, $PsGerman, $PsOldGerman, $PsSwissGerman, $PsItalian, $PsNorwegian, $PsNynorskNorwegian, $PsPortugese, $PsBrazilianPortugese, $PsSpanish, $PsSwedish, $PsDutch, $PsDanish

; PsLayerCompressionType
Global Enum $PsRLELayerCompression = 1, $PsZIPLayerCompression

; PsLayerKind
Global Enum $PsNormalLayer = 1, $PsTextLayer, $PsSolidFillLayer, $PsGradientFillLayer, $PsPatternFillLayer, $PsLevelsLayer, $PsCurvesLayer, $PsColorBalanceLayer, $PsBrightnessContrastLayer, $PsHueSaturationLayer, $PsSelectiveColorLayer, $PsChannelMixerLayer, $PsGradientMapLayer, $PsInversionLayer, $PsThresholdLayer, $PsPosterizeLayer, $PsSmartObjectLayer, $PsPhotoFilterLayer, $PsExposureLayer, $PsLayer3D, $PsVideoLayer, $PsBlackAndWhiteLayer, $PsVibrance

; PsLayerType
Global Enum $PsArtLayer = 1, $PsLayerSet

; PsLensType
Global Enum $PsZoomLens = 1, $PsPrime35, $PsPrime105, $PsMoviePrime

; PsMagnificationType
Global Enum $PsActualSize, $PsFitPage

; PsMatteType
Global Enum $PsNoMatte = 1, $PsForegroundColorMatte, $PsBackgroundColorMatte, $PsWhiteMatte, $PsBlackMatte, $PsSemiGray, $PsNetscapeGrayMatte

; PsMeasurementRange
Global Enum $PsAllMeasurements = 1, $PsActiveMeasurements

; PsMeasurementSource
Global Enum $PsMeasureSelection = 1, $PsMeasureCountTool, $PsMeasureRulerTool

; PsNewDocumentMode
Global Enum $PsNewGray = 1, $PsNewRGB, $PsNewCMYK, $PsNewLab, $PsNewBitmap

; PsNoiseDistribution
Global Enum $PsUniformNoise = 1, $PsGaussianNoise

; PsOffsetUndefinedAreas
Global Enum $PsOffsetSetToLayerFill = 1, $PsOffsetWraparound, $PsOffsetRepeatEdgePixels

; PsOpenDocumentMode
Global Enum $PsOpenGray = 1, $PsOpenRGB, $PsOpenCMYK, $PsOpenLab

; PsOpenDocumentType
Global Enum $PsPhotoshopOpen = 1, $PsBMPOpen, $PsCompuServeGIFOpen, $PsPhotoshopEPSOpen, $PsFilmstripOpen, $PsJPEGOpen, $PsPCXOpen, $PsPhotoshopPDFOpen, $PsPhotoCDOpen, $PsPICTFileFormatOpen, $PsPICTResourceFormatOpen, $PsPixarOpen, $PsPNGOpen, $PsRawOpen, $PsScitexCTOpen, $PsTargaOpen, $PsTIFFOpen, $PsPhotoshopDCS_1Open, $PsPhotoshopDCS_2Open, $PsPDFOpen, $PsEPSOpen, $PsEPSPICTPreviewOpen, $PsEPSTIFFPreviewOpen, $PsAliasPIXOpen, $PsElectricImageOpen, $PsPortableBitmapOpen, $PsWavefrontRLAOpen, $PsSGIRGBOpen, $PsSoftImageOpen, $PsWirelessBitmapOpen, $PsCameraRAWOpen, $PsDICOMOpen

; PsOperatingSystem
Global Enum $PsOS2 = 1, $PsWindows

; PsOrientation
Global Enum $PsLandscape = 1, $PsPortrait

; PsOtherPaintingCursors
Global Enum $PsStandardOther = 1, $PsPreciseOther

; PsPaintingCursors
Global Enum $PsStandard = 1, $PsPrecise, $PsBrushSize

; PsPaletteType
Global Enum $PsExact = 1, $PsMacOSPalette, $PsWindowsPalette, $PsWebPalette, $PsUniform, $PsLocalPerceptual, $PsLocalSelective, $PsLocalAdaptive, $PsMasterPerceptual, $PsMasterSelective, $PsMasterAdaptive, $PsPreviousPalette

; PsPathKind
Global Enum $PsNormalPath = 1, $PsClippingPath, $PsWorkPath, $PsVectorMask, $PsTextMask

; PsPDFCompatibilityType
Global Enum $PsPDF13 = 1, $PsPDF14, $PsPDF15, $PsPDF16

; PsPDFEncoding
Global Enum $PsPDFNone, $PsPDFZip, $PsPDFJPEG, $PsPDFPDFZip4Bit, $PsPDFJPEGHIGH, $PsPDFJPEGMED, $PsPDFJPEGMEDLOW, $PsPDFJPEGLOW, $PsPDFJPEG2000HIGH, $PsPDFJPEG2000MEDHIGH, $PsPDFJPEG2000MED, $PsPDFJPEG2000MEDLOW, $PsPDFJPEG2000LOW, $PsPDFJPEG2000LOSSLESS

; PsPDFResampleType
Global Enum $PsNoResample, $PsPDFAverage, $PsPDFSubSample, $PsPDFBicubic

; PsPDFStandardType
Global Enum $PsNoStandard, $PsPDFX1A2001, $PsPDFX1A2003, $PsPDFX32002, $PsPDFX32003

; PsPhotoCDColorSpace
Global Enum $PsRGB8 = 1, $PsRGB16, $PsLab8, $PsLab16

; PsPhotoCDSize
Global Enum $PsMinimumPhotoCD = 1, $PsSmallPhotoCD, $PsMediumPhotoCD, $PsLargePhotoCD, $PsExtraLargePhotoCD, $PsMaximumPhotoCD

; PsPICTBitsPerPixels
Global Enum Step *2 $PsPICTTwoBits = 2, $PsPICTFourBits, $PsPICTEightBits, $PsPICTSixteenBits, $PsPICTThirtyTwoBits

; PsPICTCompression
Global Enum $PsNoPICTCompression = 1, $PsJPEGLowPICT, $PsJPEGMediumPICT, $PsJPEGHighPICT, $PsJPEGMaximumPICT

; PsPicturePackageTextType
Global Enum $PsNoText = 1, $PsUserText, $PsFilenameText, $PsCopyrightText, $PsCaptionText, $PsCreditText, $PsOriginText

; PsPointKind
Global Enum $PsSmoothPoint = 1, $PsCornerPoint

; PsPointType
Global Enum $PsPostScriptPoints = 1, $PsTraditionalPoints

; PsPolarConversionType
Global Enum $PsRectangularToPolar = 1, $PsPolarToRectangular

; PsPreviewType
Global Enum $PsNoPreview = 1, $PsMonochromeTIFF, $PsEightbitTIFF

; PsPurgeTarget
Global Enum $PsUndoCaches = 1, $PsHistoryCaches, $PsClipboardCache, $PsAllCaches

; PsQueryStateType
Global Enum $PsAlways = 1, $PsAsk, $PsNever

; PsRadialBlurMethod
Global Enum $PsSpin = 1, $PsZoom

; PsRadialBlurQuality
Global Enum $PsRadialBlurDraft = 1, $PsRadialBlurGood, $PsRadialBlurBest

; PsRasterizeType
Global Enum $PsTextContents = 1, $PsShape, $PsFillContent, $PsLayerClippingPath, $PsEntireLayer, $PsLinkedLayers

; PsReferenceFormType
Global Enum $PsReferenceNameType = 1, $PsReferenceIndexType, $PsReferenceIdentifierType, $PsReferenceOffsetType, $PsReferenceEnumeratedType, $PsReferencePropertyType, $PsReferenceClassType

; PsResampleMethod
Global Enum $PsNoResampling = 1, $PsNearestNeighbor, $PsBilinear, $PsBicubic, $PsBicubicSharper, $PsBicubicSmoother, $PsBicubicAutomatic, $PsAutomatic, $PsPreserveDetails

; PsRippleSize
Global Enum $PsSmallRipple = 1, $PsMediumRipple, $PsLargeRipple

; PsSaveBehavior
Global Enum $PsNeverSave = 1, $PsAlwaysSave, $PsAskWhenSaving

; PsSaveDocumentType
Global Enum $PsPhotoshopSave = 1, $PsBMPSave, $PsCompuServeGIFSave, $PsPhotoshopEPSSave, $PsJPEGSave, $PsPCXSave, $PsPhotoshopPDFSave, $PsPICTFileFormatSave, $PsPixarSave, $PsPNGSave, $PsRawSave, $PsScitexCTSave, $PsTargaSave, $PsTIFFSave, $PsPhotoshopDCS_1Save, $PsPhotoshopDCS_2Save, $PsAliasPIXSave, $PsElectricImageSave, $PsPortableBitmapSave, $PsWavefrontRLASave, $PsSGIRGBSave, $PsSoftImageSave, $PsWirelessBitmapSave

; PsSaveEncoding
Global Enum $PsBinary = 1, $PsJPEGLow, $PsAscii, $PsJPEGMedium, $PsJPEGHigh, $PsJPEGMaximum

; PsSaveLogItemsType
Global Enum $PsMetadata = 1, $PsLogFile, $PsLogFileAndMetadata

; PsSaveOptions
Global Enum $PsSaveChanges = 1, $PsDoNotSaveChanges, $PsPromptToSaveChanges

; PsSelectionType
Global Enum $PsReplaceSelection = 1, $PsExtendSelection, $PsDiminishSelection, $PsIntersectSelection

; PsShapeOperation
Global Enum $PsShapeAdd = 1, $PsShapeXOR, $PsShapeIntersect, $PsShapeSubtract

; PsSmartBlurMode
Global Enum $PsSmartBlurNormal = 1, $PsSmartBlurEdgeOnly, $PsSmartBlurOverlayEdge

; PsSmartBlurQuality
Global Enum $PsSmartBlurLow = 1, $PsSmartBlurMedium, $PsSmartBlurHigh

; PsSourceSpaceType
Global Enum $PsDocumentSpace = 1, $PsProofSpace

; PsSpherizeMode
Global Enum $PsNormalSpherize = 1, $PsHorizontalSpherize, $PsVerticalSpherize

; PsStrikeThruType
Global Enum $PsStrikeOff = 1, $PsStrikeHeight, $PsStrikeBox

; PsStrokeLocation
Global Enum $PsInsideStroke = 1, $PsCenterStroke, $PsOutsideStroke

; PsTargaBitsPerPixels
Global Enum Step +8 $PsTarga16Bits = 16, $PsTarga24Bits, $PsTarga32Bits

; PsTextComposer
Global Enum $PsAdobeSingleLine = 1, $PsAdobeEveryLine

; PsTextType
Global Enum $PsPointText = 1, $PsParagraphText

; PsTextureType
Global Enum $PsBlocksTexture = 1, $PsCanvasTexture, $PsFrostedTexture, $PsTinyLensTexture, $PsTextureFile

; PsTIFFEncodingType
Global Enum $PsNoTIFFCompression = 1, $PsTIFFLZW, $PsTIFFJPEG, $PsTIFFZIP

; PsToolType
Global Enum $PsPencil = 1, $PsBrush, $PsEraser, $PsBackgroundEraser, $PsCloneStamp, $PsPatternStamp, $PsHealingBrush, $PsHistoryBrush, $PsArtHistoryBrush, $PsSmudge, $PsBlur, $PsSharpen, $PsDodge, $PsBurn, $PsSponge, $PsColorReplacementTool

; PsTransitionType
Global Enum $PsBlindsHorizontal = 1, $PsBlindsVertical, $PsDissolveTransition, $PsBoxIn, $PsBoxOut, $PsGlitterDown, $PsGlitterRight, $PsGlitterRightDown, $PsNoTransition, $PsRandom, $PsSplitHorizontalIn, $PsSplitHorizontalOut, $PsSplitVerticalIn, $PsSplitVerticalOut, $PsWipeDown, $PsWipeLeft, $PsWipeRight, $PsWipeUp

; PsTrimType
Global Enum $PsTransparentPixels, $PsTopLeftPixel, $PsBottomRightPixel = 9

; PsTypeUnits
Global Enum $PsTypePixels = 1, $PsTypeMM = 4, $PsTypePoints

; PsUndefindedAreas
Global Enum $PsWrapAround = 1, $PsRepeatEdgePixels

; PsUnderlineType
Global Enum $PsUnderlineOff = 1, $PsUnderlineRight, $PsUnderlineLeft

; PsUnits
Global Enum $PsPixels = 1, $PsInches, $PsCM, $PsMM, $PsPoints, $PsPicas, $PsPercent

; PsUrgency
Global Enum $PsNone, $PsLow, $PsTwo, $PsThree, $PsFour, $PsNormal, $PsSix, $PsSeven, $PsHigh

; PsWarpStyle
Global Enum $PsNoWarp = 1, $PsArc, $PsArcLower, $PsArcUpper, $PsArch, $PsBulge, $PsShellLower, $PsShellUpper, $PsFlag, $PsWave, $PsFish, $PsRise, $PsFishEye, $PsInflate, $PsSqueeze, $PsTwist

; PsWaveType
Global Enum $PsSine = 1, $PsTriangular, $PsSquare

; PsWhiteBalanceType
Global Enum $PsAsShot, $PsAuto, $PsDaylight, $PsCloudy, $PsShade, $PsTungsten, $PsFluorescent, $PsFlash, $PsCustomCameraSettings

; PsZigZagType
Global Enum $PsAroundCenter = 1, $PsOutFromCenter, $PsPondRipples
