#pragma compile(AutoItExecuteAllowed, true) ; Required!
#pragma compile(FileDescription, "AutoIt Protocol Handler")
#pragma compile(FileVersion, 1.1.0.0)
#pragma compile(CompanyName, scintilla4evr)
#pragma compile(Icon, icon.ico)

#include <Array.au3>
#include <File.au3>
#include <WinAPIShPath.au3>

If @Compiled Then
	; Warn the user! [TheDcoder]
	$bAreYouReallySure = MsgBox(36, "Script execution warning", "The website is trying to execute a script, which may be dangerous to your computer. Are you sure you want to proceed?")
	If $bAreYouReallySure <> 6 Then Exit

	; Put the URL together
	$arr = $CmdLine
	_ArrayDelete($arr, 0)
	$sData = _ArrayToString($arr, " ")
	$sData = StringTrimLeft($sData, 7)

	; Look for modifiers
	If StringRegExp($sData, "\A\s*url\(.*\)\s*\Z") Then
		$aRegExp = StringRegExp($sData, "\A\s*url\((.*)\)\s*\Z", 1)
		$sURL = $aRegExp[0]
		$sData = BinaryToString(InetRead($sURL))
	ElseIf StringRegExp($sData, "\A\s*local-url\(.*\)\s*\Z") Then
		$aRegExp = StringRegExp($sData, "\A\s*local-url\((.*)\)\s*\Z", 1)
		$sURL = $aRegExp[0]
		$sData = FileRead($sURL)
	ElseIf StringRegExp($sData, "\A\s*helpfile-example\(.*\)\s*\Z") Then
		$aRegExp = StringRegExp($sData, "\A\s*helpfile-example\((.*)\)\s*\Z", 1)
		$sURL = $aRegExp[0]
		$sData = FileRead(_WinAPI_PathRemoveFileSpec(@AutoItExe)&"\Examples\Helpfile\"&$sURL&".au3")
	ElseIf StringRegExp($sData, "\A\s*str-format\(.*\)\s*\Z") Then
		$aRegExp = StringRegExp($sData, "\A\s*str-format\((.*)\)\s*\Z", 1)
		$sData = StringFormat($aRegExp[0])
	EndIf

	; Save to a temporary file and EXECUTE!
	$sTempFile = _TempFile(@TempDir, "~", ".au3")
	FileWrite($sTempFile, $sData)
	RunWait('"'&@AutoItExe&'" /AutoIt3ExecuteScript "'&$sTempFile&'"')
	FileDelete($sTempFile)
EndIf

