#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=..\Icons\listcompare3.ico
#AutoIt3Wrapper_Outfile=..\Program\ListCompare.exe
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Run_Tidy=y
#Tidy_Parameters=/tc 4 /reel
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/rm
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

Opt("GUICloseOnESC", 0) ; Disable ESC to close!

; +----------------------------------------------------------------+
; | Define local and global variables.                             |
; +----------------------------------------------------------------+

#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <Array.au3>
#include <WinAPI.au3>

#Region ### START Koda GUI section ### Form=
$Form1 = GUICreate("List Compare", 465, 651, -1, -1)
GUISetBkColor(0xC0C0C0)
$List1 = GUICtrlCreateEdit("", 16, 48, 200, 265)
GUICtrlSetData(-1, "")
$List2 = GUICtrlCreateEdit("", 248, 48, 200, 265)
GUICtrlSetData(-1, "")
$Name1 = GUICtrlCreateInput("Left", 16, 16, 200, 21)
$Name2 = GUICtrlCreateInput("Right", 248, 16, 200, 21)
$Button1 = GUICtrlCreateButton("Compare", 15, 320, 202, 25)
$Button2 = GUICtrlCreateButton("Compare Case", 247, 320, 202, 25)
$Edit1 = GUICtrlCreateEdit("", 16, 375, 145, 257, BitOR($GUI_SS_DEFAULT_EDIT, $ES_READONLY))
GUICtrlSetData(-1, "")
$Edit2 = GUICtrlCreateEdit("", 160, 375, 145, 257, BitOR($GUI_SS_DEFAULT_EDIT, $ES_READONLY))
GUICtrlSetData(-1, "")
$Edit3 = GUICtrlCreateEdit("", 304, 375, 145, 257, BitOR($GUI_SS_DEFAULT_EDIT, $ES_READONLY))
GUICtrlSetData(-1, "")
$Label1 = GUICtrlCreateLabel("", 16, 352, 140, 17)
$Label2 = GUICtrlCreateLabel("Both", 160, 352, 140, 17)
$Label3 = GUICtrlCreateLabel("", 302, 352, 140, 17)
GUISetState(@SW_SHOW)
#EndRegion ### END Koda GUI section ###

GUICtrlSetData($Label1, GUICtrlRead($Name1) & " Only")
GUICtrlSetData($Label3, GUICtrlRead($Name2) & " Only")

While 1
    $nMsg = GUIGetMsg()
    If WinActive("List Compare") Then
        HotKeySet("^a", "_selectall")
    Else
        HotKeySet("^a")
    EndIf
    Switch $nMsg
        Case $GUI_EVENT_CLOSE
            Exit
        Case $Button1
            $CheckCase = 0
            _DoCompare()
        Case $Button2
            $CheckCase = 1
            _DoCompare()
    EndSwitch
WEnd

Func _DoCompare()
    $Value1 = GUICtrlRead($List1)
    $Value2 = GUICtrlRead($List2)

    $Value1 = StringRegExpReplace($Value1, '\R', '|')
    $Value2 = StringRegExpReplace($Value2, '\R', '|')

    If StringRight($Value1, 1) = "|" Then $Value1 = StringTrimRight($Value1, 1)
    If StringRight($Value2, 1) = "|" Then $Value2 = StringTrimRight($Value2, 1)

    If StringLeft($Value1, 1) = "|" Then $Value1 = StringTrimLeft($Value1, 1)
    If StringLeft($Value2, 1) = "|" Then $Value2 = StringTrimLeft($Value2, 1)

    Do ; -- Remove all blank and white space entries
        $Value1 = StringReplace($Value1, "||", "|")
        $Value2 = StringReplace($Value2, "||", "|")

        $Value1 = StringReplace($Value1, " ", "")
        $Value2 = StringReplace($Value2, " ", "")

        $CheckV1 = StringInStr($Value1 & $Value2, "||")
        $CheckV2 = StringInStr($Value1 & $Value2, " ")
    Until $CheckV1 = 0 And $CheckV2 = 0

    $cTestV1 = StringSplit(StringUpper($Value1), '|', $STR_ENTIRESPLIT + $STR_NOCOUNT)
    $cTestV2 = StringSplit(StringUpper($Value2), '|', $STR_ENTIRESPLIT + $STR_NOCOUNT)

    $TestV1 = StringSplit($Value1, '|', $STR_ENTIRESPLIT + $STR_NOCOUNT)
    $TestV2 = StringSplit($Value2, '|', $STR_ENTIRESPLIT + $STR_NOCOUNT)

    _ArraySort($TestV1)
    _ArraySort($TestV2)

    $ListV1 = _ArrayToString($TestV1, "|")
    $ListV2 = _ArrayToString($TestV2, "|")

    $Value1 = StringReplace($ListV1, '|', @CRLF)
    $Value2 = StringReplace($ListV2, '|', @CRLF)

    GUICtrlSetData($List1, $Value1)
    GUICtrlSetData($List2, $Value2)

    If $CheckCase = 0 Then $RetV = _GetIntersection($cTestV1, $cTestV2, 0)
    If $CheckCase = 1 Then $RetV = _GetIntersection($TestV1, $TestV2, 0)

    If IsArray($RetV) Then
        $RetV1 = _ArrayToString($RetV, "|", -1, -1, @CRLF, 0, 0)
        $RetV2 = _ArrayToString($RetV, "|", -1, -1, @CRLF, 1, 1)
        $RetV3 = _ArrayToString($RetV, "|", -1, -1, @CRLF, 2, 2)

        $RetV1 = StringReplace($RetV1, "|", @CRLF)
        $RetV2 = StringReplace($RetV2, "|", @CRLF)
        $RetV3 = StringReplace($RetV3, "|", @CRLF)

        GUICtrlSetData($Edit1, $RetV2)
        GUICtrlSetData($Edit2, $RetV1)
        GUICtrlSetData($Edit3, $RetV3)

        GUICtrlSetData($Label1, GUICtrlRead($Name1) & " Only")
        GUICtrlSetData($Label3, GUICtrlRead($Name2) & " Only")
    EndIf
EndFunc   ;==>_DoCompare

;==================================================================================================
; Function Name:   _GetIntersection($Set1, $Set2 [, $GetAll=0 [, $Delim=Default]])
; Description::    Detect from 2 sets
;                  - Intersection (elements are contains in both sets)
;                  - Difference 1 (elements are contains only in $Set1)
;                  - Difference 2 (elements are contains only in $Set2)
; Parameter(s):    $Set1    set 1 (1D-array or delimited string)
;                  $Set2    set 2 (1D-array or delimited string)
;      optional:   $GetAll  0 - only one occurence of every different element are shown (Default)
;                           1 - all elements of differences are shown
;      optional:   $Delim   Delimiter for strings (Default use the separator character set by Opt("GUIDataSeparatorChar") )
; Return Value(s): Succes   2D-array    [i][0]=Intersection
;                                       [i][1]=Difference 1
;                                       [i][2]=Difference 2
;                  Failure  -1  @error  set, that was given as array, is'nt 1D-array
; Note:            Comparison is case-sensitiv! - i.e. Number 9 is different to string '9'!
; Author(s):       BugFix (bugfix@autoit.de)
;==================================================================================================
Func _GetIntersection(ByRef $Set1, ByRef $Set2, $GetAll = 0, $Delim = Default)
    Local $o1 = ObjCreate("System.Collections.ArrayList")
    Local $o2 = ObjCreate("System.Collections.ArrayList")
    Local $oUnion = ObjCreate("System.Collections.ArrayList")
    Local $oDiff1 = ObjCreate("System.Collections.ArrayList")
    Local $oDiff2 = ObjCreate("System.Collections.ArrayList")
    Local $tmp, $i
    If $GetAll <> 1 Then $GetAll = 0
    If $Delim = Default Then $Delim = Opt("GUIDataSeparatorChar")
    If Not IsArray($Set1) Then
        If Not StringInStr($Set1, $Delim) Then
            $o1.Add($Set1)
        Else
            $tmp = StringSplit($Set1, $Delim, 1)
            For $i = 1 To UBound($tmp) - 1
                $o1.Add($tmp[$i])
            Next
        EndIf
    Else
        If UBound($Set1, 0) > 1 Then Return SetError(1, 0, -1)
        For $i = 0 To UBound($Set1) - 1
            $o1.Add($Set1[$i])
        Next
    EndIf
    If Not IsArray($Set2) Then
        If Not StringInStr($Set2, $Delim) Then
            $o2.Add($Set2)
        Else
            $tmp = StringSplit($Set2, $Delim, 1)
            For $i = 1 To UBound($tmp) - 1
                $o2.Add($tmp[$i])
            Next
        EndIf
    Else
        If UBound($Set2, 0) > 1 Then Return SetError(1, 0, -1)
        For $i = 0 To UBound($Set2) - 1
            $o2.Add($Set2[$i])
        Next
    EndIf
    For $tmp In $o1 ; create union and diff1 arrays
        If $o2.Contains($tmp) Then
            If Not $oUnion.Contains($tmp) Then $oUnion.Add($tmp)
        Else
            If $GetAll Or Not $oDiff1.Contains($tmp) Then $oDiff1.Add($tmp)
        EndIf
    Next
    For $tmp In $o2 ; create diff2 array
        If Not $oUnion.Contains($tmp) And ($GetAll Or Not $oDiff2.Contains($tmp)) Then $oDiff2.Add($tmp)
    Next
    Local $UBound[3] = [$oDiff1.Count, $oDiff2.Count, $oUnion.Count], $max = 1
    For $i = 0 To UBound($UBound) - 1
        If $UBound[$i] > $max Then $max = $UBound[$i]
    Next
    Local $aOut[$max][3]
    If $oUnion.Count > 0 Then
        $i = 0
        For $tmp In $oUnion
            $aOut[$i][0] = $tmp
            $i += 1
        Next
    EndIf
    If $oDiff1.Count > 0 Then
        $i = 0
        For $tmp In $oDiff1
            $aOut[$i][1] = $tmp
            $i += 1
        Next
    EndIf
    If $oDiff2.Count > 0 Then
        $i = 0
        For $tmp In $oDiff2
            $aOut[$i][2] = $tmp
            $i += 1
        Next
    EndIf
    Return $aOut
EndFunc   ;==>_GetIntersection

Func _selectall()
    _SendMessage(ControlGetHandle("", "", ""), $EM_SETSEL, 0, -1)
EndFunc   ;==>_selectall
