#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=Icons\Folder+Program.ico
#AutoIt3Wrapper_Outfile=Program\Program+Folders.exe
#AutoIt3Wrapper_Run_Tidy=y
#Tidy_Parameters=/tc 4 /reel
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

;╔══════════════════════════════════════════════════════════╗
;║ Program +folder+folder+folder...                         ║
;╟──────────────────────────────────────────────────────────╢
;║ Program by: Zone97                                       ║
;║ Written on: 12/28/2016                                   ║
;║ Function:   Create shortcuts on removabale media where   ║
;║             Windows shortcuts fail.                      ║
;╚══════════════════════════════════════════════════════════╝

;╔══════════════════════════════════════════════════════════╗
;║ Includes                                                 ║
;╚══════════════════════════════════════════════════════════╝

#include <FileConstants.au3>
#include <MsgBoxConstants.au3>
#include <String.au3>
#include <File.au3>

; - Custom UDFs
#include ".\Incudes\ChooseFileFolder.au3"
#include ".\Incudes\ExtMsgBox.au3"

;╔══════════════════════════════════════════════════════════╗
;║ GUI Options                                              ║
;╚══════════════════════════════════════════════════════════╝

;╔══════════════════════════════════════════════════════════╗
;║ Variables                                                ║
;╚══════════════════════════════════════════════════════════╝

Global $ShortCut, $fPath, $nPath, $NewFileName

Global $FileTypes = "*.exe"
Global $Excludes = @ScriptName ; - exclude self

Local $MsgConfig[7] = [5, 1, 0x000000, 0xFFD800, 15, "Courier New", @DesktopWidth - 50]
Local $AbtConfig[7] = [5, 0, 0xBBBBBB, 0x333333, 12, "Courier New", 500]

;╔══════════════════════════════════════════════════════════╗
;║ Pre-startup checks                                       ║
;╚══════════════════════════════════════════════════════════╝

; Register handlers
$sRet = _CFF_RegMsg()
If Not $sRet Then
    _ExtMsgBoxSet($MsgConfig[0], $MsgConfig[1], $MsgConfig[2], $MsgConfig[3], $MsgConfig[4], $MsgConfig[5], $MsgConfig[6])
    _ExtMsgBox(16, "Close", "Failure!", "Handler not registered" & @CRLF & ".\" & $ShortCut)
    _ExtMsgBoxSet(Default)
    Exit
EndIf

;╔══════════════════════════════════════════════════════════╗
;║ Start of main loop                                       ║
;╚══════════════════════════════════════════════════════════╝

$ScriptName = @ScriptName

If StringInStr($ScriptName, " ") And StringInStr($ScriptName, "+") Then
    $aFile = StringSplit(StringReplace($ScriptName, ' +', 0x0, 1), 0x0) ; - Seperate file name from paths
    $FileName = $aFile[1] & ".exe"
    $stLenP = StringLen($aFile[1])
    $stLenA = StringLen($ScriptName)
    $aFile[2] = StringRight($ScriptName, $stLenA - $stLenP)
    $aFile[2] = StringTrimRight($aFile[2], 4) ; - remove .exe from file name.
    $bFile = StringSplit($aFile[2], "+")
    $cDrive = StringLeft(@ScriptFullPath, 3)

    For $x = 2 To $bFile[0]
        $fPath = $fPath & $bFile[$x] & "\"
    Next

    If FileExists($cDrive & $fPath & $FileName) Then
        Run($cDrive & $fPath & $FileName)
        Sleep(1000)
        If Not ProcessExists($FileName) Then
            ShellExecute($cDrive & $fPath & $FileName, "", "", "runas")
        EndIf
    ElseIf FileExists(".\" & $fPath & $FileName) Then
        Run(".\" & $fPath & $FileName)
        Sleep(1000)
        If Not ProcessExists($FileName) Then
            ShellExecute(".\" & $fPath & $FileName, "", "", "runas")
        EndIf
    Else
        SplashTextOn("", "File not found!", 130, 43, -1, -1, 1)
        Sleep(1000)
        SplashOff()
        _FileSelector() ; - File not found
    EndIf
Else
    _ExtMsgBoxSet($AbtConfig[0], $AbtConfig[1], $AbtConfig[2], $AbtConfig[3], $AbtConfig[4], $AbtConfig[5], $AbtConfig[6])
    _ExtMsgBox(@ScriptFullPath, "Close", "About", "Program+Folders 2.2" & @CRLF & "" & @CRLF & "Written By: ZoNE97" & @CRLF & "ExtMsgBox UDF By: Melba23" & @CRLF & "ChooseFileFolder UDF By: Melba23", 0)
    _ExtMsgBoxSet(Default)
    _FileSelector() ; - Name wrong
EndIf

;╔══════════════════════════════════════════════════════════╗
;║ App Functions                                            ║
;╚══════════════════════════════════════════════════════════╝

Func _FileSelector()
    $cDrive = StringLeft(@ScriptFullPath, 1)
    $sRet = _CFF_Choose("Select a program.", 300, 300, -1, -1, $cDrive & "|" & StringReplace(@ScriptFullPath, @ScriptName, ""), $FileTypes & "|" & $Excludes)

    If Not $sRet Then
        SplashTextOn("", "No program was selected!", 250, 43, -1, -1, 1)
        Sleep(2000)
        SplashOff()
    Else
        _FileRenamer()
    EndIf
EndFunc   ;==>_FileSelector

Func _FileRenamer()
    $NewFileName = $sRet
    $FullPath = StringReplace(@ScriptFullPath, @ScriptName, "")

    If StringInStr($NewFileName, $FullPath) Then
        $NewFileName = StringReplace($NewFileName, $FullPath, "")
    Else
        $NewFileName = StringTrimLeft($NewFileName, 3) ; - Remove drive letter + :\
    EndIf

    $NewFileName = StringTrimRight($NewFileName, 4) ; - remove .exe from file name.
    $aFile = StringSplit($NewFileName, "\")

    For $x = 1 To $aFile[0] - 1
        $nPath = $nPath & "+" & $aFile[$x]
    Next

    $FulName = $aFile[$aFile[0]] & " " & $nPath & ".exe"
    ; Convert name to Title Case
    $FulName = _StringTitleCase($FulName)
    ; Fix .Exe to .exe
    $FulName = StringReplace($FulName, ".exe", ".exe")

    If FileExists(@ScriptDir & "\" & $FulName) Then
        FileDelete(@ScriptDir & "\" & $FulName)
    EndIf

    FileCopy(@ScriptName, $FulName)
    Run(@SystemDir & '\cmd.exe /C del /F /Q "' & @ScriptFullPath & '"', @TempDir, @SW_HIDE)
EndFunc   ;==>_FileRenamer
