#include <array.au3>
#include <ie.au3>
#include "TeamViewer.au3"
#include "TeamVierwer_JSON.au3"

_Example()
Exit

Func _Example()

	; If not exist then create new INI file from template
	If Not FileExists('TeamViewer_Example.ini') Then FileCopy('TeamViewer_Example — Template.ini', 'TeamViewer_Example.ini')

	; Read Access Token from INI
	Local $sTV_AccessToken = IniRead('TeamViewer_Example.ini', 'Settings', 'AccessToken', '')
	If $sTV_AccessToken = '' Then
		; Your Access Token, can be left empty when OAuth (below) is configured.

		; ClientId = <-----------------	Create an app in your TeamViewer Management Console and insert the client ID to the INI
		; ClientSecret = <------------- Insert your client secret to the INI
		; AuthorizationCode = <--------	Visit https://webapi.teamviewer.com/api/v1/oauth2/authorize?response_type=code&client_id=YOUR$i_ClientIdHERE
		; 								Login, grant the permissions (popup) and put the code shown in the AuthorizationCode variable to the INI

		Local $sTVOAuth_ClientID = IniRead('TeamViewer_Example.ini', 'OAuth2', 'ClientID', '')
		Local $sTVOAuth_ClientSecret = IniRead('TeamViewer_Example.ini', 'OAuth2', 'ClientSecret', '')

		_IECreate('https://webapi.teamviewer.com/api/v1/oauth2/authorize?response_type=code&client_id=' & $sTVOAuth_ClientID)
		; Local $sTVOAuth_AuthorizationCode = IniRead('TeamViewer_Example.ini', 'OAuth2', 'authorizationCode', '')
		Local $sTVOAuth_AuthorizationCode = InputBox('AuthorizationCode', 'Please provide TV OAuth2 AuthorizationCode')
		If @error Then Return

		If $sTVOAuth_ClientID Then $sTV_AccessToken = _TVAPI_RequestOAuth2_AccessToken($sTVOAuth_ClientID, $sTVOAuth_ClientSecret, $sTVOAuth_AuthorizationCode)
	EndIf

	If $sTV_AccessToken Then _TVAPI_AccessToken($sTV_AccessToken)

	If _TVAPI_Ping() = True Then ; ping API to check connection and $sTV_AccessToken
		_Example_TeamViewer__1_Devices_SaveToFile()
;~ 		_Example_TeamViewer__2_Devices_ChangeDetails()
;~ 		_Example_TeamViewer__3_Devices_GetDevicesSingleID()
;~ 		_Example_TeamViewer__4_Reports_GetAllConnections()
;~ 		_Example_TeamViewer__5_Users_GetUserInfomation()
;~ 		_Example_TeamViewer__6_Groups_ListGroups()
;~ 		_Example_TeamViewer__7_Devices_AddDeleteDevice()
;~ 		_Example_TeamViewer_3()
	Else
		MsgBox(0, '_TVAPI_Ping', "$v_Token or connection problem.")
	EndIf
EndFunc   ;==>_Example


Func _Example_TeamViewer__1_Devices_SaveToFile()
	_TVAPI_Devices_SaveToFile(@ScriptDir & '\Devices_' & @YEAR & @MON & @MDAY & '_' & @HOUR & @MIN & '.json')
EndFunc   ;==>_Example_TeamViewer__1_Devices_SaveToFile

Func _Example_TeamViewer__2_Devices_ChangeDetails()
	_TVAPI_Devices_ChangeDetails(000000000, 'MY NEW ALIAS NAME', 'MY NEW DESCRIPTION')
	MsgBox(0, '_TVAPI_GET_ResponseTextPretty()', _TVAPI_GET_ResponseTextPretty())
	If @error Then MsgBox($MB_ICONERROR, '_Example_TeamViewer__2_Devices_ChangeDetails', '@error = ' & @error & @CRLF & '@extended = ' & @extended)
EndFunc   ;==>_Example_TeamViewer__2_Devices_ChangeDetails

Func _Example_TeamViewer__3_Devices_GetDevicesSingleID()
	Local $oJSON = _TVAPI_Devices_GetDevice(000000000)
	If @error Then MsgBox($MB_ICONERROR, '_TVAPI_GetDevices', '@error = ' & @error & @CRLF & '@extended = ' & @extended)

	Local $sJSON_String = _Chilkat_JSON_ObjToString($oJSON)
	ClipPut($sJSON_String)

	MsgBox(0, '_Example_TeamViewer__3_Devices_GetDevicesSingleID: $sResponse', $sJSON_String)

EndFunc   ;==>_Example_TeamViewer__3_Devices_GetDevicesSingleID

Func _Example_TeamViewer__4_Reports_GetAllConnections()
	; fetch all connections between two point in time
;~ 	Local $aResultConnections = _TVAPI_Reports_GetConnections('2016-12-01T00:00:01Z', '2016-12-31T23:59:59Z')

	; fetch all connections where Device is Unknown (not in contact list)
	Local $aResultConnections = _TVAPI_Reports_GetConnections(Default, Default, Default, Default, Default, "unnamed_device")

	; fetch all connections for specyfic Device between two point in time
;~ 	Local $aResultConnections = _TVAPI_Reports_GetConnections('2013-07-01T10:06:00Z', '2013-07-03T10:10:00Z', Default, Default, Default, "FIND ALIAS NAME")

	_ArrayDisplay($aResultConnections, '$aResultConnections')

EndFunc   ;==>_Example_TeamViewer__4_Reports_GetAllConnections

Func _Example_TeamViewer__5_Users_GetUserInfomation()
	Local $oJSON = _TVAPI_Users_ListUsers(Default, Default, Default, True)
	Local $iNumberOfUsers = @extended
	If @error Then Return SetError(@error, @extended, False)

	Local $sJSON_String = _Chilkat_JSON_ObjToString($oJSON)
	ClipPut($sJSON_String)

	MsgBox(0, '_Example_TeamViewer__5_Users_GetUserInfomation: $sResponse', $sJSON_String)

	Local $iLoopMax = $iNumberOfUsers - 1
	If $iLoopMax > 2 Then $iLoopMax = 2
	For $iArray_idx = 0 To $iLoopMax
		MsgBox(0, "$iArray_idx = " & $iArray_idx & " of " & $iNumberOfUsers - 1, _
				"uID: " & $oJSON.StringOf("users[" & $iArray_idx & "].id") & @CRLF & _
				@CRLF & _
				"Name: " & $oJSON.StringOf("users[" & $iArray_idx & "].name") & @CRLF & _
				@CRLF & _
				"Permissions: " & $oJSON.StringOf("users[" & $iArray_idx & "].permissions") & @CRLF & _
				@CRLF & _
				"active: " & $oJSON.StringOf("users[" & $iArray_idx & "].active") & @CRLF & _
				@CRLF & _
				"log_sessions: " & $oJSON.StringOf("users[" & $iArray_idx & "].log_sessions") & @CRLF & _
				@CRLF & _
				"show_comment_window: " & $oJSON.StringOf("users[" & $iArray_idx & "].show_comment_window") & @CRLF & _
				@CRLF & _
				"" & @CRLF & _
				"")
	Next

	; get ID of first user
	Local $iUserID = Int(StringTrimLeft($oJSON.StringOf("users[0].id"), 1))

	; get UserInfo for first user
	Local $oJSON_single = _TVAPI_Users_GetUserInfo($iUserID)
	Local $oJSON_single_String = _Chilkat_JSON_ObjToString($oJSON_single)
	MsgBox(0, '_TVAPI_Users_GetUserInfo: $sResponse', $oJSON_single_String)

EndFunc   ;==>_Example_TeamViewer__5_Users_GetUserInfomation

Func _Example_TeamViewer__6_Groups_ListGroups()
	Local $oJSON = _TVAPI_Groups_ListGroups(Default, Default)
	If @error Then Return SetError(@error, @extended, False)

	Local $sJSON_String = _Chilkat_JSON_ObjToString($oJSON)

	ClipPut($sJSON_String)
	MsgBox(0, '_Example_TeamViewer__6_Groups_ListGroups: $sResponse', $sJSON_String)


EndFunc   ;==>_Example_TeamViewer__6_Groups_ListGroups

Func _Example_TeamViewer__7_Devices_AddDeleteDevice()
	Local $oJSON = _TVAPI_Devices_AddNew(000000000, 00000000, 'ALIAS NAME', 'DESCRIPTION TEXT')
	Local $iNewDeviceID = @extended
	If @error Then
		MsgBox($MB_ICONERROR, '_TVAPI_Devices_AddNew', 'Result = ' & $oJSON & @CRLF & '@error = ' & @error & @CRLF & '@extended = ' & @extended)
	Else
		MsgBox(0, 'TEST', 'Check your device list in TV APP contact list')

		Local $sJSON_String = _Chilkat_JSON_ObjToString($oJSON)
		ClipPut($sJSON_String)
		MsgBox(0, '_Example_TeamViewer__7_Devices_AddDeleteDevice: $sResponse', $sJSON_String)

		Local $oJSON = _TVAPI_Devices_Delete($iNewDeviceID)
		If @error Then MsgBox($MB_ICONERROR, '_TVAPI_Devices_Delete', 'Result = ' & $oJSON & @CRLF & '@error = ' & @error & @CRLF & '@extended = ' & @extended)
		MsgBox(0, 'TEST', 'Again check your device list in TV APP contact list')
	EndIf
EndFunc   ;==>_Example_TeamViewer__7_Devices_AddDeleteDevice

Func _Example_TeamViewer_3()

	Return ; temporary this is a fake function :)

	Local $oJSON = _TVAPI_Users_ListUsers()
	If @error Then Return SetError(@error, @extended, False)

	Local $sJSON_String = _Chilkat_JSON_ObjToString($oJSON)
	ClipPut($sJSON_String)

	MsgBox(0, '_Example_TeamViewer__3_Devices_GetDevicesSingleID: $sResponse', $sJSON_String)


EndFunc   ;==>_Example_TeamViewer_3
