// INVERT FILTER
// for AutoIt CUDA UDF

extern "C" __global__ void kernel(int *colors)
{
	// Get the original color
	int i = blockIdx.y * gridDim.x + blockIdx.x;
	int argb = colors[i];

	// Unpack ARGB to separate colors
	int alpha = argb >> 24;
	int red = (argb >> 16) & 0xFF;
	int green = (argb >> 8) & 0xFF;
	int blue = argb & 0xFF;

	// Invert R, G and B
	red = 255 - red;
	green = 255 - green;
	blue = 255 - blue;

	// Put it back together
	argb = blue | (green << 8) | (red << 16) | (alpha << 24);

	// Done!
	colors[i] = argb;
}
