// JULIA FRACTAL
// for AutoIt CUDA UDF

extern "C" __global__ void julia(float *ranges, int iter, int *colors)
{
	// Set up some variables
	int i = blockIdx.y * gridDim.x + blockIdx.x;

	int x = blockIdx.x;
	int y = blockIdx.y;

	// Map X and Y to the range defined in 'ranges'
	float fx = ((float)x)/((float)gridDim.x)*(ranges[1]-ranges[0]) + ranges[0];
	float fy = ((float)y)/((float)gridDim.y)*(ranges[3]-ranges[2]) + ranges[2];

	// More setup
	int j = 0;
	float re = fx, im = fy, _re, _im;
	int it = 0;

	// Fractal parameters
	float posx = -0.65, posy = 0.4;

	// The actual processing
	for (j = 0; j < iter; j++) {
		_re = re*re - im*im + posx;
		_im = 2*re*im + posy;

		re = _re;
		im = _im;

		it++;
		if ((re*re + im*im) > 4)
			break;
	}

	// Create color data
	float amt = ((float)it)/((float)iter);

	float reda = amt;
	float greena = pow(amt, 2);
	float bluea = pow(amt, 4);

	int alpha = 0xFF;
	int red = (int)(reda*255.0);
	int green = (int)(greena*255.0);
	int blue = (int)(bluea*255.0);

	int argb = blue | (green << 8) | (red << 16) | (alpha << 24);

	// Done!
	colors[i] = argb;
}
