#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#AutoIt3Wrapper_AU3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, -1, -1, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Change Y-Axis of Chart 1: Set minimum, maximum
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Y-Axis: Set minimum, maximum")
_XLChart_AxisSet($aExcel[1].Axes($xlValue), 7.5, 44)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_AxisSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Change Y-Axis of Chart 1: Set unit to Thousands
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Y-Axis: Set unit to Thousands")
_XLChart_AxisSet($aExcel[1].Axes($xlValue), Default, Default, $xlThousands)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_AxisSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Change Y-Axis of Chart 1: Set DisplayUnitLabel to a custom text
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Y-Axis: Set DisplayUnitLabel to a custom text")
_XLChart_AxisSet($aExcel[1].Axes($xlValue), Default, Default, Default, Default, "in Thousand Units")
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_AxisSet' on line " & @ScriptLineNumber)